/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.ModelParametersSchema;
import water.fvec.Frame;
import water.util.PojoUtils;

public class KMeansV2
extends ModelBuilderSchema<KMeans, KMeansV2, KMeansParametersV2> {
    public KMeansParametersV2 createParametersSchema() {
        return new KMeansParametersV2();
    }

    public KMeans createImpl() {
        if (((KMeansParametersV2)this.parameters).K < 2 || ((KMeansParametersV2)this.parameters).K > 9999999) {
            throw new IllegalArgumentException("2<= K && K < 10000000");
        }
        if (((KMeansParametersV2)this.parameters).max_iters < 0 || ((KMeansParametersV2)this.parameters).max_iters > 9999999) {
            throw new IllegalArgumentException("1<= max_iters && max_iters < 10000000");
        }
        if (((KMeansParametersV2)this.parameters).max_iters == 0) {
            ((KMeansParametersV2)this.parameters).max_iters = 1000;
        }
        if (((KMeansParametersV2)this.parameters).seed == 0L) {
            ((KMeansParametersV2)this.parameters).seed = System.nanoTime();
        }
        KMeansModel.KMeansParameters parms = ((KMeansParametersV2)this.parameters).createImpl();
        return new KMeans(parms);
    }

    protected String acceptsFrame(Frame fr) {
        return "/v2/KMeans?training_frame=" + fr._key;
    }

    public static final class KMeansParametersV2
    extends ModelParametersSchema<KMeansModel.KMeansParameters, KMeansParametersV2> {
        @API(help="Number of clusters", required=true)
        public int K;
        @API(help="Maximum training iterations.")
        public int max_iters;
        @API(help="Normalize columns", level=API.Level.secondary)
        public boolean normalize = true;
        @API(help="RNG Seed", level=API.Level.expert)
        public long seed;
        @API(help="Initialization mode", values={"None", "PlusPlus", "Furthest"})
        public KMeans.Initialization init;

        public String[] fields() {
            return new String[]{"destination_key", "training_frame", "K", "max_iters", "normalize", "seed", "init"};
        }

        public KMeansParametersV2 fillFromImpl(KMeansModel.KMeansParameters parms) {
            super.fillFromImpl((Model.Parameters)parms);
            this.init = KMeans.Initialization.Furthest;
            return this;
        }

        public KMeansModel.KMeansParameters createImpl() {
            KMeansModel.KMeansParameters impl = new KMeansModel.KMeansParameters();
            PojoUtils.copyProperties((Object)((Object)impl), (Object)((Object)this), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            impl._init = KMeans.Initialization.Furthest;
            return impl;
        }
    }
}

