/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class DataInfo
extends Keyed {
    public int[] _activeCols;
    public Frame _adaptedFrame;
    public int _responses;
    boolean _weightsVec;
    public TransformType _predictor_transform;
    public TransformType _response_transform;
    public boolean _useAllFactorLevels;
    public int _nums;
    public int _bins;
    public int _cats;
    public int[] _catOffsets;
    public int[] _catMissing;
    public double[] _normMul;
    public double[] _normSub;
    public double[] _normRespMul;
    public double[] _normRespSub;
    public int _foldId;
    public int _nfolds;
    public boolean _intercept = true;
    public boolean _offset = false;
    public final boolean _skipMissing;
    final int[][] _catLvls;
    public double _etaOffset;

    public Vec weightsVec() {
        return this._weightsVec ? this._adaptedFrame.vec(this._adaptedFrame.numCols() - 1) : null;
    }

    public DataInfo setWeights(Vec v) {
        if (this._weightsVec) {
            int id = this._adaptedFrame.numCols() - 1;
            this._adaptedFrame.replace(id, v);
        } else {
            String name = "_weights_vec";
            while (this._adaptedFrame.vec(name) != null) {
                name = "_" + name;
            }
            this._adaptedFrame.add(name, v);
            this._weightsVec = true;
        }
        return this;
    }

    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    public DataInfo deep_clone() {
        AutoBuffer ab = new AutoBuffer();
        this.write(ab);
        ab.flipForReading();
        return (DataInfo)new DataInfo().read(ab);
    }

    private DataInfo() {
        super(null);
        this._catLvls = null;
        this._skipMissing = true;
    }

    private DataInfo(Key selfKey, DataInfo dinfo, int foldId, int nfolds) {
        super(selfKey);
        assert (dinfo._catLvls == null) : "Should not be called with filtered levels (assuming the selected levels may change with fold id) ";
        assert (dinfo._predictor_transform != null);
        assert (dinfo._response_transform != null);
        this._predictor_transform = dinfo._predictor_transform;
        this._response_transform = dinfo._response_transform;
        this._responses = dinfo._responses;
        this._nums = dinfo._nums;
        this._cats = dinfo._cats;
        this._adaptedFrame = dinfo._adaptedFrame;
        this._catOffsets = dinfo._catOffsets;
        this._catMissing = dinfo._catMissing;
        this._normMul = dinfo._normMul;
        this._normSub = dinfo._normSub;
        this._normRespMul = dinfo._normRespMul;
        this._normRespSub = dinfo._normRespSub;
        this._foldId = foldId;
        this._nfolds = nfolds;
        this._useAllFactorLevels = dinfo._useAllFactorLevels;
        this._catLvls = null;
        this._skipMissing = dinfo._skipMissing;
        if (this._normMul != null && this._normSub != null) {
            for (int i = 0; i < this._normMul.length; ++i) {
                this._etaOffset -= this._normSub[i] * this._normMul[i];
            }
        }
    }

    public DataInfo(Key selfKey, Frame fr, int[][] catLevels, int responses, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, int foldId, int nfolds) {
        super(selfKey);
        Vec v;
        int i;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._skipMissing = skipMissing;
        this._adaptedFrame = fr;
        this._catOffsets = MemoryManager.malloc4((int)(catLevels.length + 1));
        this._catMissing = new int[catLevels.length];
        int s = 0;
        for (i = 0; i < catLevels.length; ++i) {
            this._catOffsets[i] = s;
            s += catLevels[i].length;
        }
        this._catLvls = catLevels;
        this._catOffsets[this._catOffsets.length - 1] = s;
        this._responses = responses;
        this._cats = catLevels.length;
        this._nums = fr.numCols() - this._cats - responses;
        if (this._nums > 0) {
            switch (this._predictor_transform) {
                case STANDARDIZE: {
                    this._normMul = MemoryManager.malloc8d((int)this._nums);
                    this._normSub = MemoryManager.malloc8d((int)this._nums);
                    for (i = 0; i < this._nums; ++i) {
                        v = fr.vec(catLevels.length + i);
                        this._normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                        this._normSub[i] = v.mean();
                    }
                    break;
                }
                case NORMALIZE: {
                    this._normMul = MemoryManager.malloc8d((int)this._nums);
                    this._normSub = MemoryManager.malloc8d((int)this._nums);
                    for (i = 0; i < this._nums; ++i) {
                        v = fr.vec(catLevels.length + i);
                        this._normMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                        this._normSub[i] = v.mean();
                    }
                    break;
                }
                case DEMEAN: {
                    this._normMul = MemoryManager.malloc8d((int)this._nums);
                    Arrays.fill(this._normMul, 1.0);
                    this._normSub = MemoryManager.malloc8d((int)this._nums);
                    for (i = 0; i < this._nums; ++i) {
                        v = fr.vec(catLevels.length + i);
                        this._normSub[i] = v.mean();
                    }
                    break;
                }
                case DESCALE: {
                    this._normMul = MemoryManager.malloc8d((int)this._nums);
                    this._normSub = MemoryManager.malloc8d((int)this._nums);
                    for (i = 0; i < this._nums; ++i) {
                        v = fr.vec(catLevels.length + i);
                        this._normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    }
                    break;
                }
                case NONE: {
                    this._normMul = null;
                    this._normSub = null;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
        if (responses > 0) {
            switch (this._response_transform) {
                case STANDARDIZE: {
                    this._normRespMul = MemoryManager.malloc8d((int)responses);
                    this._normRespSub = MemoryManager.malloc8d((int)responses);
                    for (i = 0; i < responses; ++i) {
                        v = fr.vec(fr.numCols() - responses + i);
                        this._normRespMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                        this._normRespSub[i] = v.mean();
                    }
                    break;
                }
                case NORMALIZE: {
                    this._normRespMul = MemoryManager.malloc8d((int)responses);
                    this._normRespSub = MemoryManager.malloc8d((int)responses);
                    for (i = 0; i < responses; ++i) {
                        v = fr.vec(fr.numCols() - responses + i);
                        this._normRespMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                        this._normRespSub[i] = v.mean();
                    }
                    break;
                }
                case DEMEAN: {
                    this._normRespMul = MemoryManager.malloc8d((int)responses);
                    this._normRespSub = MemoryManager.malloc8d((int)responses);
                    for (i = 0; i < responses; ++i) {
                        v = fr.vec(fr.numCols() - responses + i);
                        this._normRespMul[i] = 1.0;
                        this._normRespSub[i] = v.mean();
                    }
                    break;
                }
                case DESCALE: {
                    this._normRespSub = MemoryManager.malloc8d((int)responses);
                    this._normRespMul = MemoryManager.malloc8d((int)responses);
                    for (i = 0; i < responses; ++i) {
                        v = fr.vec(fr.numCols() - responses + i);
                        this._normRespMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    }
                    break;
                }
                case NONE: {
                    this._normRespMul = null;
                    this._normRespSub = null;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
        this._useAllFactorLevels = false;
        this._adaptedFrame.reloadVecs();
        this._nfolds = nfolds;
        this._foldId = foldId;
        if (this._normMul != null) {
            double[] arr$ = this._normMul;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                double d = arr$[i$];
                assert (!Double.isNaN(d));
            }
        }
        if (this._normSub != null) {
            for (double d : this._normSub) {
                assert (!Double.isNaN(d));
            }
        }
    }

    public DataInfo(Key selfKey, Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean missingBucket) {
        super(selfKey);
        double vm;
        double vs;
        Vec v;
        int i;
        int i2;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._skipMissing = skipMissing;
        this._foldId = 0;
        this._nfolds = 0;
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._responses = nResponses;
        this._useAllFactorLevels = useAllFactorLevels;
        this._catLvls = null;
        Vec[] tvecs = train.vecs();
        Vec[] vvecs = valid == null ? null : valid.vecs();
        int n = tvecs.length - this._responses;
        assert (n >= 1);
        int[] nums = MemoryManager.malloc4((int)n);
        int[] cats = MemoryManager.malloc4((int)n);
        int nnums = 0;
        int ncats = 0;
        for (i2 = 0; i2 < n; ++i2) {
            if (tvecs[i2].isEnum() && tvecs[i2].domain() != null) {
                cats[ncats++] = i2;
                continue;
            }
            if (tvecs[i2].isEnum()) {
                Log.debug((Object[])new Object[]{"In DataInfo:  Confused isEnum column number " + i2});
            }
            nums[nnums++] = i2;
        }
        this._nums = nnums;
        this._cats = ncats;
        for (i2 = 0; i2 < ncats; ++i2) {
            for (int j = i2 + 1; j < ncats; ++j) {
                if (tvecs[cats[i2]].domain().length >= tvecs[cats[j]].domain().length) continue;
                int x = cats[i2];
                cats[i2] = cats[j];
                cats[j] = x;
            }
        }
        String[] names = new String[train.numCols()];
        Vec[] tvecs2 = new Vec[train.numCols()];
        Vec[] vvecs2 = valid == null ? null : new Vec[train.numCols()];
        this._catOffsets = MemoryManager.malloc4((int)(ncats + 1));
        this._catMissing = new int[ncats];
        this._catOffsets[0] = 0;
        int len = 0;
        for (i = 0; i < ncats; ++i) {
            names[i] = train._names[cats[i]];
            if (valid != null) {
                vvecs2[i] = vvecs[cats[i]];
            }
            v = tvecs2[i] = tvecs[cats[i]];
            this._catMissing[i] = missingBucket ? 1 : 0;
            this._catOffsets[i + 1] = len += v.domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
        }
        switch (predictor_transform) {
            case STANDARDIZE: 
            case NORMALIZE: {
                this._normSub = MemoryManager.malloc8d((int)nnums);
                this._normMul = MemoryManager.malloc8d((int)nnums);
                Arrays.fill(this._normMul, 1.0);
                break;
            }
            case DEMEAN: {
                this._normSub = MemoryManager.malloc8d((int)nnums);
                this._normMul = MemoryManager.malloc8d((int)nnums);
                Arrays.fill(this._normMul, 1.0);
                break;
            }
            case DESCALE: {
                this._normSub = MemoryManager.malloc8d((int)nnums);
                this._normMul = MemoryManager.malloc8d((int)nnums);
                break;
            }
            case NONE: {
                this._normSub = null;
                this._normMul = null;
                break;
            }
            default: {
                throw H2O.unimpl();
            }
        }
        block30: for (i = 0; i < nnums; ++i) {
            names[ncats + i] = train._names[nums[i]];
            if (valid != null) {
                vvecs2[ncats + i] = vvecs[nums[i]];
            }
            Vec vec = tvecs[nums[i]];
            tvecs2[ncats + i] = vec;
            v = vec;
            vs = v.sigma() == 0.0 ? 1.0 : 1.0 / v.sigma();
            vm = v.max() - v.min() == 0.0 ? 1.0 : 1.0 / (v.max() - v.min());
            switch (predictor_transform) {
                case STANDARDIZE: {
                    this._normSub[i] = v.mean();
                    this._normMul[i] = vs;
                    continue block30;
                }
                case NORMALIZE: {
                    this._normSub[i] = v.mean();
                    this._normMul[i] = vm;
                    continue block30;
                }
                case DEMEAN: {
                    this._normSub[i] = v.mean();
                    continue block30;
                }
                case DESCALE: {
                    this._normMul[i] = vs;
                    continue block30;
                }
                case NONE: {
                    continue block30;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
        if (this._responses > 0) {
            switch (response_transform) {
                case STANDARDIZE: 
                case NORMALIZE: {
                    this._normRespSub = MemoryManager.malloc8d((int)this._responses);
                    this._normRespMul = MemoryManager.malloc8d((int)this._responses);
                    Arrays.fill(this._normRespMul, 1.0);
                    break;
                }
                case DEMEAN: {
                    this._normRespSub = MemoryManager.malloc8d((int)this._responses);
                    this._normRespMul = MemoryManager.malloc8d((int)this._responses);
                    Arrays.fill(this._normRespMul, 1.0);
                    break;
                }
                case DESCALE: {
                    this._normRespSub = MemoryManager.malloc8d((int)this._responses);
                    this._normRespMul = MemoryManager.malloc8d((int)this._responses);
                    break;
                }
                case NONE: {
                    this._normRespSub = null;
                    this._normRespMul = null;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            block31: for (i = 0; i < this._responses; ++i) {
                names[ncats + nnums + i] = train._names[ncats + nnums + i];
                if (valid != null) {
                    vvecs2[ncats + nnums + i] = vvecs[ncats + nnums + i];
                }
                Vec vec = tvecs[ncats + nnums + i];
                tvecs2[ncats + nnums + i] = vec;
                v = vec;
                vs = v.sigma() == 0.0 ? 1.0 : 1.0 / v.sigma();
                vm = v.max() - v.min() == 0.0 ? 1.0 : 1.0 / (v.max() - v.min());
                switch (response_transform) {
                    case STANDARDIZE: {
                        this._normRespSub[i] = v.mean();
                        this._normRespMul[i] = vs;
                        continue block31;
                    }
                    case NORMALIZE: {
                        this._normRespSub[i] = v.mean();
                        this._normRespMul[i] = vm;
                        continue block31;
                    }
                    case DEMEAN: {
                        this._normRespSub[i] = v.mean();
                        continue block31;
                    }
                    case DESCALE: {
                        this._normRespMul[i] = vs;
                        continue block31;
                    }
                    case NONE: {
                        continue block31;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
            }
        }
        if (this._normMul != null) {
            for (double d : this._normMul) {
                assert (!Double.isNaN(d));
            }
        }
        if (this._normSub != null) {
            for (double d : this._normSub) {
                assert (!Double.isNaN(d));
            }
        }
        train.restructure(names, tvecs2);
        if (valid != null) {
            valid.restructure(names, vvecs2);
        }
        this._adaptedFrame = train;
    }

    public DataInfo filterExpandedColumns(int[] cols) {
        int k;
        assert (this._predictor_transform != null);
        assert (this._response_transform != null);
        if (cols == null) {
            return this;
        }
        int i = 0;
        int j = 0;
        int ignoredCnt = 0;
        int[][] catLvls = new int[this._cats][];
        int[] ignoredCols = MemoryManager.malloc4((int)(this._nums + this._cats));
        if (this._catOffsets != null) {
            while (i < cols.length && cols[i] < this._catOffsets[this._catOffsets.length - 1]) {
                int[] levels = MemoryManager.malloc4((int)(this._catOffsets[j + 1] - this._catOffsets[j]));
                k = 0;
                while (i < cols.length && cols[i] < this._catOffsets[j + 1]) {
                    levels[k++] = cols[i++] - this._catOffsets[j];
                }
                if (k > 0) {
                    catLvls[j] = Arrays.copyOf(levels, k);
                }
                ++j;
            }
        }
        for (int k2 = 0; k2 < catLvls.length; ++k2) {
            if (catLvls[k2] != null) continue;
            ignoredCols[ignoredCnt++] = k2;
        }
        if (ignoredCnt > 0) {
            int[][] c = new int[this._cats - ignoredCnt][];
            int y = 0;
            for (int[] catLvl : catLvls) {
                if (catLvl == null) continue;
                c[y++] = catLvl;
            }
            assert (y == c.length);
            catLvls = c;
        }
        j = 0;
        int prev = 0;
        while (i < cols.length) {
            for (k = prev; k < cols[i] - this.numStart(); ++k) {
                ignoredCols[ignoredCnt++] = k + this._cats;
                ++j;
            }
            prev = ++j;
            ++i;
        }
        for (k = prev; k < this._nums; ++k) {
            ignoredCols[ignoredCnt++] = k + this._cats;
        }
        Frame f = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
        if (ignoredCnt > 0) {
            f.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
        }
        assert (catLvls.length < f.numCols()) : "cats = " + catLvls.length + " numcols = " + f.numCols();
        DataInfo dinfo = new DataInfo(this._key, f, catLvls, this._responses, this._predictor_transform, this._response_transform, this._skipMissing, this._foldId, this._nfolds);
        dinfo._activeCols = cols;
        return dinfo;
    }

    public String toString() {
        return "";
    }

    public DataInfo getFold(int foldId, int nfolds) {
        return new DataInfo(Key.make(), this, foldId, nfolds);
    }

    public final int fullN() {
        return this._nums + this._catOffsets[this._cats];
    }

    public final int largestCat() {
        return this._cats > 0 ? this._catOffsets[1] : 0;
    }

    public final int numStart() {
        return this._catOffsets[this._cats];
    }

    public final String[] coefNames() {
        int k = 0;
        int n = this.fullN();
        String[] res = new String[n];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (int i = 0; i < this._cats; ++i) {
            int j;
            int n2 = j = this._useAllFactorLevels ? 0 : 1;
            while (j < vecs[i].domain().length) {
                res[k++] = this._adaptedFrame._names[i] + "." + vecs[i].domain()[j];
                ++j;
            }
            if (this._catMissing[i] <= 0) continue;
            res[k++] = this._adaptedFrame._names[i] + ".missing(NA)";
        }
        int nums = n - k;
        System.arraycopy(this._adaptedFrame._names, this._cats, res, k, nums);
        return res;
    }

    public final void unScaleNumericals(float[] in, float[] out) {
        if (this._nums == 0) {
            return;
        }
        assert (in.length == out.length);
        assert (in.length == this.fullN());
        for (int k = this.numStart(); k < this.fullN(); ++k) {
            out[k] = in[k] / (float)this._normMul[k - this.numStart()] + (float)this._normSub[k - this.numStart()];
        }
    }

    public final int getCategoricalId(int cid, int val) {
        int c = this._catLvls != null ? Arrays.binarySearch(this._catLvls[cid], val) : val - (this._useAllFactorLevels ? 0 : 1);
        return c >= 0 ? c + this._catOffsets[cid] : -1;
    }

    public final Row extractDenseRow(Chunk[] chunks, int rid, Row row) {
        int i;
        row.bad = false;
        row.rid = (long)rid + chunks[0].start();
        if (this._skipMissing) {
            for (Chunk c : chunks) {
                if (!c.isNA(rid)) continue;
                row.bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (int i2 = 0; i2 < this._cats; ++i2) {
            if (chunks[i2].isNA(rid)) {
                row.binIds[nbins++] = this._catOffsets[i2 + 1] - 1;
                continue;
            }
            int c = this.getCategoricalId(i2, (int)chunks[i2].at8(rid));
            if (c < 0) continue;
            row.binIds[nbins++] = c;
        }
        row.nBins = nbins;
        int n = this._nums;
        for (i = 0; i < n; ++i) {
            double d = chunks[this._cats + i].atd(rid);
            if (this._normMul != null && this._normSub != null) {
                d = (d - this._normSub[i]) * this._normMul[i];
            }
            row.numVals[i] = d;
        }
        for (i = 0; i < this._responses; ++i) {
            row.response[i] = chunks[chunks.length - this._responses + i].atd(rid);
            if (this._normRespMul != null) {
                row.response[i] = (row.response[i] - this._normRespSub[i]) * this._normRespMul[i];
            }
            if (!Double.isNaN(row.response[i])) continue;
            row.bad = true;
            return row;
        }
        return row;
    }

    public Row newDenseRow() {
        return new Row(false, this._nums, this._cats, this._responses, 0.0);
    }

    public final Row[] extractSparseRows(Chunk[] chunks, double[] beta) {
        Chunk c;
        int cid;
        int i;
        if (!this._skipMissing) {
            throw H2O.unimpl();
        }
        Row[] rows = new Row[chunks[0]._len];
        double etaOffset = 0.0;
        if (this._normMul != null && this._normSub != null && beta != null) {
            for (i = 0; i < this._nums; ++i) {
                etaOffset -= beta[i + this.numStart()] * this._normSub[i] * this._normMul[i];
            }
        }
        for (i = 0; i < rows.length; ++i) {
            rows[i] = new Row(true, Math.min(this._nums - this._bins, 16), Math.min(this._bins, 16) + this._cats, this._responses, etaOffset);
            rows[i].rid = chunks[0].start() + (long)i;
        }
        for (i = 0; i < this._cats; ++i) {
            for (int r = 0; r < chunks[0]._len; ++r) {
                Row row = rows[r];
                if (chunks[i].isNA(r)) {
                    if (this._skipMissing) {
                        row.bad = true;
                        continue;
                    }
                    row.binIds[row.nBins++] = this._catOffsets[i + 1] - 1;
                    continue;
                }
                int c2 = this.getCategoricalId(i, (int)chunks[i].at8(r));
                if (c2 < 0) continue;
                row.binIds[row.nBins++] = c2;
            }
        }
        int numStart = this.numStart();
        for (cid = 0; cid < this._bins; ++cid) {
            c = chunks[cid + this._cats];
            int r = c.nextNZ(-1);
            while (r < c._len) {
                if (c.isSparse() || c.atd(r) != 0.0) {
                    Row row = rows[r];
                    if (c.isNA(r)) {
                        row.bad = this._skipMissing;
                    }
                    if (!row.bad) {
                        row.addBinId(cid + numStart);
                    }
                }
                r = c.nextNZ(r);
            }
        }
        for (cid = 0; cid < this._nums; ++cid) {
            c = chunks[this._cats + cid];
            int oldRow = -1;
            int r = c.nextNZ(-1);
            while (r < c._len) {
                if (c.isSparse() || c.atd(r) != 0.0) {
                    assert (r > oldRow);
                    oldRow = r;
                    Row row = rows[r];
                    if (c.isNA(r)) {
                        row.bad = this._skipMissing;
                    }
                    if (!row.bad) {
                        double d = c.atd(r);
                        if (this._normMul != null) {
                            d *= this._normMul[cid];
                        }
                        row.addNum(cid + numStart + this._bins, d);
                    }
                }
                r = c.nextNZ(r);
            }
        }
        double rsum = 0.0;
        int nobs = 0;
        for (int i2 = 1; i2 <= this._responses; ++i2) {
            Chunk rChunk = chunks[chunks.length - i2];
            for (int r = 0; r < chunks[0]._len; ++r) {
                ++nobs;
                Row row = rows[r];
                double d = rChunk.atd(r);
                rsum += d;
                row.response[row.response.length - i2] = rChunk.atd(r);
                if (this._normRespMul != null) {
                    assert (false);
                    row.response[i2] = (row.response[i2] - this._normRespSub[i2]) * this._normRespMul[i2];
                }
                if (!Double.isNaN(row.response[row.response.length - i2])) continue;
                row.bad = true;
            }
        }
        return rows;
    }

    public final class Row {
        public boolean bad;
        public double[] numVals;
        public double[] response;
        public int[] numIds;
        public int[] binIds;
        public long rid;
        public int nBins;
        public int nNums;
        public final double etaOffset;

        public final boolean isSparse() {
            return this.numIds != null;
        }

        public Row(boolean sparse, int nNums, int nBins, int nresponses, double etaOffset) {
            this.binIds = MemoryManager.malloc4((int)nBins);
            this.numVals = MemoryManager.malloc8d((int)nNums);
            this.response = MemoryManager.malloc8d((int)nresponses);
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.etaOffset = etaOffset;
            this.nNums = sparse ? 0 : nNums;
        }

        public double response(int i) {
            return this.response[i];
        }

        public void addBinId(int id) {
            if (this.binIds.length == this.nBins) {
                this.binIds = Arrays.copyOf(this.binIds, Math.max(4, this.binIds.length + (this.binIds.length >> 1)));
            }
            this.binIds[this.nBins++] = id;
        }

        public void addNum(int id, double val) {
            if (this.numIds.length == this.nNums) {
                int newSz = Math.max(4, this.numIds.length + (this.numIds.length >> 1));
                this.numIds = Arrays.copyOf(this.numIds, newSz);
                this.numVals = Arrays.copyOf(this.numVals, newSz);
            }
            int i = this.nNums++;
            this.numIds[i] = id;
            this.numVals[i] = val;
        }

        public final double innerProduct(double[] vec) {
            int i;
            double res = 0.0;
            int numStart = DataInfo.this.numStart();
            for (i = 0; i < this.nBins; ++i) {
                res += vec[this.binIds[i]];
            }
            if (this.numIds == null) {
                for (i = 0; i < this.numVals.length; ++i) {
                    res += this.numVals[i] * vec[numStart + i];
                }
            } else {
                res += this.etaOffset;
                for (i = 0; i < this.nNums; ++i) {
                    res += this.numVals[i] * vec[this.numIds[i]];
                }
            }
            if (DataInfo.this._intercept) {
                res += vec[vec.length - 1];
            }
            return res;
        }

        public String toString() {
            return this.rid + Arrays.toString(Arrays.copyOf(this.binIds, this.nBins)) + ", " + Arrays.toString(this.numVals);
        }
    }

    public static enum TransformType {
        NONE,
        STANDARDIZE,
        NORMALIZE,
        DEMEAN,
        DESCALE;

    }
}

