/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.VarImp;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.schemas.DeepLearningModelV3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.api.ModelSchema;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.SB;
import water.util.Timer;
import water.util.TwoDimTable;

public class DeepLearningModel
extends SupervisedModel<DeepLearningModel, DeepLearningParameters, DeepLearningModelOutput>
implements Model.DeepFeatures {
    private volatile DeepLearningModelInfo model_info;
    public long run_time;
    private long start_time;
    public long actual_train_samples_per_iteration;
    public double time_for_communication_us;
    public double epoch_counter;
    public long training_rows;
    public long validation_rows;
    private DeepLearningScoring[] errors;
    private float _bestError = Float.POSITIVE_INFINITY;
    public Key actual_best_model_key;
    public long _timeLastScoreEnter;
    private transient long _timeLastScoreStart;
    private transient long _timeLastScoreEnd;
    private transient long _timeLastPrintStart;
    private final transient String unstable_msg = "Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing.";

    public ModelSchema schema() {
        return new DeepLearningModelV3();
    }

    void set_model_info(DeepLearningModelInfo mi) {
        this.model_info = mi;
    }

    public final DeepLearningModelInfo model_info() {
        return this.model_info;
    }

    public final VarImp varImp() {
        return ((DeepLearningModelOutput)this._output).errors.variable_importances;
    }

    public DeepLearningScoring[] scoring_history() {
        return this.errors;
    }

    DeepLearningScoring last_scored() {
        return this.errors == null ? null : this.errors[this.errors.length - 1];
    }

    public final DeepLearningParameters get_params() {
        return this.model_info.get_params();
    }

    public float error() {
        return (float)(((DeepLearningModelOutput)this._output).isClassifier() ? this.cm().err() : this.mse());
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((DeepLearningModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((DeepLearningModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((DeepLearningModelOutput)this._output).nfeatures());
            }
        }
        throw H2O.unimpl((String)("Invalid ModelCategory " + ((DeepLearningModelOutput)this._output).getModelCategory()));
    }

    public int compareTo(DeepLearningModel o) {
        if (((DeepLearningModelOutput)o._output).isClassifier() != ((DeepLearningModelOutput)this._output).isClassifier()) {
            throw new UnsupportedOperationException("Cannot compare classifier against regressor.");
        }
        if (((DeepLearningModelOutput)o._output).nclasses() != ((DeepLearningModelOutput)this._output).nclasses()) {
            throw new UnsupportedOperationException("Cannot compare models with different number of classes.");
        }
        return this.error() < o.error() ? -1 : (this.error() > o.error() ? 1 : 0);
    }

    public ConfusionMatrix cm() {
        ConfusionMatrix cm;
        DeepLearningScoring lasterror = this.last_scored();
        if (lasterror == null) {
            return null;
        }
        ConfusionMatrix confusionMatrix = cm = lasterror.validation || lasterror.num_folds > 0 ? lasterror.valid_confusion_matrix : lasterror.train_confusion_matrix;
        if (cm == null) {
            if (lasterror.validation || lasterror.num_folds > 0) {
                return new ConfMat(lasterror.valid_err, lasterror.validation_AUC != null ? lasterror.validation_AUC.maxF1() : 0.0);
            }
            return new ConfMat(lasterror.train_err, lasterror.training_AUC != null ? lasterror.training_AUC.maxF1() : 0.0);
        }
        return cm;
    }

    public double mse() {
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.last_scored().validation || this.last_scored().num_folds > 0 ? this.last_scored().validation_MSE : this.last_scored().training_MSE;
    }

    public double logloss() {
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.last_scored().validation || this.last_scored().num_folds > 0 ? this.last_scored().valid_logloss : this.last_scored().train_logloss;
    }

    private TwoDimTable createScoringHistoryTable(DeepLearningScoring[] errors) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Training Speed");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Epochs");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Samples");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Training MSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (!((DeepLearningModelOutput)this._output).autoencoder) {
            colHeaders.add("Training R^2");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            colHeaders.add("Training LogLoss");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial || ((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Multinomial) {
            colHeaders.add("Training Classification Error");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (this.get_params()._valid != null) {
            colHeaders.add("Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (!((DeepLearningModelOutput)this._output).autoencoder) {
                colHeaders.add("Validation R^2");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Validation LogLoss");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        } else if (this.get_params().getNumFolds() > 0) {
            colHeaders.add("Cross-Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial) {
                colHeaders.add("Cross-Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Cross-Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        int rows = errors.length;
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i < errors.length; ++i) {
            DeepLearningScoring e = errors[i];
            int col = 0;
            assert (row < table.getRowDim());
            assert (col < table.getColDim());
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(this.start_time + e.training_time_ms));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)e.training_time_ms, (boolean)true));
            table.set(row, col++, e.training_time_ms == 0L ? null : String.format("%.3f", (double)e.training_samples / ((double)e.training_time_ms / 1000.0)) + " rows/sec");
            table.set(row, col++, (Object)e.epoch_counter);
            table.set(row, col++, (Object)e.training_samples);
            table.set(row, col++, (Object)e.training_MSE);
            if (!((DeepLearningModelOutput)this._output).autoencoder) {
                table.set(row, col++, (Object)e.training_R2);
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                table.set(row, col++, (Object)e.train_logloss);
            }
            if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial) {
                table.set(row, col++, (Object)(e.training_AUC != null ? e.training_AUC._auc : Double.NaN));
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                table.set(row, col++, (Object)e.train_err);
            }
            if (this.get_params()._valid != null) {
                table.set(row, col++, (Object)e.validation_MSE);
                if (!((DeepLearningModelOutput)this._output).autoencoder) {
                    table.set(row, col++, (Object)e.validation_R2);
                }
                if (((DeepLearningModelOutput)this._output).isClassifier()) {
                    table.set(row, col++, (Object)e.valid_logloss);
                }
                if (((DeepLearningModelOutput)this._output).getModelCategory() == Model.ModelCategory.Binomial) {
                    table.set(row, col++, (Object)(e.validation_AUC != null ? e.validation_AUC._auc : Double.NaN));
                }
                if (((DeepLearningModelOutput)this._output).isClassifier()) {
                    table.set(row, col++, (Object)e.valid_err);
                }
            } else if (this.get_params().getNumFolds() > 1) {
                throw H2O.unimpl((String)"n_folds >= 2 is not (yet) implemented.");
            }
            ++row;
        }
        return table;
    }

    private void makeWeightsBiases(Key destKey) {
        if (!this.model_info.get_params()._export_weights_and_biases) {
            ((DeepLearningModelOutput)this._output).weights = null;
            ((DeepLearningModelOutput)this._output).biases = null;
        } else {
            int i;
            ((DeepLearningModelOutput)this._output).weights = new Key[this.model_info.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                ((DeepLearningModelOutput)this._output).weights[i] = Key.makeUserHidden((Key)Key.make((String)(destKey + ".weights." + i)));
            }
            ((DeepLearningModelOutput)this._output).biases = new Key[this.model_info.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                ((DeepLearningModelOutput)this._output).biases[i] = Key.makeUserHidden((Key)Key.make((String)(destKey + ".biases." + i)));
            }
        }
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModel cp, boolean store_best_model, DataInfo dataInfo) {
        super(destKey, (SupervisedModel.SupervisedParameters)(parms == null ? (DeepLearningParameters)((DeepLearningParameters)cp._parms).clone() : parms), (SupervisedModel.SupervisedOutput)((DeepLearningModelOutput)((DeepLearningModelOutput)cp._output).clone()));
        assert (this._parms != cp._parms);
        this.model_info = cp.model_info.deep_clone();
        if (store_best_model) {
            this.model_info.data_info = dataInfo.deep_clone();
        } else {
            this.model_info.data_info = dataInfo;
            if (parms != null) {
                assert (this._parms == parms);
                assert (((DeepLearningParameters)this._parms)._checkpoint == parms._checkpoint);
                assert (((DeepLearningParameters)this._parms)._checkpoint == cp._key);
            }
        }
        assert (this.model_info().get_params() != cp.model_info().get_params());
        this.actual_best_model_key = cp.actual_best_model_key;
        this.start_time = cp.start_time;
        this.run_time = cp.run_time;
        this.training_rows = cp.training_rows;
        this.validation_rows = cp.validation_rows;
        this._bestError = cp._bestError;
        this.errors = (DeepLearningScoring[])cp.errors.clone();
        for (int i = 0; i < this.errors.length; ++i) {
            this.errors[i] = cp.errors[i].deep_clone();
        }
        ((DeepLearningModelOutput)this._output).errors = this.last_scored();
        this.makeWeightsBiases(destKey);
        ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
        ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        ((DeepLearningModelOutput)this._output)._names = dataInfo._adaptedFrame.names();
        ((DeepLearningModelOutput)this._output)._domains = dataInfo._adaptedFrame.domains();
        this._timeLastScoreEnter = System.currentTimeMillis();
        this._timeLastScoreStart = 0L;
        this._timeLastScoreEnd = 0L;
        this._timeLastPrintStart = 0L;
        assert (Arrays.equals(this._key._kb, destKey._kb));
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModelOutput output, Frame train, Frame valid) {
        super(destKey, (SupervisedModel.SupervisedParameters)parms, (SupervisedModel.SupervisedOutput)output);
        boolean classification = train.lastVec().isEnum();
        DataInfo dinfo = DeepLearning.makeDataInfo(train, valid, (DeepLearningParameters)this._parms);
        ((DeepLearningModelOutput)this._output)._names = train._names;
        ((DeepLearningModelOutput)this._output)._domains = train.domains();
        ((DeepLearningModelOutput)this._output)._names = dinfo._adaptedFrame.names();
        ((DeepLearningModelOutput)this._output)._domains = dinfo._adaptedFrame.domains();
        DKV.put((Key)dinfo._key, (Iced)dinfo);
        this.model_info = new DeepLearningModelInfo(parms, dinfo, classification, train, valid);
        this.actual_best_model_key = Key.makeUserHidden((Key)Key.make());
        if (parms.getNumFolds() != 0) {
            this.actual_best_model_key = null;
        }
        if (!parms._autoencoder) {
            this.errors = new DeepLearningScoring[1];
            this.errors[0] = new DeepLearningScoring();
            this.errors[0].validation = parms._valid != null;
            this.errors[0].num_folds = parms.getNumFolds();
            ((DeepLearningModelOutput)this._output).errors = this.last_scored();
            ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
            ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        }
        this.makeWeightsBiases(destKey);
        this.run_time = 0L;
        this._timeLastScoreEnter = this.start_time = System.currentTimeMillis();
        assert (this._key.equals((Object)destKey));
        boolean fail = false;
        long byte_size = 0L;
        try {
            byte_size = new AutoBuffer().put((Freezable)this).buf().length;
        }
        catch (Throwable t) {
            fail = true;
        }
        if (byte_size > 0x10000000L || fail) {
            throw new IllegalArgumentException("Model is too large: PUBDEV-941");
        }
    }

    public static void modifyParms(DeepLearningParameters fromParms, DeepLearningParameters toParms, boolean classification) {
        if (fromParms._hidden_dropout_ratios == null) {
            if (fromParms._activation == DeepLearningParameters.Activation.TanhWithDropout || fromParms._activation == DeepLearningParameters.Activation.MaxoutWithDropout || fromParms._activation == DeepLearningParameters.Activation.RectifierWithDropout) {
                toParms._hidden_dropout_ratios = new double[fromParms._hidden.length];
                if (!fromParms._quiet_mode) {
                    Log.info((Object[])new Object[]{"_hidden_dropout_ratios: Automatically setting all hidden dropout ratios to 0.5."});
                }
                Arrays.fill(toParms._hidden_dropout_ratios, 0.5);
            }
        } else {
            toParms._hidden_dropout_ratios = (double[])fromParms._hidden_dropout_ratios.clone();
        }
        if (H2O.CLOUD.size() == 1 && fromParms._replicate_training_data) {
            Log.info((Object[])new Object[]{"_replicate_training_data: Disabling replicate_training_data on 1 node."});
            toParms._replicate_training_data = false;
        }
        if (fromParms._single_node_mode && (H2O.CLOUD.size() == 1 || !fromParms._replicate_training_data)) {
            Log.info((Object[])new Object[]{"_single_node_mode: Disabling single_node_mode (only for multi-node operation with replicated training data)."});
            toParms._single_node_mode = false;
        }
        if (!fromParms._use_all_factor_levels && fromParms._autoencoder) {
            Log.info((Object[])new Object[]{"_use_all_factor_levels: Automatically enabling all_factor_levels for auto-encoders."});
            toParms._use_all_factor_levels = true;
        }
        if (fromParms._overwrite_with_best_model && fromParms.getNumFolds() != 0) {
            Log.info((Object[])new Object[]{"_overwrite_with_best_model: Disabling overwrite_with_best_model in combination with n-fold cross-validation."});
            toParms._overwrite_with_best_model = false;
        }
        if (fromParms._adaptive_rate) {
            Log.info((Object[])new Object[]{"_adaptive_rate: Using automatic learning rate. Ignoring the following input parameters: rate, rate_decay, rate_annealing, momentum_start, momentum_ramp, momentum_stable, nesterov_accelerated_gradient."});
            toParms._rate = 0.0;
            toParms._rate_decay = 0.0;
            toParms._rate_annealing = 0.0;
            toParms._momentum_start = 0.0;
            toParms._momentum_ramp = 0.0;
            toParms._momentum_stable = 0.0;
            toParms._nesterov_accelerated_gradient = false;
        } else {
            Log.info((Object[])new Object[]{"_adaptive_rate: Using manual learning rate. Ignoring the following input parameters: rho, epsilon."});
            toParms._rho = 0.0;
            toParms._epsilon = 0.0;
        }
        if (fromParms.getNumFolds() != 0 && fromParms._overwrite_with_best_model) {
            Log.info((Object[])new Object[]{"_overwrite_with_best_model: Automatically disabling overwrite_with_best_model, since the final model is the only scored model with n-fold cross-validation."});
            toParms._overwrite_with_best_model = false;
        }
        if (fromParms._loss == DeepLearningParameters.Loss.Automatic) {
            toParms._loss = classification && !fromParms._autoencoder ? DeepLearningParameters.Loss.CrossEntropy : DeepLearningParameters.Loss.MeanSquare;
            Log.info((Object[])new Object[]{"_loss: Automatically setting loss function to " + (Object)((Object)toParms._loss)});
        }
        if (fromParms._reproducible) {
            Log.info((Object[])new Object[]{"_reproducibility: Automatically enabling force_load_balancing, disabling single_node_mode and replicate_training_data\nand setting train_samples_per_iteration to -1 to enforce reproducibility."});
            toParms._force_load_balance = true;
            toParms._single_node_mode = false;
            toParms._train_samples_per_iteration = -1L;
            toParms._replicate_training_data = false;
        }
    }

    boolean doScoring(Frame ftrain, Frame ftest, Key job_key, Key progressKey) {
        boolean keep_running;
        try {
            long now = System.currentTimeMillis();
            this.epoch_counter = (float)this.model_info().get_processed_total() / (float)this.training_rows;
            double time_last_iter_millis = Math.max(5L, now - this._timeLastScoreEnter);
            if (H2O.CLOUD.size() > 1 && this.get_params()._train_samples_per_iteration == -2L && this.time_for_communication_us > 10000.0) {
                double comm_to_work_ratio = this.time_for_communication_us * 0.001 / time_last_iter_millis;
                double correction = this.get_params()._target_ratio_comm_to_comp / comm_to_work_ratio;
                this.actual_train_samples_per_iteration = (long)((double)this.actual_train_samples_per_iteration / correction);
                this.actual_train_samples_per_iteration = Math.max(1L, this.actual_train_samples_per_iteration);
            }
            this.run_time = (long)((double)this.run_time + time_last_iter_millis);
            this._timeLastScoreEnter = now;
            keep_running = this.epoch_counter < this.model_info().get_params()._epochs;
            long sinceLastScore = now - this._timeLastScoreStart;
            long sinceLastPrint = now - this._timeLastPrintStart;
            if (!keep_running || (double)sinceLastPrint > this.get_params()._score_interval * 1000.0) {
                this._timeLastPrintStart = now;
                if (!this.get_params()._quiet_mode) {
                    Log.info((Object[])new Object[]{"Training time: " + PrettyPrint.msecs((long)this.run_time, (boolean)true) + ". Processed " + String.format("%,d", this.model_info().get_processed_total()) + " samples" + " (" + String.format("%.3f", this.epoch_counter) + " epochs)." + " Speed: " + String.format("%.3f", 1000.0 * (double)this.model_info().get_processed_total() / (double)this.run_time) + " samples/sec.\n"});
                }
            }
            if (!keep_running || (double)sinceLastScore > this.get_params()._score_interval * 1000.0 && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < this.get_params()._score_duty_cycle) {
                ModelMetricsSupervised mm1;
                if (progressKey != null) {
                    new Job.ProgressUpdate("Scoring on " + ftrain.numRows() + " training samples" + (ftest != null ? ", " + ftest.numRows() + " validation samples)" : ")")).fork(progressKey);
                }
                boolean printme = !this.get_params()._quiet_mode;
                this._timeLastScoreStart = now;
                if (this.get_params()._diagnostics) {
                    this.model_info().computeStats();
                }
                DeepLearningScoring err = new DeepLearningScoring();
                err.training_time_ms = this.run_time;
                err.epoch_counter = this.epoch_counter;
                err.training_samples = this.model_info().get_processed_total();
                err.validation = ftest != null;
                err.score_training_samples = ftrain.numRows();
                err.classification = ((DeepLearningModelOutput)this._output).isClassifier();
                if (this.get_params()._autoencoder) {
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the auto-encoder."});
                    }
                    Frame mse_frame = this.scoreAutoEncoder(ftrain, Key.make());
                    Vec l2 = mse_frame.anyVec();
                    Log.info((Object[])new Object[]{"Mean reconstruction error on training data: " + l2.mean() + "\n"});
                    err.training_MSE = l2.mean();
                    mse_frame.delete();
                    mm1 = (ModelMetricsAutoEncoder)ModelMetrics.getFromDKV((Model)this, (Frame)ftrain);
                    err.training_MSE = err.train_err = mm1._MSE;
                    ((DeepLearningModelOutput)this._output)._training_metrics = mm1;
                    if (ftest != null) {
                        mse_frame = this.scoreAutoEncoder(ftest, Key.make());
                        l2 = mse_frame.anyVec();
                        Log.info((Object[])new Object[]{"Mean reconstruction error on validation data: " + l2.mean() + "\n"});
                        err.validation_MSE = l2.mean();
                        mse_frame.delete();
                        mm1 = (ModelMetricsAutoEncoder)ModelMetrics.getFromDKV((Model)this, (Frame)ftest);
                        err.validation_MSE = err.valid_err = mm1._MSE;
                        ((DeepLearningModelOutput)this._output)._validation_metrics = mm1;
                    }
                } else {
                    ModelMetricsBinomial mm;
                    String m;
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the model."});
                    }
                    if ((m = this.model_info().toString()).length() > 0) {
                        Log.info((Object[])new Object[]{m});
                    }
                    Frame trainPredict = this.score(ftrain);
                    trainPredict.delete();
                    mm1 = (ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)this, (Frame)ftrain);
                    if (mm1 instanceof ModelMetricsBinomial) {
                        mm = (ModelMetricsBinomial)mm1;
                        err.training_AUC = mm._auc;
                        err.train_confusion_matrix = mm.cm();
                        err.train_err = err.train_confusion_matrix.err();
                        err.train_logloss = mm._logloss;
                    } else if (mm1 instanceof ModelMetricsMultinomial) {
                        mm = (ModelMetricsMultinomial)mm1;
                        err.train_confusion_matrix = mm.cm();
                        err.train_err = err.train_confusion_matrix.err();
                        err.train_logloss = mm._logloss;
                        err.train_hitratio = mm._hit_ratios;
                    }
                    err.training_MSE = mm1._MSE;
                    err.training_R2 = mm1.r2();
                    ((DeepLearningModelOutput)this._output)._training_metrics = mm1;
                    if (this.get_params()._score_training_samples != 0L && this.get_params()._score_training_samples < ftrain.numRows()) {
                        ((DeepLearningModelOutput)this._output)._training_metrics._description = "Metrics reported on " + ftrain.numRows() + " training set samples";
                    }
                    if (ftest != null) {
                        Frame validPred = this.score(ftest);
                        validPred.delete();
                        ModelMetricsSupervised mm2 = (ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)this, (Frame)ftest);
                        if (mm2 != null) {
                            ModelMetricsBinomial mm3;
                            if (mm2 instanceof ModelMetricsBinomial) {
                                mm3 = (ModelMetricsBinomial)mm2;
                                err.validation_AUC = mm3._auc;
                                err.valid_confusion_matrix = mm3.cm();
                                err.valid_logloss = mm3._logloss;
                                err.valid_err = err.valid_confusion_matrix.err();
                            } else if (mm2 instanceof ModelMetricsMultinomial) {
                                mm3 = (ModelMetricsMultinomial)mm2;
                                err.valid_confusion_matrix = mm3.cm();
                                err.valid_err = err.valid_confusion_matrix.err();
                                err.valid_logloss = mm3._logloss;
                                err.valid_hitratio = mm3._hit_ratios;
                            }
                            err.validation_MSE = mm2._MSE;
                            err.validation_R2 = mm2.r2();
                            ((DeepLearningModelOutput)this._output)._validation_metrics = mm2;
                            if (this.get_params()._score_validation_samples != 0L && this.get_params()._score_validation_samples != ftest.numRows()) {
                                ((DeepLearningModelOutput)this._output)._validation_metrics._description = "Metrics reported on " + ftest.numRows() + " validation set samples";
                                if (this.get_params()._score_validation_sampling == DeepLearningParameters.ClassSamplingMethod.Stratified) {
                                    ((DeepLearningModelOutput)this._output)._validation_metrics._description = ((DeepLearningModelOutput)this._output)._validation_metrics._description + " (stratified sampling)";
                                }
                            }
                        }
                    }
                }
                if (this.get_params()._variable_importances) {
                    if (!this.get_params()._quiet_mode) {
                        Log.info((Object[])new Object[]{"Computing variable importances."});
                    }
                    float[] vi = this.model_info().computeVariableImportances();
                    err.variable_importances = new VarImp(vi, Arrays.copyOfRange(this.model_info().data_info().coefNames(), 0, vi.length));
                }
                this._timeLastScoreEnd = System.currentTimeMillis();
                err.scoring_time = System.currentTimeMillis() - now;
                if (this.errors == null) {
                    this.errors = new DeepLearningScoring[]{err};
                } else {
                    DeepLearningScoring[] err2 = new DeepLearningScoring[this.errors.length + 1];
                    System.arraycopy(this.errors, 0, err2, 0, this.errors.length);
                    err2[err2.length - 1] = err;
                    this.errors = err2;
                }
                ((DeepLearningModelOutput)this._output).errors = this.last_scored();
                Timer t = new Timer();
                if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
                    int i;
                    for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                        this.model_info.get_weights(i).toFrame(((DeepLearningModelOutput)this._output).weights[i]);
                    }
                    for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                        this.model_info.get_biases(i).toFrame(((DeepLearningModelOutput)this._output).biases[i]);
                    }
                    Log.info((Object[])new Object[]{"Writing weights and biases to Frames took " + (double)t.time() / 1000.0 + " seconds."});
                }
                ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
                ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
                ((DeepLearningModelOutput)this._output)._model_summary = this.model_info.createSummaryTable();
                if (!this.get_params()._autoencoder) {
                    if (this.actual_best_model_key != null && this.get_params()._overwrite_with_best_model && (DKV.get((Key)this.actual_best_model_key) != null && (this.error() < ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).error() || !Arrays.equals(this.model_info().units, ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).model_info().units)) || DKV.get((Key)this.actual_best_model_key) == null && this.error() < this._bestError)) {
                        if (!this.get_params()._quiet_mode) {
                            Log.info((Object[])new Object[]{"Error reduced from " + this._bestError + " to " + this.error() + "."});
                        }
                        this._bestError = this.error();
                        this.putMeAsBestModel(this.actual_best_model_key);
                    }
                    if (keep_running) {
                        for (String s : this.toString().split("\n")) {
                            Log.info((Object[])new Object[]{s});
                        }
                    }
                    if (printme) {
                        Log.info((Object[])new Object[]{"Time taken for scoring and diagnostics: " + PrettyPrint.msecs((long)err.scoring_time, (boolean)true)});
                    }
                }
            }
            if (this.model_info().unstable()) {
                Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
                keep_running = false;
            } else if (((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().train_err <= this.get_params()._classification_stop || !((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().training_MSE <= this.get_params()._regression_stop) {
                Log.info((Object[])new Object[]{"Achieved requested predictive accuracy on the training data. Model building completed."});
                keep_running = false;
            }
            this.update(job_key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return keep_running;
    }

    public String toString() {
        return ((DeepLearningModelOutput)this._output).toString();
    }

    protected Frame scoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        if (!this.get_params()._autoencoder) {
            return super.scoreImpl(orig, adaptedFr, destination_key);
        }
        final int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        Frame adaptFrm = new Frame(adaptedFr);
        for (int c = 0; c < len; ++c) {
            adaptFrm.add(prefix + coefnames[c], adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length];
                float[] preds = new float[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    float[] p = DeepLearningModel.this.score_autoencoder(chks, row, tmp, preds, neurons);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningModelOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, Double.NaN);
        return f;
    }

    public double[] score0(double[] data, double[] preds) {
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info);
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, false, null);
        float[] out = neurons[neurons.length - 1]._a.raw();
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            assert (preds.length == out.length + 1);
            for (int i = 0; i < preds.length - 1; ++i) {
                preds[i + 1] = out[i];
                if (!Double.isNaN(preds[i + 1])) continue;
                throw new RuntimeException("Predicted class probability NaN!");
            }
            preds[0] = -1.0;
        } else {
            preds[0] = this.model_info().data_info()._normRespMul != null ? (double)out[0] / this.model_info().data_info()._normRespMul[0] + this.model_info().data_info()._normRespSub[0] : (double)out[0];
            if (Double.isNaN(preds[0])) {
                throw new RuntimeException("Predicted regression target NaN!");
            }
        }
        return preds;
    }

    public Frame scoreAutoEncoder(Frame frame, Key destination_key) {
        if (!this.get_params()._autoencoder) {
            throw new H2OIllegalArgumentException("Only for AutoEncoder Deep Learning model.", "");
        }
        final int len = ((DeepLearningModelOutput)this._output)._names.length;
        Frame adaptFrm = new Frame(frame);
        Vec v0 = adaptFrm.anyVec().makeZero();
        Scope.enter();
        this.adaptTestForTrain(adaptFrm, true);
        adaptFrm.add("Reconstruction.MSE", v0);
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    chks[len].set(row, DeepLearningModel.this.score_autoencoder(tmp, null, neurons));
                }
            }
        }.doAll(adaptFrm);
        Scope.exit((Key[])new Key[0]);
        Frame res = adaptFrm.extractFrame(len, adaptFrm.numCols());
        res = new Frame(destination_key, res.names(), res.vecs());
        DKV.put((Keyed)res);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, frame, res.vecs()[0].mean());
        return res;
    }

    public Frame score(Frame fr, String destination_key) {
        if (!((DeepLearningParameters)this._parms)._autoencoder) {
            return super.score(fr, destination_key);
        }
        Frame adaptFr = new Frame(fr);
        this.adaptTestForTrain(adaptFr, true);
        Frame output = this.scoreImpl(fr, adaptFr, destination_key);
        Vec[] vecs = adaptFr.vecs();
        for (int i = 0; i < vecs.length; ++i) {
            if (fr.find(vecs[i]) == -1) continue;
            vecs[i] = null;
        }
        adaptFr.delete();
        return output;
    }

    public Frame scoreDeepFeatures(Frame frame, final int layer) {
        int ridx;
        if (layer < 0 || layer >= this.model_info().get_params()._hidden.length) {
            throw new H2OIllegalArgumentException("hidden layer (index) to extract must be between 0 and " + (this.model_info().get_params()._hidden.length - 1), "");
        }
        final int len = ((DeepLearningModelOutput)this._output).nfeatures();
        Vec resp = null;
        if (this.isSupervised() && (ridx = frame.find(((DeepLearningModelOutput)this._output).responseName())) != -1) {
            frame = new Frame(frame);
            resp = frame.vecs()[ridx];
            frame.remove(ridx);
        }
        Frame adaptFrm = new Frame(frame);
        final int features = this.model_info().get_params()._hidden[layer];
        Vec[] vecs = adaptFrm.anyVec().makeZeros(features);
        Scope.enter();
        DeepLearningModel.adaptTestForTrain((String[])((DeepLearningModelOutput)this._output)._names, null, (String[][])((DeepLearningModelOutput)this._output)._domains, (Frame)adaptFrm, (double)((DeepLearningParameters)this._parms).missingColumnsType(), (boolean)true);
        for (int j = 0; j < features; ++j) {
            adaptFrm.add("DF.L" + (layer + 1) + ".C" + (j + 1), vecs[j]);
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    ((Neurons.Input)neurons[0]).setInput(-1L, tmp);
                    DeepLearningTask.step(-1L, neurons, DeepLearningModel.this.model_info, false, null);
                    float[] out = neurons[layer + 1]._a.raw();
                    for (int c = 0; c < features; ++c) {
                        chks[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length + c].set(row, out[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningModelOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame ret = adaptFrm.extractFrame(x, y);
        if (resp != null) {
            ret.prepend(((DeepLearningModelOutput)this._output).responseName(), resp);
        }
        Scope.exit((Key[])new Key[0]);
        return ret;
    }

    private float[] score_autoencoder(Chunk[] chks, int row_in_chunk, double[] tmp, float[] preds, Neurons[] neurons) {
        assert (this.get_params()._autoencoder);
        assert (tmp.length == ((DeepLearningModelOutput)this._output)._names.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        this.score_autoencoder(tmp, preds, neurons);
        return preds;
    }

    private double score_autoencoder(double[] data, float[] preds, Neurons[] neurons) {
        assert (this.model_info().get_params()._autoencoder);
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, false, null);
        float[] in = neurons[0]._a.raw();
        float[] out = neurons[neurons.length - 1]._a.raw();
        assert (in.length == out.length);
        double l2 = 0.0;
        for (int i = 0; i < in.length; ++i) {
            l2 += Math.pow(out[i] - in[i], 2.0);
        }
        l2 /= (double)in.length;
        if (preds != null) {
            this.model_info().data_info().unScaleNumericals(out, out);
            System.arraycopy(out, 0, preds, 0, out.length);
        }
        return l2;
    }

    public double calcOutlierThreshold(Vec mse, double quantile) {
        Frame mse_frame = new Frame(Key.make(), new String[]{"Reconstruction.MSE"}, new Vec[]{mse});
        DKV.put((Key)mse_frame._key, (Iced)mse_frame);
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._train = mse_frame._key;
        parms._probs = new double[]{quantile};
        Quantile job = new Quantile(parms).trainModel();
        QuantileModel kmm = (QuantileModel)job.get();
        job.remove();
        double q = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0];
        kmm.delete();
        DKV.remove((Key)mse_frame._key);
        return q;
    }

    private void putMeAsBestModel(Key bestModelKey) {
        DeepLearningModel bestModel = new DeepLearningModel(bestModelKey, null, this, true, this.model_info().data_info());
        DKV.put((Key)bestModel._key, (Iced)bestModel);
        assert (DKV.get((Key)bestModelKey) != null);
        assert (bestModel.compareTo(this) <= 0);
    }

    public void delete() {
        if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
            for (Key k : ((DeepLearningModelOutput)this._output).weights) {
                if (DKV.getGet((Key)k) == null) continue;
                ((Frame)DKV.getGet((Key)k)).delete();
            }
            for (Key k : ((DeepLearningModelOutput)this._output).biases) {
                if (DKV.getGet((Key)k) == null) continue;
                ((Frame)DKV.getGet((Key)k)).delete();
            }
        }
        super.delete();
    }

    void delete_xval_models() {
    }

    private String getHeader() {
        assert (this.get_params()._autoencoder);
        StringBuilder sb = new StringBuilder();
        int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        for (int c = 0; c < len; ++c) {
            if (c > 0) {
                sb.append(",");
            }
            sb.append(prefix + coefnames[c]);
        }
        return sb.toString();
    }

    protected SB toJavaInit(SB sb, SB fileContextSB) {
        String colInfoClazz;
        int i;
        sb = super.toJavaInit(sb, fileContextSB);
        String mname = JCodeGen.toJavaId((String)this._key.toString());
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info());
        DeepLearningParameters p = this.model_info.get_params();
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((DeepLearningModelOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + (p._autoencoder ? neurons[neurons.length - 1].units : ((DeepLearningModelOutput)this._output).nclasses()) + "; }").nl();
        sb.ip("public ModelCategory getModelCategory() { return ModelCategory." + ((DeepLearningModelOutput)this._output).getModelCategory() + "; }").nl();
        if (this.model_info().data_info()._nums > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"NUMS", (double[])new double[this.model_info().data_info()._nums], (String)"Workspace for storing numerical input variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMMUL", (double[])this.model_info().data_info()._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMSUB", (double[])this.model_info().data_info()._normSub, (String)"Standardization/Normalization offset for numerical variables.");
        }
        if (this.model_info().data_info()._cats > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"CATS", (int[])new int[this.model_info().data_info()._cats], (String)"Workspace for storing categorical input variables.");
        }
        JCodeGen.toStaticVar((SB)sb, (String)"CATOFFSETS", (int[])this.model_info().data_info()._catOffsets, (String)"Workspace for categorical offsets.");
        if (this.model_info().data_info()._normRespMul != null) {
            JCodeGen.toStaticVar((SB)sb, (String)"NORMRESPMUL", (double[])this.model_info().data_info()._normRespMul, (String)"Standardization/Normalization scaling factor for response.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMRESPSUB", (double[])this.model_info().data_info()._normRespSub, (String)"Standardization/Normalization offset for response.");
        }
        if (p._hidden_dropout_ratios != null) {
            JCodeGen.toStaticVar((SB)sb, (String)"HIDDEN_DROPOUT_RATIOS", (double[])p._hidden_dropout_ratios, (String)"Hidden layer dropout ratios.");
        }
        int[] layers = new int[neurons.length];
        for (i = 0; i < neurons.length; ++i) {
            layers[i] = neurons[i].units;
        }
        JCodeGen.toStaticVar((SB)sb, (String)"NEURONS", (int[])layers, (String)"Number of neurons for each layer.");
        if (this.get_params()._autoencoder) {
            sb.i(1).p("public int getPredsSize() { return " + this.model_info.units[this.model_info.units.length - 1] + "; }").nl();
            sb.i(1).p("public boolean isAutoEncoder() { return true; }").nl();
            sb.i(1).p("public String getHeader() { return \"" + this.getHeader() + "\"; }").nl();
        }
        sb.i(1).p("// Storage for neuron activation values.").nl();
        sb.i(1).p("public static final float[][] ACTIVATION = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            colInfoClazz = mname + "_Activation_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            fileContextSB.i().p("// Neuron activation values for ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, (float[])new float[layers[i]]);
        }
        sb.i(1).p("};").nl();
        sb.i(1).p("// Neuron bias values.").nl();
        sb.i(1).p("public static final float[][] BIAS = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            float[] bias;
            colInfoClazz = mname + "_Bias_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            fileContextSB.i().p("// Neuron bias values for ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            float[] fArray = bias = i == 0 ? null : new float[this.model_info().get_biases(i - 1).size()];
            if (i > 0) {
                for (int j = 0; j < bias.length; ++j) {
                    bias[j] = this.model_info().get_biases(i - 1).get(j);
                }
            }
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, (float[])bias);
        }
        sb.i(1).p("};").nl();
        sb.i(1).p("// Connecting weights between neurons.").nl();
        sb.i(1).p("public static final float[][] WEIGHT = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            float[] weights;
            colInfoClazz = mname + "_Weight_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (i > 0) {
                fileContextSB.i().p("// Neuron weights connecting ").p(neurons[i - 1].getClass().getSimpleName()).p(" and ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            }
            float[] fArray = weights = i == 0 ? null : new float[this.model_info().get_weights(i - 1).rows() * this.model_info().get_weights(i - 1).cols()];
            if (i > 0) {
                int rows = this.model_info().get_weights(i - 1).rows();
                int cols = this.model_info().get_weights(i - 1).cols();
                for (int j = 0; j < rows; ++j) {
                    for (int k = 0; k < cols; ++k) {
                        weights[j * cols + k] = this.model_info().get_weights(i - 1).get(j, k);
                    }
                }
            }
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, weights);
        }
        sb.i(1).p("};").nl();
        return sb;
    }

    protected boolean toJavaCheckTooBig() {
        return (double)this.model_info.size() > 1000000.0;
    }

    protected void toJavaPredictBody(SB bodySb, SB classCtxSb, SB fileCtxSb) {
        SB model = new SB();
        DeepLearningParameters p = this.model_info.get_params();
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = this.model_info().data_info()._cats;
        int nums = this.model_info().data_info()._nums;
        if (nums > 0) {
            bodySb.i().p("java.util.Arrays.fill(NUMS,0f);").nl();
        }
        if (cats > 0) {
            bodySb.i().p("java.util.Arrays.fill(CATS,0);").nl();
        }
        bodySb.i().p("int i = 0, ncats = 0;").nl();
        if (cats > 0) {
            bodySb.i().p("for(; i<" + cats + "; ++i) {").nl();
            bodySb.i(1).p("if (!Double.isNaN(data[i])) {").nl();
            bodySb.i(2).p("int c = (int) data[i];").nl();
            if (this.model_info().data_info()._useAllFactorLevels) {
                bodySb.i(2).p("CATS[ncats++] = c + CATOFFSETS[i];").nl();
            } else {
                bodySb.i(2).p("if (c != 0) CATS[ncats++] = c + CATOFFSETS[i] - 1;").nl();
            }
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        }
        if (nums > 0) {
            bodySb.i().p("final int n = data.length;").nl();
            bodySb.i().p("for(; i<n; ++i) {").nl();
            bodySb.i(1).p("NUMS[i" + (cats > 0 ? "-" + cats : "") + "] = Double.isNaN(data[i]) ? 0 : ");
            if (this.model_info().data_info()._normMul != null) {
                bodySb.p("(data[i] - NORMSUB[i" + (cats > 0 ? "-" + cats : "") + "])*NORMMUL[i" + (cats > 0 ? "-" + cats : "") + "];").nl();
            } else {
                bodySb.p("data[i];").nl();
            }
            bodySb.i(0).p("}").nl();
        }
        bodySb.i().p("java.util.Arrays.fill(ACTIVATION[0],0);").nl();
        if (cats > 0) {
            bodySb.i().p("for (i=0; i<ncats; ++i) ACTIVATION[0][CATS[i]] = 1f;").nl();
        }
        if (nums > 0) {
            bodySb.i().p("for (i=0; i<NUMS.length; ++i) {").nl();
            bodySb.i(1).p("ACTIVATION[0][CATOFFSETS[CATOFFSETS.length-1] + i] = Double.isNaN(NUMS[i]) ? 0f : (float) NUMS[i];").nl();
            bodySb.i().p("}").nl();
        }
        boolean tanh = p._activation == DeepLearningParameters.Activation.Tanh || p._activation == DeepLearningParameters.Activation.TanhWithDropout;
        boolean relu = p._activation == DeepLearningParameters.Activation.Rectifier || p._activation == DeepLearningParameters.Activation.RectifierWithDropout;
        boolean maxout = p._activation == DeepLearningParameters.Activation.Maxout || p._activation == DeepLearningParameters.Activation.MaxoutWithDropout;
        String stopping = p._autoencoder ? "(i<=ACTIVATION.length-1)" : "(i<ACTIVATION.length-1)";
        bodySb.i().p("for (i=1; i<ACTIVATION.length; ++i) {").nl();
        bodySb.i(1).p("java.util.Arrays.fill(ACTIVATION[i],0f);").nl();
        if (maxout) {
            bodySb.i(1).p("float rmax = 0;").nl();
            bodySb.i(1).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            bodySb.i(2).p("final int cols = ACTIVATION[i-1].length;").nl();
            bodySb.i(2).p("float cmax = Float.NEGATIVE_INFINITY;").nl();
            bodySb.i(2).p("for (int c=0; c<cols; ++c) {").nl();
            bodySb.i(3).p("if " + stopping + " cmax = Math.max(ACTIVATION[i-1][c] * WEIGHT[i][r*cols+c], cmax);").nl();
            bodySb.i(3).p("else ACTIVATION[i][r] += ACTIVATION[i-1][c] * WEIGHT[i][r*cols+c];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("if " + stopping + " ACTIVATION[i][r] = Float.isInfinite(cmax) ? 0f : cmax;").nl();
            bodySb.i(2).p("ACTIVATION[i][r] += BIAS[i][r];").nl();
            bodySb.i(2).p("if " + stopping + " rmax = Math.max(rmax, ACTIVATION[i][r]);").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            bodySb.i(3).p("if (rmax > 1 ) ACTIVATION[i][r] /= rmax;").nl();
        } else {
            bodySb.i(1).p("int cols = ACTIVATION[i-1].length;").nl();
            bodySb.i(1).p("int rows = ACTIVATION[i].length;").nl();
            bodySb.i(1).p("int extra=cols-cols%8;").nl();
            bodySb.i(1).p("int multiple = (cols/8)*8-1;").nl();
            bodySb.i(1).p("int idx = 0;").nl();
            bodySb.i(1).p("float[] a = WEIGHT[i];").nl();
            bodySb.i(1).p("float[] x = ACTIVATION[i-1];").nl();
            bodySb.i(1).p("float[] y = BIAS[i];").nl();
            bodySb.i(1).p("float[] res = ACTIVATION[i];").nl();
            bodySb.i(1).p("for (int row=0; row<rows; ++row) {").nl();
            bodySb.i(2).p("float psum0 = 0, psum1 = 0, psum2 = 0, psum3 = 0, psum4 = 0, psum5 = 0, psum6 = 0, psum7 = 0;").nl();
            bodySb.i(2).p("for (int col = 0; col < multiple; col += 8) {").nl();
            bodySb.i(3).p("int off = idx + col;").nl();
            bodySb.i(3).p("psum0 += a[off    ] * x[col    ];").nl();
            bodySb.i(3).p("psum1 += a[off + 1] * x[col + 1];").nl();
            bodySb.i(3).p("psum2 += a[off + 2] * x[col + 2];").nl();
            bodySb.i(3).p("psum3 += a[off + 3] * x[col + 3];").nl();
            bodySb.i(3).p("psum4 += a[off + 4] * x[col + 4];").nl();
            bodySb.i(3).p("psum5 += a[off + 5] * x[col + 5];").nl();
            bodySb.i(3).p("psum6 += a[off + 6] * x[col + 6];").nl();
            bodySb.i(3).p("psum7 += a[off + 7] * x[col + 7];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("res[row] += psum0 + psum1 + psum2 + psum3;").nl();
            bodySb.i(2).p("res[row] += psum4 + psum5 + psum6 + psum7;").nl();
            bodySb.i(2).p("for (int col = extra; col < cols; col++)").nl();
            bodySb.i(3).p("res[row] += a[idx + col] * x[col];").nl();
            bodySb.i(2).p("res[row] += y[row];").nl();
            bodySb.i(2).p("idx += cols;").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i(1).p("if " + stopping + " {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            if (tanh) {
                bodySb.i(3).p("ACTIVATION[i][r] = 1f - 2f / (1f + (float)Math.exp(2*ACTIVATION[i][r]));").nl();
            } else if (relu) {
                bodySb.i(3).p("ACTIVATION[i][r] = Math.max(0f, ACTIVATION[i][r]);").nl();
            }
        }
        if (p._hidden_dropout_ratios != null) {
            bodySb.i(3).p("if (i<ACTIVATION.length-1) {").nl();
            bodySb.i(4).p("ACTIVATION[i][r] *= HIDDEN_DROPOUT_RATIOS[i-1];").nl();
            bodySb.i(3).p("}").nl();
        }
        bodySb.i(2).p("}").nl();
        if (!maxout) {
            bodySb.i(1).p("}").nl();
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("float max = ACTIVATION[i][0];").nl();
            bodySb.i(2).p("for (int r=1; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (ACTIVATION[i][r]>max) max = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("float scale = 0f;").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("ACTIVATION[i][r] = (float) Math.exp(ACTIVATION[i][r] - max);").nl();
            bodySb.i(3).p("scale += ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Float.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, predicted NaN.\");").nl();
            bodySb.i(3).p("ACTIVATION[i][r] /= scale;").nl();
            bodySb.i(3).p("preds[r+1] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else if (!p._autoencoder) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            if (this.model_info().data_info()._normRespMul != null) {
                bodySb.i(2).p("preds[1] = (ACTIVATION[i][0] / NORMRESPMUL[0] + NORMRESPSUB[0]);").nl();
            } else {
                bodySb.i(2).p("preds[1] = ACTIVATION[i][0];").nl();
            }
            bodySb.i(2).p("if (Double.isNaN(preds[1])) throw new RuntimeException(\"Predicted regression target NaN!\");").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Float.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, reconstructed NaN.\");").nl();
            bodySb.i(3).p("preds[r] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            if (this.model_info().data_info()._nums > 0) {
                int ns = this.model_info().data_info().numStart();
                bodySb.i(2).p("for (int k=" + ns + "; k<" + this.model_info().data_info().fullN() + "; ++k) {").nl();
                bodySb.i(3).p("preds[k] = preds[k] / NORMMUL[k-" + ns + "] + NORMSUB[k-" + ns + "];").nl();
                bodySb.i(2).p("}").nl();
            }
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        }
        fileCtxSb.p(model);
        if (((DeepLearningModelOutput)this._output).autoencoder) {
            return;
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            if (((DeepLearningParameters)this._parms)._balance_classes) {
                bodySb.ip("hex.genmodel.GenModel.correctProbabilities(preds, PRIOR_CLASS_DISTRIB, MODEL_CLASS_DISTRIB);").nl();
            }
            bodySb.ip("preds[0] = hex.genmodel.GenModel.getPrediction(preds, data, " + this.defaultThreshold() + ");").nl();
        } else {
            bodySb.ip("preds[0] = (float)preds[1];").nl();
        }
    }

    protected long checksum_impl() {
        return super.checksum_impl() * this.model_info.checksum_impl();
    }

    public static class DeepLearningModelInfo
    extends Iced {
        public TwoDimTable summaryTable;
        private DataInfo data_info;
        private Neurons.DenseRowMatrix[] dense_row_weights;
        private Neurons.DenseColMatrix[] dense_col_weights;
        private Neurons.DenseVector[] biases;
        private Neurons.DenseVector[] avg_activations;
        private Neurons.DenseRowMatrix[] dense_row_weights_momenta;
        private Neurons.DenseColMatrix[] dense_col_weights_momenta;
        private Neurons.DenseVector[] biases_momenta;
        private Neurons.DenseRowMatrix[] dense_row_ada_dx_g;
        private Neurons.DenseColMatrix[] dense_col_ada_dx_g;
        private Neurons.DenseVector[] biases_ada_dx_g;
        private DeepLearningParameters parameters;
        private float[] mean_rate;
        private float[] rms_rate;
        private float[] mean_bias;
        private float[] rms_bias;
        private float[] mean_weight;
        public float[] rms_weight;
        public float[] mean_a;
        private volatile boolean unstable = false;
        private long processed_global;
        private long processed_local;
        int[] units;
        final boolean _classification;
        final Frame _train;
        final Frame _valid;

        public DataInfo data_info() {
            return this.data_info;
        }

        public long size() {
            long siz = 0L;
            for (Neurons.DenseRowMatrix denseRowMatrix : this.dense_row_weights) {
                if (denseRowMatrix == null) continue;
                siz += denseRowMatrix.size();
            }
            for (Iced iced : this.dense_col_weights) {
                if (iced == null) continue;
                siz += iced.size();
            }
            for (Iced iced : this.biases) {
                siz += (long)iced.size();
            }
            return siz;
        }

        boolean has_momenta() {
            return this.get_params()._momentum_start != 0.0 || this.get_params()._momentum_stable != 0.0;
        }

        boolean adaDelta() {
            return this.get_params()._adaptive_rate;
        }

        public final Neurons.Matrix get_weights(int i) {
            return (Neurons.Matrix)(this.dense_row_weights[i] == null ? this.dense_col_weights[i] : this.dense_row_weights[i]);
        }

        public final Neurons.DenseVector get_biases(int i) {
            return this.biases[i];
        }

        public final Neurons.Matrix get_weights_momenta(int i) {
            return (Neurons.Matrix)(this.dense_row_weights_momenta[i] == null ? this.dense_col_weights_momenta[i] : this.dense_row_weights_momenta[i]);
        }

        public final Neurons.DenseVector get_biases_momenta(int i) {
            return this.biases_momenta[i];
        }

        public final Neurons.Matrix get_ada_dx_g(int i) {
            return (Neurons.Matrix)(this.dense_row_ada_dx_g[i] == null ? this.dense_col_ada_dx_g[i] : this.dense_row_ada_dx_g[i]);
        }

        public final Neurons.DenseVector get_biases_ada_dx_g(int i) {
            return this.biases_ada_dx_g[i];
        }

        public final Neurons.DenseVector get_avg_activations(int i) {
            return this.avg_activations[i];
        }

        public final DeepLearningParameters get_params() {
            return this.parameters;
        }

        public boolean unstable() {
            return this.unstable;
        }

        public void set_unstable() {
            if (!this.unstable) {
                this.computeStats();
            }
            this.unstable = true;
        }

        public synchronized long get_processed_global() {
            return this.processed_global;
        }

        public synchronized void set_processed_global(long p) {
            this.processed_global = p;
        }

        public synchronized void add_processed_global(long p) {
            this.processed_global += p;
        }

        public synchronized long get_processed_local() {
            return this.processed_local;
        }

        public synchronized void set_processed_local(long p) {
            this.processed_local = p;
        }

        public synchronized void add_processed_local(long p) {
            this.processed_local += p;
        }

        public synchronized long get_processed_total() {
            return this.processed_global + this.processed_local;
        }

        public DeepLearningModelInfo() {
            this._classification = false;
            this._valid = null;
            this._train = null;
        }

        public DeepLearningModelInfo(DeepLearningParameters params, DataInfo dinfo, boolean classification, Frame train, Frame valid) {
            int i;
            boolean warn;
            int num_output;
            this._classification = classification;
            this._train = train;
            this._valid = valid;
            this.data_info = dinfo;
            this.parameters = (DeepLearningParameters)params.clone();
            DeepLearningModel.modifyParms(this.parameters, this.parameters, this._classification);
            int num_input = dinfo.fullN();
            int n = this.get_params()._autoencoder ? num_input : (num_output = this._classification ? train.lastVec().cardinality() : 1);
            assert (num_input > 0);
            assert (num_output > 0);
            if (this.has_momenta() && this.adaDelta()) {
                throw new IllegalArgumentException("Cannot have non-zero momentum and adaptive rate at the same time.");
            }
            int layers = this.get_params()._hidden.length;
            this.units = new int[layers + 2];
            this.units[0] = this.get_params()._max_categorical_features <= Integer.MAX_VALUE - dinfo._nums ? Math.min(dinfo._nums + this.get_params()._max_categorical_features, num_input) : num_input;
            System.arraycopy(this.get_params()._hidden, 0, this.units, 1, layers);
            this.units[layers + 1] = num_output;
            boolean printLevels = (long)this.units[0] > 1000L;
            boolean bl = warn = (long)this.units[0] > 100000L;
            if (printLevels) {
                String[][] domains = dinfo._adaptedFrame.domains();
                int[] levels = new int[domains.length];
                for (int i2 = 0; i2 < levels.length; ++i2) {
                    levels[i2] = domains[i2] != null ? domains[i2].length : 0;
                }
                Arrays.sort(levels);
                if (warn) {
                    Log.warn((Object[])new Object[]{"==================================================================================================================================="});
                    Log.warn((Object[])new Object[]{num_input + " input features" + (dinfo._cats > 0 ? " (after categorical one-hot encoding)" : "") + ". Can be slow and require a lot of memory."});
                }
                if (levels[levels.length - 1] > 0) {
                    int levelcutoff = levels[levels.length - 1 - Math.min(10, levels.length - 1)];
                    int count = 0;
                    for (int i3 = 0; i3 < dinfo._adaptedFrame.numCols() - (this.get_params()._autoencoder ? 0 : 1) && count < 10; ++count, ++i3) {
                        if (dinfo._adaptedFrame.domains()[i3] == null || dinfo._adaptedFrame.domains()[i3].length < levelcutoff) continue;
                        if (warn) {
                            Log.warn((Object[])new Object[]{"Categorical feature '" + dinfo._adaptedFrame._names[i3] + "' has cardinality " + dinfo._adaptedFrame.domains()[i3].length + "."});
                            continue;
                        }
                        Log.info((Object[])new Object[]{"Categorical feature '" + dinfo._adaptedFrame._names[i3] + "' has cardinality " + dinfo._adaptedFrame.domains()[i3].length + "."});
                    }
                }
                if (warn) {
                    Log.warn((Object[])new Object[]{"Suggestions:"});
                    Log.warn((Object[])new Object[]{" *) Limit the size of the first hidden layer"});
                    if (dinfo._cats > 0) {
                        Log.warn((Object[])new Object[]{" *) Limit the total number of one-hot encoded features with the parameter 'max_categorical_features'"});
                        Log.warn((Object[])new Object[]{" *) Run h2o.interaction(...,pairwise=F) on high-cardinality categorical columns to limit the factor count, see http://learn.h2o.ai"});
                    }
                    Log.warn((Object[])new Object[]{"==================================================================================================================================="});
                }
            }
            this.dense_row_weights = new Neurons.DenseRowMatrix[layers + 1];
            this.dense_col_weights = new Neurons.DenseColMatrix[layers + 1];
            if (this.get_params()._col_major) {
                this.dense_col_weights[0] = new Neurons.DenseColMatrix(this.units[1], this.units[0]);
            } else {
                this.dense_row_weights[0] = new Neurons.DenseRowMatrix(this.units[1], this.units[0]);
            }
            for (i = 1; i <= layers; ++i) {
                this.dense_row_weights[i] = new Neurons.DenseRowMatrix(this.units[i + 1], this.units[i]);
            }
            this.biases = new Neurons.DenseVector[layers + 1];
            for (i = 0; i <= layers; ++i) {
                this.biases[i] = new Neurons.DenseVector(this.units[i + 1]);
            }
            if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
                this.avg_activations = new Neurons.DenseVector[layers];
                this.mean_a = new float[layers];
                for (i = 0; i < layers; ++i) {
                    this.avg_activations[i] = new Neurons.DenseVector(this.units[i + 1]);
                }
            }
            this.fillHelpers();
            this.mean_rate = new float[this.units.length];
            this.rms_rate = new float[this.units.length];
            this.mean_bias = new float[this.units.length];
            this.rms_bias = new float[this.units.length];
            this.mean_weight = new float[this.units.length];
            this.rms_weight = new float[this.units.length];
        }

        DeepLearningModelInfo deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (DeepLearningModelInfo)new DeepLearningModelInfo().read(ab);
        }

        void fillHelpers() {
            block9: {
                int i;
                block8: {
                    int i2;
                    if (!this.has_momenta()) break block8;
                    this.dense_row_weights_momenta = new Neurons.DenseRowMatrix[this.dense_row_weights.length];
                    this.dense_col_weights_momenta = new Neurons.DenseColMatrix[this.dense_col_weights.length];
                    if (this.dense_row_weights[0] != null) {
                        this.dense_row_weights_momenta[0] = new Neurons.DenseRowMatrix(this.units[1], this.units[0]);
                    } else {
                        this.dense_col_weights_momenta[0] = new Neurons.DenseColMatrix(this.units[1], this.units[0]);
                    }
                    for (i2 = 1; i2 < this.dense_row_weights_momenta.length; ++i2) {
                        this.dense_row_weights_momenta[i2] = new Neurons.DenseRowMatrix(this.units[i2 + 1], this.units[i2]);
                    }
                    this.biases_momenta = new Neurons.DenseVector[this.biases.length];
                    for (i2 = 0; i2 < this.biases_momenta.length; ++i2) {
                        this.biases_momenta[i2] = new Neurons.DenseVector(this.units[i2 + 1]);
                    }
                    break block9;
                }
                if (!this.adaDelta()) break block9;
                this.dense_row_ada_dx_g = new Neurons.DenseRowMatrix[this.dense_row_weights.length];
                this.dense_col_ada_dx_g = new Neurons.DenseColMatrix[this.dense_col_weights.length];
                if (this.dense_row_weights[0] != null) {
                    this.dense_row_ada_dx_g[0] = new Neurons.DenseRowMatrix(this.units[1], 2 * this.units[0]);
                } else {
                    this.dense_col_ada_dx_g[0] = new Neurons.DenseColMatrix(2 * this.units[1], this.units[0]);
                }
                for (i = 1; i < this.dense_row_ada_dx_g.length; ++i) {
                    this.dense_row_ada_dx_g[i] = new Neurons.DenseRowMatrix(this.units[i + 1], 2 * this.units[i]);
                }
                this.biases_ada_dx_g = new Neurons.DenseVector[this.biases.length];
                for (i = 0; i < this.biases_ada_dx_g.length; ++i) {
                    this.biases_ada_dx_g[i] = new Neurons.DenseVector(2 * this.units[i + 1]);
                }
            }
        }

        public TwoDimTable createSummaryTable() {
            Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this);
            long byte_size = new AutoBuffer().put((Freezable)this).buf().length;
            TwoDimTable table = new TwoDimTable("Status of Neuron Layers", (!this.get_params()._autoencoder ? "predicting " + this._train.lastVecName() + ", " : "") + (this.get_params()._autoencoder ? "auto-encoder" : (this._classification ? this.units[this.units.length - 1] + "-class classification" : "regression")) + ", " + this.get_params()._loss.toString() + " loss, " + String.format("%,d", this.size()) + " weights/biases, " + PrettyPrint.bytes((long)byte_size), new String[neurons.length], new String[]{"Layer", "Units", "Type", "Dropout", "L1", "L2", "Mean Rate", "Rate RMS", "Momentum", "Mean Weight", "Weight RMS", "Mean Bias", "Bias RMS"}, new String[]{"int", "int", "string", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"}, new String[]{"%d", "%d", "%s", "%2.2f %%", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f"}, "");
            String format = "%7g";
            for (int i = 0; i < neurons.length; ++i) {
                table.set(i, 0, (Object)(i + 1));
                table.set(i, 1, (Object)neurons[i].units);
                table.set(i, 2, (Object)neurons[i].getClass().getSimpleName());
                if (i == 0) {
                    table.set(i, 3, (Object)(neurons[i].params._input_dropout_ratio * 100.0));
                    continue;
                }
                if (i < neurons.length - 1) {
                    if (neurons[i].params._hidden_dropout_ratios == null) {
                        table.set(i, 3, (Object)0);
                    } else {
                        table.set(i, 3, (Object)(neurons[i].params._hidden_dropout_ratios[i - 1] * 100.0));
                    }
                }
                table.set(i, 4, (Object)neurons[i].params._l1);
                table.set(i, 5, (Object)neurons[i].params._l2);
                table.set(i, 6, (Object)Float.valueOf(this.get_params()._adaptive_rate ? this.mean_rate[i] : neurons[i].rate(this.get_processed_total())));
                table.set(i, 7, (Object)Float.valueOf(this.get_params()._adaptive_rate ? this.rms_rate[i] : 0.0f));
                table.set(i, 8, (Object)Float.valueOf(this.get_params()._adaptive_rate ? 0.0f : neurons[i].momentum(this.get_processed_total())));
                table.set(i, 9, (Object)Float.valueOf(this.mean_weight[i]));
                table.set(i, 10, (Object)Float.valueOf(this.rms_weight[i]));
                table.set(i, 11, (Object)Float.valueOf(this.mean_bias[i]));
                table.set(i, 12, (Object)Float.valueOf(this.rms_bias[i]));
            }
            this.summaryTable = table;
            return this.summaryTable;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.get_params()._diagnostics && !this.get_params()._quiet_mode) {
                if (this.get_params()._sparsity_beta > 0.0) {
                    for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                        sb.append("Average activation in hidden layer ").append(k).append(" is  ").append(this.mean_a[k]).append(" \n");
                    }
                }
                this.createSummaryTable();
                sb.append(this.summaryTable.toString(1));
            }
            return sb.toString();
        }

        public String toStringAll() {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString());
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nweights[").append(i).append("][]=").append(Arrays.toString(this.get_weights(i).raw()));
            }
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nbiases[").append(i).append("][]=").append(Arrays.toString(this.get_biases(i).raw()));
            }
            if (this.has_momenta()) {
                for (i = 0; i < this.units.length - 1; ++i) {
                    sb.append("\nweights_momenta[").append(i).append("][]=").append(Arrays.toString(this.get_weights_momenta(i).raw()));
                }
            }
            if (this.biases_momenta != null) {
                for (i = 0; i < this.units.length - 1; ++i) {
                    sb.append("\nbiases_momenta[").append(i).append("][]=").append(Arrays.toString(this.biases_momenta[i].raw()));
                }
            }
            sb.append("\nunits[]=").append(Arrays.toString(this.units));
            sb.append("\nprocessed global: ").append(this.get_processed_global());
            sb.append("\nprocessed local:  ").append(this.get_processed_local());
            sb.append("\nprocessed total:  ").append(this.get_processed_total());
            sb.append("\n");
            return sb.toString();
        }

        void initializeMembers() {
            this.randomizeWeights();
            for (int i = 0; i < this.get_params()._hidden.length; ++i) {
                if (this.get_params()._activation == DeepLearningParameters.Activation.Rectifier || this.get_params()._activation == DeepLearningParameters.Activation.RectifierWithDropout || this.get_params()._activation == DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningParameters.Activation.MaxoutWithDropout) {
                    Arrays.fill(this.biases[i].raw(), i == 0 ? 0.5f : 1.0f);
                    continue;
                }
                if (this.get_params()._activation != DeepLearningParameters.Activation.Tanh && this.get_params()._activation != DeepLearningParameters.Activation.TanhWithDropout) continue;
                Arrays.fill(this.biases[i].raw(), 0.0f);
            }
            Arrays.fill(this.biases[this.biases.length - 1].raw(), 0.0f);
        }

        public void add(DeepLearningModelInfo other) {
            int i;
            for (i = 0; i < this.dense_row_weights.length; ++i) {
                ArrayUtils.add((float[])this.get_weights(i).raw(), (float[])other.get_weights(i).raw());
            }
            for (i = 0; i < this.biases.length; ++i) {
                ArrayUtils.add((float[])this.biases[i].raw(), (float[])other.biases[i].raw());
            }
            if (this.avg_activations != null) {
                for (i = 0; i < this.avg_activations.length; ++i) {
                    ArrayUtils.add((float[])this.avg_activations[i].raw(), (float[])other.biases[i].raw());
                }
            }
            if (this.has_momenta()) {
                assert (other.has_momenta());
                for (i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                    ArrayUtils.add((float[])this.get_weights_momenta(i).raw(), (float[])other.get_weights_momenta(i).raw());
                }
                for (i = 0; i < this.biases_momenta.length; ++i) {
                    ArrayUtils.add((float[])this.biases_momenta[i].raw(), (float[])other.biases_momenta[i].raw());
                }
            }
            if (this.adaDelta()) {
                assert (other.adaDelta());
                for (i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                    ArrayUtils.add((float[])this.get_ada_dx_g(i).raw(), (float[])other.get_ada_dx_g(i).raw());
                }
            }
            this.add_processed_local(other.get_processed_local());
        }

        protected void div(float N) {
            for (int i = 0; i < this.dense_row_weights.length; ++i) {
                ArrayUtils.div((float[])this.get_weights(i).raw(), (float)N);
            }
            for (Neurons.DenseVector bias : this.biases) {
                ArrayUtils.div((float[])bias.raw(), (float)N);
            }
            if (this.avg_activations != null) {
                for (Neurons.DenseVector avgac : this.avg_activations) {
                    ArrayUtils.div((float[])avgac.raw(), (float)N);
                }
            }
            if (this.has_momenta()) {
                for (int i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                    ArrayUtils.div((float[])this.get_weights_momenta(i).raw(), (float)N);
                }
                for (Neurons.DenseVector bias_momenta : this.biases_momenta) {
                    ArrayUtils.div((float[])bias_momenta.raw(), (float)N);
                }
            }
            if (this.adaDelta()) {
                for (int i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                    ArrayUtils.div((float[])this.get_ada_dx_g(i).raw(), (float)N);
                }
            }
        }

        double uniformDist(Random rand, double min, double max) {
            return min + (double)rand.nextFloat() * (max - min);
        }

        void randomizeWeights() {
            for (int w = 0; w < this.dense_row_weights.length; ++w) {
                Random rng = RandomUtils.getRNG((long[])new long[]{this.get_params()._seed + 195911405L + (long)w + 1L});
                double range = Math.sqrt(6.0 / (double)(this.units[w] + this.units[w + 1]));
                for (int i = 0; i < this.get_weights(w).rows(); ++i) {
                    for (int j = 0; j < this.get_weights(w).cols(); ++j) {
                        if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.UniformAdaptive) {
                            if (w == this.dense_row_weights.length - 1 && this._classification) {
                                this.get_weights(w).set(i, j, (float)(4.0 * this.uniformDist(rng, -range, range)));
                                continue;
                            }
                            this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -range, range));
                            continue;
                        }
                        if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.Uniform) {
                            this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -this.get_params()._initial_weight_scale, this.get_params()._initial_weight_scale));
                            continue;
                        }
                        if (this.get_params()._initial_weight_distribution != DeepLearningParameters.InitialWeightDistribution.Normal) continue;
                        this.get_weights(w).set(i, j, (float)(rng.nextGaussian() * this.get_params()._initial_weight_scale));
                    }
                }
            }
        }

        public float[] computeVariableImportances() {
            int i;
            int k;
            float[] vi = new float[this.units[0]];
            Arrays.fill(vi, 0.0f);
            float[][] Qik = new float[this.units[0]][this.units[2]];
            float[] sum_wj = new float[this.units[1]];
            float[] sum_wk = new float[this.units[2]];
            for (float[] Qi : Qik) {
                Arrays.fill(Qi, 0.0f);
            }
            Arrays.fill(sum_wj, 0.0f);
            Arrays.fill(sum_wk, 0.0f);
            for (int j = 0; j < this.units[1]; ++j) {
                for (int i2 = 0; i2 < this.units[0]; ++i2) {
                    float wij = this.get_weights(0).get(j, i2);
                    int n = j;
                    sum_wj[n] = sum_wj[n] + Math.abs(wij);
                }
            }
            for (k = 0; k < this.units[2]; ++k) {
                for (int j = 0; j < this.units[1]; ++j) {
                    float wjk = this.get_weights(1).get(k, j);
                    int n = k;
                    sum_wk[n] = sum_wk[n] + Math.abs(wjk);
                }
            }
            for (i = 0; i < this.units[0]; ++i) {
                for (int k2 = 0; k2 < this.units[2]; ++k2) {
                    for (int j = 0; j < this.units[1]; ++j) {
                        float wij = this.get_weights(0).get(j, i);
                        float wjk = this.get_weights(1).get(k2, j);
                        float[] fArray = Qik[i];
                        int n = k2;
                        fArray[n] = fArray[n] + Math.abs(wij) / sum_wj[j] * Math.abs(wjk) / sum_wk[k2];
                    }
                }
            }
            for (k = 0; k < this.units[2]; ++k) {
                int i3;
                float sumQk = 0.0f;
                for (i3 = 0; i3 < this.units[0]; ++i3) {
                    sumQk += Qik[i3][k];
                }
                for (i3 = 0; i3 < this.units[0]; ++i3) {
                    float[] fArray = Qik[i3];
                    int n = k;
                    fArray[n] = fArray[n] / sumQk;
                }
            }
            for (i = 0; i < this.units[0]; ++i) {
                vi[i] = ArrayUtils.sum((float[])Qik[i]);
            }
            ArrayUtils.div((float[])vi, (float)ArrayUtils.maxValue((float[])vi));
            return vi;
        }

        public void computeStats() {
            float[][] rate = this.get_params()._adaptive_rate ? (Object)new float[this.units.length - 1][] : (float[][])null;
            Object object = rate;
            if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
                for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                    this.mean_a[k] = 0.0f;
                    for (int j = 0; j < this.avg_activations[k].size(); ++j) {
                        int n = k;
                        this.mean_a[n] = this.mean_a[n] + this.avg_activations[k].get(j);
                    }
                    int n = k;
                    this.mean_a[n] = this.mean_a[n] / (float)this.avg_activations[k].size();
                }
            }
            for (int y = 1; y < this.units.length; ++y) {
                int u;
                this.rms_rate[y] = 0.0f;
                this.mean_rate[y] = 0.0f;
                this.rms_bias[y] = 0.0f;
                this.mean_bias[y] = 0.0f;
                this.rms_weight[y] = 0.0f;
                this.mean_weight[y] = 0.0f;
                for (u = 0; u < this.biases[y - 1].size(); ++u) {
                    int n = y;
                    this.mean_bias[n] = this.mean_bias[n] + this.biases[y - 1].get(u);
                }
                if (rate != null) {
                    rate[y - 1] = new float[this.get_weights(y - 1).raw().length];
                }
                for (u = 0; u < this.get_weights(y - 1).raw().length; ++u) {
                    int n = y;
                    this.mean_weight[n] = this.mean_weight[n] + this.get_weights(y - 1).raw()[u];
                    if (rate == null) continue;
                    float RMS_dx = MathUtils.approxSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u] + (float)this.get_params()._epsilon));
                    float invRMS_g = MathUtils.approxInvSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u + 1] + (float)this.get_params()._epsilon));
                    rate[y - 1][u] = RMS_dx * invRMS_g;
                    int n2 = y;
                    this.mean_rate[n2] = this.mean_rate[n2] + rate[y - 1][u];
                }
                int n = y;
                this.mean_bias[n] = this.mean_bias[n] / (float)this.biases[y - 1].size();
                int n3 = y;
                this.mean_weight[n3] = this.mean_weight[n3] / (float)this.get_weights(y - 1).size();
                if (rate != null) {
                    int n4 = y;
                    this.mean_rate[n4] = this.mean_rate[n4] / (float)rate[y - 1].length;
                }
                for (u = 0; u < this.biases[y - 1].size(); ++u) {
                    double db = this.biases[y - 1].get(u) - this.mean_bias[y];
                    int n5 = y;
                    this.rms_bias[n5] = (float)((double)this.rms_bias[n5] + db * db);
                }
                u = 0;
                while ((long)u < this.get_weights(y - 1).size()) {
                    double dw = this.get_weights(y - 1).raw()[u] - this.mean_weight[y];
                    int n6 = y;
                    this.rms_weight[n6] = (float)((double)this.rms_weight[n6] + dw * dw);
                    if (rate != null) {
                        double drate = rate[y - 1][u] - this.mean_rate[y];
                        int n7 = y;
                        this.rms_rate[n7] = (float)((double)this.rms_rate[n7] + drate * drate);
                    }
                    ++u;
                }
                this.rms_bias[y] = MathUtils.approxSqrt((float)(this.rms_bias[y] / (float)this.biases[y - 1].size()));
                this.rms_weight[y] = MathUtils.approxSqrt((float)(this.rms_weight[y] / (float)this.get_weights(y - 1).size()));
                if (rate != null) {
                    this.rms_rate[y] = MathUtils.approxSqrt((float)(this.rms_rate[y] / (float)rate[y - 1].length));
                }
                double thresh = 1.0E10;
                this.unstable |= (double)this.mean_bias[y] > 1.0E10 || Double.isNaN(this.mean_bias[y]) || (double)this.rms_bias[y] > 1.0E10 || Double.isNaN(this.rms_bias[y]) || (double)this.mean_weight[y] > 1.0E10 || Double.isNaN(this.mean_weight[y]) || (double)this.rms_weight[y] > 1.0E10 || Double.isNaN(this.rms_weight[y]);
            }
        }

        protected long checksum_impl() {
            long cs = this.parameters._seed;
            cs ^= this.size() * this.get_processed_total();
            cs ^= (long)(2234.3424 * (double)ArrayUtils.sum((float[])this.mean_bias));
            cs *= (long)(9234.1343 * (double)ArrayUtils.sum((float[])this.rms_bias));
            cs ^= (long)(9723.9734 * (double)ArrayUtils.sum((float[])this.mean_weight));
            cs *= (long)(9234.1783 * (double)ArrayUtils.sum((float[])this.rms_weight));
            cs ^= (long)(4273.2344 * (double)ArrayUtils.sum((float[])this.mean_rate));
            return cs *= (long)(3378.1999 * (double)ArrayUtils.sum((float[])this.rms_rate));
        }
    }

    private static final class ConfMat
    extends ConfusionMatrix {
        private final double _err;
        private final double _f1;

        public ConfMat(double err, double f1) {
            super((long[][])null, null);
            this._err = err;
            this._f1 = f1;
        }

        public double err() {
            return this._err;
        }

        public double F1() {
            return this._f1;
        }
    }

    public static class DeepLearningScoring
    extends Iced {
        public double epoch_counter;
        public long training_samples;
        public long training_time_ms;
        boolean validation;
        int num_folds;
        public long score_training_samples;
        public long score_validation_samples;
        public boolean classification;
        VarImp variable_importances;
        public ConfusionMatrix train_confusion_matrix;
        public ConfusionMatrix valid_confusion_matrix;
        public double train_err = Double.NaN;
        public double valid_err = Double.NaN;
        public double train_logloss = Double.NaN;
        public double valid_logloss = Double.NaN;
        public AUC2 training_AUC;
        public AUC2 validation_AUC;
        public float[] train_hitratio;
        public float[] valid_hitratio;
        public double training_MSE = Double.NaN;
        public double validation_MSE = Double.NaN;
        public double training_R2 = Double.NaN;
        public double validation_R2 = Double.NaN;
        public long scoring_time;

        DeepLearningScoring deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (DeepLearningScoring)new DeepLearningScoring().read(ab);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Training MSE: " + this.training_MSE + "\n");
            sb.append("Training R^2: " + this.training_R2 + "\n");
            if (this.classification) {
                sb.append("Training LogLoss: " + this.train_logloss + "\n");
                sb.append("Training " + this.train_confusion_matrix.table().toString(1));
                sb.append("Training Misclassification" + (this.training_AUC != null ? " [using threshold for " + AUC2.DEFAULT_CM.toString().replace("_", " ") + "]: " : ": ") + String.format("%.2f", 100.0 * this.train_err) + "%");
                if (this.training_AUC != null) {
                    sb.append(", AUC: " + String.format("%.4f", 100.0 * this.training_AUC._auc) + "%");
                }
            }
            if (this.validation || this.num_folds > 0) {
                if (this.num_folds > 0) {
                    sb.append("\nDoing " + this.num_folds + "-fold cross-validation:");
                }
                sb.append("\nValidation MSE: " + this.validation_MSE + "\n");
                sb.append("Validation R^2: " + this.validation_R2 + "\n");
                if (this.classification) {
                    sb.append("Validation LogLoss: " + this.valid_logloss + "\n");
                    sb.append("Validation " + this.valid_confusion_matrix.table().toString(1));
                    sb.append("Validation Misclassification" + (this.validation_AUC != null ? " [using threshold for " + AUC2.DEFAULT_CM.toString().replace("_", " ") + "]: " : ": ") + String.format("%.2f", 100.0 * this.valid_err) + "%");
                    if (this.validation_AUC != null) {
                        sb.append(", AUC: " + String.format("%.4f", 100.0 * this.validation_AUC._auc) + "%");
                    }
                }
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    public static class DeepLearningModelOutput
    extends SupervisedModel.SupervisedOutput {
        boolean autoencoder;
        DeepLearningScoring errors;
        Key[] weights;
        Key[] biases;
        public TwoDimTable _variable_importances;

        public int nfeatures() {
            return this._names.length - (this.autoencoder ? 0 : 1);
        }

        public DeepLearningModelOutput() {
        }

        public DeepLearningModelOutput(DeepLearning b) {
            super((SupervisedModelBuilder)b);
        }

        public Model.ModelCategory getModelCategory() {
            return this.autoencoder ? Model.ModelCategory.AutoEncoder : super.getModelCategory();
        }

        public boolean isSupervised() {
            return !this.autoencoder;
        }
    }

    public static class DeepLearningParameters
    extends SupervisedModel.SupervisedParameters {
        public boolean _keep_cross_validation_splits;
        public Key _checkpoint;
        public boolean _overwrite_with_best_model = true;
        public boolean _autoencoder = false;
        public boolean _use_all_factor_levels = true;
        public Activation _activation = Activation.Rectifier;
        public int[] _hidden = new int[]{200, 200};
        public double _epochs = 10.0;
        public long _train_samples_per_iteration = -2L;
        public double _target_ratio_comm_to_comp = 0.02;
        public long _seed = RandomUtils.getRNG((long[])new long[]{System.currentTimeMillis()}).nextLong();
        public boolean _adaptive_rate = true;
        public double _rho = 0.99;
        public double _epsilon = 1.0E-8;
        public double _rate = 0.005;
        public double _rate_annealing = 1.0E-6;
        public double _rate_decay = 1.0;
        public double _momentum_start = 0.0;
        public double _momentum_ramp = 1000000.0;
        public double _momentum_stable = 0.0;
        public boolean _nesterov_accelerated_gradient = true;
        public double _input_dropout_ratio = 0.0;
        public double[] _hidden_dropout_ratios;
        public double _l1 = 0.0;
        public double _l2 = 0.0;
        public float _max_w2 = Float.POSITIVE_INFINITY;
        public InitialWeightDistribution _initial_weight_distribution = InitialWeightDistribution.UniformAdaptive;
        public double _initial_weight_scale = 1.0;
        public Loss _loss = Loss.Automatic;
        public double _score_interval = 5.0;
        public long _score_training_samples = 10000L;
        public long _score_validation_samples = 0L;
        public double _score_duty_cycle = 0.1;
        public double _classification_stop = 0.0;
        public double _regression_stop = 1.0E-6;
        public boolean _quiet_mode = false;
        public ClassSamplingMethod _score_validation_sampling = ClassSamplingMethod.Uniform;
        public boolean _diagnostics = true;
        public boolean _variable_importances = false;
        public boolean _fast_mode = true;
        public boolean _ignore_const_cols = true;
        public boolean _force_load_balance = true;
        public boolean _replicate_training_data = true;
        public boolean _single_node_mode = false;
        public boolean _shuffle_training_data = false;
        public MissingValuesHandling _missing_values_handling = MissingValuesHandling.MeanImputation;
        public boolean _sparse = false;
        public boolean _col_major = false;
        public double _average_activation = 0.0;
        public double _sparsity_beta = 0.0;
        public int _max_categorical_features = Integer.MAX_VALUE;
        public boolean _reproducible = false;
        public boolean _export_weights_and_biases = false;

        public double missingColumnsType() {
            return this._sparse ? 0.0 : Double.NaN;
        }

        public int getNumFolds() {
            return 0;
        }

        void validate(DeepLearning dl, boolean expensive) {
            boolean classification;
            dl.hide("_score_each_iteration", "Not used by Deep Learning.");
            boolean bl = expensive || dl._nclass != 0 ? dl.isClassifier() : (classification = this._loss == Loss.CrossEntropy);
            if (this._hidden == null || this._hidden.length == 0) {
                dl.error("_hidden", "There must be at least one hidden layer.");
            }
            for (int h : this._hidden) {
                if (h > 0) continue;
                dl.error("_hidden", "Hidden layer size must be positive.");
            }
            if (!this._autoencoder) {
                if (this._valid == null) {
                    dl.hide("_score_validation_samples", "score_validation_samples requires a validation frame.");
                }
                if (classification) {
                    dl.hide("_regression_stop", "regression_stop is used only with regression.");
                } else {
                    dl.hide("_classification_stop", "classification_stop is used only with classification.");
                }
                if (!classification && this._valid != null || this._valid == null) {
                    dl.hide("_score_validation_sampling", "score_validation_sampling requires classification and a validation frame.");
                }
            }
            if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout) {
                dl.hide("_hidden_dropout_ratios", "hidden_dropout_ratios requires a dropout activation function.");
            }
            if (this._hidden_dropout_ratios != null) {
                if (this._hidden_dropout_ratios.length != this._hidden.length) {
                    dl.error("_hidden_dropout_ratios", "Must have " + this._hidden.length + " hidden layer dropout ratios.");
                } else if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout) {
                    if (!this._quiet_mode) {
                        dl.hide("_hidden_dropout_ratios", "Ignoring hidden_dropout_ratios because a non-dropout activation function was specified.");
                    }
                } else if (ArrayUtils.maxValue((double[])this._hidden_dropout_ratios) >= 1.0 || ArrayUtils.minValue((double[])this._hidden_dropout_ratios) < 0.0) {
                    dl.error("_hidden_dropout_ratios", "Hidden dropout ratios must be >= 0 and <1.");
                }
            }
            if (this._input_dropout_ratio < 0.0 || this._input_dropout_ratio >= 1.0) {
                dl.error("_input_dropout_ratio", "Input dropout must be >= 0 and <1.");
            }
            if (this._score_duty_cycle < 0.0 || this._score_duty_cycle > 1.0) {
                dl.error("_score_duty_cycle", "Score duty cycle must be >= 0 and <=1.");
            }
            if (this._l1 < 0.0) {
                dl.error("_l1", "L1 penalty must be >= 0.");
            }
            if (this._l2 < 0.0) {
                dl.error("_l2", "L2 penalty must be >= 0.");
            }
            if (H2O.CLOUD.size() == 1 && this._replicate_training_data) {
                dl.hide("_replicate_training_data", "replicate_training_data is only valid with cloud size greater than 1.");
            }
            if (this._single_node_mode && (H2O.CLOUD.size() == 1 || !this._replicate_training_data)) {
                dl.hide("_single_node_mode", "single_node_mode is only used with multi-node operation with replicated training data.");
            }
            if (this._autoencoder) {
                dl.hide("_use_all_factor_levels", "use_all_factor_levels is mandatory in combination with autoencoder.");
            }
            if (this.getNumFolds() != 0) {
                dl.hide("_overwrite_with_best_model", "overwrite_with_best_model is unsupported in combination with n-fold cross-validation.");
            }
            if (this._adaptive_rate) {
                dl.hide("_rate", "rate is not used with adaptive_rate.");
                dl.hide("_rate_annealing", "rate_annealing is not used with adaptive_rate.");
                dl.hide("_rate_decay", "rate_decay is not used with adaptive_rate.");
                dl.hide("_momentum_start", "momentum_start is not used with adaptive_rate.");
                dl.hide("_momentum_ramp", "momentum_ramp is not used with adaptive_rate.");
                dl.hide("_momentum_stable", "momentum_stable is not used with adaptive_rate.");
                dl.hide("_nesterov_accelerated_gradient", "nesterov_accelerated_gradient is not used with adaptive_rate.");
            } else {
                dl.hide("_rho", "rho is only used with adaptive_rate.");
                dl.hide("_epsilon", "epsilon is only used with adaptive_rate.");
            }
            if (this._initial_weight_distribution == InitialWeightDistribution.UniformAdaptive) {
                dl.hide("_initial_weight_scale", "initial_weight_scale is not used if initial_weight_distribution == UniformAdaptive.");
            }
            if (this.getNumFolds() != 0) {
                dl.error("_n_folds", "n_folds is not yet implemented.");
            }
            if (this._loss == null) {
                if (expensive || dl._nclass != 0) {
                    dl.error("_loss", "Loss function must be specified. Try CrossEntropy for categorical response (classification), MeanSquare, Absolute or Huber for numerical response (regression).");
                }
            } else if (this._loss != Loss.Automatic) {
                if (this._autoencoder && this._loss == Loss.CrossEntropy) {
                    dl.error("_loss", "Cannot use CrossEntropy loss for auto-encoder.");
                }
                if (!classification && this._loss == Loss.CrossEntropy) {
                    dl.error("_loss", "For CrossEntropy loss, the response must be categorical.");
                }
            }
            if (!classification && this._loss == Loss.CrossEntropy) {
                dl.error("_loss", "For CrossEntropy loss, the response must be categorical. Either select MeanSquare, Absolute or Huber loss for regression, or use a categorical response.");
            }
            if (this._score_training_samples < 0L) {
                dl.error("_score_training_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
            }
            if (this._score_validation_samples < 0L) {
                dl.error("_score_validation_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
            }
            if (this._autoencoder && this._sparsity_beta > 0.0) {
                if (this._activation == Activation.Tanh || this._activation == Activation.TanhWithDropout) {
                    if (this._average_activation >= 1.0 || this._average_activation <= -1.0) {
                        dl.error("_average_activation", "Tanh average activation must be in (-1,1).");
                    }
                } else if ((this._activation == Activation.Rectifier || this._activation == Activation.RectifierWithDropout) && this._average_activation <= 0.0) {
                    dl.error("_average_activation", "Rectifier average activation must be positive.");
                }
            }
            if (!this._autoencoder && this._sparsity_beta != 0.0) {
                dl.info("_sparsity_beta", "Sparsity beta can only be used for autoencoder.");
            }
            if (this._autoencoder && this._activation == Activation.Maxout) {
                dl.error("_activation", "Maxout activation is not supported for auto-encoder.");
            }
            if (this._max_categorical_features < 1) {
                dl.error("_max_categorical_features", "max_categorical_features must be at least 1.");
            }
            if (!this._sparse && this._col_major) {
                dl.error("_col_major", "Cannot use column major storage for non-sparse data handling.");
            }
            if (expensive) {
                if (!classification && this._balance_classes) {
                    dl.error("_balance_classes", "balance_classes requires classification.");
                }
                if (this._class_sampling_factors != null && !this._balance_classes) {
                    dl.error("_class_sampling_factors", "class_sampling_factors requires balance_classes to be enabled.");
                }
                if (this._replicate_training_data && (double)this.train().byteSize() > 1.0E10) {
                    dl.error("_replicate_training_data", "Compressed training dataset takes more than 10 GB, cannot run with replicate_training_data.");
                }
            }
        }

        public static enum Loss {
            Automatic,
            MeanSquare,
            CrossEntropy,
            Huber,
            Absolute;

        }

        public static enum Activation {
            Tanh,
            TanhWithDropout,
            Rectifier,
            RectifierWithDropout,
            Maxout,
            MaxoutWithDropout;

        }

        public static enum InitialWeightDistribution {
            UniformAdaptive,
            Uniform,
            Normal;

        }

        public static enum ClassSamplingMethod {
            Uniform,
            Stratified;

        }

        public static enum MissingValuesHandling {
            Skip,
            MeanImputation;

        }
    }
}

