/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.FrameTask;
import hex.Model;
import hex.ModelBuilder;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.schemas.GLRMV3;
import hex.schemas.ModelBuilderSchema;
import hex.svd.SVD;
import hex.svd.SVDModel;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.TwoDimTable;

public class GLRM
extends ModelBuilder<GLRMModel, GLRMModel.GLRMParameters, GLRMModel.GLRMOutput> {
    private final double TOLERANCE = 1.0E-6;
    private transient int _ncolA;
    private transient int _ncolX;

    public ModelBuilderSchema schema() {
        return new GLRMV3();
    }

    public Job<GLRMModel> trainModel() {
        return this.start(new GLRMDriver(), 0L);
    }

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Clustering};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public GLRM(GLRMModel.GLRMParameters parms) {
        super("GLRM", (Model.Parameters)parms);
        this.init(false);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((GLRMModel.GLRMParameters)this._parms)._loading_key == null) {
            ((GLRMModel.GLRMParameters)this._parms)._loading_key = Key.make((String)("GLRMLoading_" + Key.rand()));
        }
        if (((GLRMModel.GLRMParameters)this._parms)._gamma < 0.0) {
            this.error("_gamma", "gambda must be a non-negative number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._max_iterations < 1 || (double)((GLRMModel.GLRMParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._init_step_size <= 0.0) {
            this.error("_init_step_size", "init_step_size must be a positive number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._min_step_size < 0.0 || ((GLRMModel.GLRMParameters)this._parms)._min_step_size > ((GLRMModel.GLRMParameters)this._parms)._init_step_size) {
            this.error("_min_step_size", "min_step_size must be between 0 and " + ((GLRMModel.GLRMParameters)this._parms)._init_step_size);
        }
        if (this._train == null) {
            return;
        }
        if (this._train.numCols() < 2) {
            this.error("_train", "_train must have more than one column");
        }
        int k_min = (int)Math.min((long)this._train.numCols(), this._train.numRows());
        if (((GLRMModel.GLRMParameters)this._parms)._k < 1 || ((GLRMModel.GLRMParameters)this._parms)._k > k_min) {
            this.error("_k", "_k must be between 1 and " + k_min);
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._user_points) {
            if (((Frame)((GLRMModel.GLRMParameters)this._parms)._user_points.get()).numCols() != this._train.numCols()) {
                this.error("_user_points", "The user-specified points must have the same number of columns (" + this._train.numCols() + ") as the training observations");
            } else if (((Frame)((GLRMModel.GLRMParameters)this._parms)._user_points.get()).numRows() != (long)((GLRMModel.GLRMParameters)this._parms)._k) {
                this.error("_user_points", "The user-specified points must have k = " + ((GLRMModel.GLRMParameters)this._parms)._k + " rows");
            } else {
                int zero_vec = 0;
                Vec[] centersVecs = ((Frame)((GLRMModel.GLRMParameters)this._parms)._user_points.get()).vecs();
                for (int c = 0; c < this._train.numCols(); ++c) {
                    if (!centersVecs[c].isConst() || centersVecs[c].max() != 0.0) continue;
                    ++zero_vec;
                }
                if (zero_vec == this._train.numCols()) {
                    this.error("_user_points", "The user-specified points cannot all be zero");
                }
            }
        }
        Vec[] vecs = this._train.vecs();
        for (int i = 0; i < vecs.length; ++i) {
            if (vecs[i].isNumeric()) continue;
            throw H2O.unimpl();
        }
        this._ncolA = this._train.numCols();
        this._ncolX = ((GLRMModel.GLRMParameters)this._parms)._k;
    }

    public static double frobenius2(double[][] x) {
        if (x == null) {
            return 0.0;
        }
        double frob = 0.0;
        for (int i = 0; i < x.length; ++i) {
            for (int j = 0; j < x[0].length; ++j) {
                frob += x[i][j] * x[i][j];
            }
        }
        return frob;
    }

    public static double[][] transform(double[][] centers, int ncats, double[] normSub, double[] normMul) {
        int K = centers.length;
        int N = centers[0].length;
        double[][] value = new double[K][N];
        double[] means = normSub == null ? MemoryManager.malloc8d((int)N) : normSub;
        double[] mults = normMul == null ? MemoryManager.malloc8d((int)N) : normMul;
        for (int clu = 0; clu < K; ++clu) {
            System.arraycopy(centers[clu], 0, value[clu], 0, N);
            for (int col = ncats; col < N; ++col) {
                value[clu][col] = (value[clu][col] - means[col]) * mults[col];
            }
        }
        return value;
    }

    protected static int idx_xold(int c, int ncolA) {
        return ncolA + c;
    }

    protected static int idx_xnew(int c, int ncolA, int ncolX) {
        return ncolA + ncolX + c;
    }

    protected static Chunk chk_xold(Chunk[] chks, int c, int ncolA) {
        return chks[ncolA + c];
    }

    protected static Chunk chk_xnew(Chunk[] chks, int c, int ncolA, int ncolX) {
        return chks[ncolA + ncolX + c];
    }

    private static class BMulTask
    extends FrameTask<BMulTask> {
        double[][] _yt;

        BMulTask(Key jobKey, DataInfo dinfo, double[][] yt) {
            super(jobKey, dinfo);
            this._yt = yt;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row row, NewChunk[] outputs) {
            double[] nums = row.numVals;
            assert (nums.length == this._yt[0].length);
            for (int k = 0; k < this._yt[0].length; ++k) {
                double x = 0.0;
                int c = this._dinfo.numStart();
                for (int d = 0; d < nums.length; ++d) {
                    x += nums[d] * this._yt[k][c++];
                }
                assert (c == this._yt[0].length);
                outputs[k].addNum(x);
            }
        }
    }

    private static class ObjCalc
    extends MRTask<ObjCalc> {
        GLRMModel.GLRMParameters _parms;
        final double[][] _yt;
        final int _ncolA;
        final int _ncolX;
        final double[] _normSub;
        final double[] _normMul;
        double _loss;

        ObjCalc(GLRMModel.GLRMParameters parms, double[][] yt, int ncolA, int ncolX, double[] normSub, double[] normMul) {
            assert (yt != null && yt.length == ncolA && yt[0].length == ncolX);
            this._parms = parms;
            this._yt = yt;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._normSub = normSub;
            this._normMul = normMul;
            this._loss = 0.0;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            for (int row = 0; row < cs[0]._len; ++row) {
                for (int j = 0; j < this._ncolA; ++j) {
                    double a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double xy = 0.0;
                    for (int k = 0; k < this._ncolX; ++k) {
                        xy += GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._yt[j][k];
                    }
                    this._loss += this._parms.loss(xy, (a - this._normSub[j]) * this._normMul[j]);
                }
            }
        }
    }

    private static class UpdateY
    extends MRTask<UpdateY> {
        GLRMModel.GLRMParameters _parms;
        final double _alpha;
        final double[][] _ytold;
        final int _ncolA;
        final int _ncolX;
        final double[] _normSub;
        final double[] _normMul;
        double[][] _ytnew;
        double _yreg;

        UpdateY(GLRMModel.GLRMParameters parms, double[][] yt, double alpha, int ncolA, int ncolX, double[] normSub, double[] normMul) {
            assert (yt != null && yt.length == ncolA && yt[0].length == ncolX);
            this._parms = parms;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._normSub = normSub;
            this._normMul = normMul;
            this._ytold = yt;
            this._yreg = 0.0;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            this._ytnew = new double[this._ncolA][this._ncolX];
            for (int j = 0; j < this._ncolA; ++j) {
                for (int row = 0; row < cs[0]._len; ++row) {
                    double a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double xy = 0.0;
                    for (int k = 0; k < this._ncolX; ++k) {
                        xy += GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._ytold[j][k];
                    }
                    double weight = this._parms.lgrad(xy, (a - this._normSub[j]) * this._normMul[j]);
                    for (int k = 0; k < this._ncolX; ++k) {
                        double[] dArray = this._ytnew[j];
                        int n = k;
                        dArray[n] = dArray[n] + weight * GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row);
                    }
                }
            }
        }

        public void reduce(UpdateY other) {
            ArrayUtils.add((double[][])this._ytnew, (double[][])other._ytnew);
        }

        protected void postGlobal() {
            for (int j = 0; j < this._ncolA; ++j) {
                for (int k = 0; k < this._ncolX; ++k) {
                    double u = this._ytold[j][k] - this._alpha * this._ytnew[j][k];
                    this._ytnew[j][k] = this._parms.rproxgrad(u, this._alpha);
                    this._yreg += this._parms.regularize(this._ytnew[j][k]);
                }
            }
        }
    }

    private static class UpdateX
    extends MRTask<UpdateX> {
        GLRMModel.GLRMParameters _parms;
        final double _alpha;
        final boolean _update;
        final double[][] _yt;
        final int _ncolA;
        final int _ncolX;
        final double[] _normSub;
        final double[] _normMul;
        double _loss;
        double _xreg;

        UpdateX(GLRMModel.GLRMParameters parms, double[][] yt, double alpha, boolean update, int ncolA, int ncolX, double[] normSub, double[] normMul) {
            assert (yt != null && yt.length == ncolA && yt[0].length == ncolX);
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._normSub = normSub;
            this._normMul = normMul;
            this._parms = parms;
            this._alpha = alpha;
            this._update = update;
            this._yt = yt;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            double[] a = new double[this._ncolA];
            this._xreg = 0.0;
            this._loss = 0.0;
            for (int row = 0; row < cs[0]._len; ++row) {
                double xy;
                int j;
                int k;
                double[] grad = new double[this._ncolX];
                double[] xnew = new double[this._ncolX];
                if (this._update) {
                    for (k = 0; k < this._ncolX; ++k) {
                        GLRM.chk_xold(cs, k, this._ncolA).set(row, GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row));
                    }
                }
                for (j = 0; j < this._ncolA; ++j) {
                    a[j] = cs[j].atd(row);
                    if (Double.isNaN(a[j])) continue;
                    xy = 0.0;
                    for (int k2 = 0; k2 < this._ncolX; ++k2) {
                        xy += GLRM.chk_xold(cs, k2, this._ncolA).atd(row) * this._yt[j][k2];
                    }
                    double weight = this._parms.lgrad(xy, (a[j] - this._normSub[j]) * this._normMul[j]);
                    for (int i = 0; i < this._ncolX; ++i) {
                        int n = i;
                        grad[n] = grad[n] + weight * this._yt[j][i];
                    }
                }
                for (k = 0; k < this._ncolX; ++k) {
                    double xold = GLRM.chk_xold(cs, k, this._ncolA).atd(row);
                    xnew[k] = this._parms.rproxgrad(xold - this._alpha * grad[k], this._alpha);
                    GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).set(row, xnew[k]);
                    this._xreg += this._parms.regularize(xnew[k]);
                }
                for (j = 0; j < this._ncolA; ++j) {
                    if (Double.isNaN(a[j])) continue;
                    xy = ArrayUtils.innerProduct((double[])xnew, (double[])this._yt[j]);
                    this._loss += this._parms.loss(xy, a[j]);
                }
            }
        }

        public void reduce(UpdateX other) {
            this._loss += other._loss;
            this._xreg += other._xreg;
        }
    }

    class GLRMDriver
    extends H2O.H2OCountedCompleter<GLRMDriver> {
        GLRMDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double[][] initialY() {
            Object parms;
            double[][] centers;
            if (null != ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_points) {
                Vec[] centersVecs = ((Frame)((GLRMModel.GLRMParameters)GLRM.this._parms)._user_points.get()).vecs();
                centers = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][GLRM.this._ncolA];
                for (int r = 0; r < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++r) {
                    for (int c = 0; c < GLRM.this._ncolA; ++c) {
                        centers[r][c] = centersVecs[c].at((long)r);
                    }
                }
            } else if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == Initialization.SVD) {
                parms = new SVDModel.SVDParameters();
                parms._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                parms._nv = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                parms._max_iterations = ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                parms._transform = ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform;
                parms._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                parms._only_v = true;
                SVDModel svd = null;
                SVD job = null;
                try {
                    job = new SVD((SVDModel.SVDParameters)((Object)parms));
                    svd = (SVDModel)job.trainModel().get();
                }
                finally {
                    if (job != null) {
                        job.remove();
                    }
                    if (svd != null) {
                        svd.remove();
                    }
                }
                centers = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)svd._output)._v);
            } else {
                parms = new KMeansModel.KMeansParameters();
                ((KMeansModel.KMeansParameters)((Object)parms))._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                ((KMeansModel.KMeansParameters)((Object)parms))._ignored_columns = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignored_columns;
                ((KMeansModel.KMeansParameters)((Object)parms))._dropConsCols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._dropConsCols;
                ((KMeansModel.KMeansParameters)((Object)parms))._drop_na20_cols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._drop_na20_cols;
                ((KMeansModel.KMeansParameters)((Object)parms))._score_each_iteration = ((GLRMModel.GLRMParameters)GLRM.this._parms)._score_each_iteration;
                ((KMeansModel.KMeansParameters)((Object)parms))._init = KMeans.Initialization.PlusPlus;
                ((KMeansModel.KMeansParameters)((Object)parms))._k = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                ((KMeansModel.KMeansParameters)((Object)parms))._max_iterations = ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                ((KMeansModel.KMeansParameters)((Object)parms))._standardize = true;
                ((KMeansModel.KMeansParameters)((Object)parms))._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                KMeansModel km = null;
                KMeans job = null;
                try {
                    job = new KMeans((KMeansModel.KMeansParameters)((Object)parms));
                    km = (KMeansModel)job.trainModel().get();
                }
                finally {
                    if (job != null) {
                        job.remove();
                    }
                    if (km != null) {
                        km.remove();
                    }
                }
                centers = GLRM.transform(((KMeansModel.KMeansOutput)km._output)._centers_raw, 0, ((KMeansModel.KMeansOutput)km._output)._normSub, ((KMeansModel.KMeansOutput)km._output)._normMul);
            }
            double frob = GLRM.frobenius2(centers);
            if (frob == 0.0 || Double.isNaN(frob)) {
                GLRM.this.warn("_init", "Initialization failed. Setting initial Y to standard normal random matrix instead...");
                centers = ArrayUtils.gaussianArray((int)((GLRMModel.GLRMParameters)GLRM.this._parms)._k, (int)GLRM.this._ncolA);
            }
            return centers;
        }

        private boolean isDone(GLRMModel model, int steps_in_row, double step) {
            if (!GLRM.this.isRunning()) {
                return true;
            }
            if (((GLRMModel.GLRMOutput)model._output)._iterations > ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations) {
                return true;
            }
            if (step <= ((GLRMModel.GLRMParameters)GLRM.this._parms)._min_step_size) {
                return true;
            }
            return ((GLRMModel.GLRMOutput)model._output)._iterations > 10 && steps_in_row > 3 && Math.abs(((GLRMModel.GLRMOutput)model._output)._avg_change_obj) < 1.0E-6;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram, int max_attempts) {
            double addedL2 = 0.0;
            Gram.Cholesky chol = gram.cholesky(null);
            for (int attempts = 0; !chol.isSPD() && attempts < max_attempts; ++attempts) {
                addedL2 = addedL2 == 0.0 ? 1.0E-5 : (addedL2 *= 10.0);
                gram.addDiag(addedL2);
                Log.info((Object[])new Object[]{"Added L2 regularization = " + addedL2 + " to diagonal of X Gram matrix"});
                gram.cholesky(chol);
            }
            if (!chol.isSPD()) {
                throw new Gram.NonSPDMatrixException();
            }
            return chol;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram) {
            return this.regularizedCholesky(gram, 10);
        }

        public void recoverPCA(GLRMModel model, DataInfo xinfo) {
            Gram.GramTask xgram = (Gram.GramTask)new Gram.GramTask(this.self(), xinfo).doAll(xinfo._adaptedFrame);
            Gram.Cholesky xxchol = this.regularizedCholesky(xgram._gram);
            Matrix x_r = new Matrix(xxchol.getL()).transpose();
            x_r = x_r.times(Math.sqrt(GLRM.this._train.numRows()));
            QRDecomposition yt_qr = new QRDecomposition(new Matrix(((GLRMModel.GLRMOutput)model._output)._archetypes));
            Matrix yt_r = yt_qr.getR();
            Matrix rrmul = x_r.times(yt_r.transpose());
            SingularValueDecomposition rrsvd = new SingularValueDecomposition(rrmul);
            Matrix eigvec = yt_qr.getQ().times(rrsvd.getV());
            ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw = eigvec.getArray();
            Object[] colTypes = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Object[] colFormats = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            String[] colHeaders = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            for (int i = 0; i < colHeaders.length; ++i) {
                colHeaders[i] = "PC" + String.valueOf(i + 1);
            }
            ((GLRMModel.GLRMOutput)model._output)._eigenvectors = new TwoDimTable("Rotation", null, GLRM.this._train.names(), colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[GLRM.this._train.numCols()][], ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw);
            double[] sval = rrsvd.getSingularValues();
            double[] sdev = new double[sval.length];
            double[] pcvar = new double[sval.length];
            double tot_var = 0.0;
            double dfcorr = 1.0 / Math.sqrt((double)GLRM.this._train.numRows() - 1.0);
            for (int i = 0; i < sval.length; ++i) {
                sdev[i] = dfcorr * sval[i];
                pcvar[i] = sdev[i] * sdev[i];
                tot_var += pcvar[i];
            }
            ((GLRMModel.GLRMOutput)model._output)._std_deviation = sdev;
            double[] prop_var = new double[sval.length];
            double[] cum_var = new double[sval.length];
            for (int i = 0; i < sval.length; ++i) {
                prop_var[i] = pcvar[i] / tot_var;
                cum_var[i] = i == 0 ? prop_var[0] : cum_var[i - 1] + prop_var[i];
            }
            ((GLRMModel.GLRMOutput)model._output)._pc_importance = new TwoDimTable("Importance of components", null, new String[]{"Standard deviation", "Proportion of Variance", "Cumulative Proportion"}, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[3][], (double[][])new double[][]{sdev, prop_var, cum_var});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            GLRMModel model = null;
            DataInfo dinfo = null;
            DataInfo xinfo = null;
            Frame fr = null;
            Frame x = null;
            try {
                int i;
                ((GLRMModel.GLRMParameters)GLRM.this._parms).read_lock_frames((Job)GLRM.this);
                GLRM.this.init(true);
                if (GLRM.this.error_count() > 0) {
                    throw new IllegalArgumentException("Found validation errors: " + GLRM.this.validationErrors());
                }
                model = new GLRMModel(GLRM.this.dest(), (GLRMModel.GLRMParameters)GLRM.this._parms, new GLRMModel.GLRMOutput(GLRM.this));
                model.delete_and_lock(GLRM.this._key);
                double nobs = GLRM.this._train.numRows() * (long)GLRM.this._train.numCols();
                double[][] yt = ArrayUtils.transpose((double[][])this.initialY());
                Vec[] vecs = new Vec[GLRM.this._ncolA + 2 * GLRM.this._ncolX];
                for (i = 0; i < GLRM.this._ncolA; ++i) {
                    vecs[i] = GLRM.this._train.vec(i);
                }
                for (i = GLRM.this._ncolA; i < vecs.length; ++i) {
                    vecs[i] = GLRM.this._train.anyVec().makeRand(((GLRMModel.GLRMParameters)GLRM.this._parms)._seed);
                }
                fr = new Frame(null, vecs);
                dinfo = new DataInfo(Key.make(), fr, null, 0, false, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, true, false);
                DKV.put((Key)dinfo._key, (Iced)dinfo);
                double[] dArray = ((GLRMModel.GLRMOutput)model._output)._normSub = dinfo._normSub == null ? new double[GLRM.this._ncolA] : Arrays.copyOf(dinfo._normSub, GLRM.this._ncolA);
                if (dinfo._normMul == null) {
                    ((GLRMModel.GLRMOutput)model._output)._normMul = new double[GLRM.this._ncolA];
                    Arrays.fill(((GLRMModel.GLRMOutput)model._output)._normMul, 1.0);
                } else {
                    ((GLRMModel.GLRMOutput)model._output)._normMul = Arrays.copyOf(dinfo._normMul, GLRM.this._ncolA);
                }
                ObjCalc objtsk = (ObjCalc)new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, yt, GLRM.this._ncolA, GLRM.this._ncolX, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul).doAll(dinfo._adaptedFrame);
                ((GLRMModel.GLRMOutput)model._output)._objective = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma * ((GLRMModel.GLRMParameters)GLRM.this._parms).regularize(yt);
                ((GLRMModel.GLRMOutput)model._output)._iterations = 0;
                ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = 2.0E-6;
                boolean overwriteX = false;
                double step = ((GLRMModel.GLRMParameters)GLRM.this._parms)._init_step_size;
                int steps_in_row = 0;
                while (!this.isDone(model, steps_in_row, step)) {
                    UpdateX xtsk = new UpdateX((GLRMModel.GLRMParameters)GLRM.this._parms, yt, step / (double)GLRM.this._ncolA, overwriteX, GLRM.this._ncolA, GLRM.this._ncolX, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul);
                    xtsk.doAll(dinfo._adaptedFrame);
                    UpdateY ytsk = new UpdateY((GLRMModel.GLRMParameters)GLRM.this._parms, yt, step / (double)GLRM.this._ncolA, GLRM.this._ncolA, GLRM.this._ncolX, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul);
                    double[][] ytnew = ((UpdateY)ytsk.doAll((Frame)dinfo._adaptedFrame))._ytnew;
                    objtsk = (ObjCalc)new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, ytnew, GLRM.this._ncolA, GLRM.this._ncolX, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul).doAll(dinfo._adaptedFrame);
                    double obj_new = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma * (xtsk._xreg + ytsk._yreg);
                    ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = (((GLRMModel.GLRMOutput)model._output)._objective - obj_new) / nobs;
                    ++((GLRMModel.GLRMOutput)model._output)._iterations;
                    if (((GLRMModel.GLRMOutput)model._output)._avg_change_obj > 0.0) {
                        yt = ytnew;
                        ((GLRMModel.GLRMOutput)model._output)._objective = obj_new;
                        step *= 1.05;
                        steps_in_row = Math.max(1, steps_in_row + 1);
                        overwriteX = true;
                    } else {
                        step /= Math.max(1.5, (double)(-steps_in_row));
                        steps_in_row = Math.min(0, steps_in_row - 1);
                        overwriteX = false;
                    }
                    model.update(GLRM.this._key);
                    GLRM.this.update(1L);
                }
                Vec[] xvecs = new Vec[GLRM.this._ncolX];
                for (int i2 = 0; i2 < GLRM.this._ncolX; ++i2) {
                    xvecs[i2] = fr.vec(GLRM.idx_xnew(i2, GLRM.this._ncolA, GLRM.this._ncolX));
                }
                x = new Frame(((GLRMModel.GLRMParameters)GLRM.this._parms)._loading_key, null, xvecs);
                xinfo = new DataInfo(Key.make(), x, null, 0, false, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false);
                DKV.put((Key)x._key, (Iced)x);
                DKV.put((Key)xinfo._key, (Iced)xinfo);
                ((GLRMModel.GLRMOutput)model._output)._loading_key = ((GLRMModel.GLRMParameters)GLRM.this._parms)._loading_key;
                ((GLRMModel.GLRMOutput)model._output)._archetypes = yt;
                ((GLRMModel.GLRMOutput)model._output)._step_size = step;
                if (((GLRMModel.GLRMParameters)GLRM.this._parms)._recover_pca) {
                    this.recoverPCA(model, xinfo);
                }
                GLRM.this.done();
            }
            catch (Throwable t) {
                Job thisJob = (Job)DKV.getGet((Key)GLRM.this._key);
                if (thisJob._state == Job.JobState.CANCELLED) {
                    Log.info((Object[])new Object[]{"Job cancelled by user."});
                }
                t.printStackTrace();
                GLRM.this.failed(t);
                throw t;
            }
            finally {
                ((GLRMModel.GLRMParameters)GLRM.this._parms).read_unlock_frames((Job)GLRM.this);
                if (model != null) {
                    model.unlock(GLRM.this._key);
                }
                if (dinfo != null) {
                    dinfo.remove();
                }
                if (xinfo != null) {
                    xinfo.remove();
                }
                if (fr != null) {
                    for (int i = 0; i < GLRM.this._ncolX; ++i) {
                        fr.vec(GLRM.idx_xold(i, GLRM.this._ncolA)).remove();
                    }
                }
            }
            this.tryComplete();
        }

        Key self() {
            return GLRM.this._key;
        }
    }

    public static enum Initialization {
        SVD,
        PlusPlus,
        User;

    }
}

