/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Grid;
import hex.Model;
import hex.ModelBuilder;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;

public class KMeansGrid
extends Grid<KMeansModel.KMeansParameters, KMeansGrid> {
    public static final String MODEL_NAME = "KMeans";
    private static final String[] HYPER_NAMES = new String[]{"_k", "_standardize", "_init", "_seed"};
    private static final double[] HYPER_DEFAULTS = new double[]{0.0, 1.0, KMeans.Initialization.PlusPlus.ordinal(), 1.23456789E8};

    protected String modelName() {
        return MODEL_NAME;
    }

    protected String[] hyperNames() {
        return HYPER_NAMES;
    }

    protected double[] hyperDefaults() {
        return HYPER_DEFAULTS;
    }

    protected double suggestedNextHyperValue(int h, Model m, double[] hyperLimits) {
        throw H2O.unimpl();
    }

    protected ModelBuilder createBuilder(KMeansModel.KMeansParameters params) {
        return new KMeans(params);
    }

    protected KMeansModel.KMeansParameters applyHypers(KMeansModel.KMeansParameters params, double[] hypers) {
        params._train = this._fr._key;
        params._k = (int)hypers[0];
        params._standardize = hypers[1] != 0.0;
        params._init = KMeans.Initialization.values()[(int)hypers[2]];
        params._seed = (long)hypers[3];
        return params;
    }

    public double[] getHypers(KMeansModel.KMeansParameters params) {
        double[] ds = new double[HYPER_NAMES.length];
        ds[0] = params._k;
        ds[1] = params._standardize ? 1.0 : 0.0;
        ds[2] = params._init.ordinal();
        ds[3] = params._seed;
        return ds;
    }

    private KMeansGrid(Key key, Frame fr) {
        super(key, fr);
    }

    public static KMeansGrid get(Frame fr) {
        Key k = Grid.keyName((String)MODEL_NAME, (Frame)fr);
        KMeansGrid kmg = (KMeansGrid)DKV.getGet((Key)k);
        if (kmg != null) {
            return kmg;
        }
        kmg = new KMeansGrid(k, fr);
        DKV.put((Keyed)kmg);
        return kmg;
    }

    public KMeansGrid() {
        super(null, null);
    }
}

