/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.ConfusionMatrix;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsSupervised;
import hex.SupervisedModelBuilder;
import hex.VarImp;
import hex.genmodel.GenModel;
import hex.tree.CompressedTree;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.Score;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTreeModel;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.Scope;
import water.Value;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public abstract class SharedTree<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends SupervisedModelBuilder<M, P, O> {
    protected int _ntrees;
    protected M _model;
    protected int _ncols;
    protected double _initialPrediction;
    private transient float[] _improvPerVar;
    transient long _timeLastScoreStart;
    transient long _timeLastScoreEnd;
    transient long _firstScore;
    static int counter = 0;

    public SharedTree(String name, P parms) {
        super(name, parms);
    }

    public void init(boolean expensive) {
        Value cv;
        super.init(expensive);
        if (this._nclass > 1000) {
            this.error("_nclass", "Too many levels in response column!");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows < 0) {
            this.error("_min_rows", "Requested min_rows must be greater than 0");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < 0 || ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees > 100000) {
            this.error("_ntrees", "Requested ntrees must be between 1 and 100000");
        }
        this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._checkpoint && (cv = DKV.get((Key)((SharedTreeModel.SharedTreeParameters)this._parms)._model_id)) != null) {
            SharedTreeModel checkpointModel = (SharedTreeModel)cv.get();
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees < ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1) {
                this.error("_ntrees", "Requested ntrees must be between " + ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees + 1 + " and 100000");
            }
            this._ntrees = ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees - ((SharedTreeModel.SharedTreeOutput)checkpointModel._output)._ntrees;
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._nbins <= 1) {
            this.error("_nbins", "_nbins must be > 1.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._max_depth <= 0) {
            this.error("_max_depth", "_max_depth must be > 0.");
        }
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows < 1) {
            this.error("_min_rows", "_min_rows must be >= 1.");
        }
        if (this._train != null && this._train.numRows() < (long)(((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows * 2)) {
            this.error("_min_rows", "The dataset size is too small to split for min_rows=" + ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows + " , number of rows: " + this._train.numRows() + " < 2*" + ((SharedTreeModel.SharedTreeParameters)this._parms)._min_rows);
        }
        if (this._train != null) {
            this._ncols = this._train.numCols() - 1;
        }
    }

    protected DHistogram[][][] buildLayer(Frame fr, int nbins, DTree[] ktrees, int[] leafs, DHistogram[][][] hcs, boolean subset, boolean build_tree_one_node) {
        ScoreBuildOneTree[] sb1ts = new ScoreBuildOneTree[this._nclass];
        Vec[] vecs = fr.vecs();
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            Frame fr2 = new Frame(Arrays.copyOf(fr._names, this._ncols + 1), Arrays.copyOf(vecs, this._ncols + 1));
            fr2.add(fr._names[this.idx_tree(k)], vecs[this.idx_tree(k)]);
            fr2.add(fr._names[this.idx_work(k)], vecs[this.idx_work(k)]);
            fr2.add(fr._names[this.idx_nids(k)], vecs[this.idx_nids(k)]);
            sb1ts[k] = new ScoreBuildOneTree(this, k, nbins, tree, leafs, hcs, fr2, subset, build_tree_one_node, this._improvPerVar);
            H2O.submitTask((H2O.H2OCountedCompleter)sb1ts[k]);
        }
        boolean did_split = false;
        for (int k = 0; k < this._nclass; ++k) {
            DTree tree = ktrees[k];
            if (tree == null) continue;
            sb1ts[k].join();
            if (!sb1ts[k]._did_split) continue;
            did_split = true;
        }
        return did_split ? hcs : (DHistogram[][][])null;
    }

    protected int idx_resp() {
        return this._ncols;
    }

    protected int idx_oobt() {
        return this._ncols + 1 + this._nclass + this._nclass + this._nclass;
    }

    protected int idx_tree(int c) {
        return this._ncols + 1 + c;
    }

    protected int idx_work(int c) {
        return this._ncols + 1 + this._nclass + c;
    }

    protected int idx_nids(int c) {
        return this._ncols + 1 + this._nclass + this._nclass + c;
    }

    protected Chunk chk_resp(Chunk[] chks) {
        return chks[this.idx_resp()];
    }

    protected Chunk chk_tree(Chunk[] chks, int c) {
        return chks[this.idx_tree(c)];
    }

    protected Chunk chk_work(Chunk[] chks, int c) {
        return chks[this.idx_work(c)];
    }

    protected Chunk chk_nids(Chunk[] chks, int c) {
        return chks[this.idx_nids(c)];
    }

    protected Chunk chk_oobt(Chunk[] chks) {
        return chks[this._ncols + 1 + this._nclass + this._nclass + this._nclass];
    }

    protected final Vec vec_nids(Frame fr, int t) {
        return fr.vecs()[this._ncols + 1 + this._nclass + this._nclass + t];
    }

    protected final Vec vec_resp(Frame fr) {
        return fr.vecs()[this._ncols];
    }

    protected final Vec vec_tree(Frame fr, int c) {
        return fr.vecs()[this.idx_tree(c)];
    }

    protected double[] data_row(Chunk[] chks, int row, double[] data) {
        assert (data.length == this._ncols);
        for (int f = 0; f < this._ncols; ++f) {
            data[f] = chks[f].atd(row);
        }
        return data;
    }

    protected abstract DTree.DecidedNode makeDecided(DTree.UndecidedNode var1, DHistogram[] var2);

    protected abstract double score1(Chunk[] var1, double[] var2, int var3);

    void score2(Chunk[] chks, double[] fs, int row) {
        double sum = this.score1(chks, fs, row);
        if (this.isClassifier()) {
            if (!Double.isInfinite(sum) && sum > 0.0) {
                ArrayUtils.div((double[])fs, (double)sum);
            }
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])fs, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._priorClassDist, (double[])((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._modelClassDist);
            }
        }
    }

    protected double doScoringAndSaveModel(boolean finalScoring, boolean oob, boolean build_tree_one_node) {
        double training_r2 = Double.NaN;
        long now = System.currentTimeMillis();
        if (this._firstScore == 0L) {
            this._firstScore = now;
        }
        long sinceLastScore = now - this._timeLastScoreStart;
        boolean updated = false;
        if (((SharedTreeModel.SharedTreeParameters)this._parms)._score_each_iteration || finalScoring || now - this._firstScore < 4000L || sinceLastScore > 4000L && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < 0.1) {
            ConfusionMatrix cm;
            this.checkMemoryFootPrint();
            this._model.update(this._key);
            updated = true;
            Log.info((Object[])new Object[]{"============================================================== "});
            SharedTreeModel.SharedTreeOutput out = (SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output;
            this._timeLastScoreStart = now;
            Score sc = (Score)new Score(this, true, oob, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory()).doAll(this.train(), build_tree_one_node);
            ModelMetricsSupervised mm = sc.makeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).train(), ((SharedTreeModel.SharedTreeParameters)this._parms)._response_column);
            out._training_metrics = mm;
            if (oob) {
                out._training_metrics._description = "Metrics reported on Out-Of-Bag training samples";
            }
            String train_logloss = this.isClassifier() ? ", logloss is " + (float)(this._nclass == 2 ? ((ModelMetricsBinomial)mm)._logloss : ((ModelMetricsMultinomial)mm)._logloss) : "";
            out._mse_train[out._ntrees] = mm._MSE;
            training_r2 = mm.r2();
            Log.info((Object[])new Object[]{"training r2 is " + (float)mm.r2() + ", MSE is " + (float)mm._MSE + train_logloss + ", with " + ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees + "x" + this._nclass + " trees (average of " + (1.0f + ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeStats._mean_leaves) + " nodes)"});
            if (mm.hr() != null) {
                Log.info((Object[])new Object[]{ModelMetricsMultinomial.getHitRatioTable((float[])mm.hr())});
            }
            if (((SharedTreeModel.SharedTreeParameters)this._parms)._valid != null) {
                Score scv = (Score)new Score(this, false, oob, ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output).getModelCategory()).doAll(this.valid(), build_tree_one_node);
                ModelMetricsSupervised mmv = scv.makeModelMetrics((SharedTreeModel)((Object)this._model), ((SharedTreeModel.SharedTreeParameters)this._parms).valid(), ((SharedTreeModel.SharedTreeParameters)this._parms)._response_column);
                out._mse_valid[out._ntrees] = mmv._MSE;
                out._validation_metrics = mmv;
                String valid_logloss = this.isClassifier() ? ", logloss is " + (float)(this._nclass == 2 ? ((ModelMetricsBinomial)mmv)._logloss : ((ModelMetricsMultinomial)mmv)._logloss) : "";
                Log.info((Object[])new Object[]{"validation r2 is " + (float)mmv.r2() + ", MSE is " + (float)mmv._MSE + valid_logloss});
                if (mmv.hr() != null) {
                    Log.info((Object[])new Object[]{ModelMetricsMultinomial.getHitRatioTable((float[])mm.hr())});
                }
            }
            if (out._ntrees > 0) {
                out._model_summary = this.createModelSummaryTable(out);
                out._scoring_history = this.createScoringHistoryTable(out);
                out._variable_importances = ModelMetrics.calcVarImp((VarImp)new VarImp(this._improvPerVar, out._names));
                Log.info((Object[])new Object[]{out._model_summary.toString()});
            }
            if ((cm = mm.cm()) != null) {
                if (cm._cm.length <= ((SharedTreeModel.SharedTreeParameters)this._parms)._max_confusion_matrix_size) {
                    Log.info((Object[])new Object[]{cm.toASCII()});
                } else {
                    Log.info((Object[])new Object[]{"Confusion Matrix is too large (max_confusion_matrix_size=" + ((SharedTreeModel.SharedTreeParameters)this._parms)._max_confusion_matrix_size + "): " + this._nclass + " classes."});
                }
                Log.info((Object[])new Object[]{(this._nclass > 1 ? "Total of " + cm.errCount() + " errors" : "Reported") + " on " + cm.totalRows() + " rows"});
            }
            this._timeLastScoreEnd = System.currentTimeMillis();
        }
        if (updated) {
            this._model.update(this._key);
        }
        return training_r2;
    }

    protected static void printGenerateTrees(DTree[] trees) {
        for (DTree dtree : trees) {
            if (dtree == null) continue;
            try {
                PrintWriter writer = new PrintWriter("/tmp/h2o-dev.tree" + ++counter + ".txt", "UTF-8");
                writer.println(dtree.root().toString2(new StringBuilder(), 0));
                writer.close();
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println(dtree.root().toString2(new StringBuilder(), 0));
        }
    }

    double initial_MSE(Vec train, Vec test) {
        if (train.isEnum()) {
            int cls = ArrayUtils.maxIndex((long[])train.bins());
            double guess = train.bins()[cls] / (train.length() - train.naCnt());
            double actual = test.bins()[cls] / (test.length() - test.naCnt());
            return guess * guess + actual - 2.0 * actual * guess;
        }
        double stddev = test.sigma();
        double bias = train.mean() - test.mean();
        return stddev * stddev + bias * bias;
    }

    public static Random createRNG(long seed) {
        return new RandomUtils.MersenneTwisterRNG(new int[]{(int)(seed >> 32), (int)seed});
    }

    private TwoDimTable createScoringHistoryTable(SharedTreeModel.SharedTreeOutput _output) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Training MSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (this.valid() != null) {
            colHeaders.add("Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        int rows = _output._mse_train.length - 1;
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 1; i <= rows; ++i) {
            int col = 0;
            assert (row < table.getRowDim());
            assert (col < table.getColDim());
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(_output._training_time_ms[i]));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)(_output._training_time_ms[i] - this._start_time), (boolean)true));
            table.set(row, col++, (Object)i);
            table.set(row, col++, (Object)_output._mse_train[i]);
            if (this._valid != null) {
                table.set(row, col++, (Object)_output._mse_valid[i]);
            }
            ++row;
        }
        return table;
    }

    private TwoDimTable createModelSummaryTable(SharedTreeModel.SharedTreeOutput _output) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Model Size in Bytes");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Min. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Depth");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Min. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Leaves");
        colTypes.add("double");
        colFormat.add("%.5f");
        boolean rows = true;
        TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        int col = 0;
        table.set(row, col++, (Object)_output._treeStats._num_trees);
        table.set(row, col++, (Object)_output._treeStats._byte_size);
        table.set(row, col++, (Object)_output._treeStats._min_depth);
        table.set(row, col++, (Object)_output._treeStats._max_depth);
        table.set(row, col++, (Object)Float.valueOf(_output._treeStats._mean_depth));
        table.set(row, col++, (Object)_output._treeStats._min_leaves);
        table.set(row, col++, (Object)_output._treeStats._max_leaves);
        table.set(row, col++, (Object)Float.valueOf(_output._treeStats._mean_leaves));
        return table;
    }

    protected void checkMemoryFootPrint() {
        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees == 0) {
            return;
        }
        int model_mem_size = 0;
        int trees_so_far = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._ntrees;
        ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeStats._byte_size = 0L;
        for (int i = 0; i < trees_so_far; ++i) {
            Key<CompressedTree>[] per_class = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeKeys[i];
            for (int j = 0; j < per_class.length; ++j) {
                if (per_class[j] == null) continue;
                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)this._model))._output)._treeStats._byte_size += (long)(model_mem_size += DKV.get(per_class[j])._max);
            }
        }
        double avg_tree_mem_size = (double)model_mem_size / (double)trees_so_far;
        Log.debug((Object[])new Object[]{"Average tree size (for all classes): " + PrettyPrint.bytes((long)((long)avg_tree_mem_size))});
        long max_mem = H2O.SELF.get_max_mem();
        if ((double)((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees * avg_tree_mem_size > (double)max_mem) {
            String msg = "The tree model will not fit in the driver node's memory (" + PrettyPrint.bytes((long)((long)avg_tree_mem_size)) + " per tree x " + ((SharedTreeModel.SharedTreeParameters)this._parms)._ntrees + " > " + PrettyPrint.bytes((long)max_mem) + ") - try decreasing ntrees and/or max_depth or increasing min_rows!";
            this.error("_ntrees", msg);
            this.cancel(msg);
        }
    }

    static /* synthetic */ float[] access$1902(SharedTree x0, float[] x1) {
        x0._improvPerVar = x1;
        return x1;
    }

    class ExcludeNAResponse
    extends MRTask<ExcludeNAResponse> {
        ExcludeNAResponse() {
        }

        public void map(Chunk[] chks) {
            Chunk ys = SharedTree.this.chk_resp(chks);
            for (int row = 0; row < ys._len; ++row) {
                if (!ys.isNA(row)) continue;
                for (int t = 0; t < SharedTree.this._nclass; ++t) {
                    SharedTree.this.chk_nids(chks, t).set(row, -1L);
                }
            }
        }
    }

    private static class ScoreBuildOneTree
    extends H2O.H2OCountedCompleter {
        final SharedTree _st;
        final int _k;
        final int _nbins;
        final DTree _tree;
        final int[] _leafs;
        final DHistogram[][][] _hcs;
        final Frame _fr2;
        final boolean _subset;
        final boolean _build_tree_one_node;
        float[] _improvPerVar;
        boolean _did_split;

        ScoreBuildOneTree(SharedTree st, int k, int nbins, DTree tree, int[] leafs, DHistogram[][][] hcs, Frame fr2, boolean subset, boolean build_tree_one_node, float[] improvPerVar) {
            this._st = st;
            this._k = k;
            this._nbins = nbins;
            this._tree = tree;
            this._leafs = leafs;
            this._hcs = hcs;
            this._fr2 = fr2;
            this._subset = subset;
            this._build_tree_one_node = build_tree_one_node;
            this._improvPerVar = improvPerVar;
        }

        public void compute2() {
            new ScoreBuildHistogram(this, this._k, this._st._ncols, this._nbins, this._tree, this._leafs[this._k], this._hcs[this._k], this._subset).dfork(0, this._fr2, this._build_tree_one_node);
        }

        public void onCompletion(CountedCompleter caller) {
            ScoreBuildHistogram sbh = (ScoreBuildHistogram)caller;
            int leafk = this._leafs[this._k];
            int tmax = this._tree.len();
            for (int leaf = leafk; leaf < tmax; ++leaf) {
                DTree.UndecidedNode udn = this._tree.undecided(leaf);
                DTree.DecidedNode dn = this._st.makeDecided(udn, sbh._hcs[leaf - leafk]);
                if (dn._split._col == -1) {
                    udn.do_not_split();
                    continue;
                }
                this._did_split = true;
                DTree.Split s = dn._split;
                AtomicUtils.FloatArray.add((float[])this._improvPerVar, (int)s.col(), (float)((float)(s.pre_split_se() - s.se())));
            }
            this._leafs[this._k] = tmax;
            int new_leafs = this._tree.len() - tmax;
            this._hcs[this._k] = new DHistogram[new_leafs][];
            for (int nl = tmax; nl < this._tree.len(); ++nl) {
                this._hcs[this._k][nl - tmax] = this._tree.undecided((int)nl)._hs;
            }
            if (this._did_split) {
                ++this._tree._depth;
            }
        }
    }

    protected abstract class Driver
    extends H2O.H2OCountedCompleter<Driver> {
        protected Driver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block25: {
                SharedTree.this._model = null;
                try {
                    int i;
                    Scope.enter();
                    ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_lock_frames((Job)SharedTree.this);
                    SharedTree.this.init(true);
                    if (SharedTree.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + SharedTree.this.validationErrors());
                    }
                    if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._checkpoint && DKV.get((Key)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._model_id) != null) {
                        SharedTree.this._model = (SharedTreeModel)DKV.get((Key)SharedTree.this._dest).get();
                        SharedTree.this._model.write_lock(SharedTree.this._key);
                    } else {
                        SharedTree.this._model = this.makeModel(SharedTree.this._dest, (Object)((Object)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)), SharedTree.this.initial_MSE(SharedTree.this.response(), SharedTree.this.response()), SharedTree.this._valid == null ? Double.NaN : SharedTree.this.initial_MSE(SharedTree.this.response(), SharedTree.this.vresponse()));
                        SharedTree.this._model.delete_and_lock(SharedTree.this._key);
                        ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._init_f = SharedTree.this._initialPrediction;
                    }
                    String[] domain = SharedTree.this._response.domain();
                    assert (SharedTree.this._nclass > 1 && domain != null || SharedTree.this._nclass == 1 && domain == null);
                    if (SharedTree.this._nclass == 1) {
                        domain = new String[]{"r"};
                    }
                    if (SharedTree.this._nclass > 1) {
                        if (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output).isClassifier() && ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._balance_classes) {
                            Frame stratified;
                            float[] trainSamplingFactors = new float[SharedTree.this._train.lastVec().domain().length];
                            if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors != null) {
                                if (((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.length != SharedTree.this._train.lastVec().domain().length) {
                                    throw new IllegalArgumentException("class_sampling_factors must have " + SharedTree.this._train.lastVec().domain().length + " elements");
                                }
                                trainSamplingFactors = (float[])((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._class_sampling_factors.clone();
                            }
                            if ((stratified = MRUtils.sampleFrameStratified((Frame)SharedTree.this._train, (Vec)SharedTree.this._train.lastVec(), (float[])trainSamplingFactors, (long)((long)(((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._max_after_balance_size * (float)SharedTree.this._train.numRows())), (long)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms)._seed, (boolean)true, (boolean)false)) != SharedTree.this._train) {
                                SharedTree.this._train = stratified;
                                SharedTree.this._response = stratified.lastVec();
                                MRUtils.ClassDist cdmt2 = (MRUtils.ClassDist)new MRUtils.ClassDist(SharedTree.this._nclass).doAll(new Vec[]{SharedTree.this._response});
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution = cdmt2.dist();
                                ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist = cdmt2.rel_dist();
                            }
                        }
                        Log.info((Object[])new Object[]{"Prior class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._priorClassDist)});
                        Log.info((Object[])new Object[]{"Model class distribution: " + Arrays.toString(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._modelClassDist)});
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        SharedTree.this._train.add("Tree_" + domain[i], SharedTree.this._response.makeZero());
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        SharedTree.this._train.add("Work_" + domain[i], SharedTree.this._response.makeZero());
                    }
                    for (i = 0; i < SharedTree.this._nclass; ++i) {
                        SharedTree.this._train.add("NIDs_" + domain[i], SharedTree.this._response.makeCon(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution == null ? 0.0 : (double)(((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)((Object)SharedTree.this._model))._output)._distribution[i] == 0L ? -1 : 0)));
                    }
                    new ExcludeNAResponse().doAll(SharedTree.this._train);
                    SharedTree.access$1902(SharedTree.this, new float[SharedTree.this._ncols]);
                    this.buildModel();
                    SharedTree.this.done();
                    if (SharedTree.this._model == null) break block25;
                }
                catch (Throwable t) {
                    block26: {
                        try {
                            Job thisJob = (Job)DKV.getGet((Key)SharedTree.this._key);
                            if (thisJob._state != Job.JobState.CANCELLED) {
                                t.printStackTrace();
                                SharedTree.this.failed(t);
                                throw t;
                            }
                            Log.info((Object[])new Object[]{"Job cancelled by user."});
                            if (SharedTree.this._model == null) break block26;
                        }
                        catch (Throwable throwable) {
                            if (SharedTree.this._model != null) {
                                SharedTree.this._model.unlock(SharedTree.this._key);
                            }
                            ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_unlock_frames((Job)SharedTree.this);
                            if (SharedTree.this._model == null) {
                                Scope.exit((Key[])new Key[0]);
                            } else {
                                Scope.exit((Key[])new Key[]{((SharedTreeModel)((Object)SharedTree.this._model))._key, ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).train()), ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).valid())});
                            }
                            throw throwable;
                        }
                        SharedTree.this._model.unlock(SharedTree.this._key);
                    }
                    ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_unlock_frames((Job)SharedTree.this);
                    if (SharedTree.this._model == null) {
                        Scope.exit((Key[])new Key[0]);
                    } else {
                        Scope.exit((Key[])new Key[]{((SharedTreeModel)((Object)SharedTree.this._model))._key, ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).train()), ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).valid())});
                    }
                }
                SharedTree.this._model.unlock(SharedTree.this._key);
            }
            ((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).read_unlock_frames((Job)SharedTree.this);
            if (SharedTree.this._model == null) {
                Scope.exit((Key[])new Key[0]);
            } else {
                Scope.exit((Key[])new Key[]{((SharedTreeModel)((Object)SharedTree.this._model))._key, ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).train()), ModelMetrics.buildKey(SharedTree.this._model, (Frame)((SharedTreeModel.SharedTreeParameters)SharedTree.this._parms).valid())});
            }
            this.tryComplete();
        }

        protected abstract M makeModel(Key var1, P var2, double var3, double var5);

        protected abstract void buildModel();
    }
}

