/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import hex.tree.SharedTreeModel;
import hex.tree.TreeVisitor;
import java.util.Arrays;
import water.util.IcedBitSet;
import water.util.SB;

class TreeJCodeGen
extends TreeVisitor<RuntimeException> {
    public static final int MAX_NODES = 1024;
    final byte[] _bits = new byte[100];
    final float[] _fs = new float[100];
    final SB[] _sbs = new SB[100];
    final int[] _nodesCnt = new int[100];
    final SharedTreeModel _tm;
    SB _sb;
    SB _csb;
    SB _grpsplit;
    int _subtrees = 0;
    int _grpcnt = 0;

    public TreeJCodeGen(SharedTreeModel tm, CompressedTree ct, SB sb) {
        super(ct);
        this._tm = tm;
        this._sb = sb;
        this._csb = new SB();
        this._grpsplit = new SB();
    }

    protected void preamble(SB sb, int subtree) throws RuntimeException {
        String subt = subtree > 0 ? String.valueOf(subtree) : "";
        sb.ip("static final double score0").p(subt).p("(double[] data) {").nl().ii(1);
        sb.ip("double pred = ");
    }

    protected void closure(SB sb) throws RuntimeException {
        sb.p(";").nl();
        sb.ip("return pred;").nl().di(1);
        sb.ip("}").nl();
    }

    @Override
    protected void pre(int col, float fcmp, IcedBitSet gcmp, int equal) {
        if (equal == 2 || equal == 3 && gcmp != null) {
            this._grpsplit.i(1).p("// ").p(gcmp.toString()).nl();
            this._grpsplit.i(1).p("public static final byte[] GRPSPLIT").p(this._grpcnt).p(" = new byte[] ").p(gcmp.toStrArray()).p(";").nl();
        }
        if (this._depth > 0) {
            byte b = this._bits[this._depth - 1];
            assert (b > 0) : Arrays.toString(this._bits) + "\n" + this._sb.toString();
            if (b == 1) {
                this._bits[this._depth - 1] = 3;
            }
            if (b == 1 || b == 2) {
                this._sb.p('\n').i(this._depth).p("?");
            }
            if (b == 2) {
                this._sb.p(' ').pj(this._fs[this._depth - 1]);
            }
            if (b == 2 || b == 3) {
                this._sb.p('\n').i(this._depth).p(":");
            }
        }
        if (this._nodes > 1024) {
            this._sb.p("score0").p(this._subtrees).p("(data)");
            this._nodesCnt[this._depth] = this._nodes;
            this._sbs[this._depth] = this._sb;
            this._sb = new SB();
            this._nodes = 0;
            this.preamble(this._sb, this._subtrees);
            ++this._subtrees;
        }
        this._sb.p(" (");
        if (equal == 0 || equal == 1) {
            this._sb.p("data[").p(col).p(" /* ").p(this._tm._output._names[col]).p(" */").p("] ").p(equal == 1 ? "!= " : "<").pj(fcmp);
        } else {
            gcmp.toJava(this._sb, "GRPSPLIT" + this._grpcnt, col, this._tm._output._names[col]);
            ++this._grpcnt;
        }
        assert (this._bits[this._depth] == 0);
        this._bits[this._depth] = 1;
    }

    @Override
    protected void leaf(float pred) {
        assert (this._depth == 0 || this._bits[this._depth - 1] > 0) : Arrays.toString(this._bits);
        if (this._depth == 0) {
            this._sb.pj(pred);
        } else if (this._bits[this._depth - 1] == 1) {
            this._bits[this._depth - 1] = 2;
            this._fs[this._depth - 1] = pred;
        } else {
            if (this._bits[this._depth - 1] == 2) {
                this._sb.p(" ? ").pj(this._fs[this._depth - 1]).p(" ");
            } else {
                this._sb.p('\n').i(this._depth);
            }
            this._sb.p(": ").pj(pred);
        }
    }

    @Override
    protected void post(int col, float fcmp, int equal) {
        this._sb.p(')');
        this._bits[this._depth] = 0;
        if (this._sbs[this._depth] != null) {
            this.closure(this._sb);
            this._csb.p(this._sb);
            this._sb = this._sbs[this._depth];
            this._nodes = this._nodesCnt[this._depth];
            this._sbs[this._depth] = null;
        }
    }

    public void generate() {
        this.preamble(this._sb, this._subtrees++);
        this.visit();
        this.closure(this._sb);
        this._sb.p(this._grpsplit);
        this._sb.p(this._csb);
    }
}

