/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.tree.DTreeScorer;
import java.util.Arrays;
import water.Key;
import water.fvec.Chunk;

public class ResidualsCollector
extends DTreeScorer<ResidualsCollector> {
    public ResidualsCollector(int ncols, int nclass, Key[][] treeKeys) {
        super(ncols, nclass, treeKeys);
    }

    public void map(Chunk[] chks) {
        double[] data = new double[this._ncols];
        double[] preds = new double[this._nclass + 1];
        int ntrees = this.ntrees();
        Chunk cys = this.chk_resp(chks);
        for (int tidx = 0; tidx < ntrees; ++tidx) {
            for (int row = 0; row < cys._len; ++row) {
                for (int i = 0; i < this._ncols; ++i) {
                    data[i] = chks[i].atd(row);
                }
                Arrays.fill(preds, 0.0);
                this.score0(data, preds, this._trees[tidx]);
                if (this._nclass == 1) {
                    preds[1] = preds[0];
                }
                for (int c = 0; c < this._nclass; ++c) {
                    if (preds[1 + c] == 0.0) continue;
                    Chunk ctree = this.chk_tree(chks, c);
                    ctree.set(row, (float)(ctree.atd(row) + preds[1 + c]));
                }
            }
        }
    }
}

