/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import java.util.Random;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;
import water.util.RandomUtils;

public abstract class FrameTask<T extends FrameTask<T>>
extends MRTask<T> {
    protected transient DataInfo _dinfo;
    final Key _dinfoKey;
    final int[] _activeCols;
    protected final Key _jobKey;
    protected float _useFraction = 1.0f;
    protected boolean _shuffle = false;

    public DataInfo dinfo() {
        return this._dinfo;
    }

    public FrameTask(Key jobKey, DataInfo dinfo) {
        this(jobKey, dinfo._key, dinfo._activeCols, null);
    }

    public FrameTask(Key jobKey, DataInfo dinfo, H2O.H2OCountedCompleter cmp) {
        this(jobKey, dinfo._key, dinfo._activeCols, cmp);
    }

    public FrameTask(Key jobKey, Key dinfoKey, int[] activeCols) {
        this(jobKey, dinfoKey, activeCols, null);
    }

    public FrameTask(Key jobKey, Key dinfoKey, int[] activeCols, H2O.H2OCountedCompleter cmp) {
        super(cmp);
        assert (dinfoKey == null || DKV.get((Key)dinfoKey) != null);
        this._jobKey = jobKey;
        this._dinfoKey = dinfoKey;
        this._activeCols = activeCols;
    }

    protected FrameTask(FrameTask ft) {
        this._dinfo = ft._dinfo;
        this._jobKey = ft._jobKey;
        this._useFraction = ft._useFraction;
        this._shuffle = ft._shuffle;
        this._activeCols = ft._activeCols;
        this._dinfoKey = ft._dinfoKey;
        assert (DKV.get((Key)this._dinfoKey) != null);
    }

    protected void setupLocal() {
        DataInfo dinfo = (DataInfo)DKV.get((Key)this._dinfoKey).get();
        this._dinfo = this._activeCols == null ? dinfo : dinfo.filterExpandedColumns(this._activeCols);
    }

    protected void closeLocal() {
        this._dinfo = null;
    }

    protected void processRow(long gid, DataInfo.Row r) {
        throw new RuntimeException("should've been overriden!");
    }

    protected void processRow(long gid, DataInfo.Row r, NewChunk[] outputs) {
        throw new RuntimeException("should've been overriden!");
    }

    public T dfork(Frame fr) {
        assert (fr == this._dinfo._adaptedFrame);
        return (T)((Object)((FrameTask)super.dfork(fr)));
    }

    protected void chunkInit() {
    }

    protected void chunkDone(long n) {
    }

    public final void map(Chunk[] chunks, NewChunk[] outputs) {
        if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
            throw new Job.JobCancelledException();
        }
        int nrows = chunks[0]._len;
        long offset = chunks[0].start();
        this.chunkInit();
        int start = 0;
        int end = nrows;
        Random skip_rng = null;
        int repeats = (int)Math.ceil(this._useFraction);
        float fraction = this._useFraction / (float)repeats;
        if ((double)fraction < 1.0) {
            skip_rng = RandomUtils.getRNG((long[])new long[]{new Random().nextLong()});
        }
        long[] shuf_map = null;
        if (this._shuffle) {
            shuf_map = new long[end - start];
            for (int i = 0; i < shuf_map.length; ++i) {
                shuf_map[i] = start + i;
            }
            ArrayUtils.shuffleArray((long[])shuf_map, (long)new Random().nextLong());
        }
        long num_processed_rows = 0L;
        DataInfo.Row row = this._dinfo.newDenseRow();
        for (int rrr = 0; rrr < repeats; ++rrr) {
            for (int rr = start; rr < end; ++rr) {
                int r = shuf_map != null ? (int)shuf_map[rr - start] : rr;
                long lr = (long)r + chunks[0].start();
                if (this._dinfo._nfolds > 0 && lr % (long)this._dinfo._nfolds == (long)this._dinfo._foldId || skip_rng != null && skip_rng.nextFloat() > fraction) continue;
                ++num_processed_rows;
                if (this._dinfo.extractDenseRow((Chunk[])chunks, (int)r, (DataInfo.Row)row).bad) continue;
                long seed = offset + (long)(rrr * (end - start)) + (long)r;
                if (outputs != null && outputs.length > 0) {
                    this.processRow(seed, row, outputs);
                    continue;
                }
                this.processRow(seed, row);
            }
        }
        this.chunkDone(num_processed_rows);
    }
}

