/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.schemas.GLMV3;
import hex.schemas.ModelBuilderSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import jsr166y.CountedCompleter;
import water.DKV;
import water.DTask;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.MemoryManager;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ValueString;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class GLM
extends SupervisedModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static final double LINE_SEARCH_STEP = 0.5;
    static final int NUM_LINE_SEARCH_STEPS = 16;
    private BetaConstraint _bc = new BetaConstraint();
    DataInfo _dinfo;
    private Vec _rowFilter;
    private transient GLMTaskInfo[] _tInfos;
    private int _lambdaId;
    private transient DataInfo _validDinfo;
    private transient ArrayList<Integer> _scoring_iters = new ArrayList();
    private transient ArrayList<Integer> _scoring_times = new ArrayList();
    private transient ArrayList<Double> _likelihoods = new ArrayList();
    private transient ArrayList<Double> _objectives = new ArrayList();
    private transient ArrayList<Integer> _lIds = new ArrayList();
    private transient ArrayList<Integer> _lambda_times = new ArrayList();
    private transient ArrayList<Integer> _lambda_iterations = new ArrayList();
    private transient ArrayList<Double> _explainedDevTrain = new ArrayList();
    private transient ArrayList<Double> _explainedDevVal = new ArrayList();
    long _t0 = System.currentTimeMillis();
    long _t1 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private static final long WORK_TOTAL = 1000000L;
    static double GLM_GRAD_EPS = 1.0E-4;
    static final int sparseCoefThreshold = 750;

    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Regression, Model.ModelCategory.Binomial};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    protected void checkMemoryFootPrint() {
    }

    protected void checkMemoryFootPrint(DataInfo dinfo) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM && !((GLMModel.GLMParameters)this._parms)._lambda_search) {
            long max_mem;
            HeartBeat hb = H2O.CLOUD._memary[H2O.SELF.index()]._heartbeat;
            double p = dinfo.fullN() - dinfo.largestCat();
            long mem_usage = (long)((double)hb._cpus_allowed * (p * p + (double)dinfo.largestCat()) * 8.0 * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            if (mem_usage > (max_mem = hb.get_max_mem())) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
                this.error("_train", msg);
                this.cancel(msg);
            }
        }
    }

    public GLM(Key dest, String desc, GLMModel.GLMParameters parms) {
        super(dest, desc, (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super("GLM", (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public void addLambdaScoringHistory(int iteration, int lambdaId, double eTrain) {
        long t = System.currentTimeMillis();
        this._lIds.add(lambdaId);
        this._explainedDevTrain.add(eTrain);
        this._lambda_times.add((int)(t - this._t1));
        this._lambda_iterations.add(iteration);
        this._t1 = t;
    }

    public void addLambdaScoringHistory(int iteration, int lambdaId, double eTrain, double eVal) {
        this.addLambdaScoringHistory(iteration, lambdaId, eTrain);
        this._explainedDevVal.add(eVal);
    }

    public void addScoringHistory(int i, double l, double o) {
        long t = System.currentTimeMillis();
        this._scoring_times.add((int)(t - this._t0));
        this._scoring_iters.add(i);
        this._likelihoods.add(l);
        this._objectives.add(o);
        this._t0 = t;
    }

    public void init(boolean expensive) {
        this._t0 = System.currentTimeMillis();
        super.init(expensive);
        this.hide("_score_each_iteration", "Not used by GLM.");
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (expensive) {
            int i;
            if (((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
                int n = ((GLMModel.GLMParameters)this._parms)._max_active_predictors = ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM ? 6000 : 100000000;
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            this._dinfo = new DataInfo(Key.make(), this._train, this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false);
            DKV.put((Key)this._dinfo._key, (Iced)this._dinfo);
            this.checkMemoryFootPrint(this._dinfo);
            double[] betaStart = null;
            double[] betaGiven = null;
            double[] betaLB = null;
            double[] betaUB = null;
            double[] rho = null;
            if (((GLMModel.GLMParameters)this._parms)._beta_constraints != null) {
                int[] map;
                Object[] dom;
                Frame beta_constraints = (Frame)((GLMModel.GLMParameters)this._parms)._beta_constraints.get();
                Vec v = beta_constraints.vec("names");
                if (v.isString()) {
                    dom = new String[(int)v.length()];
                    map = new int[dom.length];
                    ValueString vs = new ValueString();
                    for (int i2 = 0; i2 < dom.length; ++i2) {
                        dom[i2] = v.atStr(vs, (long)i2).toString();
                        map[i2] = i2;
                    }
                } else if (v.isEnum()) {
                    dom = v.domain();
                    map = FrameUtils.asInts((Vec)v);
                } else {
                    throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
                }
                Object[] names = (String[])ArrayUtils.append((Object[])this._dinfo.coefNames(), (Object[])new String[]{"Intercept"});
                if (!Arrays.deepEquals(dom, names)) {
                    HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                    for (int i3 = 0; i3 < names.length; ++i3) {
                        m.put(names[i3], i3);
                    }
                    int[] newMap = MemoryManager.malloc4((int)dom.length);
                    for (int i4 = 0; i4 < map.length; ++i4) {
                        Integer I = (Integer)m.get(dom[map[i4]]);
                        if (I == null) {
                            throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                        }
                        newMap[i4] = I == null ? -1 : I;
                    }
                    map = newMap;
                }
                int numoff = this._dinfo.numStart();
                v = beta_constraints.vec("beta_start");
                if (v != null) {
                    betaStart = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                        betaStart[map == null ? i5 : map[i5]] = v.at((long)i5);
                    }
                }
                if ((v = beta_constraints.vec("beta_given")) != null) {
                    betaGiven = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                        betaGiven[map == null ? i6 : map[i6]] = v.at((long)i6);
                    }
                }
                if ((v = beta_constraints.vec("upper_bounds")) != null) {
                    betaUB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    Arrays.fill(betaUB, Double.POSITIVE_INFINITY);
                    for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                        betaUB[map == null ? i7 : map[i7]] = v.at((long)i7);
                    }
                }
                if ((v = beta_constraints.vec("lower_bounds")) != null) {
                    betaLB = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    Arrays.fill(betaLB, Double.NEGATIVE_INFINITY);
                    for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                        betaLB[map == null ? i8 : map[i8]] = v.at((long)i8);
                    }
                }
                if ((v = beta_constraints.vec("rho")) != null) {
                    rho = MemoryManager.malloc8d((int)(this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0)));
                    for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                        rho[map == null ? i9 : map[i9]] = v.at((long)i9);
                    }
                }
                if (this._dinfo._normMul != null) {
                    double normG = 0.0;
                    double normS = 0.0;
                    for (i = numoff; i < this._dinfo.fullN(); ++i) {
                        double s = this._dinfo._normSub[i - numoff];
                        double d = 1.0 / this._dinfo._normMul[i - numoff];
                        if (betaUB != null && !Double.isInfinite(betaUB[i])) {
                            int n = i;
                            betaUB[n] = betaUB[n] * d;
                        }
                        if (betaLB != null && !Double.isInfinite(betaUB[i])) {
                            int n = i;
                            betaLB[n] = betaLB[n] * d;
                        }
                        if (betaGiven != null) {
                            normG += betaGiven[i] * s;
                            int n = i;
                            betaGiven[n] = betaGiven[n] * d;
                        }
                        if (betaStart == null) continue;
                        normS += betaStart[i] * s;
                        int n = i;
                        betaStart[n] = betaStart[n] * d;
                    }
                    if (this._dinfo._intercept) {
                        int n = this._dinfo.fullN();
                        if (betaGiven != null) {
                            int n2 = n;
                            betaGiven[n2] = betaGiven[n2] - normG;
                        }
                        if (betaStart != null) {
                            int n3 = n;
                            betaStart[n3] = betaStart[n3] - normS;
                        }
                    }
                }
                if (betaStart == null && betaGiven != null) {
                    betaStart = (double[])betaGiven.clone();
                }
                if (betaStart != null && (betaLB != null || betaUB != null)) {
                    for (int i10 = 0; i10 < betaStart.length; ++i10) {
                        if (betaLB != null && betaLB[i10] > betaStart[i10]) {
                            betaStart[i10] = betaLB[i10];
                        }
                        if (betaUB == null || !(betaUB[i10] < betaStart[i10])) continue;
                        betaStart[i10] = betaUB[i10];
                    }
                }
                this._bc.setBetaStart(betaStart).setLowerBounds(betaLB).setUpperBounds(betaUB).setProximalPenalty(betaGiven, rho);
            }
            this._tInfos = new GLMTaskInfo[((GLMModel.GLMParameters)this._parms)._n_folds + 1];
            InitTsk itsk = new InitTsk(0, ((GLMModel.GLMParameters)this._parms)._intercept, null);
            H2O.submitTask((H2O.H2OCountedCompleter)itsk).join();
            assert (itsk._ymut != null);
            assert (itsk._ymut._nobs == 0L || itsk._gtNull != null);
            assert (itsk._ymut._nobs == 0L || itsk._ymut._nobs == itsk._gtNull._nobs) : "unexpected nobs, " + itsk._ymut._nobs + " != " + itsk._gtNull._nobs;
            this._rowFilter = itsk._ymut._fVec;
            assert (this._rowFilter.nChunks() == this._dinfo._adaptedFrame.anyVec().nChunks());
            assert (Math.abs((double)this._dinfo._adaptedFrame.numRows() - this._rowFilter.mean() * (double)this._rowFilter.length() - (double)itsk._ymut._nobs) < 1.0E-8) : "unexpected nobs, expected " + itsk._ymut._nobs + ", but got " + ((double)this._dinfo._adaptedFrame.numRows() - this._rowFilter.mean() * (double)this._rowFilter.length());
            assert (this._rowFilter != null);
            if (itsk._ymut._nobs == 0L) {
                this.error("training_frame", "Got no data to run on after filtering out the rows with missing values.");
                return;
            }
            if (itsk._ymut._yMin == itsk._ymut._yMax) {
                this.error("response", "Can not run glm on dataset with constant response. Response == " + itsk._ymut._yMin + " for all rows in the dataset after filtering out rows with NAs, got " + itsk._ymut._nobs + " rows out of " + this._dinfo._adaptedFrame.numRows() + " rows total.");
                return;
            }
            if (itsk._ymut._nobs < this._dinfo._adaptedFrame.numRows() >> 1) {
                this.warn("training_frame", "Dataset has less than 1/2 of the data after filtering out rows with NAs");
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(itsk._ymut._ymu * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - itsk._ymut._ymu)));
            }
            GLMTask.GLMGradientTask gtBetastart = itsk._gtBetaStart != null ? itsk._gtBetaStart : itsk._gtNull;
            this._bc.adjustGradient(itsk._gtNull._beta, itsk._gtNull._gradient);
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM ? 0.5 : 0.0};
            }
            double lmax = this.lmax(itsk._gtNull);
            double objval = gtBetastart._likelihood / (double)gtBetastart._nobs;
            double l2pen = 0.5 * lmax * (1.0 - ((GLMModel.GLMParameters)this._parms)._alpha[0]) * ArrayUtils.l2norm2((double[])gtBetastart._beta, (boolean)this._dinfo._intercept);
            double objStart = this.objVal(gtBetastart._likelihood, gtBetastart._beta, lmax, gtBetastart._nobs, ((GLMModel.GLMParameters)this._parms)._intercept);
            this._tInfos[0] = new GLMTaskInfo(this._dest, 0, itsk._ymut._nobs, itsk._ymut._ymu, lmax, this._bc._betaStart, this._dinfo.fullN() + (this._dinfo._intercept ? 1 : 0), new GLMGradientInfo(gtBetastart._likelihood, objval += (l2pen += this._bc.proxPen(gtBetastart._beta)), gtBetastart._gradient), objStart);
            this.addScoringHistory(0, gtBetastart._likelihood, objStart);
            if (((GLMModel.GLMParameters)this._parms)._lambda != null) {
                ArrayUtils.mult((double[])((GLMModel.GLMParameters)this._parms)._lambda, (double)-1.0);
                Arrays.sort(((GLMModel.GLMParameters)this._parms)._lambda);
                ArrayUtils.mult((double[])((GLMModel.GLMParameters)this._parms)._lambda, (double)-1.0);
                for (i = 0; i < ((GLMModel.GLMParameters)this._parms)._lambda.length && ((GLMModel.GLMParameters)this._parms)._lambda[i] > this._tInfos[0]._lambdaMax; ++i) {
                }
                if (i == ((GLMModel.GLMParameters)this._parms)._lambda.length) {
                    this.error("lambda", "All passed lambda values are > lambda_max = " + this._tInfos[0]._lambdaMax + ", nothing to compute.");
                }
                if (i > 0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOfRange(((GLMModel.GLMParameters)this._parms)._lambda, i, ((GLMModel.GLMParameters)this._parms)._lambda.length);
                    this.warn("lambda", "removed " + i + " lambda values which were greater than lambda_max = " + this._tInfos[0]._lambdaMax);
                }
            } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                if (((GLMModel.GLMParameters)this._parms)._nlambdas == 1) {
                    this.error("nlambdas", "Number of lambdas must be > 1 when running with lambda_search!");
                }
                if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._tInfos[0]._nobs > (long)(25 * this._dinfo.fullN()) ? 1.0E-4 : 0.01;
                }
                double d = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                ((GLMModel.GLMParameters)this._parms)._lambda = MemoryManager.malloc8d((int)((GLMModel.GLMParameters)this._parms)._nlambdas);
                ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._tInfos[0]._lambdaMax;
                for (int i11 = 1; i11 < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i11) {
                    ((GLMModel.GLMParameters)this._parms)._lambda[i11] = ((GLMModel.GLMParameters)this._parms)._lambda[i11 - 1] * d;
                }
            } else {
                ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{this._tInfos[0]._lambdaMax * ((long)this._dinfo.fullN() < this._tInfos[0]._nobs >> 4 ? 0.001 : 0.1)};
            }
            GLMModel m = new GLMModel(this._dest, (GLMModel.GLMParameters)this._parms, new GLMModel.GLMOutput(this), this._dinfo, this._tInfos[0]._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._tInfos[0]._lambdaMax, this._tInfos[0]._nobs);
            m.delete_and_lock(this._key);
            m.adaptTestForTrain(this._valid, true);
            if (this._valid != null) {
                this._validDinfo = new DataInfo(Key.make(), this._valid, null, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, ((GLMModel.GLMParameters)this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, true, false);
            }
            this.setSubmodel(this._dest, 0, this._bc._betaStart, gtBetastart._val, null, null);
            if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
                double eta = ((GLMModel.GLMParameters)this._parms).link(this._tInfos[0]._ymu);
                this._tInfos[0]._eVec = this._dinfo._adaptedFrame.anyVec().makeCon(eta);
                this._tInfos[0]._wVec = this._dinfo._adaptedFrame.anyVec().makeCon(1.0);
                this._tInfos[0]._zVec = this._dinfo._adaptedFrame.lastVec().makeCopy(null);
                this._tInfos[0]._iVec = this._dinfo._adaptedFrame.anyVec().makeCon(1.0);
            }
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM) {
                    this._tInfos[0]._iterationsPerLambda = 10;
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? this._tInfos[0]._iterationsPerLambda * ((GLMModel.GLMParameters)this._parms)._nlambdas : 50;
                } else {
                    ((GLMModel.GLMParameters)this._parms)._max_iterations = Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                        this._tInfos[0]._iterationsPerLambda = Math.max(20, ((GLMModel.GLMParameters)this._parms)._max_iterations / 20);
                        ((GLMModel.GLMParameters)this._parms)._max_iterations *= ((GLMModel.GLMParameters)this._parms)._nlambdas * this._tInfos[0]._iterationsPerLambda;
                    }
                }
            }
            this._tInfos[0]._workPerIteration = (int)(1000000L / (long)((GLMModel.GLMParameters)this._parms)._max_iterations);
        }
    }

    public ModelBuilderSchema schema() {
        return new GLMV3();
    }

    public Job<GLMModel> trainModel() {
        ((GLMModel.GLMParameters)this._parms).read_lock_frames((Job)this);
        this.start((H2O.H2OCountedCompleter)new GLMDriver(null), 1000000L);
        return this;
    }

    private final double lmax(GLMTask.GLMGradientTask gLmax) {
        return Math.max(ArrayUtils.maxValue((double[])gLmax._gradient), -ArrayUtils.minValue((double[])gLmax._gradient)) / Math.max(0.001, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private void setSubmodel(Key dstKey, int iter, double[] fullBeta, GLMValidation trainVal, GLMValidation holdOutVal, H2O.H2OCountedCompleter cmp) {
        double[] newBetaDeNorm;
        double[] fb = MemoryManager.arrayCopyOf((double[])fullBeta, (int)fullBeta.length);
        if (((GLMModel.GLMParameters)this._parms)._intercept) {
            int n = fb.length - 1;
            fb[n] = fb[n] + this._iceptAdjust;
        }
        if (this._dinfo._predictor_transform == DataInfo.TransformType.STANDARDIZE) {
            int numoff;
            newBetaDeNorm = (double[])fb.clone();
            double norm = 0.0;
            for (int i = numoff = this._dinfo.numStart(); i < fb.length - 1; ++i) {
                double b = newBetaDeNorm[i] * this._dinfo._normMul[i - numoff];
                norm += b * this._dinfo._normSub[i - numoff];
                newBetaDeNorm[i] = b;
            }
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                int n = newBetaDeNorm.length - 1;
                newBetaDeNorm[n] = newBetaDeNorm[n] - norm;
            }
        } else {
            newBetaDeNorm = null;
        }
        GLMModel.setSubmodel(cmp, dstKey, ((GLMModel.GLMParameters)this._parms)._lambda[this._lambdaId], newBetaDeNorm == null ? fb : newBetaDeNorm, newBetaDeNorm == null ? null : fb, iter, System.currentTimeMillis() - this._start_time, this._dinfo.fullN() >= 750, trainVal, holdOutVal, this._train, this._valid);
    }

    double objVal(double likelihood, double[] beta, double lambda, long nobs, boolean intercept) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        if (this._bc._betaGiven != null) {
            for (int i = 0; i < this._bc._betaGiven.length; ++i) {
                double diff = beta[i] - this._bc._betaGiven[i];
                proximalPen += diff * diff * this._bc._rho[i] * 0.5;
            }
        }
        return likelihood / (double)nobs + proximalPen + lambda * (alpha * ArrayUtils.l1norm((double[])beta, (boolean)intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)intercept));
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] contractVec(double[] beta, int[] activeCols) {
        if (beta == null) {
            return null;
        }
        if (activeCols == null) {
            return (double[])beta.clone();
        }
        double[] res = MemoryManager.malloc8d((int)(activeCols.length + 1));
        int i = 0;
        for (int c : activeCols) {
            res[i++] = beta[c];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static final double[] resizeVec(double[] beta, int[] activeCols, int[] oldActiveCols, int fullN) {
        if (beta == null || Arrays.equals(activeCols, oldActiveCols)) {
            return beta;
        }
        double[] full = GLM.expandVec(beta, oldActiveCols, fullN);
        if (activeCols == null) {
            return full;
        }
        return GLM.contractVec(full, activeCols);
    }

    public static final class GLMGradientSolver
    extends L_BFGS.GradientSolver {
        final GLMModel.GLMParameters _glmp;
        final DataInfo _dinfo;
        final double _ymu;
        final double _lambda;
        final long _nobs;
        Vec _rowFilter;
        double[] _beta;

        public GLMGradientSolver(GLMModel.GLMParameters glmp, DataInfo dinfo, double lambda, double ymu, long nobs) {
            this(glmp, dinfo, lambda, ymu, nobs, null);
        }

        public GLMGradientSolver(GLMModel.GLMParameters glmp, DataInfo dinfo, double lambda, double ymu, long nobs, Vec rowFilter) {
            this._glmp = glmp;
            this._dinfo = dinfo;
            this._ymu = ymu;
            this._nobs = nobs;
            this._lambda = lambda;
            this._rowFilter = rowFilter;
        }

        public GLMGradientSolver setBetaStart(double[] beta) {
            this._beta = (double[])beta.clone();
            return this;
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            GLMTask.GLMGradientTask gt = this._glmp._family == GLMModel.GLMParameters.Family.binomial ? (GLMTask.GLMGradientTask)new GLMTask.LBFGS_LogisticGradientTask(this._dinfo, this._glmp, this._lambda, beta, 1.0 / (double)this._nobs, this._rowFilter).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(this._dinfo, this._glmp, this._lambda, beta, 1.0 / (double)this._nobs, this._rowFilter).doAll(this._dinfo._adaptedFrame);
            return new GLMGradientInfo(gt._likelihood, gt._likelihood / (double)gt._nobs + 0.5 * this._lambda * ArrayUtils.l2norm2((double[])beta, (boolean)this._dinfo._intercept), gt._gradient);
        }

        @Override
        public double[] getObjVals(double[] beta, double[] direction, int nSteps, double stepDec) {
            double reg = 1.0 / (double)this._nobs;
            double[] objs = ((GLMTask.GLMLineSearchTask)new GLMTask.GLMLineSearchTask((DataInfo)this._dinfo, (GLMModel.GLMParameters)this._glmp, (double)(1.0 / (double)this._nobs), (double[])beta, (double[])direction, (double)stepDec, (int)nSteps, (Vec)this._rowFilter).setFasterMetrics((boolean)true).doAll((Frame)this._dinfo._adaptedFrame))._likelihoods;
            double step = 1.0;
            int i = 0;
            while (i < objs.length) {
                int n = i;
                objs[n] = objs[n] * reg;
                if (this._lambda > 0.0) {
                    double[] b = ArrayUtils.wadd((double[])((double[])beta.clone()), (double[])direction, (double)step);
                    if (this._lambda > 0.0) {
                        int n2 = i;
                        objs[n2] = objs[n2] + 0.5 * this._lambda * ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
                    }
                }
                ++i;
                step *= stepDec;
            }
            return objs;
        }
    }

    public static final class GLMGradientInfo
    extends L_BFGS.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }
    }

    public static class ProximalGradientSolver
    extends L_BFGS.GradientSolver {
        final L_BFGS.GradientSolver _solver;
        final double[] _betaGiven;
        final double[] _rho;

        public ProximalGradientSolver(L_BFGS.GradientSolver s, double[] betaGiven, double[] rho) {
            this._solver = s;
            this._betaGiven = betaGiven;
            this._rho = rho;
        }

        @Override
        public L_BFGS.GradientInfo getGradient(double[] beta) {
            L_BFGS.GradientInfo gt = this._solver.getGradient(beta);
            int i = 0;
            while (i < gt._gradient.length) {
                double diff = beta[i] - this._betaGiven[i];
                double pen = this._rho[i] * diff;
                int n = i++;
                gt._gradient[n] = gt._gradient[n] + pen;
                gt._objVal += 0.5 * pen * diff;
            }
            return gt;
        }

        @Override
        public double[] getObjVals(double[] beta, double[] pk, int nSteps, double stepDec) {
            double[] objs = this._solver.getObjVals(beta, pk, nSteps, stepDec);
            double step = 1.0;
            assert (objs.length == nSteps);
            int i = 0;
            while (i < objs.length) {
                double[] b = ArrayUtils.wadd((double[])((double[])beta.clone()), (double[])pk, (double)step);
                double pen = 0.0;
                for (int j = 0; j < this._betaGiven.length; ++j) {
                    double diff = b[j] - this._betaGiven[j];
                    pen += this._rho[j] * diff * diff;
                }
                int n = i++;
                objs[n] = objs[n] + 0.5 * pen;
                step *= stepDec;
            }
            return objs;
        }
    }

    public static final class LBFGS_ProximalSolver
    implements ADMM.ProximalSolver {
        double[] _beta;
        final double[] _rho;
        final L_BFGS.GradientSolver _gSolver;
        double[] _gradient;
        public int _iter;
        final Key _jobKey;
        double[] _beta_given;
        L_BFGS.GradientInfo _ginfo;

        public LBFGS_ProximalSolver(L_BFGS.GradientSolver gs, double[] beta, double[] rho, Key jobKey) {
            this._gSolver = gs;
            this._beta = beta;
            this._rho = rho;
            this._jobKey = jobKey;
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public void solve(double[] beta_given, double[] result) {
            if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
                throw new Job.JobCancelledException();
            }
            ProximalGradientSolver s = new ProximalGradientSolver(this._gSolver, beta_given, this._rho);
            if (this._beta_given == null) {
                this._beta_given = MemoryManager.malloc8d((int)beta_given.length);
            }
            if (this._ginfo != null) {
                for (int i = 0; i < beta_given.length; ++i) {
                    int n = i;
                    this._ginfo._gradient[n] = this._ginfo._gradient[n] + this._rho[i] * (this._beta_given[i] - beta_given[i]);
                    this._ginfo._objVal += 0.5 * this._rho[i] * ((result[i] - beta_given[i]) * (result[i] - beta_given[i]) - (result[i] - this._beta_given[i]) * (result[i] - this._beta_given[i]));
                    this._beta_given[i] = beta_given[i];
                }
            } else {
                this._ginfo = s.getGradient(result);
            }
            L_BFGS.Result r = new L_BFGS().solve(s, (double[])result.clone(), this._ginfo, new L_BFGS.ProgressMonitor(){

                @Override
                public boolean progress(double[] beta, L_BFGS.GradientInfo ginfo) {
                    return LBFGS_ProximalSolver.this._jobKey == null || Job.isRunning((Key)LBFGS_ProximalSolver.this._jobKey);
                }
            });
            this._ginfo = r.ginfo;
            this._beta = r.coefs;
            this._gradient = r.ginfo._gradient;
            this._iter += r.iter;
            System.arraycopy(this._beta, 0, result, 0, this._beta.length);
        }

        @Override
        public boolean hasGradient() {
            return this._gradient != null;
        }

        @Override
        public double[] gradient(double[] beta) {
            return this._gSolver.getGradient((double[])beta)._gradient;
        }

        @Override
        public void setRho(double[] rho) {
            System.arraycopy(rho, 0, this._rho, 0, this._rho.length);
        }

        @Override
        public boolean canSetRho() {
            return true;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            if (!intercept) {
                gram.dropIntercept();
                xy = Arrays.copyOf(xy, xy.length - 1);
            }
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf((double[])result, (int)result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient(result);
                    gerr = Math.max(-ArrayUtils.minValue((double[])g), ArrayUtils.maxValue((double[])g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn((Object[])new Object[]{"Gram solver did not converge, gerr = " + gerr});
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double default_rho, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = xy.length - 1;
            double[] rhos = MemoryManager.malloc8d((int)(xy.length - 1 + ii));
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - 1; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double ux;
                double lx;
                double xx;
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = beta_given != null && proxPen != null ? (y - ybar * gram.get(icptCol, i) + proxPen[i] * beta_given[i]) / (gram.get(i, i) - xbar * xbar + l2pen + proxPen[i]) : (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar) + l2pen;
                double rho = ADMM.L1Solver.estimateRho(x, l1pen);
                rhos[i] = ub != null && !Double.isInfinite(ub[i]) || lb != null && !Double.isInfinite(lb[i]) ? Math.max(rho, (xx = Math.min(lx = x - lb[i], ux = ub[i] - x)) <= 0.5 * x ? 1.0 : 1.0E-4) : rho;
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (!intercept) {
                gram.dropIntercept();
                xy = Arrays.copyOf(xy, xy.length - 1);
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this.computeCholesky(gram, rhos, 1.0E-5);
            this._rho = rhos;
            this._xy = xy;
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd) {
            gram.addDiag(rhos);
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                ArrayUtils.mult((double[])rhos, (double)-1.0);
                int i = 0;
                while (i < rhos.length) {
                    int n = i++;
                    rhos[n] = rhos[n] + rhoAdd;
                }
                Log.info((Object[])new Object[]{"Got NonSPD matrix with original rho, re-computing with rho = " + rhos[0]});
                this._gram.addDiag(rhos);
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                    ArrayUtils.mult((double[])rhos, (double)-1.0);
                    int i2 = 0;
                    while (i2 < rhos.length) {
                        int n = i2++;
                        rhos[n] = rhos[n] * 100.0;
                    }
                    Log.warn((Object[])new Object[]{"Still NonSPD matrix, re-computing with rho = " + rhos[0]});
                    this._gram.addDiag(rhos);
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
            ArrayUtils.mult((double[])rhos, (double)-1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public void solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public double[] gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < grad.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return grad;
        }

        @Override
        public void setRho(double[] r) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canSetRho() {
            return false;
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMSingleLambdaTsk
    extends DTask<GLMSingleLambdaTsk> {
        DataInfo _activeData;
        GLMTaskInfo _taskInfo;
        long _start_time;

        public GLMSingleLambdaTsk(H2O.H2OCountedCompleter cmp, GLMTaskInfo state) {
            super(cmp);
            this._taskInfo = state;
            assert (DKV.get((Key)GLM.this._dinfo._key) != null);
        }

        private String LogInfo(String msg) {
            msg = "GLM[dest=" + this._taskInfo._dstKey + ", iteration=" + this._taskInfo._iter + ", lambda = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] + "]: " + msg;
            Log.info((Object[])new Object[]{msg});
            return msg;
        }

        private int[] activeCols(double l1, double l2, double[] grad) {
            if (this._taskInfo._allIn) {
                return null;
            }
            int selected = 0;
            int[] cols = null;
            if (((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] > 0.0) {
                double rhs = ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * (2.0 * l1 - l2);
                cols = MemoryManager.malloc4((int)GLM.this._dinfo.fullN());
                int j = 0;
                int[] oldActiveCols = this._taskInfo._activeCols;
                if (oldActiveCols == null) {
                    oldActiveCols = new int[]{};
                }
                for (int i = 0; i < GLM.this._dinfo.fullN(); ++i) {
                    if (!(j < oldActiveCols.length && i == oldActiveCols[j] || grad[i] > rhs) && !(grad[i] < -rhs)) continue;
                    cols[selected++] = i;
                    if (j >= oldActiveCols.length || i != oldActiveCols[j]) continue;
                    ++j;
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] == 0.0 || selected == GLM.this._dinfo.fullN()) {
                this._taskInfo._allIn = true;
                this._activeData = GLM.this._dinfo;
                this.LogInfo("strong rule at lambda_value=" + l1 + ", all " + GLM.this._dinfo.fullN() + " coefficients are active");
                return null;
            }
            this.LogInfo("strong rule at lambda_value=" + l1 + ", got " + selected + " active cols out of " + GLM.this._dinfo.fullN() + " total.");
            return Arrays.copyOf(cols, selected);
        }

        private double[] setSubmodel(double[] newBeta, GLMValidation trainVal, GLMValidation holdOutVal, H2O.H2OCountedCompleter cmp) {
            double[] fullBeta;
            if (trainVal != null) {
                trainVal._intercept = ((GLMModel.GLMParameters)GLM.this._parms)._intercept;
            }
            if (holdOutVal != null) {
                holdOutVal._intercept = ((GLMModel.GLMParameters)GLM.this._parms)._intercept;
            }
            double[] dArray = fullBeta = this._taskInfo._activeCols == null || newBeta == null ? newBeta : GLM.expandVec(newBeta, this._taskInfo._activeCols, GLM.this._dinfo.fullN() + 1);
            if (fullBeta == null) {
                fullBeta = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    fullBeta[fullBeta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).linkInv(this._taskInfo._ymu);
                }
            }
            GLM.this.setSubmodel(this._taskInfo._dstKey, this._taskInfo._iter, fullBeta, trainVal, holdOutVal, cmp);
            return fullBeta;
        }

        protected void solve() {
            if (this._activeData.fullN() > ((GLMModel.GLMParameters)GLM.this._parms)._max_active_predictors) {
                throw new TooManyPredictorsException();
            }
            GLMModel.GLMParameters.Solver solverType = ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            if (solverType == GLMModel.GLMParameters.Solver.AUTO) {
                solverType = this._activeData.fullN() > 6000 || this._activeData._adaptedFrame.numCols() > 500 ? GLMModel.GLMParameters.Solver.L_BFGS : GLMModel.GLMParameters.Solver.IRLSM;
            }
            switch (solverType) {
                case L_BFGS: {
                    double[] beta = this._taskInfo._beta;
                    assert (beta.length == this._activeData.fullN() + 1);
                    L_BFGS.GradientSolver solver = new GLMGradientSolver((GLMModel.GLMParameters)GLM.this._parms, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), this._taskInfo._ymu, this._taskInfo._nobs, GLM.this._rowFilter);
                    if (((GLM)GLM.this)._bc._betaGiven != null && ((GLM)GLM.this)._bc._rho != null) {
                        solver = new ProximalGradientSolver(solver, ((GLM)GLM.this)._bc._betaGiven, ((GLM)GLM.this)._bc._rho);
                    }
                    if (beta == null) {
                        beta = MemoryManager.malloc8d((int)(this._activeData.fullN() + (this._activeData._intercept ? 1 : 0)));
                        if (this._activeData._intercept) {
                            beta[beta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu);
                        }
                    }
                    L_BFGS lbfgs = new L_BFGS().setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
                    assert (beta.length == this._taskInfo._ginfo._gradient.length);
                    double l1pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0];
                    if (l1pen > 0.0 || GLM.this._bc.hasBounds()) {
                        double[] nullBeta = MemoryManager.malloc8d((int)this._taskInfo._beta.length);
                        if (GLM.this._dinfo._intercept) {
                            nullBeta[nullBeta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(this._taskInfo._ymu);
                        }
                        double[] g = solver.getGradient((double[])nullBeta)._gradient;
                        double[] rho = MemoryManager.malloc8d((int)beta.length);
                        for (int i = 0; i < rho.length - (GLM.this._dinfo._intercept ? 1 : 0); ++i) {
                            rho[i] = ADMM.L1Solver.estimateRho(-g[i], l1pen);
                        }
                        new ADMM.L1Solver(1.0E-4, 1000).solve(new LBFGS_ProximalSolver(solver, this._taskInfo._beta, rho, GLM.this._key), this._taskInfo._beta, l1pen);
                        break;
                    }
                    L_BFGS.Result r = lbfgs.solve(solver, beta, this._taskInfo._ginfo, new L_BFGS.ProgressMonitor(){

                        @Override
                        public boolean progress(double[] beta, L_BFGS.GradientInfo ginfo) {
                            if (ginfo instanceof GLMGradientInfo) {
                                GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                                GLM.this.addScoringHistory(GLMSingleLambdaTsk.this._taskInfo._iter, gginfo._likelihood, gginfo._objVal);
                            }
                            if ((GLMSingleLambdaTsk.this._taskInfo._iter & 7) == 0) {
                                GLMSingleLambdaTsk.this._taskInfo._worked += GLMSingleLambdaTsk.this._taskInfo._workPerIteration * 8;
                                Job.update((long)(GLMSingleLambdaTsk.this._taskInfo._workPerIteration * 8), (String)("iteration " + (GLMSingleLambdaTsk.this._taskInfo._iter + 1) + ", objective value = " + ginfo._objVal + ", gradient norm = " + ArrayUtils.l2norm2((double[])ginfo._gradient, (boolean)false)), (Key)GLM.this._key);
                                GLMSingleLambdaTsk.this.LogInfo("LBFGS: objval = " + ginfo._objVal);
                            }
                            ++GLMSingleLambdaTsk.this._taskInfo._iter;
                            return Job.isRunning((Key)GLM.this._key);
                        }
                    });
                    this._taskInfo._beta = r.coefs;
                    break;
                }
                case COORDINATE_DESCENT: {
                    double l1pen = ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId];
                    double l2pen = (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId];
                    double[] beta = (double[])this._taskInfo._beta.clone();
                    double xNewSub = 0.0;
                    double xNewMul = 1.0;
                    double[] betaUpdate = null;
                    boolean betaChanges = true;
                    int iter = 0;
                    while (betaChanges) {
                        int it = iter;
                        while (betaChanges && ++iter < 1000) {
                            betaChanges = false;
                            for (int i = 0; i < this._activeData._adaptedFrame.numCols(); ++i) {
                                int to;
                                int off;
                                Vec previousVec = i == 0 ? this._taskInfo._iVec : GLM.this._dinfo._adaptedFrame.vec(i - 1);
                                Vec currentVec = i == GLM.this._dinfo._adaptedFrame.numCols() - 1 ? this._taskInfo._iVec : GLM.this._dinfo._adaptedFrame.vec(i);
                                double xOldSub = xNewSub;
                                double xOldMul = xNewMul;
                                boolean isCategorical = currentVec.isEnum();
                                if (isCategorical) {
                                    xNewSub = 0.0;
                                    xNewMul = 1.0;
                                    off = GLM.this._dinfo._catOffsets[i];
                                    to = GLM.this._dinfo._catOffsets[i + 1];
                                } else {
                                    int k = i - GLM.this._dinfo._cats;
                                    xNewSub = GLM.this._dinfo._normSub[k];
                                    xNewMul = GLM.this._dinfo._normMul[k];
                                    off = GLM.this._dinfo.numStart() + k;
                                    to = off + 1;
                                }
                                double[] currentBeta = Arrays.copyOfRange(this._taskInfo._beta, off, to);
                                double[] xy = ((GLMTask.GLMCoordinateDescentTask)new GLMTask.GLMCoordinateDescentTask(betaUpdate, (double[])currentBeta, (double)xOldSub, (double)xOldMul, (double)xNewSub, (double)xNewMul).doAll((Vec[])new Vec[]{previousVec, currentVec, this._taskInfo._eVec, this._taskInfo._wVec, this._taskInfo._zVec}))._xy;
                                for (int j = 0; j < xy.length; ++j) {
                                    betaUpdate = currentBeta;
                                    double updatedCoef = ADMM.shrinkage(xy[j], l1pen) / (1.0 + l2pen);
                                    betaUpdate[j] = updatedCoef - currentBeta[j];
                                    if (betaUpdate[j] < -1.0E-4 || betaUpdate[j] > 1.0E-4) {
                                        betaChanges = true;
                                    }
                                    beta[off + j] = updatedCoef;
                                }
                            }
                        }
                        if (iter <= it + 1) continue;
                        betaChanges = true;
                        new GLMTask.GLMWeightsTask((GLMModel.GLMParameters)GLM.this._parms).doAll(new Vec[]{GLM.this._dinfo._adaptedFrame.lastVec(), this._taskInfo._zVec, this._taskInfo._wVec, this._taskInfo._eVec});
                    }
                    break;
                }
                case IRLSM: {
                    new GLMTask.GLMIterationTask(GLM.this._key, this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, false, this._taskInfo._beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? this._taskInfo._ymu : 0.5, GLM.this._rowFilter, (H2O.H2OCountedCompleter)new Iteration((CountedCompleter)this, false)).asyncExec(this._activeData._adaptedFrame);
                    return;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            this.checkKKTsAndComplete();
            this.tryComplete();
        }

        protected void checkKKTsAndComplete() {
            final double[] fullBeta = GLM.expandVec(this._taskInfo._beta, this._activeData._activeCols, GLM.this._dinfo.fullN() + 1);
            this.addToPendingCount(1);
            new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], fullBeta, 1.0 / (double)this._taskInfo._nobs, GLM.this._rowFilter, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMGradientTask>((H2O.H2OCountedCompleter)this){

                public void callback(final GLMTask.GLMGradientTask gt1) {
                    int i;
                    assert (gt1._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs);
                    double[] subgrad = (double[])gt1._gradient.clone();
                    ADMM.subgrad(((GLMModel.GLMParameters)GLM.this._parms)._alpha[0] * ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], fullBeta, subgrad);
                    double err = GLM_GRAD_EPS;
                    if (GLMSingleLambdaTsk.this._taskInfo._activeCols != null) {
                        for (int c : GLMSingleLambdaTsk.this._taskInfo._activeCols) {
                            if (subgrad[c] > err) {
                                err = subgrad[c];
                                continue;
                            }
                            if (!(subgrad[c] < -err)) continue;
                            err = -subgrad[c];
                        }
                        GLMSingleLambdaTsk.this.LogInfo("solved with gerr = " + err);
                        int[] failedCols = new int[64];
                        int fcnt = 0;
                        for (i = 0; i < subgrad.length - 1; ++i) {
                            if (Arrays.binarySearch(GLMSingleLambdaTsk.this._taskInfo._activeCols, i) >= 0 || !(subgrad[i] > err) && !(-subgrad[i] > err)) continue;
                            if (fcnt == failedCols.length) {
                                failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                            }
                            failedCols[fcnt++] = i;
                        }
                        if (fcnt > 0) {
                            int n = GLMSingleLambdaTsk.this._taskInfo._activeCols.length;
                            int[] newCols = Arrays.copyOf(GLMSingleLambdaTsk.this._taskInfo._activeCols, GLMSingleLambdaTsk.this._taskInfo._activeCols.length + fcnt);
                            for (int i2 = 0; i2 < fcnt; ++i2) {
                                newCols[n + i2] = failedCols[i2];
                            }
                            Arrays.sort(newCols);
                            GLMSingleLambdaTsk.this._taskInfo._beta = GLM.resizeVec(gt1._beta, newCols, GLMSingleLambdaTsk.this._taskInfo._activeCols, GLM.this._dinfo.fullN() + 1);
                            GLMSingleLambdaTsk.this._taskInfo._activeCols = newCols;
                            GLMSingleLambdaTsk.this.LogInfo(fcnt + " variables failed KKT conditions check! Adding them to the model and continuing computation.(grad_eps = " + err + ", activeCols = " + (GLMSingleLambdaTsk.this._taskInfo._activeCols.length > 100 ? "lost" : Arrays.toString(GLMSingleLambdaTsk.this._taskInfo._activeCols)));
                            GLMSingleLambdaTsk.this._activeData = GLM.this._dinfo.filterExpandedColumns(GLMSingleLambdaTsk.this._taskInfo._activeCols);
                            assert (newCols == null || GLMSingleLambdaTsk.this._activeData.fullN() == GLMSingleLambdaTsk.this._taskInfo._activeCols.length);
                            this.getCompleter().addToPendingCount(1);
                            GLMSingleLambdaTsk.this.solve();
                            return;
                        }
                    }
                    if (GLM.this._valid != null) {
                        GLMSingleLambdaTsk.this.addToPendingCount(1);
                        new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], gt1._beta, 1.0 / (double)GLMSingleLambdaTsk.this._taskInfo._nobs, null, (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.GLMGradientTask>((H2O.H2OCountedCompleter)GLMSingleLambdaTsk.this){

                            public void callback(GLMTask.GLMGradientTask gt2) {
                                GLMSingleLambdaTsk.this.LogInfo("hold-out set validation: \n" + gt2._val.toString());
                                GLMSingleLambdaTsk.this.setSubmodel(GLMSingleLambdaTsk.this._taskInfo._beta, gt1._val, gt2._val, (H2O.H2OCountedCompleter)GLMSingleLambdaTsk.this);
                                GLM.this.addLambdaScoringHistory(GLMSingleLambdaTsk.this._taskInfo._iter, GLM.this._lambdaId, gt1._val.explainedDev(), gt2._val.explainedDev());
                            }
                        }).setValidate(((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu : 0.0, true).asyncExec(((GLM)GLM.this)._validDinfo._adaptedFrame);
                    } else {
                        GLM.this.addLambdaScoringHistory(GLMSingleLambdaTsk.this._taskInfo._iter, GLM.this._lambdaId, gt1._val.explainedDev());
                        GLMSingleLambdaTsk.this.setSubmodel(GLMSingleLambdaTsk.this._taskInfo._beta, gt1._val, null, null);
                    }
                    double l2pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) * ArrayUtils.l2norm2((double[])gt1._beta, (boolean)GLMSingleLambdaTsk.this._activeData._intercept);
                    if (((GLM)GLM.this)._bc._betaGiven != null && ((GLM)GLM.this)._bc._rho != null) {
                        for (i = 0; i < ((GLM)GLM.this)._bc._betaGiven.length; ++i) {
                            double diff = gt1._beta[i] - ((GLM)GLM.this)._bc._betaGiven[i];
                            l2pen += ((GLM)GLM.this)._bc._rho[i] * diff * diff;
                        }
                    }
                    GLMSingleLambdaTsk.this._taskInfo._ginfo = new GLMGradientInfo(gt1._likelihood, gt1._likelihood / (double)gt1._nobs + (l2pen *= 0.5), gt1._gradient);
                    assert (GLMSingleLambdaTsk.this._taskInfo._ginfo._gradient.length == GLM.this._dinfo.fullN() + 1) : GLMSingleLambdaTsk.this._taskInfo._ginfo._gradient.length + " != " + GLM.this._dinfo.fullN() + ", intercept = " + ((GLMModel.GLMParameters)GLM.this._parms)._intercept;
                    GLMSingleLambdaTsk.this._taskInfo._objVal = GLM.this.objVal(gt1._likelihood, gt1._beta, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], gt1._nobs, GLM.this._dinfo._intercept);
                    GLM.this.addScoringHistory(GLMSingleLambdaTsk.this._taskInfo._iter, gt1._likelihood, GLMSingleLambdaTsk.this._taskInfo._objVal);
                    GLMSingleLambdaTsk.this._taskInfo._beta = fullBeta;
                }
            }).setValidate(((GLMModel.GLMParameters)GLM.this._parms)._intercept ? this._taskInfo._ymu : 0.5, true).asyncExec(GLM.this._dinfo._adaptedFrame);
        }

        protected void compute2() {
            if (!Job.isRunning((Key)GLM.this._key)) {
                throw new Job.JobCancelledException();
            }
            assert (GLM.this._rowFilter != null);
            this._start_time = System.currentTimeMillis();
            this.LogInfo("lambda = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] + "\n");
            int[] activeCols = this.activeCols(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLM.this._lambdaId == 0 ? this._taskInfo._lambdaMax : ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId - 1], this._taskInfo._ginfo._gradient);
            this._taskInfo._activeCols = activeCols;
            this._activeData = GLM.this._dinfo.filterExpandedColumns(activeCols);
            assert (this._taskInfo._activeCols == null || this._taskInfo._activeCols.length == this._activeData.fullN());
            this._taskInfo._ginfo = new GLMGradientInfo(this._taskInfo._ginfo._likelihood, this._taskInfo._ginfo._objVal, GLM.contractVec(this._taskInfo._ginfo._gradient, activeCols));
            this._taskInfo._beta = GLM.contractVec(this._taskInfo._beta, activeCols);
            assert (activeCols == null || this._activeData.fullN() == activeCols.length) : this.LogInfo("mismatched number of cols, got " + activeCols.length + " active cols, but data info claims " + this._activeData.fullN());
            assert (DKV.get((Key)this._activeData._key) != null);
            this.solve();
        }

        private final double beta_diff(double[] b1, double[] b2) {
            if (b1 == null) {
                return Double.MAX_VALUE;
            }
            double res = b1[0] >= b2[0] ? b1[0] - b2[0] : b2[0] - b1[0];
            for (int i = 1; i < b1.length; ++i) {
                double diff = b1[i] - b2[i];
                if (diff > res) {
                    res = diff;
                    continue;
                }
                if (!(-diff > res)) continue;
                res = -diff;
            }
            return res;
        }

        protected double l1norm(double[] beta) {
            if (beta == null) {
                return 0.0;
            }
            double l1 = 0.0;
            for (int i = 0; i < beta.length - 1; ++i) {
                l1 += beta[i] < 0.0 ? -beta[i] : beta[i];
            }
            return l1;
        }

        private class LineSearchIteration
        extends H2O.H2OCallback<GLMTask.GLMLineSearchTask> {
            LineSearchIteration(CountedCompleter cmp) {
                super((H2O.H2OCountedCompleter)cmp);
            }

            public void callback(GLMTask.GLMLineSearchTask lst) {
                assert (lst._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs) : lst._nobs + " != " + GLMSingleLambdaTsk.this._taskInfo._nobs + ", filtervec = " + (lst._rowFilter == null);
                double t = 1.0;
                int i = 0;
                while (i < lst._likelihoods.length) {
                    double[] beta = ArrayUtils.wadd((double[])((double[])GLMSingleLambdaTsk.this._taskInfo._beta.clone()), (double[])lst._direction, (double)t);
                    double newObj = GLM.this.objVal(lst._likelihoods[i], beta, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLMSingleLambdaTsk.this._taskInfo._nobs, GLMSingleLambdaTsk.this._activeData._intercept);
                    if (GLMSingleLambdaTsk.this._taskInfo._objVal > newObj) {
                        assert (t < 1.0);
                        GLMSingleLambdaTsk.this.LogInfo("line search: found admissible step = " + t + ",  objval = " + newObj);
                        this.getCompleter().addToPendingCount(1);
                        new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, true, beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu : 0.5, GLM.this._rowFilter, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true, false)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                        return;
                    }
                    ++i;
                    t *= 0.5;
                }
                GLMSingleLambdaTsk.this.LogInfo("Line search did not find feasible step, converged at objval = " + GLMSingleLambdaTsk.this._taskInfo._objVal);
                GLMSingleLambdaTsk.this.checkKKTsAndComplete();
            }
        }

        private class Iteration
        extends H2O.H2OCallback<GLMTask.GLMIterationTask> {
            public final long _iterationStartTime;
            final boolean _countIteration;
            public final boolean _doLinesearch;

            public Iteration(CountedCompleter cmp, boolean doLinesearch) {
                this(cmp, doLinesearch, true);
            }

            public Iteration(CountedCompleter cmp, boolean doLinesearch, boolean countIteration) {
                super((H2O.H2OCountedCompleter)cmp);
                this._countIteration = countIteration;
                this._iterationStartTime = System.currentTimeMillis();
                this._doLinesearch = doLinesearch;
            }

            public void callback(final GLMTask.GLMIterationTask glmt) {
                double defaultRho;
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept || glmt._beta[GLMSingleLambdaTsk.this._activeData.fullN()] == 0.0);
                double objVal = GLM.this.objVal(glmt._likelihood, glmt._beta, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLMSingleLambdaTsk.this._taskInfo._nobs, GLMSingleLambdaTsk.this._activeData._intercept);
                if (!Job.isRunning((Key)GLM.this._key)) {
                    throw new Job.JobCancelledException();
                }
                assert (glmt._nobs == GLMSingleLambdaTsk.this._taskInfo._nobs) : "got wrong number of observations, expected " + GLMSingleLambdaTsk.this._taskInfo._nobs + ", but got " + glmt._nobs + ", got row filter?" + (glmt._rowFilter != null);
                assert (GLMSingleLambdaTsk.this._taskInfo._activeCols == null || glmt._beta == null || glmt._beta.length == GLMSingleLambdaTsk.this._taskInfo._activeCols.length + 1) : GLMSingleLambdaTsk.access$1600(GLMSingleLambdaTsk.this, "betalen = " + glmt._beta.length + ", activecols = " + GLMSingleLambdaTsk.this._taskInfo._activeCols.length);
                assert (GLMSingleLambdaTsk.this._taskInfo._activeCols == null || GLMSingleLambdaTsk.this._taskInfo._activeCols.length == GLMSingleLambdaTsk.this._activeData.fullN());
                double reg = 1.0 / (double)GLMSingleLambdaTsk.this._taskInfo._nobs;
                glmt._gram.mul(reg);
                ArrayUtils.mult((double[])glmt._xy, (double)reg);
                if (this._countIteration) {
                    ++GLMSingleLambdaTsk.this._taskInfo._iter;
                }
                long callbackStart = System.currentTimeMillis();
                double lastObjVal = GLMSingleLambdaTsk.this._taskInfo._objVal;
                GLMSingleLambdaTsk.this.LogInfo("gram computed in " + (callbackStart - this._iterationStartTime) + "ms");
                double logl = glmt._likelihood;
                GLMSingleLambdaTsk.this.LogInfo("-log(l) = " + logl + ", obj = " + objVal);
                if (this._doLinesearch && (glmt.hasNaNsOrInf() || !(lastObjVal > objVal))) {
                    GLMSingleLambdaTsk.this._taskInfo._lineSearch = true;
                    this.getCompleter().addToPendingCount(1);
                    GLMSingleLambdaTsk.this.LogInfo("invoking line search, objval = " + objVal + ", lastObjVal = " + lastObjVal);
                    new GLMTask.GLMLineSearchTask(GLMSingleLambdaTsk.this._activeData, (GLMModel.GLMParameters)GLM.this._parms, 1.0 / (double)GLMSingleLambdaTsk.this._taskInfo._nobs, (double[])GLMSingleLambdaTsk.this._taskInfo._beta.clone(), ArrayUtils.subtract((double[])glmt._beta, (double[])GLMSingleLambdaTsk.this._taskInfo._beta), 0.5, 16, GLM.this._rowFilter, (CountedCompleter)new LineSearchIteration(this.getCompleter())).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                    return;
                }
                if (GLMSingleLambdaTsk.this._taskInfo._iter != 1 && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.gaussian) {
                    GLM.this.addScoringHistory(GLMSingleLambdaTsk.this._taskInfo._iter - 1, logl, objVal);
                }
                if (lastObjVal > objVal) {
                    GLMSingleLambdaTsk.this._taskInfo._beta = glmt._beta;
                    GLMSingleLambdaTsk.this._taskInfo._objVal = objVal;
                    GLMSingleLambdaTsk.this._taskInfo._ginfo = null;
                }
                double[] newBeta = MemoryManager.malloc8d((int)glmt._xy.length);
                double l2pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]);
                double l1pen = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0];
                double d = defaultRho = ((GLM)GLM.this)._bc._betaLB != null || ((GLM)GLM.this)._bc._betaUB != null ? GLMSingleLambdaTsk.this._taskInfo._lambdaMax * 0.01 : 0.0;
                if (l1pen > 0.0 || ((GLM)GLM.this)._bc._betaLB != null || ((GLM)GLM.this)._bc._betaUB != null || ((GLM)GLM.this)._bc._betaGiven != null) {
                    long tx = System.currentTimeMillis();
                    GramSolver gslvr = new GramSolver(glmt._gram, glmt._xy, GLMSingleLambdaTsk.this._activeData._intercept, l2pen, l1pen, ((GLM)GLM.this)._bc._betaGiven, ((GLM)GLM.this)._bc._rho, defaultRho, ((GLM)GLM.this)._bc._betaLB, ((GLM)GLM.this)._bc._betaUB);
                    long ty = System.currentTimeMillis();
                    new ADMM.L1Solver(1.0E-4, 1000).solve(gslvr, newBeta, l1pen, GLMSingleLambdaTsk.this._activeData._intercept, ((GLM)GLM.this)._bc._betaLB, ((GLM)GLM.this)._bc._betaUB);
                    GLMSingleLambdaTsk.this.LogInfo("ADMM done in " + (System.currentTimeMillis() - tx) + "ms, cholesky took " + (ty - tx) + "ms");
                } else {
                    glmt._gram.addDiag(l2pen);
                    new GramSolver(glmt._gram, glmt._xy, GLMSingleLambdaTsk.this._taskInfo._lambdaMax, ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon, ((GLMModel.GLMParameters)GLM.this._parms)._intercept).solve(newBeta);
                }
                GLMSingleLambdaTsk.this._taskInfo._worked += GLMSingleLambdaTsk.this._taskInfo._workPerIteration;
                GLM.this.update(GLMSingleLambdaTsk.this._taskInfo._workPerIteration, "lambdaId = " + GLM.this._lambdaId + ", iteration = " + GLMSingleLambdaTsk.this._taskInfo._iter + ", objective value = " + objVal);
                if (ArrayUtils.hasNaNsOrInfs((double[])newBeta)) {
                    throw new RuntimeException(GLMSingleLambdaTsk.this.LogInfo("got NaNs and/or Infs in beta"));
                }
                double bdiff = GLMSingleLambdaTsk.this.beta_diff(glmt._beta, newBeta);
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)GLM.this._parms)._link == GLMModel.GLMParameters.Link.identity || bdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon || GLMSingleLambdaTsk.this._taskInfo._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                    int diff = (int)Math.log10(bdiff);
                    int nzs = 0;
                    for (int i = 0; i < newBeta.length; ++i) {
                        if (newBeta[i] == 0.0) continue;
                        ++nzs;
                    }
                    GLMSingleLambdaTsk.this.LogInfo("converged (reached a fixed point with ~ 1e" + diff + " precision), got " + nzs + " nzs");
                    GLMSingleLambdaTsk.this._taskInfo._beta = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian ? newBeta : glmt._beta;
                    GLMSingleLambdaTsk.this.checkKKTsAndComplete();
                    return;
                }
                if (glmt._beta != null) {
                    GLMSingleLambdaTsk.this.setSubmodel(glmt._beta, glmt._val, null, (H2O.H2OCountedCompleter)this.getCompleter().getCompleter());
                }
                if (GLMSingleLambdaTsk.this._taskInfo._lineSearch) {
                    this.getCompleter().addToPendingCount(1);
                    GLMSingleLambdaTsk.this.LogInfo("invoking line search, objval = " + objVal + ", lastObjVal = " + lastObjVal);
                    new GLMTask.GLMLineSearchTask(GLMSingleLambdaTsk.this._activeData, (GLMModel.GLMParameters)GLM.this._parms, 1.0 / (double)GLMSingleLambdaTsk.this._taskInfo._nobs, glmt._beta, ArrayUtils.subtract((double[])newBeta, (double[])glmt._beta), 0.5, 16, GLM.this._rowFilter, (CountedCompleter)new H2O.H2OCallback<GLMTask.GLMLineSearchTask>((H2O.H2OCountedCompleter)this.getCompleter()){

                        public void callback(GLMTask.GLMLineSearchTask lst) {
                            double t = 1.0;
                            int i = 0;
                            while (i < lst._likelihoods.length) {
                                double[] beta = ArrayUtils.wadd((double[])((double[])lst._beta.clone()), (double[])lst._direction, (double)t);
                                double newObj = GLM.this.objVal(lst._likelihoods[i], beta, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], GLMSingleLambdaTsk.this._taskInfo._nobs, GLMSingleLambdaTsk.this._activeData._intercept);
                                if (GLMSingleLambdaTsk.this._taskInfo._objVal > newObj) {
                                    GLMSingleLambdaTsk.this.LogInfo("step = " + t + ",  objval = " + newObj);
                                    if (t == 1.0) {
                                        if (++GLMSingleLambdaTsk.this._taskInfo._lsCnt == 2) {
                                            GLMSingleLambdaTsk.this._taskInfo._lineSearch = false;
                                            GLMSingleLambdaTsk.this._taskInfo._lsCnt = 0;
                                        }
                                    } else {
                                        GLMSingleLambdaTsk.this._taskInfo._lsCnt = 0;
                                    }
                                    this.getCompleter().addToPendingCount(1);
                                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), (GLMModel.GLMParameters)GLM.this._parms, true, beta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu : 0.5, GLM.this._rowFilter, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true, true)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                                    return;
                                }
                                ++i;
                                t *= 0.5;
                            }
                            int nzs = 0;
                            for (int i2 = 0; i2 < glmt._beta.length; ++i2) {
                                if (glmt._beta[i2] == 0.0) continue;
                                ++nzs;
                            }
                            GLMSingleLambdaTsk.this.LogInfo("converged (no more progress), got " + nzs + " nzs");
                            GLMSingleLambdaTsk.this._taskInfo._beta = glmt._beta;
                            GLMSingleLambdaTsk.this.checkKKTsAndComplete();
                        }
                    }).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                } else {
                    boolean validate = GLMSingleLambdaTsk.this._taskInfo._iter % 5 == 0;
                    this.getCompleter().addToPendingCount(1);
                    new GLMTask.GLMIterationTask(GLM.this._key, GLMSingleLambdaTsk.this._activeData, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]), glmt._glm, validate, newBeta, ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? GLMSingleLambdaTsk.this._taskInfo._ymu : 0.5, GLM.this._rowFilter, (H2O.H2OCountedCompleter)new Iteration(this.getCompleter(), true)).asyncExec(GLMSingleLambdaTsk.this._activeData._adaptedFrame);
                }
            }
        }
    }

    public final class GLMDriver
    extends DTask<GLMDriver> {
        transient AtomicBoolean _gotException;

        public GLMDriver(H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._gotException = new AtomicBoolean();
        }

        private void doCleanup() {
            ((GLMModel.GLMParameters)GLM.this._parms).read_unlock_frames((Job)GLM.this);
            DKV.remove((Key)GLM.this._dinfo._key);
            if (GLM.this._rowFilter != null) {
                GLM.this._rowFilter.remove();
            }
            if (GLM.this._tInfos != null && GLM.this._tInfos[0] != null) {
                if (((GLM)GLM.this)._tInfos[0]._wVec != null) {
                    ((GLM)GLM.this)._tInfos[0]._wVec.remove();
                }
                if (((GLM)GLM.this)._tInfos[0]._zVec != null) {
                    ((GLM)GLM.this)._tInfos[0]._zVec.remove();
                }
                if (((GLM)GLM.this)._tInfos[0]._eVec != null) {
                    ((GLM)GLM.this)._tInfos[0]._eVec.remove();
                }
                if (((GLM)GLM.this)._tInfos[0]._iVec != null) {
                    ((GLM)GLM.this)._tInfos[0]._iVec.remove();
                }
            }
        }

        public void onCompletion(CountedCompleter cc) {
            int i;
            int n;
            this.getCompleter().addToPendingCount(1);
            GLMModel.ScoringHistory sch = new GLMModel.ScoringHistory();
            if (!GLM.this._scoring_iters.isEmpty()) {
                n = GLM.this._scoring_iters.size();
                sch._scoring_iters = new int[n];
                sch._scoring_times = new int[n];
                sch._objectives = new double[n];
                sch._likelihoods = new double[n];
                for (i = 0; i < n; ++i) {
                    sch._scoring_iters[i] = (Integer)GLM.this._scoring_iters.get(i);
                    sch._scoring_times[i] = (Integer)GLM.this._scoring_times.get(i);
                    sch._likelihoods[i] = (Double)GLM.this._likelihoods.get(i);
                    sch._objectives[i] = (Double)GLM.this._objectives.get(i);
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                n = GLM.this._lambda_iterations.size();
                sch._lambda_iters = new int[n];
                sch._lambda_times = new int[n];
                sch._scoring_lambda = new int[n];
                sch._explained_dev_train = new double[n];
                if (((GLMModel.GLMParameters)GLM.this._parms)._valid != null) {
                    sch._explained_dev_val = new double[n];
                }
                for (i = 0; i < n; ++i) {
                    sch._lambda_iters[i] = (Integer)GLM.this._lambda_iterations.get(i);
                    sch._lambda_times[i] = (Integer)GLM.this._lambda_times.get(i);
                    sch._scoring_lambda[i] = (Integer)GLM.this._lIds.get(i);
                    sch._explained_dev_train[i] = (Double)GLM.this._explainedDevTrain.get(i);
                    if (sch._explained_dev_val == null) continue;
                    sch._explained_dev_val[i] = (Double)GLM.this._explainedDevVal.get(i);
                }
            }
            H2O.submitTask((H2O.H2OCountedCompleter)new GLMModel.FinalizeAndUnlockTsk((H2O.H2OCountedCompleter)new H2O.H2OCallback((H2O.H2OCountedCompleter)this.getCompleter()){

                public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                    GLMDriver.this.doCleanup();
                    GLM.this.done();
                }

                public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
                    GLMDriver.this.doCleanup();
                    GLM.this.failed(ex);
                    new DTask.RemoveCall(null, GLM.this._dest).invokeTask();
                    return true;
                }
            }, GLM.this._dest, GLM.this._key, ((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLMModel.GLMParameters)GLM.this._parms)._valid, ((GLM)GLM.this)._tInfos[0]._iter, sch));
        }

        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
            if (!this._gotException.getAndSet(true)) {
                if (ex instanceof TooManyPredictorsException) {
                    this.tryComplete();
                    return false;
                }
                this.doCleanup();
                new DTask.RemoveCall(null, GLM.this._dest).invokeTask();
                GLM.this.failed(ex);
                return true;
            }
            return false;
        }

        protected void compute2() {
            GLM.this.init(true);
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GLM.this);
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds != 0) {
                throw H2O.unimpl();
            }
            new GLMSingleLambdaTsk((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this), GLM.this._tInfos[0]).fork();
        }

        private class LambdaSearchIteration
        extends H2O.H2OCallback {
            public LambdaSearchIteration(H2O.H2OCountedCompleter cmp) {
                super(cmp);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                assert (((GLM)GLM.this)._tInfos[0]._ginfo._gradient.length == GLM.this._dinfo.fullN() + 1);
                int workDiff = (GLM.this._lambdaId + 1) * ((GLM)GLM.this)._tInfos[0]._iterationsPerLambda * ((GLM)GLM.this)._tInfos[0]._workPerIteration - ((GLM)GLM.this)._tInfos[0]._worked;
                if (workDiff > 0) {
                    GLM.this.update(workDiff, "lambda = " + GLM.this._lambdaId + ", iteration = " + ((GLM)GLM.this)._tInfos[0]._iter);
                    ((GLM)GLM.this)._tInfos[0]._worked += workDiff;
                }
                int rank = 0;
                for (int i = 0; i < ((GLM)GLM.this)._tInfos[0]._beta.length - (GLM.this._dinfo._intercept ? 1 : 0); ++i) {
                    if (((GLM)GLM.this)._tInfos[0]._beta[i] == 0.0) continue;
                    ++rank;
                }
                Log.info((Object[])new Object[]{"Solution at lambda = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId] + " has " + rank + " nonzeros, gradient err = " + GLM.this._tInfos[0].gradientCheck(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0])});
                if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1) {
                    MRUtils.ParallelTasks t = (MRUtils.ParallelTasks)h2OCountedCompleter;
                    for (int i = 0; i < ((GLMSingleLambdaTsk[])t._tasks).length; ++i) {
                        ((GLM)GLM.this)._tInfos[i] = ((GLMSingleLambdaTsk[])t._tasks)[i]._taskInfo;
                    }
                }
                if (++GLM.this._lambdaId < ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length && ((GLM)GLM.this)._tInfos[0]._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                    this.getCompleter().addToPendingCount(1);
                    if (((GLMModel.GLMParameters)GLM.this._parms)._n_folds > 1) {
                        DTask[] tasks = new GLMSingleLambdaTsk[GLM.this._tInfos.length];
                        LambdaSearchIteration cmp = new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter());
                        cmp.addToPendingCount(tasks.length - 1);
                        for (int i = 0; i < tasks.length; ++i) {
                            tasks[i] = new GLMSingleLambdaTsk((H2O.H2OCountedCompleter)cmp, GLM.this._tInfos[i]);
                        }
                        new MRUtils.ParallelTasks((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter()), tasks).fork();
                    } else {
                        do {
                            double currentLambda = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId - 1];
                            double nextLambda = ((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId];
                            GLM.this._tInfos[0].adjustToNewLambda(currentLambda, nextLambda, ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0], GLM.this._dinfo._intercept);
                        } while (GLM.this._tInfos[0].gradientCheck(((GLMModel.GLMParameters)GLM.this._parms)._lambda[GLM.this._lambdaId], ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) < GLM_GRAD_EPS && ++GLM.this._lambdaId < ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length - 1);
                        Log.info((Object[])new Object[]{"GLM next lambdaId = " + GLM.this._lambdaId});
                        assert (((GLM)GLM.this)._tInfos[0]._ginfo._gradient.length == GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                        new GLMSingleLambdaTsk((H2O.H2OCountedCompleter)new LambdaSearchIteration((H2O.H2OCountedCompleter)this.getCompleter()), GLM.this._tInfos[0]).fork();
                    }
                }
            }
        }
    }

    public static final class GLMTaskInfo
    extends Iced {
        final int _foldId;
        final long _nobs;
        final double _ymu;
        final double _lambdaMax;
        double[] _beta;
        int[] _activeCols;
        GLMGradientInfo _ginfo;
        double _objVal;
        int _iter;
        int _workPerIteration;
        int _iterationsPerLambda;
        int _worked;
        final Key _dstKey;
        boolean _allIn;
        Vec _eVec;
        Vec _wVec;
        Vec _zVec;
        Vec _iVec;
        final int _fullN;
        public boolean _lineSearch;
        public int _lsCnt;

        public GLMTaskInfo(Key dstKey, int foldId, long nobs, double ymu, double lmax, double[] beta, int fullN, GLMGradientInfo ginfo, double objVal) {
            this._dstKey = dstKey;
            this._foldId = foldId;
            this._nobs = nobs;
            this._ymu = ymu;
            this._lambdaMax = lmax;
            this._beta = beta;
            this._ginfo = ginfo;
            this._objVal = objVal;
            this._fullN = fullN;
        }

        public double gradientCheck(double lambda, double alpha) {
            double[] beta = GLM.expandVec(this._beta, this._activeCols, this._fullN);
            double[] subgrad = (double[])this._ginfo._gradient.clone();
            double err = 0.0;
            ADMM.subgrad(alpha * lambda, beta, subgrad);
            for (double d : subgrad) {
                if (err < -d) {
                    err = -d;
                    continue;
                }
                if (!(err < d)) continue;
                err = d;
            }
            Log.info((Object[])new Object[]{"gerr at lambda = " + lambda + " = " + err});
            return err;
        }

        public void adjustToNewLambda(double currentLambda, double newLambda, double alpha, boolean intercept) {
            assert (newLambda < currentLambda) : "newLambda = " + newLambda + ", last lambda = " + currentLambda;
            double ldiff = newLambda - currentLambda;
            double l2pen = 0.5 * (1.0 - alpha) * ArrayUtils.l2norm2((double[])this._beta, (boolean)intercept);
            double l1pen = alpha * ArrayUtils.l1norm((double[])this._beta, (boolean)intercept);
            for (int i = 0; i < this._ginfo._gradient.length - (intercept ? 1 : 0); ++i) {
                int n = i;
                this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * (1.0 - alpha) * this._beta[i];
            }
            this._ginfo = new GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal + ldiff * l2pen, this._ginfo._gradient);
            this._objVal += ldiff * (l1pen + l2pen);
        }
    }

    public static class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint setLowerBounds(double[] lb) {
            this._betaLB = lb;
            return this;
        }

        public BetaConstraint setUpperBounds(double[] ub) {
            this._betaUB = ub;
            return this;
        }

        public BetaConstraint setBetaStart(double[] bs) {
            this._betaStart = bs;
            return this;
        }

        public BetaConstraint setProximalPenalty(double[] bGiven, double[] rho) {
            this._betaGiven = bGiven;
            this._rho = rho;
            return this;
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint((double[][])ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }
    }

    private class InitTsk
    extends H2O.H2OCountedCompleter {
        final int _foldId;
        final boolean _intercept;
        GLMTask.YMUTask _ymut;
        GLMTask.GLMGradientTask _gtNull;
        GLMTask.GLMGradientTask _gtBetaStart;

        public InitTsk(int foldId, boolean intercept, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._foldId = foldId;
            this._intercept = intercept;
        }

        protected void compute2() {
            new GLMTask.YMUTask(GLM.this._dinfo, GLM.this._dinfo._adaptedFrame.anyVec().makeZero(), (H2O.H2OCountedCompleter)new H2O.H2OCallback<GLMTask.YMUTask>((H2O.H2OCountedCompleter)this){

                public void callback(GLMTask.YMUTask ymut) {
                    double ymu;
                    GLM.this._rowFilter = ymut._fVec;
                    InitTsk.this._ymut = ymut;
                    double d = ymu = ((GLMModel.GLMParameters)GLM.this._parms)._intercept ? InitTsk.this._ymut._ymu : 0.0;
                    if (ymut._nobs > 0L) {
                        InitTsk.this.addToPendingCount(1);
                        double[] beta = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                        if (InitTsk.this._intercept) {
                            beta[beta.length - 1] = ((GLMModel.GLMParameters)GLM.this._parms).link(ymut._ymu);
                        }
                        if (((GLM)GLM.this)._bc._betaStart == null) {
                            GLM.this._bc.setBetaStart(beta);
                        }
                        InitTsk.this._gtNull = (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, 0.0, beta, 1.0 / (double)ymut._nobs, GLM.this._rowFilter, InitTsk.this).setValidate(ymu, true).asyncExec(GLM.this._dinfo._adaptedFrame);
                        if (beta != ((GLM)GLM.this)._bc._betaStart) {
                            InitTsk.this.addToPendingCount(1);
                            InitTsk.this._gtBetaStart = (GLMTask.GLMGradientTask)new GLMTask.GLMGradientTask(GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, 0.0, ((GLM)GLM.this)._bc._betaStart, 1.0 / (double)ymut._nobs, GLM.this._rowFilter, InitTsk.this).setValidate(ymu, true).asyncExec(GLM.this._dinfo._adaptedFrame);
                        }
                    }
                }
            }).asyncExec(GLM.this._dinfo._adaptedFrame);
        }
    }

    static class TooManyPredictorsException
    extends RuntimeException {
        TooManyPredictorsException() {
        }
    }
}

