/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelMetrics;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.glm.GLM;
import hex.glm.GLMValidation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import water.DKV;
import water.DTask;
import water.H2O;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.RPC;
import water.TAtomic;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.MathUtils;
import water.util.SB;
import water.util.TwoDimTable;

public class GLMModel
extends SupervisedModel<GLMModel, GLMParameters, GLMOutput> {
    final DataInfo _dinfo;
    public final double _lambda_max;
    public final double _ymu;
    public final double _ySigma;
    public final long _nobs;
    long _run_time;

    public GLMModel(Key selfKey, GLMParameters parms, GLMOutput output, DataInfo dinfo, double ymu, double ySigma, double lambda_max, long nobs) {
        super(selfKey, (SupervisedModel.SupervisedParameters)parms, (SupervisedModel.SupervisedOutput)output);
        this._ymu = ymu;
        this._ySigma = ySigma;
        this._lambda_max = lambda_max;
        this._nobs = nobs;
        this._dinfo = dinfo;
    }

    public DataInfo dinfo() {
        return this._dinfo;
    }

    private int rank(double[] ds) {
        int res = 0;
        for (double d : ds) {
            if (d == 0.0) continue;
            ++res;
        }
        return res;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new GLMValidation(domain, this._ymu, (GLMParameters)this._parms, this.rank(this.beta()), ((GLMOutput)this._output)._threshold);
    }

    public double[] beta() {
        return ((GLMOutput)this._output)._global_beta;
    }

    public String[] names() {
        return ((GLMOutput)this._output)._names;
    }

    public GLMValidation validation() {
        return ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._best_lambda_idx].trainVal;
    }

    public double[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
        double mu;
        int i;
        double eta = 0.0;
        double[] b = this.beta();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                if (chks[i].atd(row_in_chunk) == 0.0) continue;
                eta += b[this._dinfo._catOffsets[i] + (int)chks[i].atd(row_in_chunk) - 1];
            }
        } else {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                eta += b[this._dinfo._catOffsets[i] + (int)chks[i].atd(row_in_chunk)];
            }
        }
        int noff = this._dinfo.numStart() - this._dinfo._cats;
        for (int i2 = this._dinfo._cats; i2 < b.length - 1 - noff; ++i2) {
            eta += b[noff + i2] * chks[i2].atd(row_in_chunk);
        }
        preds[0] = mu = ((GLMParameters)this._parms).linkInv(eta += b[b.length - 1]);
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Double.NaN;
                preds[1] = Double.NaN;
                preds[2] = Double.NaN;
            } else {
                preds[0] = mu >= ((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            }
        }
        return preds;
    }

    public static void setSubmodel(H2O.H2OCountedCompleter cmp, Key modelKey, final double lambda, double[] beta, double[] norm_beta, int iteration, long runtime, boolean sparseCoef, GLMValidation trainVal, GLMValidation holdOutval, Frame tFrame, Frame vFrame) {
        final Submodel sm = new Submodel(lambda, beta, norm_beta, runtime, iteration, sparseCoef);
        sm.trainVal = trainVal;
        sm.holdOutVal = holdOutval;
        if (cmp != null) {
            cmp.addToPendingCount(1);
        }
        RPC f = new TAtomic<GLMModel>(cmp){

            public GLMModel atomic(GLMModel old) {
                if (old == null) {
                    return old;
                }
                if (((GLMOutput)old._output)._submodels == null) {
                    old._output = (GLMOutput)((GLMOutput)old._output).clone();
                    ((GLMOutput)old._output)._submodels = new Submodel[]{sm};
                } else {
                    int id = ((GLMOutput)old._output).submodelIdForLambda(lambda);
                    if (id < 0) {
                        id = -id - 1;
                        Submodel[] sms = Arrays.copyOf(((GLMOutput)old._output)._submodels, ((GLMOutput)old._output)._submodels.length + 1);
                        for (int i = sms.length - 1; i > id; --i) {
                            sms[i] = sms[i - 1];
                        }
                        sms[id] = sm;
                        old._output = (GLMOutput)((GLMOutput)old._output).clone();
                        ((GLMOutput)old._output)._submodels = sms;
                    } else if (((GLMOutput)old._output)._submodels[id].iteration <= sm.iteration) {
                        ((GLMOutput)old._output)._submodels[id] = sm;
                    }
                }
                old._run_time = Math.max(old._run_time, sm.run_time);
                return old;
            }
        }.fork(modelKey);
        if (cmp == null && f != null) {
            try {
                f.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int rank(double lambda) {
        return -1;
    }

    public static void setXvalidation(H2O.H2OCountedCompleter cmp, Key modelKey, double lambda, GLMValidation val) {
        throw H2O.unimpl();
    }

    public HashMap<String, Double> coefficients() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficient_names[i], b[i]);
            }
        }
        return res;
    }

    protected double[] score0(double[] data, double[] preds) {
        double mu;
        int i;
        double eta = 0.0;
        double[] b = this.beta();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                if (data[i] == 0.0) continue;
                eta += b[this._dinfo._catOffsets[i] + (int)(data[i] - 1.0)];
            }
        } else {
            for (i = 0; i < this._dinfo._catOffsets.length - 1; ++i) {
                eta += b[this._dinfo._catOffsets[i] + (int)data[i]];
            }
        }
        int noff = this._dinfo.numStart() - this._dinfo._cats;
        for (int i2 = this._dinfo._cats; i2 < data.length; ++i2) {
            eta += b[noff + i2] * data[i2];
        }
        preds[0] = mu = ((GLMParameters)this._parms).linkInv(eta += b[b.length - 1]);
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Double.NaN;
                preds[1] = Double.NaN;
                preds[2] = Double.NaN;
            } else {
                preds[0] = mu >= ((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            }
        }
        return preds;
    }

    protected void toJavaPredictBody(SB body, SB classCtx, SB file) {
        int nclass = ((GLMOutput)this._output).nclasses();
        String mname = JCodeGen.toJavaId((String)this._key.toString());
        JCodeGen.toStaticVar((SB)classCtx, (String)"BETA", (double[])this.beta(), (String)"The Coefficients");
        JCodeGen.toStaticVar((SB)classCtx, (String)"CATOFFS", (int[])this._dinfo._catOffsets, (String)"Categorical Offsets");
        body.ip("double eta = 0.0;").nl();
        body.ip("final double [] b = BETA;").nl();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0)").nl();
            body.ip("  eta += b[CATOFFS[i] + (int)(data[i]-1)];").nl();
        } else {
            body.ip("for(int i = 0; i < CATOFFS.length-1; ++i)").nl();
            body.ip("  eta += b[CATOFFS[i] + (int)(data[i])];").nl();
        }
        int noff = this._dinfo.numStart() - this._dinfo._cats;
        body.ip("for(int i = ").p(this._dinfo._cats).p("; i < data.length; ++i)").nl();
        body.ip("  eta += b[").p(noff).p("+i]*data[i];").nl();
        body.ip("eta += b[b.length-1]; // reduce intercept").nl();
        body.ip("double mu = hex.genmodel.GenModel.GLM_").p(((GLMParameters)this._parms)._link.toString()).p("Inv(eta");
        body.p(");").nl();
        body.ip("preds[0] = mu;").nl();
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            body.ip("preds[0] = mu > ").p(((GLMOutput)this._output)._threshold).p(" ? 1 : 0);").nl();
            body.ip("preds[1] = 1.0 - mu; // class 0").nl();
            body.ip("preds[2] =       mu; // class 1").nl();
        }
    }

    protected SB toJavaInit(SB sb, SB fileContext) {
        sb.nl();
        sb.ip("public boolean isSupervised() { return true; }").nl();
        sb.ip("public int nfeatures() { return " + ((GLMOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((GLMOutput)this._output).nclasses() + "; }").nl();
        sb.ip("public ModelCategory getModelCategory() { return ModelCategory." + ((GLMOutput)this._output).getModelCategory() + "; }").nl();
        return sb;
    }

    static class FinalizeAndUnlockTsk
    extends DTask.DKeyTask<FinalizeAndUnlockTsk, GLMModel> {
        final Key _jobKey;
        final Key _validFrame;
        final Key _trainFrame;
        ScoringHistory _scoring_history;
        final int _iter;

        public FinalizeAndUnlockTsk(H2O.H2OCountedCompleter cmp, Key modelKey, Key jobKey, Key trainFrame, Key validFrame, int iter, ScoringHistory scoring_history) {
            super(cmp, modelKey);
            this._jobKey = jobKey;
            this._validFrame = validFrame;
            this._trainFrame = trainFrame;
            this._scoring_history = scoring_history;
            this._iter = iter;
        }

        protected void map(GLMModel glmModel) {
            Frame tFrame = (Frame)DKV.getGet((Key)this._trainFrame);
            Frame vFrame = this._validFrame != null ? (Frame)DKV.get((Key)this._validFrame).get() : null;
            ((GLMOutput)glmModel._output).pickBestModel(((GLMParameters)glmModel._parms)._family == GLMParameters.Family.binomial, glmModel, tFrame, vFrame);
            String[] names = new String[]{"Family", "Link", "Regularization", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
            String[] types = new String[]{"string", "string", "string", "int", "int", "int", "string"};
            String[] formats = new String[]{"%s", "%s", "%s", "%d", "%d", "%d", "%s"};
            if (((GLMParameters)glmModel._parms)._lambda_search) {
                names = new String[]{"Family", "Link", "Regularization", "Lambda Search", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
                types = new String[]{"string", "string", "string", "string", "int", "int", "int", "string"};
                formats = new String[]{"%s", "%s", "%s", "%s", "%d", "%d", "%d", "%s"};
            }
            ((GLMOutput)glmModel._output)._model_summary = new TwoDimTable("GLM Model", "summary", new String[]{""}, names, types, formats, "");
            ((GLMOutput)glmModel._output)._model_summary.set(0, 0, (Object)((GLMParameters)glmModel._parms)._family.toString());
            ((GLMOutput)glmModel._output)._model_summary.set(0, 1, (Object)((GLMParameters)glmModel._parms)._link.toString());
            String regularization = "None";
            if (((GLMParameters)glmModel._parms)._lambda != null && (((GLMParameters)glmModel._parms)._lambda.length != 1 || ((GLMParameters)glmModel._parms)._lambda[0] != 0.0)) {
                regularization = ((GLMParameters)glmModel._parms)._alpha[0] == 0.0 ? "Ridge ( lambda = " : (((GLMParameters)glmModel._parms)._alpha[0] == 1.0 ? "Lasso (lambda = " : "Elastic Net (alpha = " + MathUtils.roundToNDigits((double)((GLMParameters)glmModel._parms)._alpha[0], (int)4) + ", lambda = ");
                regularization = regularization + MathUtils.roundToNDigits((double)((GLMParameters)glmModel._parms)._lambda[((GLMOutput)glmModel._output)._best_lambda_idx], (int)4) + " )";
            }
            ((GLMOutput)glmModel._output)._model_summary.set(0, 2, (Object)regularization);
            int lambdaSearch = 0;
            if (((GLMParameters)glmModel._parms)._lambda_search) {
                lambdaSearch = 1;
                ((GLMOutput)glmModel._output)._model_summary.set(0, 3, (Object)("nlambda = " + ((GLMParameters)glmModel._parms)._nlambdas + ", lambda_max = " + MathUtils.roundToNDigits((double)glmModel._lambda_max, (int)4) + ", best_lambda_id = " + ((GLMOutput)glmModel._output)._best_lambda_idx));
            }
            int intercept = ((GLMParameters)glmModel._parms)._intercept ? 1 : 0;
            ((GLMOutput)glmModel._output)._model_summary.set(0, 3 + lambdaSearch, (Object)Integer.toString(glmModel.beta().length - intercept));
            ((GLMOutput)glmModel._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)glmModel._output).rank() - intercept));
            ((GLMOutput)glmModel._output)._model_summary.set(0, 5 + lambdaSearch, (Object)this._iter);
            ((GLMOutput)glmModel._output)._model_summary.set(0, 6 + lambdaSearch, (Object)this._trainFrame.toString());
            if (this._scoring_history != null) {
                ((GLMOutput)glmModel._output)._scoring_history = this._scoring_history.to2dTable();
            }
            glmModel.update(this._jobKey);
            glmModel.unlock(this._jobKey);
        }
    }

    public static class ScoringHistory
    extends Iced {
        int[] _scoring_times;
        double[] _likelihoods;
        double[] _objectives;
        int[] _scoring_iters;
        int[] _scoring_lambda;
        int[] _lambda_times;
        int[] _lambda_iters;
        double[] _explained_dev_train;
        double[] _explained_dev_val;

        public TwoDimTable to2dTable() {
            String[] cnames = new String[]{"iteration", "time [ms]", " -log(l)", "objective"};
            String[] ctypes = new String[]{"int", "int", "double", "double"};
            String[] cformats = new String[]{"%d", "%d", "%.5f", "%.5f"};
            if (this._lambda_times != null) {
                cnames = ArrayUtils.append((String[])cnames, (String[])new String[]{"lambdaId", "time per lambda", " Explained Deviance (train)", "Explained Deviance (test)"});
                ctypes = ArrayUtils.append((String[])ctypes, (String[])new String[]{"int", "int", "double", "double"});
                cformats = ArrayUtils.append((String[])cformats, (String[])new String[]{"%d", "%d", "%.3f", "%.3f"});
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoring_iters.length], cnames, ctypes, cformats, "");
            int j = 0;
            for (int i = 0; i < this._scoring_iters.length; ++i) {
                res.set(i, 0, (Object)this._scoring_iters[i]);
                res.set(i, 1, (Object)this._scoring_times[i]);
                res.set(i, 2, (Object)this._likelihoods[i]);
                res.set(i, 3, (Object)this._objectives[i]);
                if (this._lambda_iters == null || this._scoring_iters[i] != this._lambda_iters[j]) continue;
                res.set(i, 4, (Object)this._scoring_lambda[j]);
                res.set(i, 5, (Object)this._lambda_times[j]);
                res.set(i, 6, (Object)this._explained_dev_train[j]);
                if (this._explained_dev_val != null && j < this._explained_dev_val.length) {
                    res.set(i, 7, (Object)this._explained_dev_val[j]);
                }
                ++j;
            }
            return res;
        }
    }

    public static class GLMOutput
    extends SupervisedModel.SupervisedOutput {
        Submodel[] _submodels;
        String[] _coefficient_names;
        int _best_lambda_idx;
        double _threshold;
        double[] _global_beta;
        public boolean _binomial;
        private static String[] binomialClassNames = new String[]{"0", "1"};

        public int rank() {
            return this._submodels[this._best_lambda_idx].rank;
        }

        public boolean isNormalized() {
            return this._submodels != null && this._submodels[this._best_lambda_idx].norm_beta != null;
        }

        public String[] coefficientNames() {
            return this._coefficient_names;
        }

        public GLMOutput(String[] column_names, String[][] domains, String[] coefficient_names, double[] coefficients, float threshold, boolean binomial) {
            this._names = column_names;
            this._domains = domains;
            this._global_beta = coefficients;
            this._coefficient_names = coefficient_names;
            this._submodels = new Submodel[]{new Submodel(-1.0, coefficients, null, -1L, -1, false)};
            this._threshold = threshold;
            this._binomial = binomial;
        }

        public GLMOutput() {
        }

        public GLMOutput(GLM glm) {
            super((SupervisedModelBuilder)glm);
            String[] cnames = glm._dinfo.coefNames();
            this._names = glm._dinfo._adaptedFrame.names();
            this._coefficient_names = Arrays.copyOf(cnames, cnames.length + 1);
            this._coefficient_names[this._coefficient_names.length - 1] = "Intercept";
            this._binomial = ((GLMParameters)glm._parms)._family == GLMParameters.Family.binomial;
        }

        public int nclasses() {
            return this._binomial ? 2 : 1;
        }

        public String[] classNames() {
            return this._binomial ? binomialClassNames : null;
        }

        public int submodelIdForLambda(double lambda) {
            if (lambda >= this._submodels[0].lambda_value) {
                return 0;
            }
            for (int i = this._submodels.length - 1; i >= 0; --i) {
                if (lambda == this._submodels[i].lambda_value || Math.abs(this._submodels[i].lambda_value - lambda) / lambda < 1.0E-5) {
                    return i;
                }
                if (!(this._submodels[i].lambda_value > lambda)) continue;
                return -i - 2;
            }
            return -1;
        }

        public Submodel submodelForLambda(double lambda) {
            return this._submodels[this.submodelIdForLambda(lambda)];
        }

        public int rank(double lambda) {
            Submodel sm = this.submodelForLambda(lambda);
            if (sm == null) {
                return 0;
            }
            return this.submodelForLambda((double)lambda).rank;
        }

        public void pickBestModel(boolean useAuc, GLMModel m, Frame tFrame, Frame vFrame) {
            int bestId = this._submodels.length - 1;
            if (this._submodels.length > 2) {
                boolean xval = false;
                boolean hval = false;
                GLMValidation bestVal = null;
                if (this._submodels[1].xVal != null) {
                    xval = true;
                    bestVal = this._submodels[1].xVal;
                } else if (this._submodels[1].holdOutVal != null) {
                    hval = true;
                    bestVal = this._submodels[1].holdOutVal;
                } else {
                    bestVal = this._submodels[0].trainVal;
                }
                for (int i = 1; i < this._submodels.length; ++i) {
                    Frame f;
                    GLMValidation val = xval ? this._submodels[i].xVal : (hval ? this._submodels[i].holdOutVal : this._submodels[i].trainVal);
                    Frame frame = f = hval ? vFrame : tFrame;
                    if (val == null || val == bestVal || !(useAuc && val.computeAUC((GLMModel)m.clone(), f) > bestVal.computeAUC(m, f)) && !(val.residual_deviance < bestVal.residual_deviance)) continue;
                    bestVal = val;
                    bestId = i;
                }
            }
            this._best_lambda_idx = bestId;
            this.setSubmodelIdx(this._best_lambda_idx, m, tFrame, vFrame);
        }

        public ModelMetrics setModelMetrics(ModelMetrics mm) {
            for (int i = 0; i < this._model_metrics.length; ++i) {
                if (!this._model_metrics[i].equals((Object)mm._key)) continue;
                this._model_metrics[i] = mm._key;
                return mm;
            }
            this._model_metrics = Arrays.copyOf(this._model_metrics, this._model_metrics.length + 1);
            this._model_metrics[this._model_metrics.length - 1] = mm._key;
            return mm;
        }

        public void setSubmodelIdx(int l, GLMModel m, Frame tFrame, Frame vFrame) {
            this._best_lambda_idx = l;
            if (this._submodels[l].trainVal != null && tFrame != null) {
                this._training_metrics = this._submodels[l].trainVal.makeModelMetrics((Model)m, tFrame, tFrame.vec(((GLMOutput)m._output).responseName()).sigma());
            }
            if (this._submodels[l].holdOutVal != null && vFrame != null) {
                this._threshold = this._submodels[l].trainVal.bestThreshold();
                this._validation_metrics = this._submodels[l].holdOutVal.makeModelMetrics((Model)m, vFrame, vFrame.vec(((GLMOutput)m._output).responseName()).sigma());
            }
            if (this._global_beta == null) {
                this._global_beta = MemoryManager.malloc8d((int)this._coefficient_names.length);
            } else {
                Arrays.fill(this._global_beta, 0.0);
            }
            int j = 0;
            for (int i : this._submodels[l].idxs) {
                this._global_beta[i] = this._submodels[l].beta[j++];
            }
        }

        public double[] beta() {
            return this._global_beta;
        }

        public Submodel bestSubmodel() {
            return this._submodels[this._best_lambda_idx];
        }
    }

    public static class Submodel
    extends Iced {
        final double lambda_value;
        final int iteration;
        final long run_time;
        GLMValidation trainVal;
        GLMValidation holdOutVal;
        GLMValidation xVal;
        final int rank;
        public final int[] idxs;
        final boolean sparseCoef;
        public double[] beta;
        public double[] norm_beta;

        public Submodel(double lambda, double[] beta, double[] norm_beta, long run_time, int iteration, boolean sparseCoef) {
            this.lambda_value = lambda;
            this.run_time = run_time;
            this.iteration = iteration;
            int r = 0;
            if (beta != null) {
                double[] b = norm_beta != null ? norm_beta : beta;
                for (double d : beta) {
                    if (d == 0.0) continue;
                    ++r;
                }
                this.idxs = MemoryManager.malloc4((int)(sparseCoef ? r : beta.length));
                int j = 0;
                for (int i = 0; i < beta.length; ++i) {
                    if (sparseCoef && beta[i] == 0.0) continue;
                    this.idxs[j++] = i;
                }
                j = 0;
                this.beta = MemoryManager.malloc8d((int)this.idxs.length);
                for (int i : this.idxs) {
                    this.beta[j++] = beta[i];
                }
                if (norm_beta != null) {
                    j = 0;
                    this.norm_beta = MemoryManager.malloc8d((int)this.idxs.length);
                    for (int i : this.idxs) {
                        this.norm_beta[j++] = norm_beta[i];
                    }
                }
            } else {
                this.idxs = null;
            }
            this.rank = r;
            this.sparseCoef = sparseCoef;
        }
    }

    public static class GLM_LBFGS_Parameters
    extends GLMParameters {
    }

    public static class GLMParameters
    extends SupervisedModel.SupervisedParameters {
        public boolean _standardize = true;
        public Family _family;
        public Link _link = Link.family_default;
        public Solver _solver = Solver.IRLSM;
        public final double _tweedie_variance_power;
        public final double _tweedie_link_power;
        public double[] _alpha = null;
        public double[] _lambda = null;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public int _nlambdas = -1;
        public double _lambda_min_ratio = -1.0;
        public boolean _use_all_factor_levels = false;
        public double _beta_epsilon = 1.0E-4;
        public int _max_iterations = -1;
        public int _n_folds;
        boolean _intercept = true;
        public Key<Frame> _beta_constraints = null;
        public int _max_active_predictors = -1;

        public void validate(GLM glm) {
            Vec response;
            Frame frame;
            if (this._n_folds < 0) {
                glm.error("n_folds", "must be >= 0");
            }
            if (this._n_folds == 1) {
                this._n_folds = 0;
            }
            if (this._lambda_search && this._nlambdas == -1) {
                this._nlambdas = 100;
            }
            if (this._beta_constraints != null) {
                Vec v;
                Frame f = (Frame)this._beta_constraints.get();
                if (f == null) {
                    glm.error("beta_constraints", "Missing frame for beta constraints");
                }
                if ((v = f.vec("names")) == null) {
                    glm.error("beta_constraints", "Beta constraints parameter must have names column with valid coefficient names");
                }
                if ((v = f.vec("upper_bounds")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "upper_bounds must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("lower_bounds");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "lower_bounds must be numeric if present");
                }
                if ((v = f.vec("beta_given")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_given must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("beta_start");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_start must be numeric if present");
                }
            }
            if (this._family == Family.binomial && (frame = (Frame)DKV.getGet((Key)this._train)) != null && (response = frame.vec(this._response_column)) != null && (response.min() != 0.0 || response.max() != 1.0)) {
                glm.error("_response_column", "Illegal response for family binomial, must be binary, got min = " + response.min() + ", max = " + response.max() + ")");
            }
            if (!this._lambda_search) {
                glm.hide("_lambda_min_ratio", "only applies if lambda search is on.");
                glm.hide("_nlambdas", "only applies if lambda search is on.");
            }
            if (this._link != Link.family_default) {
                switch (this._family) {
                    case gaussian: {
                        if (this._link == Link.identity || this._link == Link.log || this._link == Link.inverse) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only identity, log and inverse links are allowed for family=gaussian.");
                    }
                    case binomial: {
                        if (this._link == Link.logit || this._link == Link.log) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only logit and log links are allowed for family=binomial. Got " + (Object)((Object)this._link));
                    }
                    case poisson: {
                        if (this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only log and identity links are allowed for family=poisson.");
                    }
                    case gamma: {
                        if (this._link == Link.inverse || this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only inverse, log and identity links are allowed for family=gamma.");
                    }
                    default: {
                        H2O.fail();
                    }
                }
            }
        }

        public GLMParameters() {
            this(Family.gaussian, Link.family_default);
            assert (this._link == Link.family_default);
        }

        public GLMParameters(Family f) {
            this(f, f.defaultLink);
        }

        public GLMParameters(Family f, Link l) {
            this(f, l, null, null);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha) {
            this._family = f;
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_link_power = Double.NaN;
            this._tweedie_variance_power = Double.NaN;
            this._link = l;
        }

        public GLMParameters(Family f, double[] lambda, double[] alpha, double twVar, double twLnk) {
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_variance_power = twVar;
            this._tweedie_link_power = twLnk;
            this._family = f;
            this._link = f.defaultLink;
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case binomial: {
                    return mu * (1.0 - mu);
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this));
        }

        public final boolean canonical() {
            switch (this._family) {
                case gaussian: {
                    return this._link == Link.identity;
                }
                case binomial: {
                    return this._link == Link.logit;
                }
                case poisson: {
                    return this._link == Link.log;
                }
                case gamma: {
                    return this._link == Link.inverse;
                }
            }
            throw H2O.unimpl();
        }

        public final double deviance(double yr, double ym) {
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case binomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0 - yr, 1.0 - ym));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case binomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0f - yr, 1.0f - ym));
                }
                case poisson: {
                    if (yr == 0.0f) {
                        return 2.0f * ym;
                    }
                    return 2.0 * ((double)yr * Math.log(yr / ym) - (double)(yr - ym));
                }
                case gamma: {
                    if (yr == 0.0f) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (double)((yr - ym) / ym));
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double likelihood(double yr, double eta, double ym) {
            switch (this._family) {
                case gaussian: {
                    return 0.5 * (yr - ym) * (yr - ym);
                }
                case binomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    return 0.5 * this.deviance(yr, ym);
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double link(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    assert (0.0 <= x && x <= 1.0) : "x out of bounds, expected <0,1> range, got " + x;
                    return Math.log(x / (1.0 - x));
                }
                case log: {
                    return Math.log(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
            }
            throw new RuntimeException("unknown link function " + (Object)((Object)this));
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInvDeriv(double x) {
            switch (this._link) {
                case identity: {
                    return 1.0;
                }
                case logit: {
                    double g = Math.exp(-x);
                    double gg = (g + 1.0) * (g + 1.0);
                    return g / gg;
                }
                case log: {
                    return Math.max(Math.exp(x), Double.MIN_NORMAL);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return -1.0 / (xx * xx);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        static final double y_log_y(double y, double mu) {
            if (y == 0.0) {
                return 0.0;
            }
            if (mu < Double.MIN_NORMAL) {
                mu = Double.MIN_NORMAL;
            }
            return y * Math.log(y / mu);
        }

        public static enum Solver {
            AUTO,
            IRLSM,
            L_BFGS,
            COORDINATE_DESCENT;

        }

        public static enum Link {
            family_default,
            identity,
            logit,
            log,
            inverse;

        }

        public static enum Family {
            gaussian(Link.identity),
            binomial(Link.logit),
            poisson(Link.log),
            gamma(Link.inverse);

            public final Link defaultLink;

            private Family(Link link) {
                this.defaultLink = link;
            }
        }
    }

    public static class GetScoringModelTask
    extends DTask.DKeyTask<GetScoringModelTask, GLMModel> {
        final double _lambda;
        public GLMModel _res;

        public GetScoringModelTask(H2O.H2OCountedCompleter cmp, Key modelKey, double lambda) {
            super(cmp, modelKey);
            this._lambda = lambda;
        }

        public void map(GLMModel m) {
            Submodel sm;
            this._res = (GLMModel)m.clone();
            this._res._output = (GLMOutput)((GLMOutput)this._res._output).clone();
            Submodel submodel = sm = Double.isNaN(this._lambda) ? ((GLMOutput)this._res._output)._submodels[((GLMOutput)this._res._output)._best_lambda_idx] : ((GLMOutput)this._res._output).submodelForLambda(this._lambda);
            assert (sm != null) : "GLM[" + m._key + "]: missing submodel for lambda " + this._lambda;
            sm = (Submodel)sm.clone();
            ((GLMOutput)this._res._output)._submodels = new Submodel[]{sm};
            ((GLMOutput)this._res._output).setSubmodelIdx(0, this._res, null, null);
        }
    }
}

