/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.AUC2;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.glm.GLMModel;
import water.DKV;
import water.Iced;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GLMValidation
extends ModelMetricsBinomial.MetricBuilderBinomial<GLMValidation> {
    final double[] _ymu;
    double residual_deviance;
    double null_deviance;
    long nobs;
    double aic;
    private double _aic2;
    final GLMModel.GLMParameters _glm;
    private final int _rank;
    final double _threshold;
    AUC2 _auc2;
    ModelMetrics.MetricBuilder _metricBuilder;
    boolean _intercept = true;
    transient double[] _ds = new double[3];
    transient float[] _yact = new float[1];
    private transient ModelMetrics _metrics;

    public GLMValidation(String[] domain, double ymu, GLMModel.GLMParameters glm, int rank, double threshold) {
        super(domain);
        this._rank = rank;
        this._ymu = new double[]{ymu};
        this._glm = glm;
        this._threshold = threshold;
        this._metricBuilder = this._glm._family == GLMModel.GLMParameters.Family.binomial ? new ModelMetricsBinomial.MetricBuilderBinomial(domain) : new ModelMetricsRegression.MetricBuilderRegression();
    }

    public double explainedDev() {
        return 1.0 - this.residualDeviance() / this.nullDeviance();
    }

    public double[] perRow(double[] ds, float[] yact, Model m) {
        this._metricBuilder.perRow(ds, yact, m);
        if (!ArrayUtils.hasNaNsOrInfs((double[])ds)) {
            if (this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                this.add2(yact[0], ds[2]);
            } else {
                this.add2(yact[0], ds[0]);
            }
        }
        return ds;
    }

    public void add(double yreal, double ymodel) {
        this._yact[0] = (float)yreal;
        if (this._glm._family == GLMModel.GLMParameters.Family.binomial) {
            this._ds[0] = ymodel > this._threshold ? 1.0 : 0.0;
            this._ds[1] = 1.0 - ymodel;
            this._ds[2] = ymodel;
        } else {
            this._ds[0] = ymodel;
        }
        this._metricBuilder.perRow(this._ds, this._yact, null);
        this.add2(yreal, ymodel);
    }

    private void add2(double yreal, double ymodel) {
        this.null_deviance += this._glm.deviance(yreal, this._ymu[0]);
        this.residual_deviance += this._glm.deviance(yreal, ymodel);
        ++this.nobs;
        if (this._glm._family == GLMModel.GLMParameters.Family.poisson) {
            long y = Math.round(yreal);
            double logfactorial = 0.0;
            for (long i = 2L; i <= y; ++i) {
                logfactorial += Math.log(i);
            }
            this._aic2 += yreal * Math.log(ymodel) - logfactorial - ymodel;
        }
    }

    public void reduce(GLMValidation v) {
        this._metricBuilder.reduce(v._metricBuilder);
        this.residual_deviance += v.residual_deviance;
        this.null_deviance += v.null_deviance;
        this.nobs += v.nobs;
        this._aic2 += v._aic2;
    }

    public final double nullDeviance() {
        return this.null_deviance;
    }

    public final double residualDeviance() {
        return this.residual_deviance;
    }

    public final long nullDOF() {
        return this.nobs - (long)(this._intercept ? 1 : 0);
    }

    public final long resDOF() {
        return this.nobs - (long)this._rank;
    }

    protected double computeAUC(GLMModel m, Frame f) {
        if (this._glm._family != GLMModel.GLMParameters.Family.binomial) {
            throw new IllegalArgumentException("AUC only defined for family == 'binomial', got '" + (Object)((Object)this._glm._family) + "'");
        }
        ModelMetricsBinomial metrics = (ModelMetricsBinomial)this.makeModelMetrics((Model)m.clone(), f, Double.NaN);
        return metrics.auc()._auc;
    }

    public double bestThreshold() {
        return this._auc2 == null ? Double.NaN : this._auc2.defaultThreshold();
    }

    protected void computeAIC() {
        this.aic = 0.0;
        switch (this._glm._family) {
            case gaussian: {
                this.aic = (double)this.nobs * (Math.log(this.residual_deviance / (double)this.nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: {
                this.aic = this.residual_deviance;
                break;
            }
            case poisson: {
                this.aic = -2.0 * this._aic2;
                break;
            }
            case gamma: {
                this.aic = Double.NaN;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._glm._family);
                break;
            }
        }
        this.aic += (double)(2 * this._rank);
    }

    public String toString() {
        return "null_dev = " + this.null_deviance + ", res_dev = " + this.residual_deviance + (this._metrics != null ? ", metrics = " + this._metrics : "");
    }

    public ModelMetrics makeModelMetrics(Model m, Frame f, double sigma) {
        ModelMetrics metrics;
        GLMModel gm = (GLMModel)m;
        this.computeAIC();
        ModelMetrics modelMetrics = metrics = this._metrics == null ? this._metricBuilder.makeModelMetrics(m, f, sigma) : this._metrics;
        if (this._glm._family == GLMModel.GLMParameters.Family.binomial) {
            ModelMetricsBinomial metricsBinommial = (ModelMetricsBinomial)metrics;
            metrics = new ModelMetricsBinomialGLM(m, f, metrics._MSE, this._domain, metricsBinommial._sigma, metricsBinommial._auc, metricsBinommial._logloss, this.residualDeviance(), this.nullDeviance(), this.aic, this.nullDOF(), this.resDOF());
        } else {
            ModelMetricsRegression metricsRegression = (ModelMetricsRegression)metrics;
            metrics = new ModelMetricsRegressionGLM(m, f, metricsRegression._MSE, metricsRegression._sigma, this.residualDeviance(), this.nullDeviance(), this.aic, this.nullDOF(), this.resDOF());
        }
        DKV.put((Key)metrics._key, (Iced)metrics);
        return ((GLMModel.GLMOutput)gm._output).addModelMetrics(metrics);
    }
}

