/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.Grid;
import hex.Model;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;

public class KMeansGrid
extends Grid<KMeansGrid> {
    public static final String MODEL_NAME = "KMeans";
    private static final String[] HYPER_NAMES = new String[]{"_k", "_standardize", "_init", "_seed"};
    private static final double[] HYPER_DEFAULTS = new double[]{0.0, 1.0, KMeans.Initialization.PlusPlus.ordinal(), 1.23456789E8};

    protected String modelName() {
        return MODEL_NAME;
    }

    protected String[] hyperNames() {
        return HYPER_NAMES;
    }

    protected double[] hyperDefaults() {
        return HYPER_DEFAULTS;
    }

    protected double suggestedNextHyperValue(int h, Model m, double[] hyperLimits) {
        throw H2O.unimpl();
    }

    protected KMeans getBuilder(double[] hypers) {
        KMeansModel.KMeansParameters parms = new KMeansModel.KMeansParameters();
        parms._train = this._fr._key;
        parms._k = (int)hypers[0];
        parms._standardize = hypers[1] != 0.0;
        parms._init = KMeans.Initialization.values()[(int)hypers[2]];
        parms._seed = (long)hypers[3];
        return new KMeans(parms);
    }

    public double[] getHypers(Model.Parameters parms) {
        double[] ds = new double[HYPER_NAMES.length];
        KMeansModel.KMeansParameters kp = (KMeansModel.KMeansParameters)parms;
        ds[0] = kp._k;
        ds[1] = kp._standardize ? 1.0 : 0.0;
        ds[2] = kp._init.ordinal();
        ds[3] = kp._seed;
        return ds;
    }

    private KMeansGrid(Key key, Frame fr) {
        super(key, fr);
    }

    public static KMeansGrid get(Frame fr) {
        Key k = Grid.keyName((String)MODEL_NAME, (Frame)fr);
        KMeansGrid kmg = (KMeansGrid)DKV.getGet((Key)k);
        if (kmg != null) {
            return kmg;
        }
        kmg = new KMeansGrid(k, fr);
        DKV.put((Keyed)kmg);
        return kmg;
    }

    protected long checksum_impl() {
        throw H2O.unimpl();
    }
}

