/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.ClusteringModel;
import hex.ClusteringModelBuilder;
import hex.ModelMetrics;
import hex.ModelMetricsClustering;
import hex.genmodel.GenModel;
import hex.kmeans.KMeans;
import water.Key;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.SB;

public class KMeansModel
extends ClusteringModel<KMeansModel, KMeansParameters, KMeansOutput> {
    public KMeansModel(Key selfKey, KMeansParameters parms, KMeansOutput output) {
        super(selfKey, (ClusteringModel.ClusteringParameters)parms, (ClusteringModel.ClusteringOutput)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        assert (domain == null);
        return new ModelMetricsClustering.MetricBuilderClustering(((KMeansOutput)this._output).nfeatures(), ((KMeansParameters)this._parms)._k);
    }

    protected double[] score0(double[] data, double[] preds) {
        double[][] centers = ((KMeansParameters)this._parms)._standardize ? ((KMeansOutput)this._output)._centers_std_raw : ((KMeansOutput)this._output)._centers_raw;
        preds[0] = GenModel.KMeans_closest((double[][])centers, (double[])data, (String[][])((KMeansOutput)this._output)._domains, (double[])((KMeansOutput)this._output)._normSub, (double[])((KMeansOutput)this._output)._normMul);
        return preds;
    }

    protected void toJavaPredictBody(SB bodySb, SB classCtxSb, SB fileCtxSb) {
        if (((KMeansParameters)this._parms)._standardize) {
            JCodeGen.toStaticVar((SB)classCtxSb, (String)"MEANS", (double[])((KMeansOutput)this._output)._normSub, (String)"Column means of training data");
            JCodeGen.toStaticVar((SB)classCtxSb, (String)"MULTS", (double[])((KMeansOutput)this._output)._normMul, (String)"Reciprocal of column standard deviations of training data");
            JCodeGen.toStaticVar((SB)classCtxSb, (String)"CENTERS", (double[][])((KMeansOutput)this._output)._centers_std_raw, (String)"Normalized cluster centers[K][features]");
            bodySb.ip("preds[0] = KMeans_closest(CENTERS,data,DOMAINS,MEANS,MULTS);").nl();
        } else {
            JCodeGen.toStaticVar((SB)classCtxSb, (String)"CENTERS", (double[][])((KMeansOutput)this._output)._centers_raw, (String)"Denormalized cluster centers[K][features]");
            bodySb.ip("preds[0] = KMeans_closest(CENTERS,data,DOMAINS,null,null);").nl();
        }
    }

    public static class KMeansOutput
    extends ClusteringModel.ClusteringOutput {
        public int _iterations;
        public double[] _avg_centroids_chg = new double[]{Double.NaN};
        public double[] _within_mse;
        public long[] _size;
        public double _avg_within_ss;
        public double[] _history_avg_within_ss = new double[0];
        public double _avg_ss;
        public double _avg_between_ss;
        public int _categorical_column_count;
        public long[] _training_time_ms = new long[]{System.currentTimeMillis()};

        public KMeansOutput(KMeans b) {
            super((ClusteringModelBuilder)b);
        }
    }

    public static class KMeansParameters
    extends ClusteringModel.ClusteringParameters {
        public int _max_iterations = 1000;
        public boolean _standardize = true;
        public long _seed = System.nanoTime();
        public KMeans.Initialization _init = KMeans.Initialization.Furthest;
        public Key<Frame> _user_points;
    }
}

