/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.ModelMetricsPCA;
import hex.pca.PCA;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.TwoDimTable;

public class PCAModel
extends Model<PCAModel, PCAParameters, PCAOutput> {
    public PCAModel(Key selfKey, PCAParameters parms, PCAOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsPCA.PCAModelMetrics(((PCAParameters)this._parms)._k);
    }

    protected Frame scoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((PCAOutput)PCAModel.this._output)._names.length];
                double[] preds = new double[((PCAParameters)PCAModel.this._parms)._k];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = PCAModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((PCAOutput)PCAModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((PCAOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, Double.NaN);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        assert (data.length == ((PCAOutput)this._output)._eigenvectors.getRowDim());
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < data.length; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[j] - ((PCAOutput)this._output)._normSub[j]) * ((PCAOutput)this._output)._normMul[j] * (Double)((PCAOutput)this._output)._eigenvectors.get(j, i);
            }
        }
        return preds;
    }

    public Frame score(Frame fr, String destination_key) {
        Frame adaptFr = new Frame(fr);
        this.adaptTestForTrain(adaptFr, true);
        Frame output = this.scoreImpl(fr, adaptFr, destination_key);
        Vec[] vecs = adaptFr.vecs();
        for (int i = 0; i < vecs.length; ++i) {
            if (fr.find(vecs[i]) == -1) continue;
            vecs[i] = null;
        }
        adaptFr.delete();
        return output;
    }

    public static class PCAOutput
    extends Model.Output {
        public TwoDimTable _eigenvectors;
        public double[] _std_deviation;
        public TwoDimTable _pc_importance;
        public double[] _normSub;
        public double[] _normMul;
        public Key<Frame> _loading_key;

        public PCAOutput(PCA b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return this._names.length;
        }

        public Model.ModelCategory getModelCategory() {
            return Model.ModelCategory.DimReduction;
        }
    }

    public static class PCAParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public int _k = 1;
        public int _max_iterations = 1000;
        public long _seed = System.nanoTime();
        public Key<Frame> _loading_key;
        public boolean _keep_loading = true;
    }
}

