/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.Grid;
import hex.Model;
import hex.tree.SharedTreeGrid;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GBMGrid<G extends GBMGrid<G>>
extends SharedTreeGrid<G> {
    public static final String MODEL_NAME = "GBM";
    private static final String[] HYPER_NAMES = ArrayUtils.append((String[])SharedTreeGrid.HYPER_NAMES, (String[])new String[]{"_distribution", "_learn_rate"});
    private static final double[] HYPER_DEFAULTS = ArrayUtils.append((double[])SharedTreeGrid.HYPER_DEFAULTS, (double[])new double[]{GBMModel.GBMParameters.Family.gaussian.ordinal(), 0.1f});

    @Override
    protected String modelName() {
        return MODEL_NAME;
    }

    protected String[] hyperNames() {
        return HYPER_NAMES;
    }

    protected double[] hyperDefaults() {
        return HYPER_DEFAULTS;
    }

    protected double suggestedNextHyperValue(int h, Model m, double[] hyperLimits) {
        throw H2O.unimpl();
    }

    protected GBM getBuilder(double[] hypers) {
        GBMModel.GBMParameters parms = new GBMModel.GBMParameters();
        this.getBuilder(parms, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        parms._distribution = GBMModel.GBMParameters.Family.values()[(int)hypers[slen + 0]];
        parms._learn_rate = (float)hypers[slen + 1];
        return new GBM(parms);
    }

    public double[] getHypers(Model.Parameters parms) {
        GBMModel.GBMParameters gbmp = (GBMModel.GBMParameters)parms;
        double[] hypers = new double[HYPER_NAMES.length];
        super.getHypers(gbmp, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        hypers[slen + 0] = gbmp._distribution.ordinal();
        hypers[slen + 1] = gbmp._learn_rate;
        return hypers;
    }

    private GBMGrid(Key key, Frame fr) {
        super(key, fr);
    }

    public static GBMGrid get(Frame fr) {
        Key k = Grid.keyName((String)MODEL_NAME, (Frame)fr);
        GBMGrid kmg = (GBMGrid)DKV.getGet((Key)k);
        if (kmg != null) {
            return kmg;
        }
        kmg = new GBMGrid(k, fr);
        DKV.put(kmg);
        return kmg;
    }

    @Override
    protected long checksum_impl() {
        throw H2O.unimpl();
    }
}

