/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import hex.Model;
import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.Word2VecV3;
import hex.word2vec.Word2VecModel;
import hex.word2vec.WordVectorTrainer;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.fvec.Vec;
import water.util.Log;

public class Word2Vec
extends ModelBuilder<Word2VecModel, Word2VecModel.Word2VecParameters, Word2VecModel.Word2VecOutput> {
    public Model.ModelCategory[] can_build() {
        return new Model.ModelCategory[]{Model.ModelCategory.Unknown};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public Word2Vec(Word2VecModel.Word2VecParameters parms) {
        super("Word2Vec", (Model.Parameters)parms);
    }

    public ModelBuilderSchema schema() {
        return new Word2VecV3();
    }

    public Job<Word2VecModel> trainModel() {
        return this.start(new Word2VecDriver(), ((Word2VecModel.Word2VecParameters)this._parms)._epochs);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((Word2VecModel.Word2VecParameters)this._parms)._train != null) {
            Boolean useableCol = false;
            for (Vec v : ((Word2VecModel.Word2VecParameters)this._parms).train().vecs()) {
                if (!v.isString()) continue;
                useableCol = true;
            }
            if (!useableCol.booleanValue()) {
                this.error("_train", "Training input frame lacks any string columns for Word2Vec to analyze.");
            }
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._vecSize > 10000) {
            this.error("_vecSize", "Requested vector size of " + ((Word2VecModel.Word2VecParameters)this._parms)._vecSize + " in Word2Vec, exceeds limit of " + 10000 + ".");
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._vecSize < 1) {
            this.error("_vecSize", "Requested vector size of " + ((Word2VecModel.Word2VecParameters)this._parms)._vecSize + " in Word2Vec, is not allowed.");
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._windowSize < 1) {
            this.error("_windowSize", "Negative window size not allowed for Word2Vec.  Expected value > 0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._windowSize);
        }
        if ((double)((Word2VecModel.Word2VecParameters)this._parms)._sentSampleRate < 0.0) {
            this.error("_sentSampleRate", "Negative sentence sample rate not allowed for Word2Vec.  Expected a value > 0.0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._sentSampleRate);
        }
        if ((double)((Word2VecModel.Word2VecParameters)this._parms)._initLearningRate < 0.0) {
            this.error("_initLearningRate", "Negative learning rate not allowed for Word2Vec.  Expected a value > 0.0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._initLearningRate);
        }
        if (((Word2VecModel.Word2VecParameters)this._parms)._epochs < 1) {
            this.error("_epochs", "Negative epoch count not allowed for Word2Vec.  Expected value > 0, received " + ((Word2VecModel.Word2VecParameters)this._parms)._epochs);
        }
    }

    private class Word2VecDriver
    extends H2O.H2OCountedCompleter<Word2VecDriver> {
        private Word2VecDriver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block8: {
                Word2VecModel model = null;
                long lastCnt = 0L;
                try {
                    ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).read_lock_frames((Job)Word2Vec.this);
                    Word2Vec.this.init(true);
                    model = new Word2VecModel(Word2Vec.this.dest(), (Word2VecModel.Word2VecParameters)Word2Vec.this._parms, new Word2VecModel.Word2VecOutput(Word2Vec.this));
                    model.delete_and_lock(Word2Vec.this._key);
                    Log.info((Object[])new Object[]{"Word2Vec: Starting to train model."});
                    long tstart = System.currentTimeMillis();
                    for (int i = 0; i < ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms)._epochs; ++i) {
                        long start = System.currentTimeMillis();
                        model.setModelInfo(((WordVectorTrainer)new WordVectorTrainer(model.getModelInfo()).doAll(((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).train())).getModelInfo());
                        long stop = System.currentTimeMillis();
                        model.getModelInfo().updateLearningRate();
                        model.update(Word2Vec.this._key);
                        Job.update((long)1L, (Key)Word2Vec.this._key);
                        float tDiff = (float)(stop - start) / 1000.0f;
                        Log.info((Object[])new Object[]{"Epoch " + i + " " + tDiff + "s  Words trained/s: " + (float)(model.getModelInfo().getTotalProcessed() - lastCnt) / tDiff});
                        lastCnt = model.getModelInfo().getTotalProcessed();
                    }
                    long tstop = System.currentTimeMillis();
                    Log.info((Object[])new Object[]{"Total time :" + (float)(tstop - tstart) / 1000.0f});
                    Log.info((Object[])new Object[]{"Finished training the Word2Vec model."});
                    model.buildModelOutput();
                    Word2Vec.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)Word2Vec.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block8;
                    }
                    t.printStackTrace();
                    Word2Vec.this.failed(t);
                    throw t;
                }
                finally {
                    if (model != null) {
                        model.unlock(Word2Vec.this._key);
                    }
                    ((Word2VecModel.Word2VecParameters)Word2Vec.this._parms).read_unlock_frames((Job)Word2Vec.this);
                }
            }
            this.tryComplete();
        }
    }

    public static enum NormModel {
        HSM,
        NegSampling;

    }

    public static enum WordModel {
        SkipGram,
        CBOW;

    }
}

