/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.SupervisedModel;
import hex.SupervisedModelBuilder;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.DeepLearningTask2;
import hex.schemas.DeepLearningV3;
import hex.schemas.ModelBuilderSchema;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.Linpack;
import water.init.NetworkTest;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class DeepLearning
extends SupervisedModelBuilder<DeepLearningModel, DeepLearningModel.DeepLearningParameters, DeepLearningModel.DeepLearningModelOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public boolean isSupervised() {
        return !((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder;
    }

    public DeepLearning(DeepLearningModel.DeepLearningParameters parms) {
        super("DeepLearning", (SupervisedModel.SupervisedParameters)parms);
        this.init(false);
    }

    public ModelBuilderSchema schema() {
        return new DeepLearningV3();
    }

    public Job<DeepLearningModel> trainModel() {
        long work = 1L;
        if (null != this._train) {
            work = (long)((DeepLearningModel.DeepLearningParameters)this._parms)._epochs * this._train.numRows();
        }
        return this.start(new DeepLearningDriver(), work);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        ((DeepLearningModel.DeepLearningParameters)this._parms).validate(this, expensive);
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, DeepLearningModel.DeepLearningParameters parms) {
        return new DataInfo(Key.make(), train, valid, parms._autoencoder ? 0 : 1, parms._autoencoder || parms._use_all_factor_levels, parms._autoencoder ? DataInfo.TransformType.NORMALIZE : DataInfo.TransformType.STANDARDIZE, train.lastVec().isEnum() ? DataInfo.TransformType.NONE : DataInfo.TransformType.STANDARDIZE, parms._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip, true);
    }

    protected void checkMemoryFootPrint() {
        int layer;
        if (((DeepLearningModel.DeepLearningParameters)this._parms)._checkpoint != null) {
            return;
        }
        long p = this._train.degreesOfFreedom() - (long)(((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? 0 : this._train.lastVec().cardinality());
        String[][] dom = this._train.domains();
        for (int i = 0; i < this._train.numCols() - (((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? 0 : 1); ++i) {
            if (dom[i] == null) continue;
            ++p;
        }
        long output = ((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? p : (long)Math.abs(this._train.lastVec().cardinality());
        long model_size = p * (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[0];
        for (layer = 1; layer < ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden.length; ++layer) {
            model_size += (long)(((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer - 1] * ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer]);
        }
        model_size += (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer - 1] * output;
        for (layer = 0; layer < ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden.length; ++layer) {
            model_size += (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer];
        }
        if ((double)(model_size += output) > 1.0E8) {
            String msg = "Model is too large: " + model_size + " parameters. Try reducing the number of neurons in the hidden layers (or reduce the number of categorical factors).";
            this.error("_hidden", msg);
            this.cancel(msg);
        }
    }

    public class DeepLearningDriver
    extends H2O.H2OCountedCompleter<DeepLearningDriver> {
        final transient String[] cp_modifiable = new String[]{"_seed", "_epochs", "_score_interval", "_train_samples_per_iteration", "_target_ratio_comm_to_comp", "_score_duty_cycle", "_score_training_samples", "_classification_stop", "_regression_stop", "_quiet_mode", "_max_confusion_matrix_size", "_max_hit_ratio_k", "_diagnostics", "_variable_importances", "_force_load_balance", "_replicate_training_data", "_shuffle_training_data", "_single_node_mode", "_fast_mode", "_l1", "_l2", "_max_w2", "_input_dropout_ratio", "_hidden_dropout_ratios", "_loss", "_overwrite_with_best_model", "_missing_values_handling", "_reproducible", "_export_weights_and_biases"};
        final transient String[] cp_not_modifiable = new String[]{"_drop_na20_cols", "_response_column", "_activation", "_use_all_factor_levels", "_adaptive_rate", "_autoencoder", "_rho", "_epsilon", "_sparse", "_sparsity_beta", "_col_major", "_rate", "_momentum_start", "_momentum_ramp", "_momentum_stable", "_nesterov_accelerated_gradient", "_ignore_const_cols", "_max_categorical_features"};
        transient HashSet<Frame> _delete_me = new HashSet();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block8: {
                try {
                    byte[] cs = new AutoBuffer().put((Freezable)DeepLearning.this._parms).buf();
                    Scope.enter();
                    DeepLearning.this.init(true);
                    ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).read_lock_frames((Job)DeepLearning.this);
                    if (DeepLearning.this.error_count() > 0) {
                        DeepLearning.this.updateValidationMessages();
                        throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)DeepLearning.this);
                    }
                    this.buildModel();
                    byte[] cs2 = new AutoBuffer().put((Freezable)DeepLearning.this._parms).buf();
                    assert (Arrays.equals(cs, cs2));
                    DeepLearning.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)DeepLearning.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block8;
                    }
                    DeepLearning.this.failed(t);
                    throw t;
                }
                finally {
                    ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).read_unlock_frames((Job)DeepLearning.this);
                    Scope.exit((Key[])new Key[0]);
                }
            }
            this.tryComplete();
        }

        Key self() {
            return DeepLearning.this._key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            Scope.enter();
            DeepLearningModel cp = null;
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint == null) {
                cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, new DeepLearningModel.DeepLearningModelOutput(DeepLearning.this), DeepLearning.this._train, DeepLearning.this._valid);
                cp.model_info().initializeMembers();
            } else {
                DeepLearningModel previous = (DeepLearningModel)DKV.getGet((Key)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint);
                if (previous == null) {
                    throw new IllegalArgumentException("Checkpoint not found.");
                }
                Log.info((Object[])new Object[]{"Resuming from checkpoint."});
                if (DeepLearning.this.isClassifier() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isClassifier()) {
                    throw new IllegalArgumentException("Response type must be the same as for the checkpointed model.");
                }
                if (DeepLearning.this.isSupervised() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isSupervised()) {
                    throw new IllegalArgumentException("Model type must be the same as for the checkpointed model.");
                }
                DeepLearningModel.DeepLearningParameters oldP = (DeepLearningModel.DeepLearningParameters)previous._parms;
                DeepLearningModel.DeepLearningParameters newP = (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms;
                new Job.ProgressUpdate("Resuming from checkpoint").fork(DeepLearning.this._progressKey);
                if (newP.getNumFolds() != 0) {
                    throw new UnsupportedOperationException("n_folds must be 0: Cross-validation is not supported during checkpoint restarts.");
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid == null != (((DeepLearningModel.DeepLearningParameters)previous._parms)._valid == null) || ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid != null && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._valid.equals((Object)((DeepLearningModel.DeepLearningParameters)previous._parms)._valid)) {
                    throw new IllegalArgumentException("Validation dataset must be the same as for the checkpointed model.");
                }
                if (!(newP._autoencoder || newP._response_column != null && newP._response_column.equals(oldP._response_column))) {
                    throw new IllegalArgumentException("Response column (" + newP._response_column + ") is not the same as for the checkpointed model: " + oldP._response_column);
                }
                if (!Arrays.equals(newP._hidden, oldP._hidden)) {
                    throw new IllegalArgumentException("Hidden layers (" + Arrays.toString(newP._hidden) + ") is not the same as for the checkpointed model: " + Arrays.toString(oldP._hidden));
                }
                if (!Arrays.equals(newP._ignored_columns, oldP._ignored_columns)) {
                    throw new IllegalArgumentException("Predictor columns must be the same as for the checkpointed model. Check ignored columns.");
                }
                for (Field field : ((Object)((Object)oldP)).getClass().getDeclaredFields()) {
                    if (!ArrayUtils.contains((String[])this.cp_not_modifiable, (String)field.getName())) continue;
                    for (Field fAfter : ((Object)((Object)newP)).getClass().getDeclaredFields()) {
                        if (!field.equals(fAfter)) continue;
                        try {
                            if (fAfter.get((Object)newP) != null && field.get((Object)oldP) != null && field.get((Object)oldP).toString().equals(fAfter.get((Object)newP).toString()) || field.get((Object)oldP) == null && fAfter.get((Object)newP) == null) continue;
                            throw new IllegalArgumentException("Cannot change parameter: '" + field.getName() + "': " + field.get((Object)oldP) + " -> " + fAfter.get((Object)newP));
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    DataInfo dataInfo = DeepLearning.makeDataInfo(DeepLearning.this._train, DeepLearning.this._valid, (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms);
                    DKV.put((Key)dataInfo._key, (Iced)dataInfo);
                    cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, previous, false, dataInfo);
                    cp.write_lock(this.self());
                    DeepLearningModel.DeepLearningParameters actualNewP = cp.model_info().get_params();
                    assert (actualNewP != previous.model_info().get_params());
                    assert (actualNewP != newP);
                    assert (actualNewP != oldP);
                    if (!Arrays.equals(((DeepLearningModel.DeepLearningModelOutput)cp._output)._names, ((DeepLearningModel.DeepLearningModelOutput)previous._output)._names)) {
                        throw new IllegalArgumentException("Predictor columns of the training data must be the same as for the checkpointed model. Check ignored columns.");
                    }
                    if (!Arrays.deepEquals((Object[])((DeepLearningModel.DeepLearningModelOutput)cp._output)._domains, (Object[])((DeepLearningModel.DeepLearningModelOutput)previous._output)._domains)) {
                        throw new IllegalArgumentException("Categorical factor levels of the training data must be the same as for the checkpointed model.");
                    }
                    if (dataInfo.fullN() != previous.model_info().data_info().fullN()) {
                        throw new IllegalArgumentException("Total number of predictors is different than for the checkpointed model.");
                    }
                    for (Field fBefore : ((Object)((Object)actualNewP)).getClass().getDeclaredFields()) {
                        if (!ArrayUtils.contains((String[])this.cp_modifiable, (String)fBefore.getName())) continue;
                        for (Field fAfter : ((Object)((Object)newP)).getClass().getDeclaredFields()) {
                            if (!fBefore.equals(fAfter)) continue;
                            try {
                                if (fAfter.get((Object)newP) != null && fBefore.get((Object)actualNewP) != null && fBefore.get((Object)actualNewP).toString().equals(fAfter.get((Object)newP).toString()) || fBefore.get((Object)actualNewP) == null && fAfter.get((Object)newP) == null) continue;
                                Log.info((Object[])new Object[]{"Applying user-requested modification of '" + fBefore.getName() + "': " + fBefore.get((Object)actualNewP) + " -> " + fAfter.get((Object)newP)});
                                fBefore.set((Object)actualNewP, fAfter.get((Object)newP));
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    DeepLearningModel.modifyParms(actualNewP, actualNewP, DeepLearning.this.isClassifier());
                    actualNewP._epochs += previous.epoch_counter;
                    Log.info((Object[])new Object[]{"Adding " + String.format("%.3f", previous.epoch_counter) + " epochs from the checkpointed model."});
                    if (actualNewP.getNumFolds() != 0) {
                        Log.info((Object[])new Object[]{"Disabling cross-validation: Not supported when resuming training from a checkpoint."});
                        H2O.unimpl((String)"writing to n_folds field needs to be uncommented");
                    }
                    cp.update(this.self());
                }
                finally {
                    if (cp != null) {
                        cp.unlock(this.self());
                    }
                }
            }
            this.trainModel(cp);
            ArrayList<Key> keep = new ArrayList<Key>();
            keep.add(DeepLearning.this.dest());
            if (((DeepLearningModel.DeepLearningModelOutput)cp._output)._model_metrics.length != 0) {
                keep.add(((DeepLearningModel.DeepLearningModelOutput)cp._output)._model_metrics[((DeepLearningModel.DeepLearningModelOutput)cp._output)._model_metrics.length - 1]);
            }
            if (((DeepLearningModel.DeepLearningModelOutput)cp._output).weights != null && ((DeepLearningModel.DeepLearningModelOutput)cp._output).biases != null) {
                for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).weights)) {
                    keep.add(k);
                    for (Vec vec : ((Frame)DKV.getGet((Key)k)).vecs()) {
                        keep.add(vec._key);
                    }
                }
                for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).biases)) {
                    keep.add(k);
                    for (Vec vec : ((Frame)DKV.getGet((Key)k)).vecs()) {
                        keep.add(vec._key);
                    }
                }
            }
            Scope.exit((Key[])keep.toArray(new Key[0]));
        }

        public final DeepLearningModel trainModel(DeepLearningModel model) {
            Frame validScoreFrame = null;
            try {
                DeepLearningModel best_model;
                if (model == null) {
                    model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                }
                Log.info((Object[])new Object[]{"Model category: " + (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder ? "Auto-Encoder" : (DeepLearning.this.isClassifier() ? "Classification" : "Regression"))});
                long model_size = model.model_info().size();
                Log.info((Object[])new Object[]{"Number of model parameters (weights/biases): " + String.format("%,d", model_size)});
                model.write_lock(this.self());
                new Job.ProgressUpdate("Setting up training data...").fork(DeepLearning.this._progressKey);
                DeepLearningModel.DeepLearningParameters mp = model.model_info().get_params();
                Frame tra_fr = new Frame(Key.make((String)(mp.train()._key.toString() + ".temporary")), DeepLearning.this._train.names(), DeepLearning.this._train.vecs());
                Frame val_fr = DeepLearning.this._valid != null ? new Frame(Key.make((String)(mp.valid()._key.toString() + ".temporary")), DeepLearning.this._valid.names(), DeepLearning.this._valid.vecs()) : null;
                Frame train = tra_fr;
                if (mp._force_load_balance) {
                    new Job.ProgressUpdate("Load balancing training data...").fork(DeepLearning.this._progressKey);
                    train = this.reBalance(train, mp._replicate_training_data, mp._train.toString() + "." + model._key.toString() + ".train");
                }
                if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes) {
                    new Job.ProgressUpdate("Balancing class distribution of training data...").fork(DeepLearning.this._progressKey);
                    float[] trainSamplingFactors = new float[train.lastVec().domain().length];
                    if (mp._class_sampling_factors != null) {
                        if (mp._class_sampling_factors.length != train.lastVec().domain().length) {
                            throw new IllegalArgumentException("class_sampling_factors must have " + train.lastVec().domain().length + " elements");
                        }
                        trainSamplingFactors = (float[])mp._class_sampling_factors.clone();
                    }
                    train = MRUtils.sampleFrameStratified((Frame)train, (Vec)train.lastVec(), (float[])trainSamplingFactors, (long)((long)(mp._max_after_balance_size * (float)train.numRows())), (long)mp._seed, (boolean)true, (boolean)false);
                    ((DeepLearningModel.DeepLearningModelOutput)model._output)._modelClassDist = ((MRUtils.ClassDist)new MRUtils.ClassDist(train.lastVec()).doAll(new Vec[]{train.lastVec()})).rel_dist();
                }
                ((DeepLearningModel.DeepLearningModelOutput)model._output).autoencoder = ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder;
                model.training_rows = train.numRows();
                Frame trainScoreFrame = MRUtils.sampleFrame((Frame)train, (long)mp._score_training_samples, (long)mp._seed);
                if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                    Log.info((Object[])new Object[]{"Number of chunks of the training data: " + train.anyVec().nChunks()});
                }
                if (val_fr != null) {
                    model.validation_rows = val_fr.numRows();
                    if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes && mp._score_validation_sampling == DeepLearningModel.DeepLearningParameters.ClassSamplingMethod.Stratified) {
                        new Job.ProgressUpdate("Sampling validation data (stratified)...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = MRUtils.sampleFrameStratified((Frame)val_fr, (Vec)val_fr.lastVec(), null, (long)(mp._score_validation_samples > 0L ? mp._score_validation_samples : val_fr.numRows()), (long)(mp._seed + 1L), (boolean)false, (boolean)false);
                    } else {
                        new Job.ProgressUpdate("Sampling validation data...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = MRUtils.sampleFrame((Frame)val_fr, (long)mp._score_validation_samples, (long)(mp._seed + 1L));
                    }
                    if (mp._force_load_balance) {
                        new Job.ProgressUpdate("Balancing class distribution of validation data...").fork(DeepLearning.this._progressKey);
                        validScoreFrame = this.reBalance(validScoreFrame, false, mp._valid.toString() + "." + model._key.toString() + ".valid");
                    }
                    if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Number of chunks of the validation data: " + validScoreFrame.anyVec().nChunks()});
                    }
                }
                model.actual_train_samples_per_iteration = this.computeTrainSamplesPerIteration(mp, train.numRows(), model);
                if (mp._replicate_training_data && model.actual_train_samples_per_iteration == train.numRows() * (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) && !mp._shuffle_training_data && H2O.CLOUD.size() > 1 && !mp._reproducible) {
                    Log.info((Object[])new Object[]{"Enabling training data shuffling, because all nodes train on the full dataset (replicated training data)."});
                    mp._shuffle_training_data = true;
                }
                if (!mp._shuffle_training_data && mp._balance_classes && !mp._reproducible) {
                    Log.info((Object[])new Object[]{"Enabling training data shuffling, because balance_classes is enabled."});
                    mp._shuffle_training_data = true;
                }
                if (!mp._quiet_mode && mp._diagnostics) {
                    Log.info((Object[])new Object[]{"Initial model:\n" + (Object)((Object)model.model_info())});
                }
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder) {
                    new Job.ProgressUpdate("Scoring null model of autoencoder...").fork(DeepLearning.this._progressKey);
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self(), null);
                }
                model.update(this.self());
                model._timeLastScoreEnter = System.currentTimeMillis();
                Log.info((Object[])new Object[]{"Starting to train the Deep Learning model."});
                do {
                    DeepLearningModel.DeepLearningModelInfo mi = model.model_info();
                    String speed = model.run_time != 0L ? " at " + mi.get_processed_total() * 1000L / model.run_time + " samples/s..." : "...";
                    String etl = model.run_time == 0L ? "" : " Estimated time left: " + PrettyPrint.msecs((long)((long)((double)model.run_time * (1.0 - (double)DeepLearning.this.progress()) / (double)DeepLearning.this.progress())), (boolean)true);
                    new Job.ProgressUpdate("Training" + speed + etl).fork(DeepLearning.this._progressKey);
                    model.set_model_info(mp._epochs == 0.0 ? mi : (H2O.CLOUD.size() > 1 && mp._replicate_training_data ? (mp._single_node_mode ? ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, mi, this.rowFraction(train, mp, model)).doAll(new Key[]{Key.make()})).model_info() : ((DeepLearningTask2)new DeepLearningTask2(this.self(), train, mi, this.rowFraction(train, mp, model)).doAllNodes()).model_info()) : ((DeepLearningTask)new DeepLearningTask(this.self(), mi, this.rowFraction(train, mp, model)).doAll(train)).model_info()));
                    DeepLearning.this.update(model.actual_train_samples_per_iteration);
                } while (model.doScoring(trainScoreFrame, validScoreFrame, this.self(), DeepLearning.this._progressKey));
                if (!DeepLearning.this.isCancelledOrCrashed() && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._overwrite_with_best_model && model.actual_best_model_key != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).getNumFolds() == 0 && (best_model = (DeepLearningModel)DKV.getGet((Key)model.actual_best_model_key)) != null && best_model.error() < model.error() && Arrays.equals(best_model.model_info().units, model.model_info().units)) {
                    Log.info((Object[])new Object[]{"Setting the model to be the best model so far (based on scoring history)."});
                    DeepLearningModel.DeepLearningModelInfo mi = best_model.model_info().deep_clone();
                    mi.set_processed_global(model.model_info().get_processed_global());
                    mi.set_processed_local(model.model_info().get_processed_local());
                    model.set_model_info(mi);
                    model.update(this.self());
                    model.doScoring(trainScoreFrame, validScoreFrame, this.self(), DeepLearning.this._progressKey);
                    assert (best_model.error() == model.error());
                }
                Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
                Log.info((Object[])new Object[]{model});
                Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
            }
            catch (Throwable ex) {
                model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                Log.info((Object[])new Object[]{"Deep Learning model building was cancelled."});
                throw new RuntimeException(ex);
            }
            finally {
                if (model != null) {
                    model.unlock(this.self());
                    if (model.actual_best_model_key != null) {
                        assert (model.actual_best_model_key != model._key);
                        DKV.remove((Key)model.actual_best_model_key);
                    }
                }
                for (Frame f : this._delete_me) {
                    f.delete();
                }
            }
            return model;
        }

        private Frame reBalance(Frame fr, boolean local, String name) {
            int chunks = (int)Math.min((long)(4 * H2O.NUMCPUS * (local ? 1 : H2O.CLOUD.size())), fr.numRows());
            if (fr.anyVec().nChunks() > chunks && !((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                Log.info((Object[])new Object[]{"Dataset already contains " + fr.anyVec().nChunks() + " chunks. No need to rebalance."});
                return fr;
            }
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._reproducible) {
                Log.warn((Object[])new Object[]{"Reproducibility enforced - using only 1 thread - can be slow."});
                chunks = 1;
            }
            if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                Log.info((Object[])new Object[]{"ReBalancing dataset into (at least) " + chunks + " chunks."});
            }
            Key newKey = Key.make((String)(name + ".chunks" + chunks));
            RebalanceDataSet rb = new RebalanceDataSet(fr, newKey, chunks);
            H2O.submitTask((H2O.H2OCountedCompleter)rb);
            rb.join();
            Frame f = (Frame)DKV.get((Key)newKey).get();
            this._delete_me.add(f);
            return f;
        }

        private long computeTrainSamplesPerIteration(DeepLearningModel.DeepLearningParameters mp, long numRows, DeepLearningModel model) {
            long tspi = mp._train_samples_per_iteration;
            assert (tspi == 0L || tspi == -1L || tspi == -2L || tspi >= 1L);
            if (tspi == 0L || !mp._replicate_training_data && tspi == -1L) {
                tspi = numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to one epoch: #rows (" + tspi + ")."});
                }
            } else if (tspi == -1L) {
                tspi = (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows;
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to #nodes x #rows (" + tspi + ")."});
                }
            } else if (tspi == -2L) {
                double total_gflops = 0.0;
                for (H2ONode h2o : H2O.CLOUD._memary) {
                    HeartBeat hb = h2o._heartbeat;
                    total_gflops += hb._gflops;
                }
                if (mp._single_node_mode) {
                    total_gflops /= (double)H2O.CLOUD.size();
                }
                if (total_gflops == 0.0) {
                    total_gflops = Linpack.run((int)H2O.SELF._heartbeat._cpus_allowed) * (double)(mp._single_node_mode ? 1 : H2O.CLOUD.size());
                }
                long model_size = model.model_info().size();
                int[] msg_sizes = new int[]{(long)((int)(model_size * 4L)) == model_size * 4L ? (int)(model_size * 4L) : Integer.MAX_VALUE};
                double[] microseconds_collective = new double[msg_sizes.length];
                NetworkTest.NetworkTester nt = new NetworkTest.NetworkTester(msg_sizes, (double[][])null, microseconds_collective, (double)model_size > 1000000.0 ? 1 : 5, false, true);
                nt.compute2();
                int network_queue_length = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 1 : 2 * (int)Math.floor(Math.log(H2O.CLOUD.size()) / Math.log(2.0));
                double flops_overhead_per_row = 30.0;
                if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout) {
                    flops_overhead_per_row *= 8.0;
                } else if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                    flops_overhead_per_row *= 5.0;
                }
                double fraction = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 0.001 : 0.05;
                model.time_for_communication_us = (H2O.CLOUD.size() == 1 ? 10000.0 : 0.0) + (double)network_queue_length * microseconds_collective[0];
                double time_per_row_us = flops_overhead_per_row * (double)model_size / (total_gflops * 1.0E9) / (double)H2O.SELF._heartbeat._cpus_allowed * 1000000.0;
                tspi = (long)((model.time_for_communication_us / fraction - model.time_for_communication_us) / time_per_row_us);
                tspi = Math.min(tspi, (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows * 10L);
                if (tspi > numRows && (double)Math.abs(tspi % numRows) / (double)numRows < 0.2) {
                    tspi -= tspi % numRows;
                }
                tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows / 10.0));
                tspi = Math.max(1L, tspi);
                if (!mp._quiet_mode) {
                    Log.info((Object[])new Object[]{"Auto-tuning parameter 'train_samples_per_iteration':"});
                    Log.info((Object[])new Object[]{"Estimated compute power : " + (int)total_gflops + " GFlops"});
                    Log.info((Object[])new Object[]{"Estimated time for comm : " + PrettyPrint.usecs((long)((long)model.time_for_communication_us))});
                    Log.info((Object[])new Object[]{"Estimated time per row  : " + ((long)time_per_row_us > 0L ? PrettyPrint.usecs((long)((long)time_per_row_us)) : time_per_row_us + " usecs")});
                    Log.info((Object[])new Object[]{"Estimated training speed: " + (int)(1000000.0 / time_per_row_us) + " rows/sec"});
                    Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to auto-tuned value: " + tspi});
                }
            } else {
                tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows));
            }
            assert (tspi != 0L && tspi != -1L && tspi != -2L && tspi >= 1L);
            return tspi;
        }

        private float computeRowUsageFraction(long numRows, long train_samples_per_iteration, boolean replicate_training_data) {
            float rowUsageFraction = (float)train_samples_per_iteration / (float)numRows;
            if (replicate_training_data) {
                rowUsageFraction /= (float)H2O.CLOUD.size();
            }
            assert (rowUsageFraction > 0.0f);
            return rowUsageFraction;
        }

        private float rowFraction(Frame train, DeepLearningModel.DeepLearningParameters p, DeepLearningModel m) {
            return this.computeRowUsageFraction(train.numRows(), m.actual_train_samples_per_iteration, p._replicate_training_data);
        }
    }
}

