/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsPCA;
import hex.pca.PCA;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.SB;
import water.util.TwoDimTable;

public class PCAModel
extends Model<PCAModel, PCAParameters, PCAOutput> {
    public PCAModel(Key selfKey, PCAParameters parms, PCAOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsPCA.PCAModelMetrics(((PCAParameters)this._parms)._k);
    }

    protected Frame scoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((PCAOutput)PCAModel.this._output)._names.length];
                double[] preds = new double[((PCAParameters)PCAModel.this._parms)._k];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = PCAModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((PCAOutput)PCAModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((PCAOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, Double.NaN);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((PCAOutput)this._output)._catOffsets[((PCAOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((PCAOutput)this._output)._nnums + ((PCAOutput)this._output)._ncats);
        for (int i = 0; i < ((PCAParameters)this._parms)._k; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < ((PCAOutput)this._output)._ncats; ++j) {
                int level = (int)data[((PCAOutput)this._output)._permutation[j]];
                if (level > ((PCAOutput)this._output)._catOffsets[j + 1] - ((PCAOutput)this._output)._catOffsets[j] - 1) continue;
                int n = i;
                preds[n] = preds[n] + ((PCAOutput)this._output)._eigenvectors_raw[((PCAOutput)this._output)._catOffsets[j] + level][i];
            }
            int dcol = ((PCAOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j = 0; j < ((PCAOutput)this._output)._nnums; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[((PCAOutput)this._output)._permutation[dcol]] - ((PCAOutput)this._output)._normSub[j]) * ((PCAOutput)this._output)._normMul[j] * ((PCAOutput)this._output)._eigenvectors_raw[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    public Frame score(Frame fr, String destination_key) {
        Frame adaptFr = new Frame(fr);
        this.adaptTestForTrain(adaptFr, true);
        Frame output = this.scoreImpl(fr, adaptFr, destination_key);
        PCAModel.cleanup_adapt((Frame)adaptFr, (Frame)fr);
        return output;
    }

    protected SB toJavaInit(SB sb, SB fileContextSB) {
        sb = super.toJavaInit(sb, fileContextSB);
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((PCAOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((PCAParameters)this._parms)._k + "; }").nl();
        if (((PCAOutput)this._output)._nnums > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"NORMMUL", (double[])((PCAOutput)this._output)._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMSUB", (double[])((PCAOutput)this._output)._normSub, (String)"Standardization/Normalization offset for numerical variables.");
        }
        JCodeGen.toStaticVar((SB)sb, (String)"CATOFFS", (int[])((PCAOutput)this._output)._catOffsets, (String)"Categorical column offsets.");
        JCodeGen.toStaticVar((SB)sb, (String)"PERMUTE", (int[])((PCAOutput)this._output)._permutation, (String)"Permutation index vector.");
        JCodeGen.toStaticVar((SB)sb, (String)"EIGVECS", (double[][])((PCAOutput)this._output)._eigenvectors_raw, (String)"Eigenvector matrix.");
        return sb;
    }

    protected void toJavaPredictBody(SB bodySb, SB classCtxSb, SB fileCtxSb) {
        SB model = new SB();
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = ((PCAOutput)this._output)._ncats;
        int nums = ((PCAOutput)this._output)._nnums;
        bodySb.i().p("final int nstart = CATOFFS[CATOFFS.length-1];").nl();
        bodySb.i().p("for(int i = 0; i < ").p(((PCAParameters)this._parms)._k).p("; i++) {").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(cats).p("; j++) {").nl();
        bodySb.i(2).p("int c = (int) data[PERMUTE[j]];").nl();
        bodySb.i(2).p("if(c > CATOFFS[j+1]-CATOFFS[j]-1) continue;").nl();
        bodySb.i(2).p("preds[i] += EIGVECS[CATOFFS[j]+c][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(nums).p("; j++) {").nl();
        bodySb.i(2).p("preds[i] += (data[PERMUTE[j" + (cats > 0 ? "+" + cats : "") + "]]-NORMSUB[j])*NORMMUL[j]*EIGVECS[j" + (cats > 0 ? "+ nstart" : "") + "][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i().p("}").nl();
        fileCtxSb.p(model);
    }

    public static class PCAOutput
    extends Model.Output {
        public double[][] _eigenvectors_raw;
        public TwoDimTable _eigenvectors;
        public double[] _std_deviation;
        public TwoDimTable _pc_importance;
        public int _ncats;
        public int _nnums;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public Key<Frame> _loading_key;

        public PCAOutput(PCA b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return this._names.length;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class PCAParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public int _k = 1;
        public int _max_iterations = 1000;
        public long _seed = System.nanoTime();
        public Key<Frame> _loading_key;
        public boolean _keep_loading = true;
        public boolean _useAllFactorLevels = false;
    }
}

