/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.schemas.SupervisedModelBuilderSchema;
import water.api.API;
import water.api.KeyV3;
import water.api.SupervisedModelParametersSchema;

public class GLMV3
extends SupervisedModelBuilderSchema<GLM, GLMV3, GLMParametersV3> {

    public static final class GLMParametersV3
    extends SupervisedModelParametersSchema<GLMModel.GLMParameters, GLMParametersV3> {
        public static String[] own_fields = new String[]{"family", "solver", "alpha", "lambda", "lambda_search", "nlambdas", "standardize", "max_iterations", "objective_epsilon", "beta_epsilon", "gradient_epsilon", "link", "prior", "lambda_min_ratio", "beta_constraints", "max_active_predictors"};
        @API(help="Family. Use binomial for classification with logistic regression, others are for regression problems.", values={"gaussian", "binomial", "poisson", "gamma"}, level=API.Level.critical)
        public GLMModel.GLMParameters.Family family;
        @API(help="Auto will pick solver better suited for the given dataset, in case of lambda search solvers may be changed during computation. IRLSM is fast on on problems with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns.", values={"AUTO", "IRLSM", "L_BFGS"}, level=API.Level.critical)
        public GLMModel.GLMParameters.Solver solver;
        @API(help="distribution of regularization between L1 and L2.", level=API.Level.critical)
        public double[] alpha;
        @API(help="regularization strength", required=false, level=API.Level.critical)
        public double[] lambda;
        @API(help="use lambda search starting at lambda max, given lambda is then interpreted as lambda min", level=API.Level.critical)
        public boolean lambda_search;
        @API(help="number of lambdas to be used in a search", level=API.Level.critical)
        public int nlambdas;
        @API(help="Standardize numeric columns to have zero mean and unit variance", level=API.Level.critical)
        public boolean standardize;
        @API(help="Maximum number of iterations", level=API.Level.secondary)
        public int max_iterations;
        @API(help="converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver ", level=API.Level.expert)
        public double beta_epsilon;
        @API(help="converge if  objective value changes less than this", level=API.Level.expert)
        public double objective_epsilon;
        @API(help="converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver", level=API.Level.expert)
        public double gradient_epsilon;
        @API(help="", level=API.Level.secondary, values={"family_default", "identity", "logit", "log", "inverse", "tweedie"})
        public GLMModel.GLMParameters.Link link;
        @API(help="include constant term in the model", level=API.Level.expert)
        public boolean intercept;
        @API(help="prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean of response does not reflect reality.", level=API.Level.expert)
        public double prior;
        @API(help="min lambda used in lambda search, specified as a ratio of lambda_max", level=API.Level.expert)
        public double lambda_min_ratio;
        @API(help="beta constraints", direction=API.Direction.INPUT)
        public KeyV3.FrameKeyV3 beta_constraints;
        @API(help="Maximum number of active predictors during computation. Use as a stopping criterium to prevent expensive model building with many predictors.", direction=API.Direction.INPUT, level=API.Level.expert)
        public int max_active_predictors = -1;
    }
}

