/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.tree.CompressedTree;
import hex.tree.DTreeScorer;
import java.util.Arrays;
import java.util.Random;
import water.Key;
import water.fvec.Chunk;

class OOBScorer
extends DTreeScorer<OOBScorer> {
    protected final float _rate;

    public OOBScorer(int ncols, int nclass, float rate, Key[][] treeKeys) {
        super(ncols, nclass, treeKeys);
        this._rate = rate;
    }

    public void map(Chunk[] chks) {
        double[] data = new double[this._ncols];
        double[] preds = new double[this._nclass + 1];
        int ntrees = this._trees.length;
        Chunk coobt = this.chk_oobt(chks);
        Chunk cys = this.chk_resp(chks);
        for (int tidx = 0; tidx < ntrees; ++tidx) {
            Random rng = this.rngForTree(this._trees[tidx], coobt.cidx());
            for (int row = 0; row < coobt._len; ++row) {
                if (!(rng.nextFloat() >= this._rate) && !Double.isNaN(cys.atd(row))) continue;
                for (int i = 0; i < this._ncols; ++i) {
                    data[i] = chks[i].atd(row);
                }
                Arrays.fill(preds, 0.0);
                this.score0(data, preds, this._trees[tidx]);
                if (this._nclass == 1) {
                    preds[1] = preds[0];
                }
                for (int c = 0; c < this._nclass; ++c) {
                    double prediction = preds[1 + c];
                    if (preds[1 + c] == 0.0) continue;
                    Chunk ctree = this.chk_tree(chks, c);
                    long count = coobt.at8(row);
                    if (this._nclass >= 2) {
                        ctree.set(row, (float)(ctree.atd(row) * (double)count + prediction) / (float)(count + 1L));
                        continue;
                    }
                    ctree.set(row, (float)(ctree.atd(row) + prediction));
                }
                coobt.set(row, coobt.atd(row) + 1.0);
            }
        }
    }

    private Random rngForTree(CompressedTree[] ts, int cidx) {
        return ts[0].rngForChunk(cidx);
    }
}

