/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import hex.ScoreKeeper;
import hex.VarImp;
import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningParameters;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import hex.schemas.DeepLearningModelV3;
import java.util.ArrayList;
import java.util.Arrays;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.api.ModelSchema;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.JCodeGen;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.SB;
import water.util.Timer;
import water.util.TwoDimTable;

public class DeepLearningModel
extends Model<DeepLearningModel, DeepLearningParameters, DeepLearningModelOutput>
implements Model.DeepFeatures {
    private volatile DeepLearningModelInfo model_info;
    public long run_time;
    private long start_time;
    public long actual_train_samples_per_iteration;
    public double time_for_communication_us;
    public double epoch_counter;
    public long training_rows;
    public long validation_rows;
    private DeepLearningScoring[] errors;
    private float _bestError = Float.POSITIVE_INFINITY;
    public Key actual_best_model_key;
    public Key model_info_key;
    public long _timeLastScoreEnter;
    private transient long _timeLastScoreStart;
    private transient long _timeLastScoreEnd;
    private transient long _timeLastPrintStart;
    private final transient String unstable_msg = "Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing.";

    public ModelSchema schema() {
        return new DeepLearningModelV3();
    }

    void set_model_info(DeepLearningModelInfo mi) {
        assert (mi != null);
        this.model_info = mi;
    }

    public final DeepLearningModelInfo model_info() {
        return this.model_info;
    }

    public final VarImp varImp() {
        return ((DeepLearningModelOutput)this._output).errors.variable_importances;
    }

    public DeepLearningScoring[] scoring_history() {
        return this.errors;
    }

    DeepLearningScoring last_scored() {
        return this.errors == null ? null : this.errors[this.errors.length - 1];
    }

    public final DeepLearningParameters get_params() {
        return this.model_info.get_params();
    }

    public float error() {
        return (float)(((DeepLearningModelOutput)this._output).isClassifier() ? this.cm().err() : this.mse());
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((DeepLearningModelOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((DeepLearningModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((DeepLearningModelOutput)this._output).nfeatures());
            }
        }
        throw H2O.unimpl((String)("Invalid ModelCategory " + ((DeepLearningModelOutput)this._output).getModelCategory()));
    }

    public int compareTo(DeepLearningModel o) {
        if (((DeepLearningModelOutput)o._output).isClassifier() != ((DeepLearningModelOutput)this._output).isClassifier()) {
            throw new UnsupportedOperationException("Cannot compare classifier against regressor.");
        }
        if (((DeepLearningModelOutput)o._output).nclasses() != ((DeepLearningModelOutput)this._output).nclasses()) {
            throw new UnsupportedOperationException("Cannot compare models with different number of classes.");
        }
        return this.error() < o.error() ? -1 : (this.error() > o.error() ? 1 : 0);
    }

    public ConfusionMatrix cm() {
        DeepLearningScoring lasterror = this.last_scored();
        if (lasterror == null) {
            return null;
        }
        ConfusionMatrix cm = lasterror.validation || lasterror.num_folds > 0 ? lasterror.valid_confusion_matrix : lasterror.train_confusion_matrix;
        return cm;
    }

    public double mse() {
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.last_scored().validation || this.last_scored().num_folds > 0 ? this.last_scored().scored_valid._mse : this.last_scored().scored_train._mse;
    }

    public double logloss() {
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.last_scored().validation || this.last_scored().num_folds > 0 ? this.last_scored().scored_valid._logloss : this.last_scored().scored_train._logloss;
    }

    private TwoDimTable createScoringHistoryTable(DeepLearningScoring[] errors) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Training Speed");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Epochs");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Samples");
        colTypes.add("double");
        colFormat.add("%f");
        colHeaders.add("Training MSE");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (!((DeepLearningModelOutput)this._output).autoencoder) {
            colHeaders.add("Training R^2");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            colHeaders.add("Training LogLoss");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
            colHeaders.add("Training AUC");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial || ((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Multinomial) {
            colHeaders.add("Training Classification Error");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        if (this.get_params()._valid != null) {
            colHeaders.add("Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (!((DeepLearningModelOutput)this._output).autoencoder) {
                colHeaders.add("Validation R^2");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Validation LogLoss");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        } else if (this.get_params().getNumFolds() > 0) {
            colHeaders.add("Cross-Validation MSE");
            colTypes.add("double");
            colFormat.add("%.5f");
            if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
                colHeaders.add("Cross-Validation AUC");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                colHeaders.add("Cross-Validation Classification Error");
                colTypes.add("double");
                colFormat.add("%.5f");
            }
        }
        int rows = errors.length;
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i < errors.length; ++i) {
            DeepLearningScoring e = errors[i];
            int col = 0;
            assert (row < table.getRowDim());
            assert (col < table.getColDim());
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, (Object)fmt.print(this.start_time + e.training_time_ms));
            table.set(row, col++, (Object)PrettyPrint.msecs((long)e.training_time_ms, (boolean)true));
            table.set(row, col++, e.training_time_ms == 0L ? null : String.format("%.3f", e.training_samples / ((double)e.training_time_ms / 1000.0)) + " rows/sec");
            table.set(row, col++, (Object)e.epoch_counter);
            table.set(row, col++, (Object)e.training_samples);
            table.set(row, col++, (Object)(e.scored_train != null ? e.scored_train._mse : Double.NaN));
            if (!((DeepLearningModelOutput)this._output).autoencoder) {
                table.set(row, col++, (Object)(e.scored_train != null ? e.scored_train._r2 : Double.NaN));
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                table.set(row, col++, (Object)(e.scored_train != null ? e.scored_train._logloss : Double.NaN));
            }
            if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
                table.set(row, col++, (Object)(e.training_AUC != null ? e.training_AUC._auc : Double.NaN));
            }
            if (((DeepLearningModelOutput)this._output).isClassifier()) {
                table.set(row, col++, (Object)(e.scored_train != null ? e.scored_train._classError : Double.NaN));
            }
            if (this.get_params()._valid != null) {
                table.set(row, col++, (Object)(e.scored_valid != null ? e.scored_valid._mse : Double.NaN));
                if (!((DeepLearningModelOutput)this._output).autoencoder) {
                    table.set(row, col++, (Object)(e.scored_valid != null ? e.scored_valid._r2 : Double.NaN));
                }
                if (((DeepLearningModelOutput)this._output).isClassifier()) {
                    table.set(row, col++, (Object)(e.scored_valid != null ? e.scored_valid._logloss : Double.NaN));
                }
                if (((DeepLearningModelOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
                    table.set(row, col++, (Object)(e.validation_AUC != null ? e.validation_AUC._auc : Double.NaN));
                }
                if (((DeepLearningModelOutput)this._output).isClassifier()) {
                    table.set(row, col++, (Object)(e.scored_valid != null ? e.scored_valid._classError : Double.NaN));
                }
            } else if (this.get_params().getNumFolds() > 1) {
                throw H2O.unimpl((String)"n_folds >= 2 is not (yet) implemented.");
            }
            ++row;
        }
        return table;
    }

    private void makeWeightsBiases(Key destKey) {
        if (!this.model_info.get_params()._export_weights_and_biases) {
            ((DeepLearningModelOutput)this._output).weights = null;
            ((DeepLearningModelOutput)this._output).biases = null;
            ((DeepLearningModelOutput)this._output).normmul = null;
            ((DeepLearningModelOutput)this._output).normsub = null;
            ((DeepLearningModelOutput)this._output).normrespmul = null;
            ((DeepLearningModelOutput)this._output).normrespsub = null;
            ((DeepLearningModelOutput)this._output).catoffsets = null;
        } else {
            int i;
            ((DeepLearningModelOutput)this._output).weights = new Key[this.model_info.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                ((DeepLearningModelOutput)this._output).weights[i] = Key.makeUserHidden((Key)Key.make((String)(destKey + ".weights." + i)));
            }
            ((DeepLearningModelOutput)this._output).biases = new Key[this.model_info.get_params()._hidden.length + 1];
            for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                ((DeepLearningModelOutput)this._output).biases[i] = Key.makeUserHidden((Key)Key.make((String)(destKey + ".biases." + i)));
            }
            ((DeepLearningModelOutput)this._output).normmul = this.model_info.data_info._normMul;
            ((DeepLearningModelOutput)this._output).normsub = this.model_info.data_info._normSub;
            ((DeepLearningModelOutput)this._output).normrespmul = this.model_info.data_info._normRespMul;
            ((DeepLearningModelOutput)this._output).normrespsub = this.model_info.data_info._normRespSub;
            ((DeepLearningModelOutput)this._output).catoffsets = this.model_info.data_info._catOffsets;
        }
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModel cp, boolean store_best_model, DataInfo dataInfo) {
        super(destKey, (Model.Parameters)(parms == null ? (DeepLearningParameters)((DeepLearningParameters)cp._parms).clone() : parms), (Model.Output)((DeepLearningModelOutput)((DeepLearningModelOutput)cp._output).clone()));
        assert (this._parms != cp._parms);
        this.model_info = cp.model_info.deep_clone();
        if (store_best_model) {
            this.model_info.data_info = dataInfo.deep_clone();
        } else {
            this.model_info.data_info = dataInfo;
            if (parms != null) {
                assert (this._parms == parms);
                assert (((DeepLearningParameters)this._parms)._checkpoint == parms._checkpoint);
                assert (((DeepLearningParameters)this._parms)._checkpoint == cp._key);
            }
        }
        DKV.put((Keyed)dataInfo);
        assert (this.model_info().get_params() != cp.model_info().get_params());
        this.actual_best_model_key = cp.actual_best_model_key;
        this.start_time = cp.start_time;
        this.run_time = cp.run_time;
        this.training_rows = cp.training_rows;
        this.validation_rows = cp.validation_rows;
        this._bestError = cp._bestError;
        this.errors = (DeepLearningScoring[])cp.errors.clone();
        for (int i = 0; i < this.errors.length; ++i) {
            this.errors[i] = cp.errors[i].deep_clone();
        }
        ((DeepLearningModelOutput)this._output).errors = this.last_scored();
        this.makeWeightsBiases(destKey);
        ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
        ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        ((DeepLearningModelOutput)this._output)._names = dataInfo._adaptedFrame.names();
        ((DeepLearningModelOutput)this._output)._domains = dataInfo._adaptedFrame.domains();
        this._timeLastScoreEnter = System.currentTimeMillis();
        this._timeLastScoreStart = 0L;
        this._timeLastScoreEnd = 0L;
        this._timeLastPrintStart = 0L;
        assert (Arrays.equals(this._key._kb, destKey._kb));
    }

    public DeepLearningModel(Key destKey, DeepLearningParameters parms, DeepLearningModelOutput output, Frame train, Frame valid) {
        super(destKey, (Model.Parameters)parms, (Model.Output)output);
        boolean classification = train.lastVec().isEnum();
        DataInfo dinfo = DeepLearning.makeDataInfo(train, valid, (DeepLearningParameters)this._parms);
        ((DeepLearningModelOutput)this._output)._names = train._names;
        ((DeepLearningModelOutput)this._output)._domains = train.domains();
        ((DeepLearningModelOutput)this._output)._names = dinfo._adaptedFrame.names();
        ((DeepLearningModelOutput)this._output)._domains = dinfo._adaptedFrame.domains();
        DKV.put((Keyed)dinfo);
        this.model_info = new DeepLearningModelInfo(parms, dinfo, classification, train, valid);
        this.model_info_key = Key.makeUserHidden((Key)Key.make((H2ONode)H2O.SELF));
        this.actual_best_model_key = Key.makeUserHidden((Key)Key.make((H2ONode)H2O.SELF));
        if (parms.getNumFolds() != 0) {
            this.actual_best_model_key = null;
        }
        if (!parms._autoencoder) {
            this.errors = new DeepLearningScoring[1];
            this.errors[0] = new DeepLearningScoring();
            this.errors[0].validation = parms._valid != null;
            this.errors[0].num_folds = parms.getNumFolds();
            ((DeepLearningModelOutput)this._output).errors = this.last_scored();
            ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
            ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
        }
        this.makeWeightsBiases(destKey);
        this.run_time = 0L;
        this._timeLastScoreEnter = this.start_time = System.currentTimeMillis();
        assert (this._key.equals((Object)destKey));
        boolean fail = false;
        long byte_size = 0L;
        try {
            byte_size = new AutoBuffer().put((Freezable)this).buf().length;
        }
        catch (Throwable t) {
            fail = true;
        }
        if (byte_size > 0x10000000L || fail) {
            throw new IllegalArgumentException("Model is too large: PUBDEV-941");
        }
    }

    boolean doScoring(Frame ftrain, Frame ftest, Key job_key, Key progressKey, int iteration) {
        boolean keep_running;
        long now = System.currentTimeMillis();
        this.epoch_counter = (double)this.model_info().get_processed_total() / (double)this.training_rows;
        double time_last_iter_millis = Math.max(5L, now - this._timeLastScoreEnter);
        this.run_time = (long)((double)this.run_time + time_last_iter_millis);
        Job.Progress prog = (Job.Progress)DKV.getGet((Key)progressKey);
        float progress = prog == null ? 0.0f : prog.progress();
        String msg = "Iteration " + String.format("%,d", iteration) + ": Training at " + String.format("%,d", this.model_info().get_processed_total() * 1000L / this.run_time) + " samples/s..." + (progress == 0.0f ? "" : " Estimated time left: " + PrettyPrint.msecs((long)((long)((double)this.run_time * (1.0 - (double)progress) / (double)progress)), (boolean)true));
        ((Job)DKV.getGet((Key)job_key)).update(this.actual_train_samples_per_iteration);
        if (progressKey != null) {
            new Job.ProgressUpdate(msg).fork(progressKey);
        }
        try {
            if (H2O.CLOUD.size() > 1 && this.get_params()._train_samples_per_iteration == -2L && this.time_for_communication_us > 10000.0) {
                double comm_to_work_ratio = this.time_for_communication_us * 0.001 / time_last_iter_millis;
                double correction = this.get_params()._target_ratio_comm_to_comp / comm_to_work_ratio;
                this.actual_train_samples_per_iteration = (long)((double)this.actual_train_samples_per_iteration / correction);
                this.actual_train_samples_per_iteration = Math.max(1L, this.actual_train_samples_per_iteration);
            }
            this._timeLastScoreEnter = now;
            keep_running = this.epoch_counter < this.model_info().get_params()._epochs;
            long sinceLastScore = now - this._timeLastScoreStart;
            long sinceLastPrint = now - this._timeLastPrintStart;
            if (!keep_running || (double)sinceLastPrint > this.get_params()._score_interval * 1000.0) {
                this._timeLastPrintStart = now;
                if (!this.get_params()._quiet_mode) {
                    if (iteration >= 1) {
                        Log.info((Object[])new Object[]{"Map/Reduce iteration #" + String.format("%,d", iteration)});
                    }
                    Log.info((Object[])new Object[]{"Training time: " + PrettyPrint.msecs((long)this.run_time, (boolean)true) + ". Processed " + String.format("%,d", this.model_info().get_processed_total()) + " samples" + " (" + String.format("%.3f", this.epoch_counter) + " epochs)." + " Speed: " + String.format("%,d", 1000L * this.model_info().get_processed_total() / this.run_time) + " samples/sec.\n"});
                    Log.info((Object[])new Object[]{msg});
                }
            }
            if (!keep_running || (double)sinceLastScore > this.get_params()._score_interval * 1000.0 && (double)(this._timeLastScoreEnd - this._timeLastScoreStart) / (double)sinceLastScore < this.get_params()._score_duty_cycle) {
                ModelMetrics mtrain;
                if (progressKey != null) {
                    new Job.ProgressUpdate("Scoring on " + ftrain.numRows() + " training samples" + (ftest != null ? ", " + ftest.numRows() + " validation samples" : "")).fork(progressKey);
                }
                boolean printme = !this.get_params()._quiet_mode;
                this._timeLastScoreStart = now;
                if (this.get_params()._diagnostics) {
                    this.model_info().computeStats();
                }
                DeepLearningScoring err = new DeepLearningScoring();
                err.training_time_ms = this.run_time;
                err.epoch_counter = this.epoch_counter;
                err.training_samples = this.model_info().get_processed_total();
                err.validation = ftest != null;
                err.score_training_samples = ftrain.numRows();
                err.classification = ((DeepLearningModelOutput)this._output).isClassifier();
                if (this.get_params()._autoencoder) {
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the auto-encoder."});
                    }
                    Frame mse_frame = this.scoreAutoEncoder(ftrain, Key.make());
                    Vec l2 = mse_frame.anyVec();
                    Log.info((Object[])new Object[]{"Mean reconstruction error on training data: " + l2.mean() + "\n"});
                    mse_frame.delete();
                    ((DeepLearningModelOutput)this._output)._training_metrics = mtrain = ModelMetrics.getFromDKV((Model)this, (Frame)ftrain);
                    err.scored_train = new ScoreKeeper(mtrain);
                    if (ftest != null) {
                        ModelMetrics mtest;
                        mse_frame = this.scoreAutoEncoder(ftest, Key.make());
                        l2 = mse_frame.anyVec();
                        Log.info((Object[])new Object[]{"Mean reconstruction error on validation data: " + l2.mean() + "\n"});
                        mse_frame.delete();
                        ((DeepLearningModelOutput)this._output)._validation_metrics = mtest = ModelMetrics.getFromDKV((Model)this, (Frame)ftest);
                        err.scored_valid = new ScoreKeeper(mtest);
                    }
                } else {
                    ModelMetricsBinomial mm;
                    String m;
                    if (printme) {
                        Log.info((Object[])new Object[]{"Scoring the model."});
                    }
                    if ((m = this.model_info().toString()).length() > 0) {
                        Log.info((Object[])new Object[]{m});
                    }
                    Frame trainPredict = this.score(ftrain);
                    trainPredict.delete();
                    ((DeepLearningModelOutput)this._output)._training_metrics = mtrain = ModelMetrics.getFromDKV((Model)this, (Frame)ftrain);
                    err.scored_train = new ScoreKeeper(mtrain);
                    ModelMetrics mtest = null;
                    ModelMetricsSupervised mm1 = (ModelMetricsSupervised)ModelMetrics.getFromDKV((Model)this, (Frame)ftrain);
                    if (mm1 instanceof ModelMetricsBinomial) {
                        mm = (ModelMetricsBinomial)mm1;
                        err.training_AUC = mm._auc;
                        err.train_confusion_matrix = mm.cm();
                    } else if (mm1 instanceof ModelMetricsMultinomial) {
                        mm = (ModelMetricsMultinomial)mm1;
                        err.train_confusion_matrix = mm.cm();
                    }
                    ((DeepLearningModelOutput)this._output)._training_metrics._description = ftrain.numRows() != this.training_rows ? "Metrics reported on temporary training frame with " + ftrain.numRows() + " samples" : (ftrain._key != null && ftrain._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) training frame" : "Metrics reported on full training frame");
                    if (ftest != null) {
                        Frame validPred = this.score(ftest);
                        validPred.delete();
                        if (ftest != null) {
                            ((DeepLearningModelOutput)this._output)._validation_metrics = mtest = ModelMetrics.getFromDKV((Model)this, (Frame)ftest);
                            err.scored_valid = new ScoreKeeper(mtest);
                        }
                        if (mtest != null) {
                            ModelMetricsBinomial mm2;
                            if (mtest instanceof ModelMetricsBinomial) {
                                mm2 = (ModelMetricsBinomial)mtest;
                                err.validation_AUC = mm2._auc;
                                err.valid_confusion_matrix = mm2.cm();
                            } else if (mtest instanceof ModelMetricsMultinomial) {
                                mm2 = (ModelMetricsMultinomial)mtest;
                                err.valid_confusion_matrix = mm2.cm();
                            }
                            if (ftest.numRows() != this.validation_rows) {
                                ((DeepLearningModelOutput)this._output)._validation_metrics._description = "Metrics reported on temporary validation frame with " + ftest.numRows() + " samples";
                                if (this.get_params()._score_validation_sampling == DeepLearningParameters.ClassSamplingMethod.Stratified) {
                                    ((DeepLearningModelOutput)this._output)._validation_metrics._description = ((DeepLearningModelOutput)this._output)._validation_metrics._description + " (stratified sampling)";
                                }
                            } else {
                                ((DeepLearningModelOutput)this._output)._validation_metrics._description = ftest._key != null && ftest._key.toString().contains("chunks") ? "Metrics reported on temporary (load-balanced) validation frame" : "Metrics reported on full validation frame";
                            }
                        }
                    }
                }
                if (this.get_params()._variable_importances) {
                    if (!this.get_params()._quiet_mode) {
                        Log.info((Object[])new Object[]{"Computing variable importances."});
                    }
                    float[] vi = this.model_info().computeVariableImportances();
                    err.variable_importances = new VarImp(vi, Arrays.copyOfRange(this.model_info().data_info().coefNames(), 0, vi.length));
                }
                this._timeLastScoreEnd = System.currentTimeMillis();
                err.scoring_time = System.currentTimeMillis() - now;
                if (this.errors == null) {
                    this.errors = new DeepLearningScoring[]{err};
                } else {
                    DeepLearningScoring[] err2 = new DeepLearningScoring[this.errors.length + 1];
                    System.arraycopy(this.errors, 0, err2, 0, this.errors.length);
                    err2[err2.length - 1] = err;
                    this.errors = err2;
                }
                ((DeepLearningModelOutput)this._output).errors = this.last_scored();
                this.makeWeightsBiases(this._key);
                Timer t = new Timer();
                if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
                    int i;
                    for (i = 0; i < ((DeepLearningModelOutput)this._output).weights.length; ++i) {
                        this.model_info.get_weights(i).toFrame(((DeepLearningModelOutput)this._output).weights[i]);
                    }
                    for (i = 0; i < ((DeepLearningModelOutput)this._output).biases.length; ++i) {
                        this.model_info.get_biases(i).toFrame(((DeepLearningModelOutput)this._output).biases[i]);
                    }
                    if (!((DeepLearningParameters)this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Writing weights and biases to Frames took " + (double)t.time() / 1000.0 + " seconds."});
                    }
                }
                ((DeepLearningModelOutput)this._output)._scoring_history = this.createScoringHistoryTable(this.errors);
                ((DeepLearningModelOutput)this._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)this.last_scored().variable_importances);
                ((DeepLearningModelOutput)this._output)._model_summary = this.model_info.createSummaryTable();
                if (!this.get_params()._autoencoder) {
                    if (this.actual_best_model_key != null && this.get_params()._overwrite_with_best_model && (DKV.get((Key)this.actual_best_model_key) != null && (this.error() < ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).error() || !Arrays.equals(this.model_info().units, ((DeepLearningModel)DKV.get((Key)this.actual_best_model_key).get()).model_info().units)) || DKV.get((Key)this.actual_best_model_key) == null && this.error() < this._bestError)) {
                        if (!this.get_params()._quiet_mode) {
                            Log.info((Object[])new Object[]{"Error reduced from " + this._bestError + " to " + this.error() + "."});
                        }
                        this._bestError = this.error();
                        this.putMeAsBestModel(this.actual_best_model_key);
                    }
                    if (keep_running && printme) {
                        for (String s : this.toString().split("\n")) {
                            Log.info((Object[])new Object[]{s});
                        }
                    }
                    if (printme) {
                        Log.info((Object[])new Object[]{"Time taken for scoring and diagnostics: " + PrettyPrint.msecs((long)err.scoring_time, (boolean)true)});
                    }
                }
            }
            if (this.model_info().unstable()) {
                Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
                keep_running = false;
            } else if (((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().scored_train._classError <= this.get_params()._classification_stop || !((DeepLearningModelOutput)this._output).isClassifier() && this.last_scored().scored_train._mse <= this.get_params()._regression_stop) {
                Log.info((Object[])new Object[]{"Achieved requested predictive accuracy on the training data. Model building completed."});
                keep_running = false;
            }
            this.update(job_key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return keep_running;
    }

    public String toString() {
        return ((DeepLearningModelOutput)this._output).toString();
    }

    protected Frame scoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        if (!this.get_params()._autoencoder) {
            return super.scoreImpl(orig, adaptedFr, destination_key);
        }
        final int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        Frame adaptFrm = new Frame(adaptedFr);
        for (int c = 0; c < len; ++c) {
            adaptFrm.add(prefix + coefnames[c], adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length];
                float[] preds = new float[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    float[] p = DeepLearningModel.this.score_autoencoder(chks, row, tmp, preds, neurons);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningModelOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 1.0, 0.0);
    }

    public double[] score0(double[] data, double[] preds, double weight, double offset) {
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info);
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, null, false, null, offset);
        float[] out = neurons[neurons.length - 1]._a.raw();
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            assert (preds.length == out.length + 1);
            for (int i = 0; i < preds.length - 1; ++i) {
                preds[i + 1] = out[i];
                if (!Double.isNaN(preds[i + 1])) continue;
                throw new RuntimeException("Predicted class probability NaN!");
            }
            preds[0] = -1.0;
        } else {
            preds[0] = this.model_info().data_info()._normRespMul != null ? (double)out[0] / this.model_info().data_info()._normRespMul[0] + this.model_info().data_info()._normRespSub[0] : (double)out[0];
            if (Double.isNaN(preds[0])) {
                throw new RuntimeException("Predicted regression target NaN!");
            }
        }
        return preds;
    }

    public Frame scoreAutoEncoder(Frame frame, Key destination_key) {
        if (!this.get_params()._autoencoder) {
            throw new H2OIllegalArgumentException("Only for AutoEncoder Deep Learning model.", "");
        }
        final int len = ((DeepLearningModelOutput)this._output)._names.length;
        Frame adaptFrm = new Frame(frame);
        Vec v0 = adaptFrm.anyVec().makeZero();
        Scope.enter();
        this.adaptTestForTrain(adaptFrm, true, false);
        adaptFrm.add("Reconstruction.MSE", v0);
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    chks[len].set(row, DeepLearningModel.this.score_autoencoder(tmp, null, neurons));
                }
            }
        }.doAll(adaptFrm);
        Scope.exit((Key[])new Key[0]);
        Frame res = adaptFrm.extractFrame(len, adaptFrm.numCols());
        res = new Frame(destination_key, res.names(), res.vecs());
        DKV.put((Keyed)res);
        ((DeepLearningModelOutput)this._output).addModelMetrics((ModelMetrics)new ModelMetricsAutoEncoder((Model)this, frame, res.vecs()[0].mean()));
        return res;
    }

    public Frame score(Frame fr, String destination_key) {
        Frame adaptFr;
        if (!((DeepLearningParameters)this._parms)._autoencoder) {
            return super.score(fr, destination_key);
        }
        this.adaptTestForTrain(adaptFr, true, (adaptFr = new Frame(fr)).find(((DeepLearningModelOutput)this._output).responseName()) != -1);
        Frame output = this.scoreImpl(fr, adaptFr, destination_key);
        DeepLearningModel.cleanup_adapt((Frame)adaptFr, (Frame)fr);
        return output;
    }

    public Frame scoreDeepFeatures(Frame frame, final int layer) {
        int ridx;
        if (layer < 0 || layer >= this.model_info().get_params()._hidden.length) {
            throw new H2OIllegalArgumentException("hidden layer (index) to extract must be between 0 and " + (this.model_info().get_params()._hidden.length - 1), "");
        }
        final int len = ((DeepLearningModelOutput)this._output).nfeatures();
        Vec resp = null;
        if (this.isSupervised() && (ridx = frame.find(((DeepLearningModelOutput)this._output).responseName())) != -1) {
            frame = new Frame(frame);
            resp = frame.vecs()[ridx];
            frame.remove(ridx);
        }
        Frame adaptFrm = new Frame(frame);
        final int features = this.model_info().get_params()._hidden[layer];
        Vec[] vecs = adaptFrm.anyVec().makeZeros(features);
        Scope.enter();
        DeepLearningModel.adaptTestForTrain((String[])((DeepLearningModelOutput)this._output)._names, (String)((DeepLearningModelOutput)this._output).weightsName(), (String)((DeepLearningModelOutput)this._output).offsetName(), null, (String[][])((DeepLearningModelOutput)this._output)._domains, (Frame)adaptFrm, (double)((DeepLearningParameters)this._parms).missingColumnsType(), (boolean)true, (boolean)true);
        for (int j = 0; j < features; ++j) {
            adaptFrm.add("DF.L" + (layer + 1) + ".C" + (j + 1), vecs[j]);
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[len];
                Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(DeepLearningModel.this.model_info);
                for (int row = 0; row < chks[0]._len; ++row) {
                    for (int i = 0; i < len; ++i) {
                        tmp[i] = chks[i].atd(row);
                    }
                    ((Neurons.Input)neurons[0]).setInput(-1L, tmp);
                    DeepLearningTask.step(-1L, neurons, DeepLearningModel.this.model_info, null, false, null, 0.0);
                    float[] out = neurons[layer + 1]._a.raw();
                    for (int c = 0; c < features; ++c) {
                        chks[((DeepLearningModelOutput)DeepLearningModel.this._output)._names.length + c].set(row, out[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((DeepLearningModelOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame ret = adaptFrm.extractFrame(x, y);
        if (resp != null) {
            ret.prepend(((DeepLearningModelOutput)this._output).responseName(), resp);
        }
        Scope.exit((Key[])new Key[0]);
        return ret;
    }

    private float[] score_autoencoder(Chunk[] chks, int row_in_chunk, double[] tmp, float[] preds, Neurons[] neurons) {
        assert (this.get_params()._autoencoder);
        assert (tmp.length == ((DeepLearningModelOutput)this._output)._names.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        this.score_autoencoder(tmp, preds, neurons);
        return preds;
    }

    private double score_autoencoder(double[] data, float[] preds, Neurons[] neurons) {
        assert (this.model_info().get_params()._autoencoder);
        if (this.model_info().unstable()) {
            Log.warn((Object[])new Object[]{"Job was aborted due to observed numerical instability (exponential growth).\nTry a different initial distribution, a bounded activation function or adding\nregularization with L1, L2 or max_w2 and/or use a smaller learning rate or faster annealing."});
            throw new UnsupportedOperationException("Trying to predict with an unstable model.");
        }
        ((Neurons.Input)neurons[0]).setInput(-1L, data);
        DeepLearningTask.step(-1L, neurons, this.model_info, null, false, null, 0.0);
        float[] in = neurons[0]._a.raw();
        float[] out = neurons[neurons.length - 1]._a.raw();
        assert (in.length == out.length);
        double l2 = 0.0;
        for (int i = 0; i < in.length; ++i) {
            l2 += Math.pow(out[i] - in[i], 2.0);
        }
        l2 /= (double)in.length;
        if (preds != null) {
            this.model_info().data_info().unScaleNumericals(out, out);
            System.arraycopy(out, 0, preds, 0, out.length);
        }
        return l2;
    }

    public double calcOutlierThreshold(Vec mse, double quantile) {
        Frame mse_frame = new Frame(Key.make(), new String[]{"Reconstruction.MSE"}, new Vec[]{mse});
        DKV.put((Key)mse_frame._key, (Iced)mse_frame);
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        parms._train = mse_frame._key;
        parms._probs = new double[]{quantile};
        Quantile job = new Quantile(parms).trainModel();
        QuantileModel kmm = (QuantileModel)job.get();
        job.remove();
        double q = ((QuantileModel.QuantileOutput)kmm._output)._quantiles[0][0];
        kmm.delete();
        DKV.remove((Key)mse_frame._key);
        return q;
    }

    private void putMeAsBestModel(Key bestModelKey) {
        DeepLearningModelInfo eamodel;
        DeepLearningModel bestModel = new DeepLearningModel(bestModelKey, null, this, true, this.model_info().data_info());
        DKV.put((Key)bestModel._key, (Iced)bestModel);
        if (this.model_info().get_params()._elastic_averaging && (eamodel = (DeepLearningModelInfo)DKV.getGet((Key)this.model_info.elasticAverageModelInfoKey())) != null) {
            DKV.put((Key)bestModel.model_info().elasticAverageModelInfoKey(), (Iced)eamodel);
        }
        assert (DKV.get((Key)bestModelKey) != null);
        assert (bestModel.compareTo(this) <= 0);
    }

    public void delete() {
        if (((DeepLearningModelOutput)this._output).weights != null && ((DeepLearningModelOutput)this._output).biases != null) {
            for (Key k : ((DeepLearningModelOutput)this._output).weights) {
                if (DKV.getGet((Key)k) == null) continue;
                ((Frame)DKV.getGet((Key)k)).delete();
            }
            for (Key k : ((DeepLearningModelOutput)this._output).biases) {
                if (DKV.getGet((Key)k) == null) continue;
                ((Frame)DKV.getGet((Key)k)).delete();
            }
        }
        DKV.remove((Key)this.model_info().data_info()._key);
        this.deleteElasticAverageModels();
        super.delete();
    }

    void deleteElasticAverageModels() {
        if (this.model_info().get_params()._elastic_averaging) {
            DKV.remove((Key)this.model_info().elasticAverageModelInfoKey());
            for (H2ONode node : H2O.CLOUD._memary) {
                DKV.remove((Key)this.model_info().localModelInfoKey(node));
            }
        }
    }

    void delete_xval_models() {
    }

    private String getHeader() {
        assert (this.get_params()._autoencoder);
        StringBuilder sb = new StringBuilder();
        int len = this.model_info().data_info().fullN();
        String prefix = "reconstr_";
        assert (this.model_info().data_info()._responses == 0);
        String[] coefnames = this.model_info().data_info().coefNames();
        assert (len == coefnames.length);
        for (int c = 0; c < len; ++c) {
            if (c > 0) {
                sb.append(",");
            }
            sb.append(prefix + coefnames[c]);
        }
        return sb.toString();
    }

    protected SB toJavaInit(SB sb, SB fileContextSB) {
        String colInfoClazz;
        int i;
        sb = super.toJavaInit(sb, fileContextSB);
        String mname = JCodeGen.toJavaId((String)this._key.toString());
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this.model_info());
        DeepLearningParameters p = this.model_info.get_params();
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((DeepLearningModelOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + (p._autoencoder ? neurons[neurons.length - 1].units : ((DeepLearningModelOutput)this._output).nclasses()) + "; }").nl();
        if (this.model_info().data_info()._nums > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"NUMS", (double[])new double[this.model_info().data_info()._nums], (String)"Workspace for storing numerical input variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMMUL", (double[])this.model_info().data_info()._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMSUB", (double[])this.model_info().data_info()._normSub, (String)"Standardization/Normalization offset for numerical variables.");
        }
        if (this.model_info().data_info()._cats > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"CATS", (int[])new int[this.model_info().data_info()._cats], (String)"Workspace for storing categorical input variables.");
        }
        JCodeGen.toStaticVar((SB)sb, (String)"CATOFFSETS", (int[])this.model_info().data_info()._catOffsets, (String)"Workspace for categorical offsets.");
        if (this.model_info().data_info()._normRespMul != null) {
            JCodeGen.toStaticVar((SB)sb, (String)"NORMRESPMUL", (double[])this.model_info().data_info()._normRespMul, (String)"Standardization/Normalization scaling factor for response.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMRESPSUB", (double[])this.model_info().data_info()._normRespSub, (String)"Standardization/Normalization offset for response.");
        }
        if (p._hidden_dropout_ratios != null) {
            JCodeGen.toStaticVar((SB)sb, (String)"HIDDEN_DROPOUT_RATIOS", (double[])p._hidden_dropout_ratios, (String)"Hidden layer dropout ratios.");
        }
        int[] layers = new int[neurons.length];
        for (i = 0; i < neurons.length; ++i) {
            layers[i] = neurons[i].units;
        }
        JCodeGen.toStaticVar((SB)sb, (String)"NEURONS", (int[])layers, (String)"Number of neurons for each layer.");
        if (this.get_params()._autoencoder) {
            sb.i(1).p("public int getPredsSize() { return " + this.model_info.units[this.model_info.units.length - 1] + "; }").nl();
            sb.i(1).p("public boolean isAutoEncoder() { return true; }").nl();
            sb.i(1).p("public String getHeader() { return \"" + this.getHeader() + "\"; }").nl();
        }
        sb.i(1).p("// Storage for neuron activation values.").nl();
        sb.i(1).p("public static final float[][] ACTIVATION = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            colInfoClazz = mname + "_Activation_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            fileContextSB.i().p("// Neuron activation values for ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, (float[])new float[layers[i]]);
        }
        sb.i(1).p("};").nl();
        sb.i(1).p("// Neuron bias values.").nl();
        sb.i(1).p("public static final float[][] BIAS = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            float[] bias;
            colInfoClazz = mname + "_Bias_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            fileContextSB.i().p("// Neuron bias values for ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            float[] fArray = bias = i == 0 ? null : new float[this.model_info().get_biases(i - 1).size()];
            if (i > 0) {
                for (int j = 0; j < bias.length; ++j) {
                    bias[j] = this.model_info().get_biases(i - 1).get(j);
                }
            }
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, (float[])bias);
        }
        sb.i(1).p("};").nl();
        sb.i(1).p("// Connecting weights between neurons.").nl();
        sb.i(1).p("public static final float[][] WEIGHT = new float[][] {").nl();
        for (i = 0; i < neurons.length; ++i) {
            float[] weights;
            colInfoClazz = mname + "_Weight_" + i;
            sb.i(2).p("/* ").p(neurons[i].getClass().getSimpleName()).p(" */ ");
            sb.p(colInfoClazz).p(".VALUES");
            if (i != neurons.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (i > 0) {
                fileContextSB.i().p("// Neuron weights connecting ").p(neurons[i - 1].getClass().getSimpleName()).p(" and ").p(neurons[i].getClass().getSimpleName()).p(" layer").nl();
            }
            float[] fArray = weights = i == 0 ? null : new float[this.model_info().get_weights(i - 1).rows() * this.model_info().get_weights(i - 1).cols()];
            if (i > 0) {
                int rows = this.model_info().get_weights(i - 1).rows();
                int cols = this.model_info().get_weights(i - 1).cols();
                for (int j = 0; j < rows; ++j) {
                    for (int k = 0; k < cols; ++k) {
                        weights[j * cols + k] = this.model_info().get_weights(i - 1).get(j, k);
                    }
                }
            }
            JCodeGen.toClassWithArray((SB)fileContextSB, null, (String)colInfoClazz, weights);
        }
        sb.i(1).p("};").nl();
        return sb;
    }

    protected boolean toJavaCheckTooBig() {
        return (double)this.model_info.size() > 1000000.0;
    }

    protected void toJavaPredictBody(SB bodySb, SB classCtxSb, SB fileCtxSb) {
        SB model = new SB();
        DeepLearningParameters p = this.model_info.get_params();
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = this.model_info().data_info()._cats;
        int nums = this.model_info().data_info()._nums;
        if (nums > 0) {
            bodySb.i().p("java.util.Arrays.fill(NUMS,0f);").nl();
        }
        if (cats > 0) {
            bodySb.i().p("java.util.Arrays.fill(CATS,0);").nl();
        }
        bodySb.i().p("int i = 0, ncats = 0;").nl();
        if (cats > 0) {
            bodySb.i().p("for(; i<" + cats + "; ++i) {").nl();
            bodySb.i(1).p("if (!Double.isNaN(data[i])) {").nl();
            bodySb.i(2).p("int c = (int) data[i];").nl();
            if (this.model_info().data_info()._useAllFactorLevels) {
                bodySb.i(2).p("CATS[ncats++] = c + CATOFFSETS[i];").nl();
            } else {
                bodySb.i(2).p("if (c != 0) CATS[ncats++] = c + CATOFFSETS[i] - 1;").nl();
            }
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        }
        if (nums > 0) {
            bodySb.i().p("final int n = data.length;").nl();
            bodySb.i().p("for(; i<n; ++i) {").nl();
            bodySb.i(1).p("NUMS[i" + (cats > 0 ? "-" + cats : "") + "] = Double.isNaN(data[i]) ? 0 : ");
            if (this.model_info().data_info()._normMul != null) {
                bodySb.p("(data[i] - NORMSUB[i" + (cats > 0 ? "-" + cats : "") + "])*NORMMUL[i" + (cats > 0 ? "-" + cats : "") + "];").nl();
            } else {
                bodySb.p("data[i];").nl();
            }
            bodySb.i(0).p("}").nl();
        }
        bodySb.i().p("java.util.Arrays.fill(ACTIVATION[0],0);").nl();
        if (cats > 0) {
            bodySb.i().p("for (i=0; i<ncats; ++i) ACTIVATION[0][CATS[i]] = 1f;").nl();
        }
        if (nums > 0) {
            bodySb.i().p("for (i=0; i<NUMS.length; ++i) {").nl();
            bodySb.i(1).p("ACTIVATION[0][CATOFFSETS[CATOFFSETS.length-1] + i] = Double.isNaN(NUMS[i]) ? 0f : (float) NUMS[i];").nl();
            bodySb.i().p("}").nl();
        }
        boolean tanh = p._activation == DeepLearningParameters.Activation.Tanh || p._activation == DeepLearningParameters.Activation.TanhWithDropout;
        boolean relu = p._activation == DeepLearningParameters.Activation.Rectifier || p._activation == DeepLearningParameters.Activation.RectifierWithDropout;
        boolean maxout = p._activation == DeepLearningParameters.Activation.Maxout || p._activation == DeepLearningParameters.Activation.MaxoutWithDropout;
        String stopping = p._autoencoder ? "(i<=ACTIVATION.length-1)" : "(i<ACTIVATION.length-1)";
        bodySb.i().p("for (i=1; i<ACTIVATION.length; ++i) {").nl();
        bodySb.i(1).p("java.util.Arrays.fill(ACTIVATION[i],0f);").nl();
        if (maxout) {
            bodySb.i(1).p("float rmax = 0;").nl();
            bodySb.i(1).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            bodySb.i(2).p("final int cols = ACTIVATION[i-1].length;").nl();
            bodySb.i(2).p("float cmax = Float.NEGATIVE_INFINITY;").nl();
            bodySb.i(2).p("for (int c=0; c<cols; ++c) {").nl();
            bodySb.i(3).p("if " + stopping + " cmax = Math.max(ACTIVATION[i-1][c] * WEIGHT[i][r*cols+c], cmax);").nl();
            bodySb.i(3).p("else ACTIVATION[i][r] += ACTIVATION[i-1][c] * WEIGHT[i][r*cols+c];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("if " + stopping + " ACTIVATION[i][r] = Float.isInfinite(cmax) ? 0f : cmax;").nl();
            bodySb.i(2).p("ACTIVATION[i][r] += BIAS[i][r];").nl();
            bodySb.i(2).p("if " + stopping + " rmax = Math.max(rmax, ACTIVATION[i][r]);").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            bodySb.i(3).p("if (rmax > 1 ) ACTIVATION[i][r] /= rmax;").nl();
        } else {
            bodySb.i(1).p("int cols = ACTIVATION[i-1].length;").nl();
            bodySb.i(1).p("int rows = ACTIVATION[i].length;").nl();
            bodySb.i(1).p("int extra=cols-cols%8;").nl();
            bodySb.i(1).p("int multiple = (cols/8)*8-1;").nl();
            bodySb.i(1).p("int idx = 0;").nl();
            bodySb.i(1).p("float[] a = WEIGHT[i];").nl();
            bodySb.i(1).p("float[] x = ACTIVATION[i-1];").nl();
            bodySb.i(1).p("float[] y = BIAS[i];").nl();
            bodySb.i(1).p("float[] res = ACTIVATION[i];").nl();
            bodySb.i(1).p("for (int row=0; row<rows; ++row) {").nl();
            bodySb.i(2).p("float psum0 = 0, psum1 = 0, psum2 = 0, psum3 = 0, psum4 = 0, psum5 = 0, psum6 = 0, psum7 = 0;").nl();
            bodySb.i(2).p("for (int col = 0; col < multiple; col += 8) {").nl();
            bodySb.i(3).p("int off = idx + col;").nl();
            bodySb.i(3).p("psum0 += a[off    ] * x[col    ];").nl();
            bodySb.i(3).p("psum1 += a[off + 1] * x[col + 1];").nl();
            bodySb.i(3).p("psum2 += a[off + 2] * x[col + 2];").nl();
            bodySb.i(3).p("psum3 += a[off + 3] * x[col + 3];").nl();
            bodySb.i(3).p("psum4 += a[off + 4] * x[col + 4];").nl();
            bodySb.i(3).p("psum5 += a[off + 5] * x[col + 5];").nl();
            bodySb.i(3).p("psum6 += a[off + 6] * x[col + 6];").nl();
            bodySb.i(3).p("psum7 += a[off + 7] * x[col + 7];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("res[row] += psum0 + psum1 + psum2 + psum3;").nl();
            bodySb.i(2).p("res[row] += psum4 + psum5 + psum6 + psum7;").nl();
            bodySb.i(2).p("for (int col = extra; col < cols; col++)").nl();
            bodySb.i(3).p("res[row] += a[idx + col] * x[col];").nl();
            bodySb.i(2).p("res[row] += y[row];").nl();
            bodySb.i(2).p("idx += cols;").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i(1).p("if " + stopping + " {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; ++r) {").nl();
            if (tanh) {
                bodySb.i(3).p("ACTIVATION[i][r] = 1f - 2f / (1f + (float)Math.exp(2*ACTIVATION[i][r]));").nl();
            } else if (relu) {
                bodySb.i(3).p("ACTIVATION[i][r] = Math.max(0f, ACTIVATION[i][r]);").nl();
            }
        }
        if (p._hidden_dropout_ratios != null) {
            bodySb.i(3).p("if (i<ACTIVATION.length-1) {").nl();
            bodySb.i(4).p("ACTIVATION[i][r] *= HIDDEN_DROPOUT_RATIOS[i-1];").nl();
            bodySb.i(3).p("}").nl();
        }
        bodySb.i(2).p("}").nl();
        if (!maxout) {
            bodySb.i(1).p("}").nl();
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("float max = ACTIVATION[i][0];").nl();
            bodySb.i(2).p("for (int r=1; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (ACTIVATION[i][r]>max) max = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("float scale = 0f;").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("ACTIVATION[i][r] = (float) Math.exp(ACTIVATION[i][r] - max);").nl();
            bodySb.i(3).p("scale += ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Float.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, predicted NaN.\");").nl();
            bodySb.i(3).p("ACTIVATION[i][r] /= scale;").nl();
            bodySb.i(3).p("preds[r+1] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else if (!p._autoencoder) {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            if (this.model_info().data_info()._normRespMul != null) {
                bodySb.i(2).p("preds[1] = (ACTIVATION[i][0] / NORMRESPMUL[0] + NORMRESPSUB[0]);").nl();
            } else {
                bodySb.i(2).p("preds[1] = ACTIVATION[i][0];").nl();
            }
            bodySb.i(2).p("if (Double.isNaN(preds[1])) throw new RuntimeException(\"Predicted regression target NaN!\");").nl();
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        } else {
            bodySb.i(1).p("if (i == ACTIVATION.length-1) {").nl();
            bodySb.i(2).p("for (int r=0; r<ACTIVATION[i].length; r++) {").nl();
            bodySb.i(3).p("if (Float.isNaN(ACTIVATION[i][r]))").nl();
            bodySb.i(4).p("throw new RuntimeException(\"Numerical instability, reconstructed NaN.\");").nl();
            bodySb.i(3).p("preds[r] = ACTIVATION[i][r];").nl();
            bodySb.i(2).p("}").nl();
            if (this.model_info().data_info()._nums > 0) {
                int ns = this.model_info().data_info().numStart();
                bodySb.i(2).p("for (int k=" + ns + "; k<" + this.model_info().data_info().fullN() + "; ++k) {").nl();
                bodySb.i(3).p("preds[k] = preds[k] / NORMMUL[k-" + ns + "] + NORMSUB[k-" + ns + "];").nl();
                bodySb.i(2).p("}").nl();
            }
            bodySb.i(1).p("}").nl();
            bodySb.i().p("}").nl();
        }
        fileCtxSb.p(model);
        if (((DeepLearningModelOutput)this._output).autoencoder) {
            return;
        }
        if (((DeepLearningModelOutput)this._output).isClassifier()) {
            if (((DeepLearningParameters)this._parms)._balance_classes) {
                bodySb.ip("hex.genmodel.GenModel.correctProbabilities(preds, PRIOR_CLASS_DISTRIB, MODEL_CLASS_DISTRIB);").nl();
            }
            bodySb.ip("preds[0] = hex.genmodel.GenModel.getPrediction(preds, data, " + this.defaultThreshold() + ");").nl();
        } else {
            bodySb.ip("preds[0] = (float)preds[1];").nl();
        }
    }

    protected long checksum_impl() {
        return super.checksum_impl() * this.model_info.checksum_impl();
    }

    public static class DeepLearningScoring
    extends Iced {
        public double epoch_counter;
        public double training_samples;
        public long training_time_ms;
        boolean validation;
        int num_folds;
        public long score_training_samples;
        public long score_validation_samples;
        public boolean classification;
        VarImp variable_importances;
        ScoreKeeper scored_train = new ScoreKeeper();
        ScoreKeeper scored_valid = new ScoreKeeper();
        public ConfusionMatrix train_confusion_matrix;
        public ConfusionMatrix valid_confusion_matrix;
        public AUC2 training_AUC;
        public AUC2 validation_AUC;
        public long scoring_time;

        DeepLearningScoring deep_clone() {
            AutoBuffer ab = new AutoBuffer();
            this.write(ab);
            ab.flipForReading();
            return (DeepLearningScoring)new DeepLearningScoring().read(ab);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.scored_train != null) {
                sb.append("Training " + this.scored_train.toString());
            }
            if (this.classification) {
                sb.append("Training " + this.train_confusion_matrix.table().toString(1));
            }
            if (this.validation || this.num_folds > 0) {
                if (this.num_folds > 0) {
                    sb.append("\nDoing " + this.num_folds + "-fold cross-validation:");
                }
                if (this.scored_valid != null) {
                    sb.append("Validation " + this.scored_valid.toString());
                }
                if (this.classification) {
                    sb.append("Validation " + this.valid_confusion_matrix.table().toString(1));
                }
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    public static class DeepLearningModelOutput
    extends Model.Output {
        final boolean autoencoder;
        DeepLearningScoring errors;
        Key[] weights;
        Key[] biases;
        double[] normmul;
        double[] normsub;
        double[] normrespmul;
        double[] normrespsub;
        int[] catoffsets;
        public TwoDimTable _variable_importances;

        public DeepLearningModelOutput() {
            this.autoencoder = false;
        }

        public DeepLearningModelOutput(DeepLearning b) {
            super((ModelBuilder)b);
            this.autoencoder = ((DeepLearningParameters)b._parms)._autoencoder;
            assert (b.isSupervised() == !this.autoencoder);
        }

        public ModelCategory getModelCategory() {
            return this.autoencoder ? ModelCategory.AutoEncoder : super.getModelCategory();
        }

        public boolean isSupervised() {
            return !this.autoencoder;
        }
    }
}

