/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.FrameTask;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningParameters;
import hex.deeplearning.Neurons;
import java.util.Arrays;
import java.util.Random;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.util.Log;
import water.util.RandomUtils;

public class DeepLearningTask
extends FrameTask<DeepLearningTask> {
    private final boolean _training;
    private DeepLearningModelInfo _localmodel;
    private DeepLearningModelInfo _sharedmodel;
    transient Neurons[] _neurons;
    transient Random _dropout_rng;
    int _chunk_node_count = 1;
    static long _lastWarn;
    static long _warnCount;

    public final DeepLearningModelInfo model_info() {
        assert (this._sharedmodel != null);
        return this._sharedmodel;
    }

    public DeepLearningTask(Key jobKey, DeepLearningModelInfo inputModel, float fraction, int iteration) {
        super(jobKey, inputModel.data_info(), inputModel.get_params()._seed + inputModel.get_processed_global(), iteration);
        assert (inputModel.get_processed_local() == 0L);
        this._training = true;
        this._sharedmodel = inputModel;
        this._useFraction = fraction;
        this._shuffle = this.model_info().get_params()._shuffle_training_data;
    }

    @Override
    protected void setupLocal() {
        assert (this._localmodel == null);
        super.setupLocal();
        if (this.model_info().get_params()._elastic_averaging) {
            this._localmodel = (DeepLearningModelInfo)DKV.getGet((Key)this._sharedmodel.localModelInfoKey(H2O.SELF));
            if (this._localmodel != null) {
                if (!Arrays.equals(this._localmodel.units, this._sharedmodel.units)) {
                    this._localmodel = this._sharedmodel.deep_clone();
                } else {
                    this._localmodel.set_params(this._sharedmodel.get_params());
                    this._localmodel.set_processed_global(this._sharedmodel.get_processed_global());
                }
            } else {
                this._localmodel = this._sharedmodel.deep_clone();
                this._sharedmodel = null;
            }
        } else {
            this._localmodel = this._sharedmodel;
            this._sharedmodel = null;
        }
        this._localmodel.set_processed_local(0L);
    }

    @Override
    protected boolean chunkInit() {
        if ((float)this._localmodel.get_processed_local() >= this._useFraction * (float)this._fr.numRows()) {
            return false;
        }
        this._neurons = DeepLearningTask.makeNeuronsForTraining(this._localmodel);
        this._dropout_rng = RandomUtils.getRNG((long[])new long[]{System.currentTimeMillis()});
        return true;
    }

    @Override
    public final void processRow(long seed, DataInfo.Row r) {
        assert (!r.isSparse()) : "Deep learning does not support sparse rows.";
        seed = this._localmodel.get_params()._reproducible ? (seed += this._localmodel.get_processed_global()) : this._dropout_rng.nextLong();
        this._localmodel.checkMissingCats(r.binIds);
        ((Neurons.Input)this._neurons[0]).setInput(seed, r.numVals, r.nBins, r.binIds);
        DeepLearningTask.step(seed, this._neurons, this._localmodel, this._localmodel.get_params()._elastic_averaging ? this._sharedmodel : null, this._training, r.response, r.offset);
    }

    @Override
    protected void chunkDone(long n) {
        if (this._training) {
            this._localmodel.add_processed_local(n);
        }
    }

    protected void postLocal() {
        if (this._localmodel.get_params()._elastic_averaging) {
            DKV.put((Key)this._localmodel.localModelInfoKey(H2O.SELF), (Iced)this._localmodel);
        }
        this._sharedmodel = null;
        super.postLocal();
    }

    public void reduce(DeepLearningTask other) {
        if (this._localmodel != null && other._localmodel != null && other._localmodel.get_processed_local() > 0L && other._localmodel != this._localmodel) {
            if (this._localmodel.get_processed_local() == 0L) {
                this._localmodel = other._localmodel;
                this._chunk_node_count = other._chunk_node_count;
            } else {
                this._localmodel.add(other._localmodel);
                this._chunk_node_count += other._chunk_node_count;
            }
            if (other._localmodel.unstable()) {
                this._localmodel.set_unstable();
            }
        }
    }

    protected void postGlobal() {
        DeepLearningParameters dlp = this._localmodel.get_params();
        if (H2O.CLOUD.size() > 1 && !dlp._replicate_training_data) {
            long now = System.currentTimeMillis();
            if (this._chunk_node_count < H2O.CLOUD.size() && now - _lastWarn > 5000L && _warnCount < 3L) {
                Log.warn((Object[])new Object[]{H2O.CLOUD.size() - this._chunk_node_count + " node(s) (out of " + H2O.CLOUD.size() + ") are not contributing to model updates. Consider setting replicate_training_data to true or using a larger training dataset (or fewer H2O nodes)."});
                _lastWarn = now;
                ++_warnCount;
            }
        }
        assert ((!dlp._replicate_training_data || H2O.CLOUD.size() == 1) == !this._run_local);
        if (!this._run_local) {
            this._localmodel.add_processed_global(this._localmodel.get_processed_local());
            this._localmodel.set_processed_local(0L);
            if (this._chunk_node_count > 1) {
                this._localmodel.div(this._chunk_node_count);
            }
            if (this._localmodel.get_params()._elastic_averaging) {
                this._sharedmodel = DeepLearningModelInfo.timeAverage(this._localmodel);
            }
        } else {
            this._sharedmodel = this._localmodel;
        }
        if (this._sharedmodel == null) {
            this._sharedmodel = this._localmodel;
        }
        this._localmodel = null;
    }

    public static Neurons[] makeNeuronsForTraining(DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, true);
    }

    public static Neurons[] makeNeuronsForTesting(DeepLearningModelInfo minfo) {
        return DeepLearningTask.makeNeurons(minfo, false);
    }

    private static Neurons[] makeNeurons(DeepLearningModelInfo minfo, boolean training) {
        int i;
        DataInfo dinfo = minfo.data_info();
        DeepLearningParameters params = minfo.get_params();
        int[] h = params._hidden;
        Neurons[] neurons = new Neurons[h.length + 2];
        neurons[0] = new Neurons.Input(minfo.units[0], dinfo);
        block8: for (i = 0; i < h.length + (params._autoencoder ? 1 : 0); ++i) {
            int n = params._autoencoder && i == h.length ? minfo.units[0] : h[i];
            switch (params._activation) {
                case Tanh: {
                    neurons[i + 1] = new Neurons.Tanh(n);
                    continue block8;
                }
                case TanhWithDropout: {
                    neurons[i + 1] = params._autoencoder && i == h.length ? new Neurons.Tanh(n) : new Neurons.TanhDropout(n);
                    continue block8;
                }
                case Rectifier: {
                    neurons[i + 1] = new Neurons.Rectifier(n);
                    continue block8;
                }
                case RectifierWithDropout: {
                    neurons[i + 1] = params._autoencoder && i == h.length ? new Neurons.Rectifier(n) : new Neurons.RectifierDropout(n);
                    continue block8;
                }
                case Maxout: {
                    neurons[i + 1] = new Neurons.Maxout(n);
                    continue block8;
                }
                case MaxoutWithDropout: {
                    neurons[i + 1] = params._autoencoder && i == h.length ? new Neurons.Maxout(n) : new Neurons.MaxoutDropout(n);
                }
            }
        }
        if (!params._autoencoder) {
            neurons[neurons.length - 1] = minfo._classification ? new Neurons.Softmax(minfo.units[minfo.units.length - 1]) : new Neurons.Linear(1);
        }
        for (i = 0; i < neurons.length; ++i) {
            neurons[i].init(neurons, i, params, minfo, training);
            neurons[i]._input = neurons[0];
        }
        return neurons;
    }

    public static void step(long seed, Neurons[] neurons, DeepLearningModelInfo minfo, DeepLearningModelInfo consensus_minfo, boolean training, double[] responses, double offset) {
        try {
            int i;
            for (i = 1; i < neurons.length - 1; ++i) {
                neurons[i].fprop(seed, training);
            }
            if (minfo.get_params()._autoencoder) {
                neurons[neurons.length - 1].fprop(seed, training);
                if (training) {
                    for (i = neurons.length - 1; i > 0; --i) {
                        neurons[i].bprop();
                    }
                }
            } else {
                if (consensus_minfo != null) {
                    for (i = 1; i < neurons.length; ++i) {
                        neurons[i]._wEA = consensus_minfo.get_weights(i - 1);
                        neurons[i]._bEA = consensus_minfo.get_biases(i - 1);
                    }
                }
                if (minfo._classification) {
                    ((Neurons.Softmax)neurons[neurons.length - 1]).fprop();
                    if (training) {
                        int target_label;
                        for (i = 1; i < neurons.length - 1; ++i) {
                            Arrays.fill(neurons[i]._e.raw(), 0.0f);
                        }
                        assert ((double)((int)responses[0]) == responses[0]);
                        if (Double.isNaN(responses[0])) {
                            target_label = Integer.MAX_VALUE;
                        } else {
                            assert ((double)((int)responses[0]) == responses[0]);
                            target_label = (int)responses[0];
                        }
                        ((Neurons.Softmax)neurons[neurons.length - 1]).bprop(target_label);
                    }
                } else {
                    ((Neurons.Linear)neurons[neurons.length - 1]).fprop();
                    if (offset > 0.0) {
                        double mul = minfo.data_info()._normRespMul[0];
                        double sub = minfo.data_info()._normRespSub[0];
                        neurons[neurons.length - 1]._a.add(0, (float)((offset - sub) * mul));
                    }
                    if (training) {
                        for (int i2 = 1; i2 < neurons.length - 1; ++i2) {
                            Arrays.fill(neurons[i2]._e.raw(), 0.0f);
                        }
                        float target_value = Double.isNaN(responses[0]) ? Neurons.missing_real_value.floatValue() : (float)responses[0];
                        ((Neurons.Linear)neurons[neurons.length - 1]).bprop(target_value);
                    }
                }
                if (training) {
                    for (int i3 = neurons.length - 2; i3 > 0; --i3) {
                        neurons[i3].bprop();
                    }
                }
            }
        }
        catch (Throwable ex) {
            Log.warn((Object[])new Object[]{ex.getMessage()});
            minfo.set_unstable();
            throw ex;
        }
    }
}

