/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.glrm.GLRM;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.pca.PCAModel;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.PCAV99;
import hex.svd.SVD;
import hex.svd.SVDModel;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class PCA
extends ModelBuilder<PCAModel, PCAModel.PCAParameters, PCAModel.PCAOutput> {
    private transient int _ncolExp;

    public ModelBuilderSchema schema() {
        return new PCAV99();
    }

    public Job<PCAModel> trainModel() {
        return this.start(new PCADriver(), 1L);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    protected void checkMemoryFootPrint() {
        long max_mem;
        HeartBeat hb = H2O.SELF._heartbeat;
        double p = this._train.degreesOfFreedom();
        long mem_usage = (long)((double)hb._cpus_allowed * p * p * 8.0 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0));
        if (mem_usage > (max_mem = hb.get_max_mem())) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
            this.cancel(msg);
        }
    }

    public PCA(PCAModel.PCAParameters parms) {
        super("PCA", (Model.Parameters)parms);
        this.init(false);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((PCAModel.PCAParameters)this._parms)._loading_name == null || ((PCAModel.PCAParameters)this._parms)._loading_name.length() == 0) {
            ((PCAModel.PCAParameters)this._parms)._loading_name = "PCALoading_" + Key.rand();
        }
        if (((PCAModel.PCAParameters)this._parms)._max_iterations < 1 || (double)((PCAModel.PCAParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (this._train == null) {
            return;
        }
        if (this._train.numCols() < 2) {
            this.error("_train", "_train must have more than one column");
        }
        this._ncolExp = this._train.numColsExp(((PCAModel.PCAParameters)this._parms)._use_all_factor_levels, false);
        int k_min = (int)Math.min((long)this._ncolExp, this._train.numRows());
        if (((PCAModel.PCAParameters)this._parms)._k < 1 || ((PCAModel.PCAParameters)this._parms)._k > k_min) {
            this.error("_k", "_k must be between 1 and " + k_min);
        }
        if (!((PCAModel.PCAParameters)this._parms)._use_all_factor_levels && ((PCAModel.PCAParameters)this._parms)._pca_method == PCAModel.PCAParameters.Method.GLRM) {
            this.error("_use_all_factor_levels", "GLRM only implemented for _use_all_factor_levels = true");
        }
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    public static double[][] formGram(double[][] x, boolean transpose) {
        int k;
        int j;
        int i;
        if (x == null) {
            return null;
        }
        int dim_in = transpose ? x[0].length : x.length;
        int dim_out = transpose ? x.length : x[0].length;
        double[][] xgram = new double[dim_out][dim_out];
        if (transpose) {
            for (i = 0; i < dim_in; ++i) {
                for (j = 0; j < dim_out; ++j) {
                    for (k = j; k < dim_out; ++k) {
                        double[] dArray = xgram[j];
                        int n = k;
                        dArray[n] = dArray[n] + x[j][i] * x[k][i];
                    }
                }
            }
        } else {
            for (i = 0; i < dim_in; ++i) {
                for (j = 0; j < dim_out; ++j) {
                    for (k = j; k < dim_out; ++k) {
                        double[] dArray = xgram[j];
                        int n = k;
                        dArray[n] = dArray[n] + x[i][j] * x[i][k];
                    }
                }
            }
        }
        for (i = 0; i < dim_in; ++i) {
            for (j = 0; j < dim_out; ++j) {
                for (k = 0; k < j; ++k) {
                    xgram[j][k] = xgram[k][j];
                }
            }
        }
        return xgram;
    }

    public static double[][] formGram(double[][] x) {
        return PCA.formGram(x, false);
    }

    public class EmbeddedGLRM
    extends GLRM {
        private final Key sharedProgressKey;
        private final Key glrmJobKey;

        public EmbeddedGLRM(Key glrmJobKey, Key sharedProgressKey, GLRMModel.GLRMParameters parms) {
            super(parms);
            this.sharedProgressKey = sharedProgressKey;
            this.glrmJobKey = glrmJobKey;
        }

        protected Key createProgressKey() {
            return this.sharedProgressKey != null ? this.sharedProgressKey : super.createProgressKey();
        }

        protected boolean deleteProgressKey() {
            return false;
        }

        public boolean isRunning() {
            return super.isRunning() && ((Job)this.glrmJobKey.get()).isRunning();
        }
    }

    public class EmbeddedSVD
    extends SVD {
        private final Key sharedProgressKey;
        private final Key pcaJobKey;

        public EmbeddedSVD(Key pcaJobKey, Key sharedProgressKey, SVDModel.SVDParameters parms) {
            super(parms);
            this.sharedProgressKey = sharedProgressKey;
            this.pcaJobKey = pcaJobKey;
        }

        protected Key createProgressKey() {
            return this.sharedProgressKey != null ? this.sharedProgressKey : super.createProgressKey();
        }

        protected boolean deleteProgressKey() {
            return false;
        }

        public boolean isRunning() {
            return super.isRunning() && ((Job)this.pcaJobKey.get()).isRunning();
        }
    }

    class PCADriver
    extends H2O.H2OCountedCompleter<PCADriver> {
        PCADriver() {
        }

        protected void buildTables(PCAModel pca, String[] rowNames) {
            Object[] colTypes = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Object[] colFormats = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            String[] colHeaders = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            assert (rowNames.length == ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw.length);
            for (int i = 0; i < colHeaders.length; ++i) {
                colHeaders[i] = "PC" + String.valueOf(i + 1);
            }
            ((PCAModel.PCAOutput)pca._output)._eigenvectors = new TwoDimTable("Rotation", null, rowNames, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[((PCAModel.PCAOutput)pca._output)._eigenvectors_raw.length][], ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw);
            double[] vars = new double[((PCAModel.PCAOutput)pca._output)._std_deviation.length];
            for (int i = 0; i < vars.length; ++i) {
                vars[i] = ((PCAModel.PCAOutput)pca._output)._std_deviation[i] * ((PCAModel.PCAOutput)pca._output)._std_deviation[i];
            }
            double[] prop_var = new double[vars.length];
            double[] cum_var = new double[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                prop_var[i] = vars[i] / ((PCAModel.PCAOutput)pca._output)._total_variance;
                cum_var[i] = i == 0 ? prop_var[0] : cum_var[i - 1] + prop_var[i];
            }
            ((PCAModel.PCAOutput)pca._output)._pc_importance = new TwoDimTable("Importance of components", null, new String[]{"Standard deviation", "Proportion of Variance", "Cumulative Proportion"}, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[3][], (double[][])new double[][]{((PCAModel.PCAOutput)pca._output)._std_deviation, prop_var, cum_var});
        }

        protected void computeStatsFillModel(PCAModel pca, SVDModel svd) {
            if (((PCAModel.PCAParameters)PCA.this._parms)._keep_loading) {
                ((PCAModel.PCAOutput)pca._output)._loading_key = ((SVDModel.SVDOutput)svd._output)._u_key;
            }
            ((PCAModel.PCAOutput)pca._output)._normSub = ((SVDModel.SVDOutput)svd._output)._normSub;
            ((PCAModel.PCAOutput)pca._output)._normMul = ((SVDModel.SVDOutput)svd._output)._normMul;
            ((PCAModel.PCAOutput)pca._output)._permutation = ((SVDModel.SVDOutput)svd._output)._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = ((SVDModel.SVDOutput)svd._output)._nnums;
            ((PCAModel.PCAOutput)pca._output)._ncats = ((SVDModel.SVDOutput)svd._output)._ncats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = ((SVDModel.SVDOutput)svd._output)._catOffsets;
            ((PCAModel.PCAOutput)pca._output)._std_deviation = ArrayUtils.mult((double[])((SVDModel.SVDOutput)svd._output)._d, (double)(1.0 / Math.sqrt((double)((SVDModel.SVDOutput)svd._output)._nobs - 1.0)));
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = ((SVDModel.SVDOutput)svd._output)._v;
            ((PCAModel.PCAOutput)pca._output)._total_variance = ((SVDModel.SVDOutput)svd._output)._total_variance;
            this.buildTables(pca, ((SVDModel.SVDOutput)svd._output)._names_expanded);
        }

        protected void computeStatsFillModel(PCAModel pca, GLRMModel glrm) {
            assert (((GLRMModel.GLRMParameters)glrm._parms)._recover_svd);
            ((PCAModel.PCAOutput)pca._output)._normSub = ((GLRMModel.GLRMOutput)glrm._output)._normSub;
            ((PCAModel.PCAOutput)pca._output)._normMul = ((GLRMModel.GLRMOutput)glrm._output)._normMul;
            ((PCAModel.PCAOutput)pca._output)._permutation = ((GLRMModel.GLRMOutput)glrm._output)._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = ((GLRMModel.GLRMOutput)glrm._output)._nnums;
            ((PCAModel.PCAOutput)pca._output)._ncats = ((GLRMModel.GLRMOutput)glrm._output)._ncats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = ((GLRMModel.GLRMOutput)glrm._output)._catOffsets;
            double dfcorr = 1.0 / Math.sqrt((double)PCA.this._train.numRows() - 1.0);
            ((PCAModel.PCAOutput)pca._output)._std_deviation = new double[((PCAModel.PCAParameters)PCA.this._parms)._k];
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = ((GLRMModel.GLRMOutput)glrm._output)._eigenvectors;
            ((PCAModel.PCAOutput)pca._output)._total_variance = 0.0;
            for (int i = 0; i < ((GLRMModel.GLRMOutput)glrm._output)._singular_vals.length; ++i) {
                ((PCAModel.PCAOutput)pca._output)._std_deviation[i] = dfcorr * ((GLRMModel.GLRMOutput)glrm._output)._singular_vals[i];
                ((PCAModel.PCAOutput)pca._output)._total_variance += ((PCAModel.PCAOutput)pca._output)._std_deviation[i] * ((PCAModel.PCAOutput)pca._output)._std_deviation[i];
            }
            this.buildTables(pca, ((GLRMModel.GLRMOutput)glrm._output)._names_expanded);
        }

        protected void computeStatsFillModel(PCAModel pca, DataInfo dinfo, SingularValueDecomposition svd, Gram gram, long nobs) {
            double[] dArray = ((PCAModel.PCAOutput)pca._output)._normSub = dinfo._normSub == null ? new double[dinfo._nums] : dinfo._normSub;
            if (dinfo._normMul == null) {
                ((PCAModel.PCAOutput)pca._output)._normMul = new double[dinfo._nums];
                Arrays.fill(((PCAModel.PCAOutput)pca._output)._normMul, 1.0);
            } else {
                ((PCAModel.PCAOutput)pca._output)._normMul = dinfo._normMul;
            }
            ((PCAModel.PCAOutput)pca._output)._permutation = dinfo._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = dinfo._nums;
            ((PCAModel.PCAOutput)pca._output)._ncats = dinfo._cats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = dinfo._catOffsets;
            double dfcorr = (double)nobs / ((double)nobs - 1.0);
            double[] sval = svd.getSingularValues();
            ((PCAModel.PCAOutput)pca._output)._std_deviation = new double[((PCAModel.PCAParameters)PCA.this._parms)._k];
            for (int i = 0; i < ((PCAModel.PCAParameters)PCA.this._parms)._k; ++i) {
                sval[i] = dfcorr * sval[i];
                ((PCAModel.PCAOutput)pca._output)._std_deviation[i] = Math.sqrt(sval[i]);
            }
            double[][] eigvec = svd.getV().getArray();
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = new double[eigvec.length][((PCAModel.PCAParameters)PCA.this._parms)._k];
            for (int i = 0; i < eigvec.length; ++i) {
                System.arraycopy(eigvec[i], 0, ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw[i], 0, ((PCAModel.PCAParameters)PCA.this._parms)._k);
            }
            ((PCAModel.PCAOutput)pca._output)._total_variance = dfcorr * gram.diagSum();
            this.buildTables(pca, dinfo.coefNames());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block31: {
                PCAModel model = null;
                DataInfo dinfo = null;
                Object xinfo = null;
                Object x = null;
                try {
                    PCA.this.init(true);
                    ((PCAModel.PCAParameters)PCA.this._parms).read_lock_frames((Job)PCA.this);
                    if (PCA.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + PCA.this.validationErrors());
                    }
                    model = new PCAModel(PCA.this.dest(), (PCAModel.PCAParameters)PCA.this._parms, new PCAModel.PCAOutput(PCA.this));
                    model.delete_and_lock(PCA.this._key);
                    if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.GramSVD) {
                        dinfo = new DataInfo(Key.make(), PCA.this._train, null, 0, ((PCAModel.PCAParameters)PCA.this._parms)._use_all_factor_levels, ((PCAModel.PCAParameters)PCA.this._parms)._transform, DataInfo.TransformType.NONE, true, false, false, false, false);
                        DKV.put((Key)dinfo._key, (Iced)dinfo);
                        Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask(this.self(), dinfo).doAll(dinfo._adaptedFrame);
                        Gram gram = gtsk._gram;
                        assert (gram.fullN() == PCA.this._ncolExp);
                        Matrix gramJ = new Matrix(gtsk._gram.getXX());
                        SingularValueDecomposition svdJ = gramJ.svd();
                        this.computeStatsFillModel(model, dinfo, svdJ, gram, gtsk._nobs);
                    } else if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.Power) {
                        SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
                        parms._train = ((PCAModel.PCAParameters)PCA.this._parms)._train;
                        parms._ignored_columns = ((PCAModel.PCAParameters)PCA.this._parms)._ignored_columns;
                        parms._ignore_const_cols = ((PCAModel.PCAParameters)PCA.this._parms)._ignore_const_cols;
                        parms._score_each_iteration = ((PCAModel.PCAParameters)PCA.this._parms)._score_each_iteration;
                        parms._use_all_factor_levels = ((PCAModel.PCAParameters)PCA.this._parms)._use_all_factor_levels;
                        parms._transform = ((PCAModel.PCAParameters)PCA.this._parms)._transform;
                        parms._nv = ((PCAModel.PCAParameters)PCA.this._parms)._k;
                        parms._max_iterations = ((PCAModel.PCAParameters)PCA.this._parms)._max_iterations;
                        parms._seed = ((PCAModel.PCAParameters)PCA.this._parms)._seed;
                        parms._only_v = false;
                        parms._u_name = ((PCAModel.PCAParameters)PCA.this._parms)._loading_name;
                        parms._keep_u = ((PCAModel.PCAParameters)PCA.this._parms)._keep_loading;
                        SVDModel svd = null;
                        EmbeddedSVD job = null;
                        try {
                            job = new EmbeddedSVD(PCA.this._key, PCA.this._progressKey, parms);
                            svd = (SVDModel)job.trainModel().get();
                            if (job.isCancelledOrCrashed()) {
                                PCA.this.cancel();
                            }
                        }
                        finally {
                            if (job != null) {
                                job.remove();
                            }
                            if (svd != null) {
                                svd.remove();
                            }
                        }
                        this.computeStatsFillModel(model, svd);
                    } else if (((PCAModel.PCAParameters)PCA.this._parms)._pca_method == PCAModel.PCAParameters.Method.GLRM) {
                        GLRMModel.GLRMParameters parms = new GLRMModel.GLRMParameters();
                        parms._train = ((PCAModel.PCAParameters)PCA.this._parms)._train;
                        parms._ignored_columns = ((PCAModel.PCAParameters)PCA.this._parms)._ignored_columns;
                        parms._ignore_const_cols = ((PCAModel.PCAParameters)PCA.this._parms)._ignore_const_cols;
                        parms._score_each_iteration = ((PCAModel.PCAParameters)PCA.this._parms)._score_each_iteration;
                        parms._transform = ((PCAModel.PCAParameters)PCA.this._parms)._transform;
                        parms._k = ((PCAModel.PCAParameters)PCA.this._parms)._k;
                        parms._max_iterations = ((PCAModel.PCAParameters)PCA.this._parms)._max_iterations;
                        parms._seed = ((PCAModel.PCAParameters)PCA.this._parms)._seed;
                        parms._recover_svd = true;
                        parms._loss = GLRMModel.GLRMParameters.Loss.L2;
                        parms._gamma_x = 0.0;
                        parms._gamma_y = 0.0;
                        GLRMModel glrm = null;
                        EmbeddedGLRM job = null;
                        try {
                            job = new EmbeddedGLRM(PCA.this._key, PCA.this._progressKey, parms);
                            glrm = (GLRMModel)job.trainModel().get();
                            if (job.isCancelledOrCrashed()) {
                                PCA.this.cancel();
                            }
                        }
                        finally {
                            if (job != null) {
                                job.remove();
                            }
                            if (glrm != null) {
                                ((Frame)((GLRMModel.GLRMParameters)glrm._parms)._loading_key.get()).delete();
                                glrm.remove();
                            }
                        }
                        this.computeStatsFillModel(model, glrm);
                    }
                    model.update(this.self());
                    PCA.this.update(1L);
                    PCA.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)PCA.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block31;
                    }
                    t.printStackTrace();
                    PCA.this.failed(t);
                    throw t;
                }
                finally {
                    ((PCAModel.PCAParameters)PCA.this._parms).read_unlock_frames((Job)PCA.this);
                    if (model != null) {
                        model.unlock(PCA.this._key);
                    }
                    if (dinfo != null) {
                        dinfo.remove();
                    }
                    if (xinfo != null) {
                        xinfo.remove();
                    }
                    if (x != null && !((PCAModel.PCAParameters)PCA.this._parms)._keep_loading) {
                        x.delete();
                    }
                }
            }
            this.tryComplete();
        }

        Key self() {
            return PCA.this._key;
        }
    }

    public static enum Initialization {
        SVD,
        PlusPlus,
        User;

    }
}

