/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.genmodel.GenModel;
import hex.tree.SharedTree;
import hex.tree.SharedTreeModel;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;

public class Score
extends MRTask<Score> {
    final SharedTree _bldr;
    final boolean _is_train;
    final boolean _oob;
    final ModelCategory _mcat;
    ModelMetrics.MetricBuilder _mb;

    public Score(SharedTree bldr, boolean is_train, boolean oob, ModelCategory mcat) {
        this._bldr = bldr;
        this._is_train = is_train;
        this._oob = oob;
        this._mcat = mcat;
    }

    public void map(Chunk[] chks) {
        Chunk ys = this._bldr.chk_resp(chks);
        Object m = this._bldr._model;
        C0DChunk weightsChunk = ((Model)m)._output.hasWeights() ? chks[((Model)m)._output.weightsIdx()] : new C0DChunk(1.0, chks[0]._len);
        C0DChunk offsetChunk = ((Model)m)._output.hasOffset() ? chks[((Model)m)._output.offsetIdx()] : new C0DChunk(0.0, chks[0]._len);
        int nclass = this._bldr.nclasses();
        String[] domain = this._bldr.vresponse().domain();
        int oobColIdx = this._bldr.idx_oobt();
        this._mb = m.makeMetricBuilder(domain);
        double[] cdists = this._mb._work;
        double[] tmp = this._is_train ? null : new double[this._bldr._ncols];
        float[] val = new float[1];
        for (int row = 0; row < ys._len; ++row) {
            double weight;
            if (ys.isNA(row) || this._oob && chks[oobColIdx].at8(row) == 0L || (weight = weightsChunk.atd(row)) == 0.0) continue;
            double offset = offsetChunk.atd(row);
            if (this._is_train) {
                this._bldr.score2(chks, weight, offset, cdists, row);
            } else {
                m.score0(chks, weight, offset, row, tmp, cdists);
            }
            if (nclass > 1) {
                cdists[0] = GenModel.getPrediction((double[])cdists, (double[])tmp, (double)m.defaultThreshold());
            }
            val[0] = (float)ys.atd(row);
            this._mb.perRow(cdists, val, weight, offset, m);
        }
    }

    public void reduce(Score t) {
        this._mb.reduce(t._mb);
    }

    ModelMetricsSupervised makeModelMetrics(SharedTreeModel model, Frame fr) {
        return (ModelMetricsSupervised)this._mb.makeModelMetrics((Model)model, fr);
    }
}

