/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.Grid;
import hex.Model;
import hex.ModelBuilder;
import hex.tree.SharedTreeGrid;
import hex.tree.drf.DRF;
import hex.tree.drf.DRFModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class DRFGrid
extends SharedTreeGrid<DRFModel.DRFParameters, DRFGrid> {
    public static final String MODEL_NAME = "DRF";
    private static final String[] HYPER_NAMES = ArrayUtils.append((String[])SharedTreeGrid.HYPER_NAMES, (String[])new String[]{"_mtries", "_sample_rate"});
    private static final double[] HYPER_DEFAULTS = ArrayUtils.append((double[])SharedTreeGrid.HYPER_DEFAULTS, (double[])new double[]{-1.0, 0.6666666865348816});

    @Override
    protected String modelName() {
        return MODEL_NAME;
    }

    protected String[] hyperNames() {
        return HYPER_NAMES;
    }

    protected double[] hyperDefaults() {
        return HYPER_DEFAULTS;
    }

    protected double suggestedNextHyperValue(int h, Model m, double[] hyperLimits) {
        throw H2O.unimpl();
    }

    protected ModelBuilder createBuilder(DRFModel.DRFParameters params) {
        return new DRF(params);
    }

    @Override
    protected DRFModel.DRFParameters applyHypers(DRFModel.DRFParameters params, double[] hypers) {
        DRFModel.DRFParameters p = super.applyHypers(params, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        p._mtries = (int)hypers[slen];
        p._sample_rate = (float)hypers[slen + 1];
        return p;
    }

    public double[] getHypers(DRFModel.DRFParameters params) {
        double[] hypers = new double[HYPER_NAMES.length];
        super.getHypers(params, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        hypers[slen] = params._mtries;
        hypers[slen + 1] = params._sample_rate;
        return hypers;
    }

    private DRFGrid(Key key, Frame fr) {
        super(key, fr);
    }

    public static DRFGrid get(Frame fr) {
        Key k = Grid.keyName((String)MODEL_NAME, (Frame)fr);
        DRFGrid kmg = (DRFGrid)DKV.getGet((Key)k);
        if (kmg != null) {
            return kmg;
        }
        kmg = new DRFGrid(k, fr);
        DKV.put((Keyed)kmg);
        return kmg;
    }

    public DRFGrid() {
        super(null, null);
    }
}

