/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import java.util.Arrays;
import java.util.Random;
import water.DKV;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.ArrayUtils;
import water.util.RandomUtils;

public abstract class FrameTask<T extends FrameTask<T>>
extends MRTask<T> {
    protected transient DataInfo _dinfo;
    final Key _dinfoKey;
    final int[] _activeCols;
    protected final Key _jobKey;
    protected float _useFraction = 1.0f;
    private final long _seed;
    protected boolean _shuffle = false;
    private final int _iteration;

    public DataInfo dinfo() {
        return this._dinfo;
    }

    public FrameTask(Key jobKey, DataInfo dinfo) {
        this(jobKey, dinfo, -557122578L, -1);
    }

    public FrameTask(Key jobKey, DataInfo dinfo, long seed, int iteration) {
        this(jobKey, dinfo._key, dinfo._activeCols, seed, iteration);
    }

    private FrameTask(Key jobKey, Key dinfoKey, int[] activeCols, long seed, int iteration) {
        super(null);
        assert (dinfoKey == null || DKV.get((Key)dinfoKey) != null);
        this._jobKey = jobKey;
        this._dinfoKey = dinfoKey;
        this._activeCols = activeCols;
        this._seed = seed;
        this._iteration = iteration;
    }

    protected void setupLocal() {
        DataInfo dinfo = (DataInfo)DKV.get((Key)this._dinfoKey).get();
        this._dinfo = this._activeCols == null ? dinfo : dinfo.filterExpandedColumns(this._activeCols);
    }

    protected void closeLocal() {
        this._dinfo = null;
    }

    protected void processRow(long gid, DataInfo.Row r) {
        throw new RuntimeException("should've been overridden!");
    }

    protected void processRow(long gid, DataInfo.Row r, NewChunk[] outputs) {
        throw new RuntimeException("should've been overridden!");
    }

    protected boolean chunkInit() {
        return true;
    }

    protected void chunkDone(long n) {
    }

    public final void map(Chunk[] chunks, NewChunk[] outputs) {
        if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
            throw new Job.JobCancelledException();
        }
        int nrows = chunks[0]._len;
        long offset = chunks[0].start();
        boolean doWork = this.chunkInit();
        if (!doWork) {
            return;
        }
        boolean obs_weights = this._dinfo._weights && !this._fr.vecs()[this._dinfo.weightChunkId()].isConst();
        double global_weight_sum = obs_weights ? this._fr.vecs()[this._dinfo.weightChunkId()].mean() * (double)this._fr.numRows() : 0.0;
        DataInfo.Row row = this._dinfo.newDenseRow();
        double[] weight_map = null;
        double relative_chunk_weight = 1.0;
        if (obs_weights) {
            weight_map = new double[nrows];
            double weight_sum = 0.0;
            for (int i = 0; i < nrows; ++i) {
                row = this._dinfo.extractDenseRow(chunks, i, row);
                weight_map[i] = weight_sum += row.weight;
                assert (i == 0 || row.weight == 0.0 || weight_map[i] > weight_map[i - 1]);
            }
            if (weight_sum > 0.0) {
                ArrayUtils.div((double[])weight_map, (double)weight_sum);
                relative_chunk_weight = global_weight_sum * (double)nrows / (double)this._fr.numRows() / weight_sum;
            } else {
                return;
            }
        }
        int repeats = (int)Math.ceil((double)this._useFraction * relative_chunk_weight);
        float fraction = (float)((double)this._useFraction * relative_chunk_weight) / (float)repeats;
        assert ((double)fraction <= 1.0);
        boolean sample = (double)fraction < 0.999 || obs_weights || this._shuffle;
        Random skip_rng = sample ? RandomUtils.getRNG((long[])new long[]{(-8704322056524490956L + this._seed + offset) * ((long)this._iteration + -7484065362112007133L)}) : null;
        long num_processed_rows = 0L;
        for (int rep = 0; rep < repeats; ++rep) {
            for (int row_idx = 0; row_idx < nrows; ++row_idx) {
                int r;
                int n = r = sample ? -1 : 0;
                if (sample && !obs_weights && skip_rng.nextDouble() > (double)fraction) continue;
                if (obs_weights && num_processed_rows % 2L == 0L) {
                    double key = skip_rng.nextDouble();
                    r = Arrays.binarySearch(weight_map, 0, nrows, key);
                    if (r < 0) {
                        r = -r - 1;
                    }
                    assert (r == 0 || weight_map[r] > weight_map[r - 1]);
                } else if (r == -1) {
                    do {
                        r = skip_rng.nextInt(nrows);
                    } while (obs_weights && (r == 0 && weight_map[0] == 0.0 || r > 0 && weight_map[r] == weight_map[r - 1]));
                } else {
                    assert (!obs_weights);
                    r = row_idx;
                }
                assert (r >= 0 && r <= nrows);
                row = this._dinfo.extractDenseRow(chunks, r, row);
                if (!row.bad) {
                    assert (row.weight > 0.0);
                    long seed = offset + (long)(rep * nrows) + (long)r;
                    if (outputs != null && outputs.length > 0) {
                        this.processRow(seed++, row, outputs);
                    } else {
                        this.processRow(seed++, row);
                    }
                }
                ++num_processed_rows;
            }
        }
        assert (fraction != 1.0f || num_processed_rows == (long)(repeats * nrows));
        this.chunkDone(num_processed_rows);
    }
}

