/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.deeplearning.DeepLearningParameters;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.Neurons;
import hex.deeplearning.Storage;
import java.util.Arrays;
import java.util.Random;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class DeepLearningModelInfo
extends Iced {
    public TwoDimTable summaryTable;
    public DataInfo data_info;
    private Storage.DenseRowMatrix[] dense_row_weights;
    private Storage.DenseColMatrix[] dense_col_weights;
    private Storage.DenseVector[] biases;
    private Storage.DenseVector[] avg_activations;
    private Storage.DenseRowMatrix[] dense_row_weights_momenta;
    private Storage.DenseColMatrix[] dense_col_weights_momenta;
    private Storage.DenseVector[] biases_momenta;
    private Storage.DenseRowMatrix[] dense_row_ada_dx_g;
    private Storage.DenseColMatrix[] dense_col_ada_dx_g;
    private Storage.DenseVector[] biases_ada_dx_g;
    private boolean[] _saw_missing_cats;
    public DeepLearningParameters parameters;
    private float[] mean_rate;
    private float[] rms_rate;
    private float[] mean_bias;
    private float[] rms_bias;
    private float[] mean_weight;
    public float[] rms_weight;
    public float[] mean_a;
    private volatile boolean unstable = false;
    private long processed_global;
    private long processed_local;
    int[] units;
    final boolean _classification;
    final Frame _train;
    final Frame _valid;

    public DataInfo data_info() {
        return this.data_info;
    }

    public long size() {
        long siz = 0L;
        for (Storage.DenseRowMatrix denseRowMatrix : this.dense_row_weights) {
            if (denseRowMatrix == null) continue;
            siz += denseRowMatrix.size();
        }
        for (Iced iced : this.dense_col_weights) {
            if (iced == null) continue;
            siz += iced.size();
        }
        for (Iced iced : this.biases) {
            siz += (long)iced.size();
        }
        return siz;
    }

    void checkMissingCats(int[] cats) {
        if (cats == null) {
            return;
        }
        if (this._saw_missing_cats == null) {
            return;
        }
        for (int i = 0; i < cats.length; ++i) {
            assert (this.data_info._catMissing[i] == 1);
            if (this._saw_missing_cats[i]) continue;
            this._saw_missing_cats[i] = cats[i] == this.data_info._catOffsets[i + 1] - 1;
        }
    }

    boolean has_momenta() {
        return this.get_params()._momentum_start != 0.0 || this.get_params()._momentum_stable != 0.0;
    }

    boolean adaDelta() {
        return this.get_params()._adaptive_rate;
    }

    public final Storage.Matrix get_weights(int i) {
        return (Storage.Matrix)(this.dense_row_weights[i] == null ? this.dense_col_weights[i] : this.dense_row_weights[i]);
    }

    public final Storage.DenseVector get_biases(int i) {
        return this.biases[i];
    }

    public final Storage.Matrix get_weights_momenta(int i) {
        return (Storage.Matrix)(this.dense_row_weights_momenta[i] == null ? this.dense_col_weights_momenta[i] : this.dense_row_weights_momenta[i]);
    }

    public final Storage.DenseVector get_biases_momenta(int i) {
        return this.biases_momenta[i];
    }

    public final Storage.Matrix get_ada_dx_g(int i) {
        return (Storage.Matrix)(this.dense_row_ada_dx_g[i] == null ? this.dense_col_ada_dx_g[i] : this.dense_row_ada_dx_g[i]);
    }

    public final Storage.DenseVector get_biases_ada_dx_g(int i) {
        return this.biases_ada_dx_g[i];
    }

    public final Storage.DenseVector get_avg_activations(int i) {
        return this.avg_activations[i];
    }

    public final DeepLearningParameters get_params() {
        return this.parameters;
    }

    public final void set_params(DeepLearningParameters p) {
        this.parameters = (DeepLearningParameters)p.clone();
    }

    public boolean unstable() {
        return this.unstable;
    }

    public void set_unstable() {
        if (!this.unstable) {
            this.computeStats();
        }
        this.unstable = true;
    }

    public synchronized long get_processed_global() {
        return this.processed_global;
    }

    public synchronized void set_processed_global(long p) {
        this.processed_global = p;
    }

    public synchronized void add_processed_global(long p) {
        this.processed_global += p;
    }

    public synchronized long get_processed_local() {
        return this.processed_local;
    }

    public synchronized void set_processed_local(long p) {
        this.processed_local = p;
    }

    public synchronized void add_processed_local(long p) {
        this.processed_local += p;
    }

    public synchronized long get_processed_total() {
        return this.processed_global + this.processed_local;
    }

    private DeepLearningModelInfo() {
        this._classification = false;
        this._valid = null;
        this._train = null;
    }

    public DeepLearningModelInfo(DeepLearningParameters params, DataInfo dinfo, boolean classification, Frame train, Frame valid) {
        int i;
        boolean warn;
        this._classification = classification;
        this._train = train;
        this._valid = valid;
        this.data_info = dinfo;
        this.parameters = (DeepLearningParameters)params.clone();
        DeepLearningParameters.Sanity.modifyParms(this.parameters, this.parameters, this._classification);
        int num_input = dinfo.fullN();
        int num_output = this.get_params()._autoencoder ? num_input : (this._classification ? train.lastVec().cardinality() : 1);
        boolean[] blArray = this._saw_missing_cats = dinfo._cats > 0 ? new boolean[this.data_info._cats] : null;
        assert (num_input > 0);
        assert (num_output > 0);
        if (this.has_momenta() && this.adaDelta()) {
            throw new IllegalArgumentException("Cannot have non-zero momentum and adaptive rate at the same time.");
        }
        int layers = this.get_params()._hidden.length;
        this.units = new int[layers + 2];
        this.units[0] = this.get_params()._max_categorical_features <= Integer.MAX_VALUE - dinfo._nums ? Math.min(dinfo._nums + this.get_params()._max_categorical_features, num_input) : num_input;
        System.arraycopy(this.get_params()._hidden, 0, this.units, 1, layers);
        this.units[layers + 1] = num_output;
        boolean printLevels = (long)this.units[0] > 1000L;
        boolean bl = warn = (long)this.units[0] > 100000L;
        if (printLevels) {
            String[][] domains = dinfo._adaptedFrame.domains();
            int[] levels = new int[domains.length];
            for (int i2 = 0; i2 < levels.length; ++i2) {
                levels[i2] = domains[i2] != null ? domains[i2].length : 0;
            }
            Arrays.sort(levels);
            if (warn) {
                Log.warn((Object[])new Object[]{"==================================================================================================================================="});
                Log.warn((Object[])new Object[]{num_input + " input features" + (dinfo._cats > 0 ? " (after categorical one-hot encoding)" : "") + ". Can be slow and require a lot of memory."});
            }
            if (levels[levels.length - 1] > 0) {
                int levelcutoff = levels[levels.length - 1 - Math.min(10, levels.length - 1)];
                int count = 0;
                for (int i3 = 0; i3 < dinfo._adaptedFrame.numCols() - (this.get_params()._autoencoder ? 0 : 1) && count < 10; ++count, ++i3) {
                    if (dinfo._adaptedFrame.domains()[i3] == null || dinfo._adaptedFrame.domains()[i3].length < levelcutoff) continue;
                    if (warn) {
                        Log.warn((Object[])new Object[]{"Categorical feature '" + dinfo._adaptedFrame._names[i3] + "' has cardinality " + dinfo._adaptedFrame.domains()[i3].length + "."});
                        continue;
                    }
                    Log.info((Object[])new Object[]{"Categorical feature '" + dinfo._adaptedFrame._names[i3] + "' has cardinality " + dinfo._adaptedFrame.domains()[i3].length + "."});
                }
            }
            if (warn) {
                Log.warn((Object[])new Object[]{"Suggestions:"});
                Log.warn((Object[])new Object[]{" *) Limit the size of the first hidden layer"});
                if (dinfo._cats > 0) {
                    Log.warn((Object[])new Object[]{" *) Limit the total number of one-hot encoded features with the parameter 'max_categorical_features'"});
                    Log.warn((Object[])new Object[]{" *) Run h2o.interaction(...,pairwise=F) on high-cardinality categorical columns to limit the factor count, see http://learn.h2o.ai"});
                }
                Log.warn((Object[])new Object[]{"==================================================================================================================================="});
            }
        }
        this.dense_row_weights = new Storage.DenseRowMatrix[layers + 1];
        this.dense_col_weights = new Storage.DenseColMatrix[layers + 1];
        if (this.get_params()._col_major) {
            this.dense_col_weights[0] = new Storage.DenseColMatrix(this.units[1], this.units[0]);
        } else {
            this.dense_row_weights[0] = new Storage.DenseRowMatrix(this.units[1], this.units[0]);
        }
        for (i = 1; i <= layers; ++i) {
            this.dense_row_weights[i] = new Storage.DenseRowMatrix(this.units[i + 1], this.units[i]);
        }
        this.biases = new Storage.DenseVector[layers + 1];
        for (i = 0; i <= layers; ++i) {
            this.biases[i] = new Storage.DenseVector(this.units[i + 1]);
        }
        if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
            this.avg_activations = new Storage.DenseVector[layers];
            this.mean_a = new float[layers];
            for (i = 0; i < layers; ++i) {
                this.avg_activations[i] = new Storage.DenseVector(this.units[i + 1]);
            }
        }
        this.allocateHelperArrays();
        this.mean_rate = new float[this.units.length];
        this.rms_rate = new float[this.units.length];
        this.mean_bias = new float[this.units.length];
        this.rms_bias = new float[this.units.length];
        this.mean_weight = new float[this.units.length];
        this.rms_weight = new float[this.units.length];
    }

    DeepLearningModelInfo deep_clone() {
        AutoBuffer ab = new AutoBuffer();
        this.write(ab);
        ab.flipForReading();
        return (DeepLearningModelInfo)new DeepLearningModelInfo().read(ab);
    }

    void allocateHelperArrays() {
        block9: {
            int i;
            block8: {
                int i2;
                if (!this.has_momenta()) break block8;
                this.dense_row_weights_momenta = new Storage.DenseRowMatrix[this.dense_row_weights.length];
                this.dense_col_weights_momenta = new Storage.DenseColMatrix[this.dense_col_weights.length];
                if (this.dense_row_weights[0] != null) {
                    this.dense_row_weights_momenta[0] = new Storage.DenseRowMatrix(this.units[1], this.units[0]);
                } else {
                    this.dense_col_weights_momenta[0] = new Storage.DenseColMatrix(this.units[1], this.units[0]);
                }
                for (i2 = 1; i2 < this.dense_row_weights_momenta.length; ++i2) {
                    this.dense_row_weights_momenta[i2] = new Storage.DenseRowMatrix(this.units[i2 + 1], this.units[i2]);
                }
                this.biases_momenta = new Storage.DenseVector[this.biases.length];
                for (i2 = 0; i2 < this.biases_momenta.length; ++i2) {
                    this.biases_momenta[i2] = new Storage.DenseVector(this.units[i2 + 1]);
                }
                break block9;
            }
            if (!this.adaDelta()) break block9;
            this.dense_row_ada_dx_g = new Storage.DenseRowMatrix[this.dense_row_weights.length];
            this.dense_col_ada_dx_g = new Storage.DenseColMatrix[this.dense_col_weights.length];
            if (this.dense_row_weights[0] != null) {
                this.dense_row_ada_dx_g[0] = new Storage.DenseRowMatrix(this.units[1], 2 * this.units[0]);
            } else {
                this.dense_col_ada_dx_g[0] = new Storage.DenseColMatrix(2 * this.units[1], this.units[0]);
            }
            for (i = 1; i < this.dense_row_ada_dx_g.length; ++i) {
                this.dense_row_ada_dx_g[i] = new Storage.DenseRowMatrix(this.units[i + 1], 2 * this.units[i]);
            }
            this.biases_ada_dx_g = new Storage.DenseVector[this.biases.length];
            for (i = 0; i < this.biases_ada_dx_g.length; ++i) {
                this.biases_ada_dx_g[i] = new Storage.DenseVector(2 * this.units[i + 1]);
            }
        }
    }

    TwoDimTable createSummaryTable() {
        Neurons[] neurons = DeepLearningTask.makeNeuronsForTesting(this);
        long byte_size = new AutoBuffer().put((Freezable)this).buf().length;
        TwoDimTable table = new TwoDimTable("Status of Neuron Layers", (this.get_params()._diagnostics ? "" : "diagnostics disabled, ") + (!this.get_params()._autoencoder ? "predicting " + this._train.lastVecName() + ", " : "") + (this.get_params()._autoencoder ? "auto-encoder" : (this._classification ? this.units[this.units.length - 1] + "-class classification" : "regression")) + ", " + this.get_params()._loss.toString() + " loss, " + String.format("%,d", this.size()) + " weights/biases, " + PrettyPrint.bytes((long)byte_size) + ", " + String.format("%,d", this.get_processed_global()) + " training samples", new String[neurons.length], new String[]{"Layer", "Units", "Type", "Dropout", "L1", "L2", "Mean Rate", "Rate RMS", "Momentum", "Mean Weight", "Weight RMS", "Mean Bias", "Bias RMS"}, new String[]{"int", "int", "string", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"}, new String[]{"%d", "%d", "%s", "%2.2f %%", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f", "%5f"}, "");
        for (int i = 0; i < neurons.length; ++i) {
            table.set(i, 0, (Object)(i + 1));
            table.set(i, 1, (Object)neurons[i].units);
            table.set(i, 2, (Object)neurons[i].getClass().getSimpleName());
            if (i == 0) {
                table.set(i, 3, (Object)(neurons[i].params._input_dropout_ratio * 100.0));
                continue;
            }
            if (i < neurons.length - 1) {
                if (neurons[i].params._hidden_dropout_ratios == null) {
                    table.set(i, 3, (Object)0);
                } else {
                    table.set(i, 3, (Object)(neurons[i].params._hidden_dropout_ratios[i - 1] * 100.0));
                }
            }
            table.set(i, 4, (Object)neurons[i].params._l1);
            table.set(i, 5, (Object)neurons[i].params._l2);
            table.set(i, 6, (Object)Float.valueOf(this.get_params()._adaptive_rate ? this.mean_rate[i] : neurons[i].rate(this.get_processed_total())));
            table.set(i, 7, (Object)Float.valueOf(this.get_params()._adaptive_rate ? this.rms_rate[i] : 0.0f));
            table.set(i, 8, (Object)Float.valueOf(this.get_params()._adaptive_rate ? 0.0f : neurons[i].momentum(this.get_processed_total())));
            table.set(i, 9, (Object)Float.valueOf(this.mean_weight[i]));
            table.set(i, 10, (Object)Float.valueOf(this.rms_weight[i]));
            table.set(i, 11, (Object)Float.valueOf(this.mean_bias[i]));
            table.set(i, 12, (Object)Float.valueOf(this.rms_bias[i]));
        }
        this.summaryTable = table;
        return this.summaryTable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.get_params()._diagnostics && !this.get_params()._quiet_mode) {
            if (this.get_params()._sparsity_beta > 0.0) {
                for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                    sb.append("Average activation in hidden layer ").append(k).append(" is  ").append(this.mean_a[k]).append(" \n");
                }
            }
            this.createSummaryTable();
            sb.append(this.summaryTable.toString(1));
        }
        return sb.toString();
    }

    public String toStringAll() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString());
        for (i = 0; i < this.units.length - 1; ++i) {
            sb.append("\nweights[").append(i).append("][]=").append(Arrays.toString(this.get_weights(i).raw()));
        }
        for (i = 0; i < this.units.length - 1; ++i) {
            sb.append("\nbiases[").append(i).append("][]=").append(Arrays.toString(this.get_biases(i).raw()));
        }
        if (this.has_momenta()) {
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nweights_momenta[").append(i).append("][]=").append(Arrays.toString(this.get_weights_momenta(i).raw()));
            }
        }
        if (this.biases_momenta != null) {
            for (i = 0; i < this.units.length - 1; ++i) {
                sb.append("\nbiases_momenta[").append(i).append("][]=").append(Arrays.toString(this.biases_momenta[i].raw()));
            }
        }
        sb.append("\nunits[]=").append(Arrays.toString(this.units));
        sb.append("\nprocessed global: ").append(this.get_processed_global());
        sb.append("\nprocessed local:  ").append(this.get_processed_local());
        sb.append("\nprocessed total:  ").append(this.get_processed_total());
        sb.append("\n");
        return sb.toString();
    }

    void initializeMembers() {
        this.randomizeWeights();
        for (int i = 0; i < this.get_params()._hidden.length; ++i) {
            if (this.get_params()._activation == DeepLearningParameters.Activation.Rectifier || this.get_params()._activation == DeepLearningParameters.Activation.RectifierWithDropout || this.get_params()._activation == DeepLearningParameters.Activation.Maxout || this.get_params()._activation == DeepLearningParameters.Activation.MaxoutWithDropout) {
                Arrays.fill(this.biases[i].raw(), i == 0 ? 0.5f : 1.0f);
                continue;
            }
            if (this.get_params()._activation != DeepLearningParameters.Activation.Tanh && this.get_params()._activation != DeepLearningParameters.Activation.TanhWithDropout) continue;
            Arrays.fill(this.biases[i].raw(), 0.0f);
        }
        Arrays.fill(this.biases[this.biases.length - 1].raw(), 0.0f);
    }

    public void add(DeepLearningModelInfo other) {
        int i;
        for (i = 0; i < this.dense_row_weights.length; ++i) {
            ArrayUtils.add((float[])this.get_weights(i).raw(), (float[])other.get_weights(i).raw());
        }
        for (i = 0; i < this.biases.length; ++i) {
            ArrayUtils.add((float[])this.biases[i].raw(), (float[])other.biases[i].raw());
        }
        if (this.avg_activations != null) {
            for (i = 0; i < this.avg_activations.length; ++i) {
                ArrayUtils.add((float[])this.avg_activations[i].raw(), (float[])other.biases[i].raw());
            }
        }
        if (this.has_momenta()) {
            assert (other.has_momenta());
            for (i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                ArrayUtils.add((float[])this.get_weights_momenta(i).raw(), (float[])other.get_weights_momenta(i).raw());
            }
            for (i = 0; i < this.biases_momenta.length; ++i) {
                ArrayUtils.add((float[])this.biases_momenta[i].raw(), (float[])other.biases_momenta[i].raw());
            }
        }
        if (this.adaDelta()) {
            assert (other.adaDelta());
            for (i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                ArrayUtils.add((float[])this.get_ada_dx_g(i).raw(), (float[])other.get_ada_dx_g(i).raw());
            }
        }
        this.add_processed_local(other.get_processed_local());
    }

    protected void mult(float N) {
        this.div(1.0f / N);
    }

    protected void div(float N) {
        for (int i = 0; i < this.dense_row_weights.length; ++i) {
            ArrayUtils.div((float[])this.get_weights(i).raw(), (float)N);
        }
        for (Storage.DenseVector bias : this.biases) {
            ArrayUtils.div((float[])bias.raw(), (float)N);
        }
        if (this.avg_activations != null) {
            for (Storage.DenseVector avgac : this.avg_activations) {
                ArrayUtils.div((float[])avgac.raw(), (float)N);
            }
        }
        if (this.has_momenta()) {
            for (int i = 0; i < this.dense_row_weights_momenta.length; ++i) {
                ArrayUtils.div((float[])this.get_weights_momenta(i).raw(), (float)N);
            }
            for (Storage.DenseVector bias_momenta : this.biases_momenta) {
                ArrayUtils.div((float[])bias_momenta.raw(), (float)N);
            }
        }
        if (this.adaDelta()) {
            for (int i = 0; i < this.dense_row_ada_dx_g.length; ++i) {
                ArrayUtils.div((float[])this.get_ada_dx_g(i).raw(), (float)N);
            }
        }
    }

    double uniformDist(Random rand, double min, double max) {
        return min + (double)rand.nextFloat() * (max - min);
    }

    private void randomizeWeights() {
        for (int w = 0; w < this.dense_row_weights.length; ++w) {
            Random rng = RandomUtils.getRNG((long[])new long[]{this.get_params()._seed + 195911405L + (long)w + 1L});
            double range = Math.sqrt(6.0 / (double)(this.units[w] + this.units[w + 1]));
            for (int i = 0; i < this.get_weights(w).rows(); ++i) {
                for (int j = 0; j < this.get_weights(w).cols(); ++j) {
                    if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.UniformAdaptive) {
                        if (w == this.dense_row_weights.length - 1 && this._classification) {
                            this.get_weights(w).set(i, j, (float)(4.0 * this.uniformDist(rng, -range, range)));
                            continue;
                        }
                        this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -range, range));
                        continue;
                    }
                    if (this.get_params()._initial_weight_distribution == DeepLearningParameters.InitialWeightDistribution.Uniform) {
                        this.get_weights(w).set(i, j, (float)this.uniformDist(rng, -this.get_params()._initial_weight_scale, this.get_params()._initial_weight_scale));
                        continue;
                    }
                    if (this.get_params()._initial_weight_distribution != DeepLearningParameters.InitialWeightDistribution.Normal) continue;
                    this.get_weights(w).set(i, j, (float)(rng.nextGaussian() * this.get_params()._initial_weight_scale));
                }
            }
        }
    }

    public float[] computeVariableImportances() {
        int i;
        int k;
        float[] vi = new float[this.units[0]];
        Arrays.fill(vi, 0.0f);
        float[][] Qik = new float[this.units[0]][this.units[2]];
        float[] sum_wj = new float[this.units[1]];
        float[] sum_wk = new float[this.units[2]];
        for (float[] Qi : Qik) {
            Arrays.fill(Qi, 0.0f);
        }
        Arrays.fill(sum_wj, 0.0f);
        Arrays.fill(sum_wk, 0.0f);
        for (int j = 0; j < this.units[1]; ++j) {
            for (int i2 = 0; i2 < this.units[0]; ++i2) {
                float wij = this.get_weights(0).get(j, i2);
                int n = j;
                sum_wj[n] = sum_wj[n] + Math.abs(wij);
            }
        }
        for (k = 0; k < this.units[2]; ++k) {
            for (int j = 0; j < this.units[1]; ++j) {
                float wjk = this.get_weights(1).get(k, j);
                int n = k;
                sum_wk[n] = sum_wk[n] + Math.abs(wjk);
            }
        }
        for (i = 0; i < this.units[0]; ++i) {
            for (int k2 = 0; k2 < this.units[2]; ++k2) {
                for (int j = 0; j < this.units[1]; ++j) {
                    float wij = this.get_weights(0).get(j, i);
                    float wjk = this.get_weights(1).get(k2, j);
                    float[] fArray = Qik[i];
                    int n = k2;
                    fArray[n] = fArray[n] + Math.abs(wij) / sum_wj[j] * Math.abs(wjk) / sum_wk[k2];
                }
            }
        }
        for (k = 0; k < this.units[2]; ++k) {
            int i3;
            float sumQk = 0.0f;
            for (i3 = 0; i3 < this.units[0]; ++i3) {
                sumQk += Qik[i3][k];
            }
            for (i3 = 0; i3 < this.units[0]; ++i3) {
                float[] fArray = Qik[i3];
                int n = k;
                fArray[n] = fArray[n] / sumQk;
            }
        }
        for (i = 0; i < this.units[0]; ++i) {
            vi[i] = ArrayUtils.sum((float[])Qik[i]);
        }
        ArrayUtils.div((float[])vi, (float)ArrayUtils.maxValue((float[])vi));
        if (this._saw_missing_cats != null) {
            for (i = 0; i < this._saw_missing_cats.length; ++i) {
                assert (this.data_info._catMissing[i] == 1);
                if (this._saw_missing_cats[i]) continue;
                vi[this.data_info._catOffsets[i + 1] - 1] = 0.0f;
            }
        }
        return vi;
    }

    public void computeStats() {
        if (!this.get_params()._diagnostics) {
            return;
        }
        float[][] rate = this.get_params()._adaptive_rate ? (Object)new float[this.units.length - 1][] : (float[][])null;
        Object object = rate;
        if (this.get_params()._autoencoder && this.get_params()._sparsity_beta > 0.0) {
            for (int k = 0; k < this.get_params()._hidden.length; ++k) {
                this.mean_a[k] = 0.0f;
                for (int j = 0; j < this.avg_activations[k].size(); ++j) {
                    int n = k;
                    this.mean_a[n] = this.mean_a[n] + this.avg_activations[k].get(j);
                }
                int n = k;
                this.mean_a[n] = this.mean_a[n] / (float)this.avg_activations[k].size();
            }
        }
        for (int y = 1; y < this.units.length; ++y) {
            int u;
            this.rms_rate[y] = 0.0f;
            this.mean_rate[y] = 0.0f;
            this.rms_bias[y] = 0.0f;
            this.mean_bias[y] = 0.0f;
            this.rms_weight[y] = 0.0f;
            this.mean_weight[y] = 0.0f;
            for (u = 0; u < this.biases[y - 1].size(); ++u) {
                int n = y;
                this.mean_bias[n] = this.mean_bias[n] + this.biases[y - 1].get(u);
            }
            if (rate != null) {
                rate[y - 1] = new float[this.get_weights(y - 1).raw().length];
            }
            for (u = 0; u < this.get_weights(y - 1).raw().length; ++u) {
                int n = y;
                this.mean_weight[n] = this.mean_weight[n] + this.get_weights(y - 1).raw()[u];
                if (rate == null) continue;
                float RMS_dx = MathUtils.approxSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u] + (float)this.get_params()._epsilon));
                float invRMS_g = MathUtils.approxInvSqrt((float)(this.get_ada_dx_g(y - 1).raw()[2 * u + 1] + (float)this.get_params()._epsilon));
                rate[y - 1][u] = RMS_dx * invRMS_g;
                int n2 = y;
                this.mean_rate[n2] = this.mean_rate[n2] + rate[y - 1][u];
            }
            int n = y;
            this.mean_bias[n] = this.mean_bias[n] / (float)this.biases[y - 1].size();
            int n3 = y;
            this.mean_weight[n3] = this.mean_weight[n3] / (float)this.get_weights(y - 1).size();
            if (rate != null) {
                int n4 = y;
                this.mean_rate[n4] = this.mean_rate[n4] / (float)rate[y - 1].length;
            }
            for (u = 0; u < this.biases[y - 1].size(); ++u) {
                double db = this.biases[y - 1].get(u) - this.mean_bias[y];
                int n5 = y;
                this.rms_bias[n5] = (float)((double)this.rms_bias[n5] + db * db);
            }
            u = 0;
            while ((long)u < this.get_weights(y - 1).size()) {
                double dw = this.get_weights(y - 1).raw()[u] - this.mean_weight[y];
                int n6 = y;
                this.rms_weight[n6] = (float)((double)this.rms_weight[n6] + dw * dw);
                if (rate != null) {
                    double drate = rate[y - 1][u] - this.mean_rate[y];
                    int n7 = y;
                    this.rms_rate[n7] = (float)((double)this.rms_rate[n7] + drate * drate);
                }
                ++u;
            }
            this.rms_bias[y] = MathUtils.approxSqrt((float)(this.rms_bias[y] / (float)this.biases[y - 1].size()));
            this.rms_weight[y] = MathUtils.approxSqrt((float)(this.rms_weight[y] / (float)this.get_weights(y - 1).size()));
            if (rate != null) {
                this.rms_rate[y] = MathUtils.approxSqrt((float)(this.rms_rate[y] / (float)rate[y - 1].length));
            }
            double thresh = 1.0E10;
            this.unstable |= (double)this.mean_bias[y] > 1.0E10 || Double.isNaN(this.mean_bias[y]) || (double)this.rms_bias[y] > 1.0E10 || Double.isNaN(this.rms_bias[y]) || (double)this.mean_weight[y] > 1.0E10 || Double.isNaN(this.mean_weight[y]) || (double)this.rms_weight[y] > 1.0E10 || Double.isNaN(this.rms_weight[y]);
        }
    }

    protected long checksum_impl() {
        long cs = this.parameters._seed;
        cs ^= this.size() * this.get_processed_total();
        cs ^= (long)(2234.3424 * (double)ArrayUtils.sum((float[])this.mean_bias));
        cs *= (long)(9234.1343 * (double)ArrayUtils.sum((float[])this.rms_bias));
        cs ^= (long)(9723.9734 * (double)ArrayUtils.sum((float[])this.mean_weight));
        cs *= (long)(9234.1783 * (double)ArrayUtils.sum((float[])this.rms_weight));
        cs ^= (long)(4273.2344 * (Math.E + (double)ArrayUtils.sum((float[])this.mean_rate)));
        return cs *= (long)(3378.1999 * (Math.PI + (double)ArrayUtils.sum((float[])this.rms_rate)));
    }

    public static DeepLearningModelInfo timeAverage(DeepLearningModelInfo nodeAverageModel) {
        float pa = (float)nodeAverageModel.get_params()._elastic_averaging_moving_rate;
        assert (pa > 0.0f && pa <= 1.0f);
        DeepLearningModelInfo elasticAverage = (DeepLearningModelInfo)DKV.getGet((Key)nodeAverageModel.elasticAverageModelInfoKey());
        if (elasticAverage == null || pa == 1.0f) {
            elasticAverage = nodeAverageModel.deep_clone();
        } else {
            nodeAverageModel.mult(pa);
            elasticAverage.mult(1.0f - pa);
            elasticAverage.add(nodeAverageModel);
            elasticAverage.set_processed_global(nodeAverageModel.get_processed_global());
        }
        elasticAverage.set_processed_local(0L);
        DKV.put((Key)elasticAverage.elasticAverageModelInfoKey(), (Iced)elasticAverage);
        return elasticAverage;
    }

    public Key localModelInfoKey(H2ONode node) {
        return Key.make((String)(this.get_params()._model_id + ".node" + node.index()), (byte)1, (byte)31, (boolean)true, (H2ONode[])new H2ONode[]{node});
    }

    public Key elasticAverageModelInfoKey() {
        return Key.make((String)(this.get_params()._model_id + ".elasticaverage"), (byte)1, (byte)31, (boolean)true, (H2ONode[])new H2ONode[]{H2O.CLOUD._memary[0]});
    }
}

