/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.Model;
import hex.deeplearning.DeepLearning;
import java.lang.reflect.Field;
import java.util.Arrays;
import water.H2O;
import water.Key;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.RandomUtils;

public class DeepLearningParameters
extends Model.Parameters {
    public boolean _keep_cross_validation_splits;
    public Key _checkpoint;
    public boolean _overwrite_with_best_model = true;
    public boolean _autoencoder = false;
    public boolean _use_all_factor_levels = true;
    public Activation _activation = Activation.Rectifier;
    public int[] _hidden = new int[]{200, 200};
    public double _epochs = 10.0;
    public long _train_samples_per_iteration = -2L;
    public double _target_ratio_comm_to_comp = 0.02;
    public long _seed = RandomUtils.getRNG((long[])new long[]{System.nanoTime()}).nextLong();
    public boolean _adaptive_rate = true;
    public double _rho = 0.99;
    public double _epsilon = 1.0E-8;
    public double _rate = 0.005;
    public double _rate_annealing = 1.0E-6;
    public double _rate_decay = 1.0;
    public double _momentum_start = 0.0;
    public double _momentum_ramp = 1000000.0;
    public double _momentum_stable = 0.0;
    public boolean _nesterov_accelerated_gradient = true;
    public double _input_dropout_ratio = 0.0;
    public double[] _hidden_dropout_ratios;
    public double _l1 = 0.0;
    public double _l2 = 0.0;
    public float _max_w2 = Float.POSITIVE_INFINITY;
    public InitialWeightDistribution _initial_weight_distribution = InitialWeightDistribution.UniformAdaptive;
    public double _initial_weight_scale = 1.0;
    public Loss _loss = Loss.Automatic;
    public double _score_interval = 5.0;
    public long _score_training_samples = 10000L;
    public long _score_validation_samples = 0L;
    public double _score_duty_cycle = 0.1;
    public double _classification_stop = 0.0;
    public double _regression_stop = 1.0E-6;
    public boolean _quiet_mode = false;
    public ClassSamplingMethod _score_validation_sampling = ClassSamplingMethod.Uniform;
    public boolean _diagnostics = true;
    public boolean _variable_importances = false;
    public boolean _fast_mode = true;
    public boolean _force_load_balance = true;
    public boolean _replicate_training_data = true;
    public boolean _single_node_mode = false;
    public boolean _shuffle_training_data = false;
    public MissingValuesHandling _missing_values_handling = MissingValuesHandling.MeanImputation;
    public boolean _sparse = false;
    public boolean _col_major = false;
    public double _average_activation = 0.0;
    public double _sparsity_beta = 0.0;
    public int _max_categorical_features = Integer.MAX_VALUE;
    public boolean _reproducible = false;
    public boolean _export_weights_and_biases = false;
    public boolean _elastic_averaging = false;
    public double _elastic_averaging_moving_rate = 0.9;
    public double _elastic_averaging_regularization = 0.001;

    public double missingColumnsType() {
        return this._sparse ? 0.0 : Double.NaN;
    }

    public int getNumFolds() {
        return 0;
    }

    void validate(DeepLearning dl, boolean expensive) {
        boolean classification;
        dl.hide("_score_each_iteration", "Not used by Deep Learning.");
        boolean bl = expensive || dl.nclasses() != 0 ? dl.isClassifier() : (classification = this._loss == Loss.CrossEntropy);
        if (this._hidden == null || this._hidden.length == 0) {
            dl.error("_hidden", "There must be at least one hidden layer.");
        }
        for (int h : this._hidden) {
            if (h > 0) continue;
            dl.error("_hidden", "Hidden layer size must be positive.");
        }
        if (!this._autoencoder) {
            if (this._valid == null) {
                dl.hide("_score_validation_samples", "score_validation_samples requires a validation frame.");
            }
            if (classification) {
                dl.hide("_regression_stop", "regression_stop is used only with regression.");
            } else {
                dl.hide("_classification_stop", "classification_stop is used only with classification.");
            }
            if (!classification && this._valid != null || this._valid == null) {
                dl.hide("_score_validation_sampling", "score_validation_sampling requires classification and a validation frame.");
            }
        }
        if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout) {
            dl.hide("_hidden_dropout_ratios", "hidden_dropout_ratios requires a dropout activation function.");
        }
        if (this._hidden_dropout_ratios != null) {
            if (this._hidden_dropout_ratios.length != this._hidden.length) {
                dl.error("_hidden_dropout_ratios", "Must have " + this._hidden.length + " hidden layer dropout ratios.");
            } else if (this._activation != Activation.TanhWithDropout && this._activation != Activation.MaxoutWithDropout && this._activation != Activation.RectifierWithDropout) {
                if (!this._quiet_mode) {
                    dl.hide("_hidden_dropout_ratios", "Ignoring hidden_dropout_ratios because a non-dropout activation function was specified.");
                }
            } else if (ArrayUtils.maxValue((double[])this._hidden_dropout_ratios) >= 1.0 || ArrayUtils.minValue((double[])this._hidden_dropout_ratios) < 0.0) {
                dl.error("_hidden_dropout_ratios", "Hidden dropout ratios must be >= 0 and <1.");
            }
        }
        if (this._input_dropout_ratio < 0.0 || this._input_dropout_ratio >= 1.0) {
            dl.error("_input_dropout_ratio", "Input dropout must be >= 0 and <1.");
        }
        if (this._score_duty_cycle < 0.0 || this._score_duty_cycle > 1.0) {
            dl.error("_score_duty_cycle", "Score duty cycle must be >= 0 and <=1.");
        }
        if (this._l1 < 0.0) {
            dl.error("_l1", "L1 penalty must be >= 0.");
        }
        if (this._l2 < 0.0) {
            dl.error("_l2", "L2 penalty must be >= 0.");
        }
        if (H2O.CLOUD.size() == 1 && this._replicate_training_data) {
            dl.hide("_replicate_training_data", "replicate_training_data is only valid with cloud size greater than 1.");
        }
        if (this._single_node_mode && (H2O.CLOUD.size() == 1 || !this._replicate_training_data)) {
            dl.hide("_single_node_mode", "single_node_mode is only used with multi-node operation with replicated training data.");
        }
        if (H2O.ARGS.client && this._single_node_mode) {
            dl.error("_single_node_mode", "Cannot run on a single node in client mode");
        }
        if (this._autoencoder) {
            dl.hide("_use_all_factor_levels", "use_all_factor_levels is mandatory in combination with autoencoder.");
        }
        if (this.getNumFolds() != 0) {
            dl.hide("_overwrite_with_best_model", "overwrite_with_best_model is unsupported in combination with n-fold cross-validation.");
        }
        if (this._adaptive_rate) {
            dl.hide("_rate", "rate is not used with adaptive_rate.");
            dl.hide("_rate_annealing", "rate_annealing is not used with adaptive_rate.");
            dl.hide("_rate_decay", "rate_decay is not used with adaptive_rate.");
            dl.hide("_momentum_start", "momentum_start is not used with adaptive_rate.");
            dl.hide("_momentum_ramp", "momentum_ramp is not used with adaptive_rate.");
            dl.hide("_momentum_stable", "momentum_stable is not used with adaptive_rate.");
            dl.hide("_nesterov_accelerated_gradient", "nesterov_accelerated_gradient is not used with adaptive_rate.");
        } else {
            dl.hide("_rho", "rho is only used with adaptive_rate.");
            dl.hide("_epsilon", "epsilon is only used with adaptive_rate.");
        }
        if (this._initial_weight_distribution == InitialWeightDistribution.UniformAdaptive) {
            dl.hide("_initial_weight_scale", "initial_weight_scale is not used if initial_weight_distribution == UniformAdaptive.");
        }
        if (this.getNumFolds() != 0) {
            dl.error("_n_folds", "n_folds is not yet implemented.");
        }
        if (this._loss == null) {
            if (expensive || dl.nclasses() != 0) {
                dl.error("_loss", "Loss function must be specified. Try CrossEntropy for categorical response (classification), MeanSquare, Absolute or Huber for numerical response (regression).");
            }
        } else if (this._loss != Loss.Automatic) {
            if (this._autoencoder && this._loss == Loss.CrossEntropy) {
                dl.error("_loss", "Cannot use CrossEntropy loss for auto-encoder.");
            }
            if (!classification && this._loss == Loss.CrossEntropy) {
                dl.error("_loss", "For CrossEntropy loss, the response must be categorical.");
            }
        }
        if (!classification && this._loss == Loss.CrossEntropy) {
            dl.error("_loss", "For CrossEntropy loss, the response must be categorical. Either select MeanSquare, Absolute or Huber loss for regression, or use a categorical response.");
        }
        if (this._score_training_samples < 0L) {
            dl.error("_score_training_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
        }
        if (this._score_validation_samples < 0L) {
            dl.error("_score_validation_samples", "Number of training samples for scoring must be >= 0 (0 for all).");
        }
        if (this._autoencoder && this._sparsity_beta > 0.0) {
            if (this._activation == Activation.Tanh || this._activation == Activation.TanhWithDropout) {
                if (this._average_activation >= 1.0 || this._average_activation <= -1.0) {
                    dl.error("_average_activation", "Tanh average activation must be in (-1,1).");
                }
            } else if ((this._activation == Activation.Rectifier || this._activation == Activation.RectifierWithDropout) && this._average_activation <= 0.0) {
                dl.error("_average_activation", "Rectifier average activation must be positive.");
            }
        }
        if (!this._autoencoder && this._sparsity_beta != 0.0) {
            dl.info("_sparsity_beta", "Sparsity beta can only be used for autoencoder.");
        }
        if (classification && dl.hasOffset()) {
            dl.info("_offset_column", "Offset is only supported for regression.");
        }
        if (this._autoencoder && this._activation == Activation.Maxout) {
            dl.error("_activation", "Maxout activation is not supported for auto-encoder.");
        }
        if (this._max_categorical_features < 1) {
            dl.error("_max_categorical_features", "max_categorical_features must be at least 1.");
        }
        if (!this._sparse && this._col_major) {
            dl.error("_col_major", "Cannot use column major storage for non-sparse data handling.");
        }
        if (this._sparse && this._elastic_averaging) {
            dl.error("_elastic_averaging", "Cannot use elastic averaging for sparse data handling.");
        }
        if (expensive) {
            if (!classification && this._balance_classes) {
                dl.error("_balance_classes", "balance_classes requires classification.");
            }
            if (this._class_sampling_factors != null && !this._balance_classes) {
                dl.error("_class_sampling_factors", "class_sampling_factors requires balance_classes to be enabled.");
            }
            if (this._replicate_training_data && null != this.train() && (double)this.train().byteSize() > 1.0E10) {
                dl.error("_replicate_training_data", "Compressed training dataset takes more than 10 GB, cannot run with replicate_training_data.");
            }
        }
        if (!this._elastic_averaging) {
            dl.hide("_elastic_averaging_moving_rate", "Elastic averaging is required for this parameter.");
            dl.hide("_elastic_averaging_regularization", "Elastic averaging is required for this parameter.");
        } else {
            if (this._elastic_averaging_moving_rate > 1.0 || this._elastic_averaging_moving_rate < 0.0) {
                dl.error("_elastic_averaging_moving_rate", "Elastic averaging moving rate must be between 0 and 1.");
            }
            if (this._elastic_averaging_regularization < 0.0) {
                dl.error("_elastic_averaging_regularization", "Elastic averaging regularization strength must be >= 0.");
            }
        }
    }

    static class Sanity {
        private static final transient String[] cp_modifiable = new String[]{"_seed", "_checkpoint", "_epochs", "_score_interval", "_train_samples_per_iteration", "_target_ratio_comm_to_comp", "_score_duty_cycle", "_score_training_samples", "_score_validation_samples", "_score_validation_sampling", "_classification_stop", "_regression_stop", "_quiet_mode", "_max_confusion_matrix_size", "_max_hit_ratio_k", "_diagnostics", "_variable_importances", "_initial_weight_distribution", "_initial_weight_scale", "_force_load_balance", "_replicate_training_data", "_shuffle_training_data", "_single_node_mode", "_fast_mode", "_l1", "_l2", "_max_w2", "_input_dropout_ratio", "_hidden_dropout_ratios", "_loss", "_overwrite_with_best_model", "_missing_values_handling", "_average_activation", "_reproducible", "_export_weights_and_biases", "_elastic_averaging", "_elastic_averaging_moving_rate", "_elastic_averaging_regularization"};
        private static final transient String[] cp_not_modifiable = new String[]{"_drop_na20_cols", "_response_column", "_activation", "_use_all_factor_levels", "_adaptive_rate", "_autoencoder", "_rho", "_epsilon", "_sparse", "_sparsity_beta", "_col_major", "_rate", "_rate_annealing", "_rate_decay", "_momentum_start", "_momentum_ramp", "_momentum_stable", "_nesterov_accelerated_gradient", "_ignore_const_cols", "_keep_cross_validation_splits", "_max_categorical_features"};

        Sanity() {
        }

        static void checkCompleteness() {
            for (Field f : DeepLearningParameters.class.getDeclaredFields()) {
                if (ArrayUtils.contains((String[])cp_not_modifiable, (String)f.getName()) || ArrayUtils.contains((String[])cp_modifiable, (String)f.getName()) || f.getName().equals("_hidden") || f.getName().equals("_ignored_columns")) continue;
                throw H2O.unimpl((String)("Please add " + f.getName() + " to either cp_modifiable or cp_not_modifiable"));
            }
        }

        static void checkpoint(DeepLearningParameters oldP, DeepLearningParameters newP) {
            Sanity.checkCompleteness();
            if (newP.getNumFolds() != 0) {
                throw new UnsupportedOperationException("n_folds must be 0: Cross-validation is not supported during checkpoint restarts.");
            }
            if (newP._valid == null != (oldP._valid == null) || newP._valid != null && !newP._valid.equals((Object)oldP._valid)) {
                throw new IllegalArgumentException("Validation dataset must be the same as for the checkpointed model.");
            }
            if (!(newP._autoencoder || newP._response_column != null && newP._response_column.equals(oldP._response_column))) {
                throw new IllegalArgumentException("Response column (" + newP._response_column + ") is not the same as for the checkpointed model: " + oldP._response_column);
            }
            if (!Arrays.equals(newP._hidden, oldP._hidden)) {
                throw new IllegalArgumentException("Hidden layers (" + Arrays.toString(newP._hidden) + ") is not the same as for the checkpointed model: " + Arrays.toString(oldP._hidden));
            }
            if (!Arrays.equals(newP._ignored_columns, oldP._ignored_columns)) {
                throw new IllegalArgumentException("Predictor columns must be the same as for the checkpointed model. Check ignored columns.");
            }
            for (Field fBefore : ((Object)((Object)oldP)).getClass().getDeclaredFields()) {
                if (!ArrayUtils.contains((String[])cp_not_modifiable, (String)fBefore.getName())) continue;
                for (Field fAfter : ((Object)((Object)newP)).getClass().getDeclaredFields()) {
                    if (!fBefore.equals(fAfter)) continue;
                    try {
                        if (fAfter.get((Object)newP) != null && fBefore.get((Object)oldP) != null && fBefore.get((Object)oldP).toString().equals(fAfter.get((Object)newP).toString()) || fBefore.get((Object)oldP) == null && fAfter.get((Object)newP) == null) continue;
                        throw new IllegalArgumentException("Cannot change parameter: '" + fBefore.getName() + "': " + fBefore.get((Object)oldP) + " -> " + fAfter.get((Object)newP));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        static void update(DeepLearningParameters actualNewP, DeepLearningParameters newP, boolean classification) {
            for (Field fBefore : ((Object)((Object)actualNewP)).getClass().getDeclaredFields()) {
                if (!ArrayUtils.contains((String[])cp_modifiable, (String)fBefore.getName())) continue;
                for (Field fAfter : ((Object)((Object)newP)).getClass().getDeclaredFields()) {
                    if (!fBefore.equals(fAfter)) continue;
                    try {
                        if (fAfter.get((Object)newP) != null && fBefore.get((Object)actualNewP) != null && fBefore.get((Object)actualNewP).toString().equals(fAfter.get((Object)newP).toString()) || fBefore.get((Object)actualNewP) == null && fAfter.get((Object)newP) == null) continue;
                        Log.info((Object[])new Object[]{"Applying user-requested modification of '" + fBefore.getName() + "': " + fBefore.get((Object)actualNewP) + " -> " + fAfter.get((Object)newP)});
                        fBefore.set((Object)actualNewP, fAfter.get((Object)newP));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            Sanity.modifyParms(actualNewP, actualNewP, classification);
        }

        static void modifyParms(DeepLearningParameters fromParms, DeepLearningParameters toParms, boolean classification) {
            if (fromParms._hidden_dropout_ratios == null) {
                if (fromParms._activation == Activation.TanhWithDropout || fromParms._activation == Activation.MaxoutWithDropout || fromParms._activation == Activation.RectifierWithDropout) {
                    toParms._hidden_dropout_ratios = new double[fromParms._hidden.length];
                    if (!fromParms._quiet_mode) {
                        Log.info((Object[])new Object[]{"_hidden_dropout_ratios: Automatically setting all hidden dropout ratios to 0.5."});
                    }
                    Arrays.fill(toParms._hidden_dropout_ratios, 0.5);
                }
            } else {
                toParms._hidden_dropout_ratios = (double[])fromParms._hidden_dropout_ratios.clone();
            }
            if (H2O.CLOUD.size() == 1 && fromParms._replicate_training_data) {
                Log.info((Object[])new Object[]{"_replicate_training_data: Disabling replicate_training_data on 1 node."});
                toParms._replicate_training_data = false;
            }
            if (fromParms._single_node_mode && (H2O.CLOUD.size() == 1 || !fromParms._replicate_training_data)) {
                Log.info((Object[])new Object[]{"_single_node_mode: Disabling single_node_mode (only for multi-node operation with replicated training data)."});
                toParms._single_node_mode = false;
            }
            if (!fromParms._use_all_factor_levels && fromParms._autoencoder) {
                Log.info((Object[])new Object[]{"_use_all_factor_levels: Automatically enabling all_factor_levels for auto-encoders."});
                toParms._use_all_factor_levels = true;
            }
            if (fromParms._overwrite_with_best_model && fromParms.getNumFolds() != 0) {
                Log.info((Object[])new Object[]{"_overwrite_with_best_model: Disabling overwrite_with_best_model in combination with n-fold cross-validation."});
                toParms._overwrite_with_best_model = false;
            }
            if (fromParms._adaptive_rate) {
                Log.info((Object[])new Object[]{"_adaptive_rate: Using automatic learning rate. Ignoring the following input parameters: rate, rate_decay, rate_annealing, momentum_start, momentum_ramp, momentum_stable, nesterov_accelerated_gradient."});
                toParms._rate = 0.0;
                toParms._rate_decay = 0.0;
                toParms._rate_annealing = 0.0;
                toParms._momentum_start = 0.0;
                toParms._momentum_ramp = 0.0;
                toParms._momentum_stable = 0.0;
                toParms._nesterov_accelerated_gradient = false;
            } else {
                Log.info((Object[])new Object[]{"_adaptive_rate: Using manual learning rate. Ignoring the following input parameters: rho, epsilon."});
                toParms._rho = 0.0;
                toParms._epsilon = 0.0;
            }
            if (fromParms.getNumFolds() != 0 && fromParms._overwrite_with_best_model) {
                Log.info((Object[])new Object[]{"_overwrite_with_best_model: Automatically disabling overwrite_with_best_model, since the final model is the only scored model with n-fold cross-validation."});
                toParms._overwrite_with_best_model = false;
            }
            if (fromParms._loss == Loss.Automatic) {
                toParms._loss = classification && !fromParms._autoencoder ? Loss.CrossEntropy : Loss.MeanSquare;
                Log.info((Object[])new Object[]{"_loss: Automatically setting loss function to " + (Object)((Object)toParms._loss)});
            }
            if (fromParms._reproducible) {
                Log.info((Object[])new Object[]{"_reproducibility: Automatically enabling force_load_balancing, disabling single_node_mode and replicate_training_data\nand setting train_samples_per_iteration to -1 to enforce reproducibility."});
                toParms._force_load_balance = true;
                toParms._single_node_mode = false;
                toParms._train_samples_per_iteration = -1L;
                toParms._replicate_training_data = false;
            }
        }
    }

    public static enum Loss {
        Automatic,
        MeanSquare,
        CrossEntropy,
        Huber,
        Absolute;

    }

    public static enum Activation {
        Tanh,
        TanhWithDropout,
        Rectifier,
        RectifierWithDropout,
        Maxout,
        MaxoutWithDropout;

    }

    public static enum InitialWeightDistribution {
        UniformAdaptive,
        Uniform,
        Normal;

    }

    public static enum ClassSamplingMethod {
        Uniform,
        Stratified;

    }

    public static enum MissingValuesHandling {
        Skip,
        MeanImputation;

    }
}

