/*
 * Decompiled with CFR 0.152.
 */
package hex.gram;

import hex.DataInfo;
import hex.FrameTask;
import java.util.Arrays;
import java.util.concurrent.Future;
import jsr166y.CountedCompleter;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import sun.misc.Unsafe;
import water.Futures;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.nbhm.UtilUnsafe;
import water.util.ArrayUtils;

public final class Gram
extends Iced<Gram> {
    boolean _hasIntercept;
    public double[][] _xx;
    double[] _diag;
    public final int _diagN;
    final int _denseN;
    int _fullN;
    static final int MIN_TSKSZ = 10000;
    public double _diagAdded;

    public Gram() {
        this._fullN = 0;
        this._denseN = 0;
        this._diagN = 0;
        this._hasIntercept = false;
    }

    public Gram(int N, int diag, int dense, int sparse, boolean hasIntercept) {
        this._hasIntercept = hasIntercept;
        this._fullN = N + (this._hasIntercept ? 1 : 0);
        this._xx = new double[this._fullN - diag][];
        this._diagN = diag;
        this._diag = MemoryManager.malloc8d((int)this._diagN);
        this._denseN = dense;
        for (int i = 0; i < this._fullN - this._diagN; ++i) {
            this._xx[i] = MemoryManager.malloc8d((int)(diag + i + 1));
        }
    }

    public Gram(Gram g) {
        this._diagN = g._diagN;
        this._denseN = g._denseN;
        this._fullN = g._fullN;
        this._hasIntercept = g._hasIntercept;
        if (g._diag != null) {
            this._diag = (double[])g._diag.clone();
        }
        if (g._xx != null) {
            this._xx = (double[][])g._xx.clone();
            for (int i = 0; i < this._xx.length; ++i) {
                this._xx[i] = (double[])this._xx[i].clone();
            }
        }
    }

    public Gram(double[][] xx) {
        this(xx.length, 0, xx.length, 0, false);
        for (int i = 0; i < this._xx.length; ++i) {
            for (int j = 0; j < this._xx[i].length; ++j) {
                this._xx[i][j] = xx[i][j];
            }
        }
    }

    public void dropIntercept() {
        if (!this._hasIntercept) {
            throw new IllegalArgumentException("Has no intercept");
        }
        double[][] xx = new double[this._xx.length - 1][];
        for (int i = 0; i < xx.length; ++i) {
            xx[i] = this._xx[i];
        }
        this._xx = xx;
        this._hasIntercept = false;
        --this._fullN;
    }

    public final int fullN() {
        return this._fullN;
    }

    public void addDiag(double[] ds) {
        int i;
        for (i = 0; i < Math.min(this._diagN, ds.length); ++i) {
            int n = i;
            this._diag[n] = this._diag[n] + ds[i];
        }
        while (i < ds.length) {
            double[] dArray = this._xx[i - this._diagN];
            int n = i;
            dArray[n] = dArray[n] + ds[i];
            ++i;
        }
    }

    public double get(int i, int j) {
        if (j > i) {
            throw new IllegalArgumentException("Gram stored as lower diagnoal matrix, j must be < i");
        }
        if (i < this._diagN) {
            return j == i ? this._diag[i] : 0.0;
        }
        return this._xx[i - this._diagN][j];
    }

    public void addDiag(double d) {
        this.addDiag(d, false);
    }

    public void addDiag(double d, boolean add2Intercept) {
        this._diagAdded += d;
        int i = 0;
        while (i < this._diag.length) {
            int n = i++;
            this._diag[n] = this._diag[n] + d;
        }
        int ii = !this._hasIntercept || add2Intercept ? 0 : 1;
        for (int i2 = 0; i2 < this._xx.length - ii; ++i2) {
            double[] dArray = this._xx[i2];
            int n = this._xx[i2].length - 1;
            dArray[n] = dArray[n] + d;
        }
    }

    public double sparseness() {
        double[][] xx = this.getXX();
        double nzs = 0.0;
        for (int i = 0; i < xx.length; ++i) {
            for (int j = 0; j < xx[i].length; ++j) {
                if (xx[i][j] == 0.0) continue;
                nzs += 1.0;
            }
        }
        return nzs / (double)(xx.length * xx.length);
    }

    public double diagSum() {
        double res = 0.0;
        if (this._diag != null) {
            for (double d : this._diag) {
                res += d;
            }
        }
        if (this._xx != null) {
            for (double[] x : this._xx) {
                res += x[x.length - 1];
            }
        }
        return res;
    }

    public double diagAvg() {
        double res = 0.0;
        int n = 0;
        if (this._diag != null) {
            n += this._diag.length;
            for (double d : this._diag) {
                res += d;
            }
        }
        if (this._xx != null) {
            n += this._xx.length;
            for (double[] x : this._xx) {
                res += x[x.length - 1];
            }
        }
        return res / (double)n;
    }

    public double diagMin() {
        double res = Double.POSITIVE_INFINITY;
        if (this._diag != null) {
            for (double d : this._diag) {
                if (!(d < res)) continue;
                res = d;
            }
        }
        if (this._xx != null) {
            for (int i = 0; i < this._xx.length - 1; ++i) {
                double[] x = this._xx[i];
                if (!(x[x.length - 1] < res)) continue;
                res = x[x.length - 1];
            }
        }
        return res;
    }

    public String toString() {
        if (this._fullN >= 1000) {
            if (this._denseN >= 1000) {
                return "Gram(" + this._fullN + ")";
            }
            return "diag:\n" + Arrays.toString(this._diag) + "\ndense:\n" + ArrayUtils.pprint((double[][])this.getDenseXX());
        }
        return ArrayUtils.pprint((double[][])this.getXX());
    }

    public Cholesky cholesky(Cholesky chol) {
        return this.cholesky(chol, true, "");
    }

    public Cholesky cholesky(Cholesky chol, boolean parallelize, String id) {
        int fi;
        int i;
        long start = System.currentTimeMillis();
        if (chol == null) {
            double[][] xx = (double[][])this._xx.clone();
            for (int i2 = 0; i2 < xx.length; ++i2) {
                xx[i2] = (double[])xx[i2].clone();
            }
            chol = new Cholesky(xx, (double[])this._diag.clone());
        }
        final Cholesky fchol = chol;
        final int sparseN = this._diag.length;
        int denseN = this._fullN - sparseN;
        if (this._diag != null) {
            for (int i3 = 0; i3 < sparseN; ++i3) {
                chol._diag[i3] = Math.sqrt(this._diag[i3]);
                double d = 1.0 / chol._diag[i3];
                for (int j = 0; j < denseN; ++j) {
                    chol._xx[j][i3] = d * this._xx[j][i3];
                }
            }
        }
        ForkJoinTask[] fjts = new ForkJoinTask[denseN];
        final int[][] nz = new int[denseN][];
        for (i = 0; i < denseN; ++i) {
            fi = i;
            fjts[i] = new RecursiveAction(){

                protected void compute() {
                    int[] tmp = new int[sparseN];
                    double[] rowi = fchol._xx[fi];
                    int n = 0;
                    for (int k = 0; k < sparseN; ++k) {
                        if (rowi[k] == 0.0) continue;
                        tmp[n++] = k;
                    }
                    nz[fi] = Arrays.copyOf(tmp, n);
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])fjts);
        for (i = 0; i < denseN; ++i) {
            fi = i;
            fjts[i] = new RecursiveAction(){

                protected void compute() {
                    double[] rowi = fchol._xx[fi];
                    int[] nzi = nz[fi];
                    for (int j = 0; j <= fi; ++j) {
                        double[] rowj = fchol._xx[j];
                        int[] nzj = nz[j];
                        double s = 0.0;
                        int t = 0;
                        int z = 0;
                        while (t < nzi.length && z < nzj.length) {
                            int k1 = nzi[t];
                            int k2 = nzj[z];
                            if (k1 < k2) {
                                ++t;
                                continue;
                            }
                            if (k1 > k2) {
                                ++z;
                                continue;
                            }
                            s += rowi[k1] * rowj[k1];
                            ++t;
                            ++z;
                        }
                        rowi[j + sparseN] = Gram.this._xx[fi][j + sparseN] - s;
                    }
                }
            };
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])fjts);
        Object arr = new double[denseN][];
        for (int i4 = 0; i4 < ((double[][])arr).length; ++i4) {
            arr[i4] = Arrays.copyOfRange(fchol._xx[i4], sparseN, sparseN + denseN);
        }
        int p = Runtime.getRuntime().availableProcessors();
        InPlaceCholesky d = InPlaceCholesky.decompose_2(arr, 10, p);
        fchol.setSPD(d.isSPD());
        arr = d.getL();
        for (int i5 = 0; i5 < ((double[][])arr).length; ++i5) {
            System.arraycopy(arr[i5], 0, fchol._xx[i5], sparseN, i5 + 1);
        }
        return chol;
    }

    public double[][] getXX() {
        int i;
        int N = this._fullN;
        double[][] xx = new double[N][];
        for (i = 0; i < N; ++i) {
            xx[i] = MemoryManager.malloc8d((int)N);
        }
        for (i = 0; i < this._diag.length; ++i) {
            xx[i][i] = this._diag[i];
        }
        for (i = 0; i < this._xx.length; ++i) {
            for (int j = 0; j < this._xx[i].length; ++j) {
                xx[i + this._diag.length][j] = this._xx[i][j];
                xx[j][i + this._diag.length] = this._xx[i][j];
            }
        }
        return xx;
    }

    public double[][] getDenseXX() {
        int i;
        int N = this._denseN;
        double[][] xx = new double[N][];
        for (i = 0; i < N; ++i) {
            xx[i] = MemoryManager.malloc8d((int)N);
        }
        for (i = 0; i < this._xx.length; ++i) {
            for (int j = this._diagN; j < this._xx[i].length; ++j) {
                xx[i][j - this._diagN] = this._xx[i][j];
                xx[j - this._diagN][i] = this._xx[i][j];
            }
        }
        return xx;
    }

    public void add(Gram grm) {
        ArrayUtils.add((double[][])this._xx, (double[][])grm._xx);
        ArrayUtils.add((double[])this._diag, (double[])grm._diag);
    }

    public final boolean hasNaNsOrInfs() {
        for (int i = 0; i < this._xx.length; ++i) {
            for (int j = 0; j < this._xx[i].length; ++j) {
                if (!Double.isInfinite(this._xx[i][j]) && !Double.isNaN(this._xx[i][j])) continue;
                return true;
            }
        }
        for (double d : this._diag) {
            if (!Double.isInfinite(d) && !Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    public final void addRowSparse(DataInfo.Row r, double w) {
        int i;
        double[] mrow;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        int denseColStart = this._fullN - this._denseN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._xx.length - 1] : null;
        for (int i2 = 0; i2 < r.nNums; ++i2) {
            int j;
            int cid = r.numIds[i2];
            mrow = this._xx[cid - this._diagN];
            double d = w * r.numVals[i2];
            for (j = 0; j <= i2; ++j) {
                int n = r.numIds[j];
                mrow[n] = mrow[n] + d * r.numVals[j];
            }
            if (this._hasIntercept) {
                int n = cid;
                interceptRow[n] = interceptRow[n] + d;
            }
            for (j = 0; j < r.nBins; ++j) {
                int n = r.binIds[j];
                mrow[n] = mrow[n] + d;
            }
        }
        if (this._hasIntercept) {
            int n = interceptRow.length - 1;
            interceptRow[n] = interceptRow[n] + w;
            for (int j = 0; j < r.nBins; ++j) {
                int n2 = r.binIds[j];
                interceptRow[n2] = interceptRow[n2] + w;
            }
        }
        boolean hasDiag = this._diagN > 0 && r.nBins > 0 && r.binIds[0] < this._diagN;
        int n = i = hasDiag ? 1 : 0;
        while (i < r.nBins) {
            mrow = this._xx[r.binIds[i] - this._diagN];
            for (int j = 0; j <= i; ++j) {
                int n3 = r.binIds[j];
                mrow[n3] = mrow[n3] + w;
            }
            ++i;
        }
        if (hasDiag && r.nBins > 0) {
            int n4 = r.binIds[0];
            this._diag[n4] = this._diag[n4] + w;
        }
    }

    public final void addRow(DataInfo.Row row, double w) {
        if (row.numIds == null) {
            this.addRowDense(row, w);
        } else {
            this.addRowSparse(row, w);
        }
    }

    public final void addRowDense(DataInfo.Row row, double w) {
        int i;
        int intercept = this._hasIntercept ? 1 : 0;
        int denseRowStart = this._fullN - this._denseN - this._diagN - intercept;
        int denseColStart = this._fullN - this._denseN - intercept;
        assert (this._denseN + denseRowStart == this._xx.length - intercept);
        double[] interceptRow = this._hasIntercept ? this._xx[this._denseN + denseRowStart] : null;
        for (int i2 = 0; i2 < this._denseN; ++i2) {
            int j;
            if (row.numVals[i2] == 0.0) continue;
            double[] mrow = this._xx[i2 + denseRowStart];
            double d = w * row.numVals[i2];
            for (j = 0; j <= i2; ++j) {
                if (row.numVals[j] == 0.0) continue;
                int n = j + denseColStart;
                mrow[n] = mrow[n] + d * row.numVals[j];
            }
            if (this._hasIntercept) {
                int n = i2 + denseColStart;
                interceptRow[n] = interceptRow[n] + d;
            }
            for (j = 0; j < row.nBins; ++j) {
                int n = row.binIds[j];
                mrow[n] = mrow[n] + d;
            }
        }
        if (this._hasIntercept) {
            int n = this._denseN + denseColStart;
            interceptRow[n] = interceptRow[n] + w;
            for (int j = 0; j < row.nBins; ++j) {
                int n2 = row.binIds[j];
                interceptRow[n2] = interceptRow[n2] + w;
            }
        }
        boolean hasDiag = this._diagN > 0 && row.nBins > 0 && row.binIds[0] < this._diagN;
        int n = i = hasDiag ? 1 : 0;
        while (i < row.nBins) {
            double[] mrow = this._xx[row.binIds[i] - this._diagN];
            for (int j = 0; j <= i; ++j) {
                int n3 = row.binIds[j];
                mrow[n3] = mrow[n3] + w;
            }
            ++i;
        }
        if (hasDiag) {
            int n4 = row.binIds[0];
            this._diag[n4] = this._diag[n4] + w;
        }
    }

    public void mul(double x) {
        int i;
        if (this._diag != null) {
            i = 0;
            while (i < this._diag.length) {
                int n = i++;
                this._diag[n] = this._diag[n] * x;
            }
        }
        for (i = 0; i < this._xx.length; ++i) {
            int j = 0;
            while (j < this._xx[i].length) {
                double[] dArray = this._xx[i];
                int n = j++;
                dArray[n] = dArray[n] * x;
            }
        }
    }

    public double[] mul(double[] x) {
        double[] res = MemoryManager.malloc8d((int)x.length);
        this.mul(x, res);
        return res;
    }

    public void mul(double[] x, double[] res) {
        Arrays.fill(res, 0.0);
        for (int i = 0; i < this._diagN; ++i) {
            res[i] = x[i] * this._diag[i];
        }
        for (int ii = 0; ii < this._xx.length; ++ii) {
            int n = this._xx[ii].length - 1;
            int i = this._diagN + ii;
            int j = 0;
            while (j < n) {
                double e = this._xx[ii][j];
                int n2 = i;
                res[n2] = res[n2] + x[j] * e;
                int n3 = j++;
                res[n3] = res[n3] + x[i] * e;
            }
            int n4 = i;
            res[n4] = res[n4] + this._xx[ii][n] * x[n];
        }
    }

    public static class NonSPDMatrixException
    extends RuntimeException {
    }

    public static class GramTask
    extends FrameTask<GramTask> {
        public Gram _gram;
        public long _nobs;

        public GramTask(Key jobKey, DataInfo dinfo) {
            super(jobKey, dinfo);
        }

        @Override
        protected boolean chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, false);
            return true;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row r) {
            double w = 1.0;
            this._gram.addRow(r, w);
            ++this._nobs;
        }

        @Override
        protected void chunkDone(long n) {
            double r = 1.0 / (double)this._nobs;
            this._gram.mul(r);
        }

        public void reduce(GramTask gt) {
            double r1 = (double)this._nobs / (double)(this._nobs + gt._nobs);
            this._gram.mul(r1);
            double r2 = (double)gt._nobs / (double)(this._nobs + gt._nobs);
            gt._gram.mul(r2);
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    public static final class Cholesky {
        public final double[][] _xx;
        protected final double[] _diag;
        private boolean _isSPD;

        public Cholesky(double[][] xx, double[] diag) {
            this._xx = xx;
            this._diag = diag;
        }

        public Cholesky(Gram gram) {
            this._xx = (double[][])gram._xx.clone();
            for (int i = 0; i < this._xx.length; ++i) {
                this._xx[i] = (double[])gram._xx[i].clone();
            }
            this._diag = (double[])gram._diag.clone();
        }

        public double[][] getXX() {
            int i;
            int N = this._xx.length + this._diag.length;
            double[][] xx = new double[N][];
            for (i = 0; i < N; ++i) {
                xx[i] = MemoryManager.malloc8d((int)N);
            }
            for (i = 0; i < this._diag.length; ++i) {
                xx[i][i] = this._diag[i];
            }
            for (i = 0; i < this._xx.length; ++i) {
                for (int j = 0; j < this._xx[i].length; ++j) {
                    xx[i + this._diag.length][j] = this._xx[i][j];
                    xx[j][i + this._diag.length] = this._xx[i][j];
                }
            }
            return xx;
        }

        public double[][] getL() {
            int i;
            int N = this._xx.length + this._diag.length;
            double[][] xx = new double[N][];
            for (i = 0; i < N; ++i) {
                xx[i] = MemoryManager.malloc8d((int)N);
            }
            for (i = 0; i < this._diag.length; ++i) {
                xx[i][i] = this._diag[i];
            }
            for (i = 0; i < this._xx.length; ++i) {
                for (int j = 0; j < this._xx[i].length; ++j) {
                    xx[i + this._diag.length][j] = this._xx[i][j];
                }
            }
            return xx;
        }

        public double sparseness() {
            double[][] xx = this.getXX();
            double nzs = 0.0;
            for (int i = 0; i < xx.length; ++i) {
                for (int j = 0; j < xx[i].length; ++j) {
                    if (xx[i][j] == 0.0) continue;
                    nzs += 1.0;
                }
            }
            return nzs / (double)(xx.length * xx.length);
        }

        public String toString() {
            return "";
        }

        public ParSolver parSolver(CountedCompleter cmp, double[] y, int iBlock, int rBlock) {
            return new ParSolver(cmp, y, iBlock, rBlock);
        }

        public final void solve(double[] y) {
            int k;
            if (!this.isSPD()) {
                throw new NonSPDMatrixException();
            }
            for (int k2 = 0; k2 < this._diag.length; ++k2) {
                int n = k2;
                y[n] = y[n] / this._diag[k2];
            }
            int n = this._xx[this._xx.length - 1].length;
            for (k = this._diag.length; k < n; ++k) {
                double d = 0.0;
                for (int i = 0; i < k; ++i) {
                    d += y[i] * this._xx[k - this._diag.length][i];
                }
                y[k] = (y[k] - d) / this._xx[k - this._diag.length][k];
            }
            for (k = n - 1; k >= this._diag.length; --k) {
                int n2 = k;
                y[n2] = y[n2] / this._xx[k - this._diag.length][k];
                for (int i = 0; i < k; ++i) {
                    int n3 = i;
                    y[n3] = y[n3] - y[k] * this._xx[k - this._diag.length][i];
                }
            }
            for (k = this._diag.length - 1; k >= 0; --k) {
                int n4 = k;
                y[n4] = y[n4] / this._diag[k];
            }
        }

        public final boolean isSPD() {
            return this._isSPD;
        }

        public final void setSPD(boolean b) {
            this._isSPD = b;
        }

        public final class ParSolver
        extends CountedCompleter {
            final double[] y;
            final int _iBlock;
            final int _rBlock;

            private ParSolver(CountedCompleter cmp, double[] y, int iBlock, int rBlock) {
                super(cmp);
                this.y = y;
                this._iBlock = iBlock;
                this._rBlock = rBlock;
            }

            public void compute() {
                int k;
                if (!Cholesky.this.isSPD()) {
                    throw new NonSPDMatrixException();
                }
                assert (Cholesky.this._xx.length + Cholesky.this._diag.length == this.y.length) : "" + Cholesky.this._xx.length + " + " + Cholesky.this._diag.length + " != " + this.y.length;
                for (int k2 = 0; k2 < Cholesky.this._diag.length; ++k2) {
                    int n = k2;
                    this.y[n] = this.y[n] / Cholesky.this._diag[k2];
                }
                int n = this.y.length;
                for (k = Cholesky.this._diag.length; k < n; ++k) {
                    double d = 0.0;
                    for (int i = 0; i < k; ++i) {
                        d += this.y[i] * Cholesky.this._xx[k - Cholesky.this._diag.length][i];
                    }
                    this.y[k] = (this.y[k] - d) / Cholesky.this._xx[k - Cholesky.this._diag.length][k];
                }
                if (this.y.length >= 0) {
                    this.addToPendingCount(1);
                    new BackSolver2(this, this.y, this._iBlock, this._rBlock).fork();
                } else {
                    for (k = n - 1; k >= Cholesky.this._diag.length; --k) {
                        int n2 = k;
                        this.y[n2] = this.y[n2] / Cholesky.this._xx[k - Cholesky.this._diag.length][k];
                        for (int i = 0; i < k; ++i) {
                            int n3 = i;
                            this.y[n3] = this.y[n3] - this.y[k] * Cholesky.this._xx[k - Cholesky.this._diag.length][i];
                        }
                    }
                }
                this.tryComplete();
            }

            public void onCompletion(CountedCompleter caller) {
                for (int k = Cholesky.this._diag.length - 1; k >= 0; --k) {
                    int n = k;
                    this.y[n] = this.y[n] / Cholesky.this._diag[k];
                }
            }
        }

        private final class BackSolver
        extends CountedCompleter {
            final int _diagLen;
            final double[] _y;
            final DelayedTask[][] _tasks;

            BackSolver(double[] y, int kBlocksz, int iBlocksz) {
                int k;
                int n = y.length;
                this._y = y;
                int kRem = Cholesky.this._xx.length % kBlocksz;
                int M = Cholesky.this._xx.length / kBlocksz + (kRem == 0 ? 0 : 1);
                int N = n / iBlocksz;
                this._tasks = new DelayedTask[M][];
                int rsz = N;
                for (int i = M - 1; i >= 0; --i) {
                    this._tasks[i] = new DelayedTask[rsz--];
                }
                this._diagLen = Cholesky.this._diag == null ? 0 : Cholesky.this._diag.length;
                int kFrom = this._diagLen + Cholesky.this._xx.length - 1;
                int kTo = this._diagLen + Cholesky.this._xx.length;
                int iFrom = n;
                int pending = 0;
                int rem = 0;
                if (kRem > 0) {
                    rem = 1;
                    k = this._tasks.length - 1;
                    int i = this._tasks[k].length - 1;
                    iFrom = i * iBlocksz;
                    kTo = kFrom - kRem + 1;
                    this._tasks[k][i] = new BackSolveDiagTsk(0, k, kFrom, kTo, iFrom);
                    for (int j = 0; j < this._tasks[k].length - 1; ++j) {
                        this._tasks[k][j] = new BackSolveInnerTsk(pending, M - 1, j, kFrom, kTo, j * iBlocksz, (j + 1) * iBlocksz);
                    }
                    pending = 1;
                }
                for (k = this._tasks.length - 1 - rem; k >= 0; --k) {
                    kFrom = kTo - 1;
                    int ii = this._tasks[k].length - 1;
                    iFrom = ii * iBlocksz;
                    this._tasks[k][this._tasks[k].length - 1] = new BackSolveDiagTsk(0, k, kFrom, kTo -= kBlocksz, iFrom);
                    for (int i = 0; i < this._tasks[k].length - 1; ++i) {
                        this._tasks[k][i] = new BackSolveInnerTsk(pending, k, i, i + iBlocksz, kFrom, kTo, i * iBlocksz);
                    }
                    pending = 1;
                }
                this.addToPendingCount(this._tasks[0].length - 1);
            }

            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                try {
                    DelayedTask[][] arr$ = this._tasks;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        DelayedTask[] ary;
                        for (DelayedTask fjt : ary = arr$[i$]) {
                            fjt.cancel(true);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }

            public void compute() {
                this._tasks[this._tasks.length - 1][this._tasks[this._tasks.length - 1].length - 1].fork();
            }

            final class BackSolveInnerTsk
            extends DelayedTask {
                final int _kfrom;
                final int _kto;
                final int _ifrom;
                final int _ito;
                final int _row;
                final int _col;

                public BackSolveInnerTsk(int pending, int row, int col, int kfrom, int kto, int ifrom, int ito) {
                    super(pending);
                    this._kfrom = kfrom;
                    this._kto = kto;
                    this._ifrom = ifrom;
                    this._ito = ito;
                    this._col = col;
                    this._row = row;
                }

                public void compute() {
                    if (BackSolver.this.isCompletedAbnormally()) {
                        return;
                    }
                    try {
                        for (int k = this._kfrom; k >= this._kto; --k) {
                            double yk = BackSolver.this._y[k];
                            double[] x = Cholesky.this._xx[k - BackSolver.this._diagLen];
                            for (int i = this._ifrom; i < this._ito; ++i) {
                                int n = i;
                                BackSolver.this._y[n] = BackSolver.this._y[n] - yk * x[i];
                            }
                        }
                        if (this._row == 0) {
                            BackSolver.this.tryComplete();
                        } else {
                            BackSolver.this._tasks[this._row - 1][this._col].tryFork();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BackSolver.this.completeExceptionally(t);
                    }
                }

                public String toString() {
                    return "InnerTsk, ifrom = " + this._ifrom + ", kto = " + this._kto;
                }
            }

            final class BackSolveDiagTsk
            extends DelayedTask {
                final int _kfrom;
                final int _kto;
                final int _ifrom;
                final int _row;

                public BackSolveDiagTsk(int pending, int row, int kfrom, int kto, int ifrom) {
                    super(pending);
                    this._row = row;
                    this._kfrom = kfrom;
                    this._kto = kto;
                    this._ifrom = ifrom;
                }

                protected void compute() {
                    if (BackSolver.this.isCompletedAbnormally()) {
                        return;
                    }
                    try {
                        for (int k = this._kfrom; k >= this._kto; --k) {
                            int n = k;
                            BackSolver.this._y[n] = BackSolver.this._y[n] / Cholesky.this._xx[k - BackSolver.this._diagLen][k];
                            for (int i = this._ifrom; i < k; ++i) {
                                int n2 = i;
                                BackSolver.this._y[n2] = BackSolver.this._y[n2] - BackSolver.this._y[k] * Cholesky.this._xx[k - BackSolver.this._diagLen][i];
                            }
                        }
                        if (this._row == 0) {
                            BackSolver.this.tryComplete();
                        }
                        for (int i = 0; i < BackSolver.this._tasks[this._row].length - 1; ++i) {
                            BackSolver.this._tasks[this._row][i].tryFork();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        BackSolver.this.completeExceptionally(t);
                    }
                }

                public String toString() {
                    return "DiagTsk, ifrom = " + this._ifrom + ", kto = " + this._kto;
                }
            }
        }

        private final class BackSolver2
        extends CountedCompleter {
            final BackSolver2[] _tasks;
            private volatile int _endPtr;
            final double[] _y;
            final int _row;
            private final int _blocksz;
            private final int _rblocksz;
            private final CountedCompleter _cmp;
            final int _tid;

            public BackSolver2(CountedCompleter cmp, double[] y, int blocksz, int rBlock) {
                this(cmp, y.length - 1, y, new BackSolver2[(y.length - cholesky._diag.length) / rBlock], blocksz, rBlock, (y.length - cholesky._diag.length) / rBlock - 1);
                this._cmp.addToPendingCount(this._tasks.length - 1);
                int row = cholesky._diag.length + (y.length - cholesky._diag.length) % this._rblocksz + this._rblocksz - 1;
                int i = 0;
                while (i < this._tasks.length - 1) {
                    this._tasks[i] = cholesky.new BackSolver2(this._cmp, row, this._y, this._tasks, this._blocksz, rBlock, i);
                    ++i;
                    row += this._rblocksz;
                }
                assert (row == y.length - 1);
                this._tasks[this._tasks.length - 1] = this;
            }

            public BackSolver2(CountedCompleter cmp, int row, double[] y, BackSolver2[] tsks, int iBlock, int rBlock, int tid) {
                super(cmp);
                this._cmp = cmp;
                this._row = row;
                this._y = y;
                this._tasks = tsks;
                this._blocksz = iBlock;
                this._rblocksz = rBlock;
                this._endPtr = this._row + 1;
                this._tid = tid;
            }

            public void compute() {
                int rEnd = this._row - this._rblocksz;
                if (rEnd < Cholesky.this._diag.length + this._rblocksz) {
                    rEnd = Cholesky.this._diag.length;
                }
                int bStart = Math.max(0, rEnd - rEnd % this._blocksz);
                assert (this._tid == this._tasks.length - 1 || bStart >= this._tasks[this._tid + 1]._endPtr);
                for (int i = 0; i < this._rblocksz; ++i) {
                    double[] x = Cholesky.this._xx[this._row - Cholesky.this._diag.length - i];
                    int n = this._row - i;
                    double d = this._y[n] / x[this._row - i];
                    this._y[n] = d;
                    double yr = d;
                    for (int j = bStart; j < this._row - i; ++j) {
                        int n2 = j;
                        this._y[n2] = this._y[n2] - yr * x[j];
                    }
                }
                boolean first = true;
                while (bStart >= this._blocksz) {
                    int bEnd = bStart - this._blocksz;
                    if (this._tid != this._tasks.length - 1) {
                        while (this._tasks[this._tid + 1]._endPtr > bEnd) {
                            Thread.yield();
                        }
                    }
                    for (int r = this._row; r >= rEnd; --r) {
                        double[] x = Cholesky.this._xx[r - Cholesky.this._diag.length];
                        double yr = this._y[r];
                        for (int i = bStart - 1; i >= bEnd; --i) {
                            int n = i;
                            this._y[n] = this._y[n] - this._y[r] * x[i];
                        }
                    }
                    this._endPtr = bEnd;
                    if (first && this._tid > 0 && bEnd <= this._row - 2 * this._rblocksz - this._blocksz) {
                        this._tasks[this._tid - 1].fork();
                        first = false;
                    }
                    bStart -= this._blocksz;
                }
                assert (bStart == 0);
                this.tryComplete();
            }

            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
                return true;
            }
        }

        public static abstract class DelayedTask
        extends RecursiveAction {
            private static final Unsafe U;
            private static final long PENDING;
            private int _pending;

            public DelayedTask(int pending) {
                this._pending = pending;
            }

            public final void tryFork() {
                int c = this._pending;
                while (c != 0 && !U.compareAndSwapInt((Object)this, PENDING, c, c - 1)) {
                    c = this._pending;
                }
                if (c == 0) {
                    this.fork();
                }
            }

            static {
                try {
                    U = UtilUnsafe.getUnsafe();
                    PENDING = U.objectFieldOffset(CountedCompleter.class.getDeclaredField("pending"));
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        }
    }

    public static class InPlaceCholesky {
        final double[][] _xx;
        private boolean _isSPD;

        private InPlaceCholesky(double[][] xx, boolean isspd) {
            this._xx = xx;
            this._isSPD = isspd;
        }

        public static InPlaceCholesky decompose_2(double[][] xx, int STEP, int P) {
            boolean isspd = true;
            int N = xx.length;
            P = Math.max(1, P);
            for (int j = 0; j < N; j += STEP) {
                int p;
                int i;
                int tjR = Math.min(j + STEP, N);
                for (i = j; i < tjR; ++i) {
                    double[] rowi = xx[i];
                    double d = 0.0;
                    for (int k = j; k < i; ++k) {
                        double[] rowk = xx[k];
                        double s = 0.0;
                        for (int jj = 0; jj < k; ++jj) {
                            s += rowk[jj] * rowi[jj];
                        }
                        rowi[k] = s = (rowi[k] - s) / rowk[k];
                        d += s * s;
                    }
                    for (int jj = 0; jj < j; ++jj) {
                        double s = rowi[jj];
                        d += s * s;
                    }
                    d = rowi[i] - d;
                    isspd = isspd && d > 0.0;
                    rowi[i] = Math.sqrt(Math.max(0.0, d));
                }
                if (tjR == N) break;
                i = tjR;
                Futures fs = new Futures();
                int rpb = 0;
                for (p = P; tjR * (rpb = (N - tjR) / p) < 10000 && p > 1; --p) {
                }
                while (p-- > 1) {
                    fs.add((Future)new BlockTask(xx, i, i + rpb, j, tjR).fork());
                    i += rpb;
                }
                new BlockTask(xx, i, N, j, tjR).compute();
                fs.blockForPending();
            }
            return new InPlaceCholesky(xx, isspd);
        }

        public double[][] getL() {
            return this._xx;
        }

        public boolean isSPD() {
            return this._isSPD;
        }

        private static class BlockTask
        extends RecursiveAction {
            final double[][] _xx;
            final int _i0;
            final int _i1;
            final int _j0;
            final int _j1;

            public BlockTask(double[][] xx, int ifr, int ito, int jfr, int jto) {
                this._xx = xx;
                this._i0 = ifr;
                this._i1 = ito;
                this._j0 = jfr;
                this._j1 = jto;
            }

            public void compute() {
                for (int i = this._i0; i < this._i1; ++i) {
                    double[] rowi = this._xx[i];
                    for (int k = this._j0; k < this._j1; ++k) {
                        double[] rowk = this._xx[k];
                        double s = 0.0;
                        for (int jj = 0; jj < k; ++jj) {
                            s += rowk[jj] * rowi[jj];
                        }
                        rowi[k] = (rowi[k] - s) / rowk[k];
                    }
                }
            }
        }
    }
}

