/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.deeplearning.DeepLearning;
import hex.deeplearning.DeepLearningParameters;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.FrameV3;
import water.api.KeyV3;
import water.api.ModelParametersSchema;

public class DeepLearningV3
extends ModelBuilderSchema<DeepLearning, DeepLearningV3, DeepLearningParametersV3> {

    public static final class DeepLearningParametersV3
    extends ModelParametersSchema<DeepLearningParameters, DeepLearningParametersV3> {
        public static String[] own_fields = new String[]{"response_column", "weights_column", "offset_column", "balance_classes", "class_sampling_factors", "max_after_balance_size", "max_confusion_matrix_size", "max_hit_ratio_k", "checkpoint", "overwrite_with_best_model", "use_all_factor_levels", "activation", "hidden", "epochs", "train_samples_per_iteration", "target_ratio_comm_to_comp", "seed", "adaptive_rate", "rho", "epsilon", "rate", "rate_annealing", "rate_decay", "momentum_start", "momentum_ramp", "momentum_stable", "nesterov_accelerated_gradient", "input_dropout_ratio", "hidden_dropout_ratios", "l1", "l2", "max_w2", "initial_weight_distribution", "initial_weight_scale", "loss", "score_interval", "score_training_samples", "score_validation_samples", "score_duty_cycle", "classification_stop", "regression_stop", "score_validation_sampling", "diagnostics", "fast_mode", "force_load_balance", "variable_importances", "replicate_training_data", "single_node_mode", "shuffle_training_data", "missing_values_handling", "quiet_mode", "autoencoder", "sparse", "col_major", "average_activation", "sparsity_beta", "max_categorical_features", "reproducible", "export_weights_and_biases"};
        @API(help="Response column", is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns"}, direction=API.Direction.INOUT)
        public FrameV3.ColSpecifierV3 response_column;
        @API(help="Column with observation weights", is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns", "response_column"}, direction=API.Direction.INOUT)
        public FrameV3.ColSpecifierV3 weights_column;
        @API(help="Offset column", is_member_of_frames={"training_frame", "validation_frame"}, is_mutually_exclusive_with={"ignored_columns", "response_column", "weights_column"}, direction=API.Direction.INOUT)
        public FrameV3.ColSpecifierV3 offset_column;
        @API(help="Balance training data class counts via over/under-sampling (for imbalanced data).", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean balance_classes;
        @API(help="Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes.", level=API.Level.expert, direction=API.Direction.INOUT)
        public float[] class_sampling_factors;
        @API(help="Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes.", level=API.Level.expert, direction=API.Direction.INOUT)
        public float max_after_balance_size;
        @API(help="Maximum size (# classes) for confusion matrices to be printed in the Logs", level=API.Level.secondary, direction=API.Direction.INOUT)
        public int max_confusion_matrix_size;
        @API(help="Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public int max_hit_ratio_k;
        @API(help="Model checkpoint to resume training with", level=API.Level.secondary, direction=API.Direction.INOUT)
        public KeyV3.ModelKeyV3 checkpoint;
        @API(help="If enabled, override the final model with the best model found during training", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean overwrite_with_best_model;
        @API(help="Auto-Encoder", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean autoencoder;
        @API(help="Use all factor levels of categorical variables. Otherwise, the first factor level is omitted (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder.", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean use_all_factor_levels;
        @API(help="Activation function", values={"Tanh", "TanhWithDropout", "Rectifier", "RectifierWithDropout", "Maxout", "MaxoutWithDropout"}, level=API.Level.critical, direction=API.Direction.INOUT)
        public DeepLearningParameters.Activation activation;
        @API(help="Hidden layer sizes (e.g. 100,100).", level=API.Level.critical, direction=API.Direction.INOUT)
        public int[] hidden;
        @API(help="How many times the dataset should be iterated (streamed), can be fractional", level=API.Level.critical, direction=API.Direction.INOUT)
        public double epochs;
        @API(help="Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic", level=API.Level.secondary, direction=API.Direction.INOUT)
        public long train_samples_per_iteration;
        @API(help="Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration=-2 (auto-tuning)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double target_ratio_comm_to_comp;
        @API(help="Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded", level=API.Level.expert, direction=API.Direction.INOUT)
        public long seed;
        @API(help="Adaptive learning rate", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean adaptive_rate;
        @API(help="Adaptive learning rate time decay factor (similarity to prior updates)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double rho;
        @API(help="Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double epsilon;
        @API(help="Learning rate (higher => less stable, lower => slower convergence)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double rate;
        @API(help="Learning rate annealing: rate / (1 + rate_annealing * samples)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double rate_annealing;
        @API(help="Learning rate decay factor between layers (N-th layer: rate*alpha^(N-1))", level=API.Level.expert, direction=API.Direction.INOUT)
        public double rate_decay;
        @API(help="Initial momentum at the beginning of training (try 0.5)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double momentum_start;
        @API(help="Number of training samples for which momentum increases", level=API.Level.expert, direction=API.Direction.INOUT)
        public double momentum_ramp;
        @API(help="Final momentum after the ramp is over (try 0.99)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double momentum_stable;
        @API(help="Use Nesterov accelerated gradient (recommended)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean nesterov_accelerated_gradient;
        @API(help="Input layer dropout ratio (can improve generalization, try 0.1 or 0.2)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double input_dropout_ratio;
        @API(help="Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double[] hidden_dropout_ratios;
        @API(help="L1 regularization (can add stability and improve generalization, causes many weights to become 0)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double l1;
        @API(help="L2 regularization (can add stability and improve generalization, causes many weights to be small", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double l2;
        @API(help="Constraint for squared sum of incoming weights per unit (e.g. for Rectifier)", level=API.Level.expert, direction=API.Direction.INOUT)
        public float max_w2;
        @API(help="Initial Weight Distribution", values={"UniformAdaptive", "Uniform", "Normal"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningParameters.InitialWeightDistribution initial_weight_distribution;
        @API(help="Uniform: -value...value, Normal: stddev)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double initial_weight_scale;
        @API(help="Loss function", values={"Automatic", "CrossEntropy", "MeanSquare", "Huber", "Absolute"}, required=false, level=API.Level.secondary, direction=API.Direction.INOUT)
        public DeepLearningParameters.Loss loss;
        @API(help="Shortest time interval (in secs) between model scoring", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double score_interval;
        @API(help="Number of training set samples for scoring (0 for all)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public long score_training_samples;
        @API(help="Number of validation set samples for scoring (0 for all)", level=API.Level.secondary, direction=API.Direction.INOUT)
        public long score_validation_samples;
        @API(help="Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).", level=API.Level.secondary, direction=API.Direction.INOUT)
        public double score_duty_cycle;
        @API(help="Stopping criterion for classification error fraction on training data (-1 to disable)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double classification_stop;
        @API(help="Stopping criterion for regression error (MSE) on training data (-1 to disable)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double regression_stop;
        @API(help="Enable quiet mode for less output to standard output", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean quiet_mode;
        @API(help="Method used to sample validation dataset for scoring", values={"Uniform", "Stratified"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningParameters.ClassSamplingMethod score_validation_sampling;
        @API(help="Enable diagnostics for hidden layers", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean diagnostics;
        @API(help="Compute variable importances for input features (Gedeon method) - can be slow for large networks", direction=API.Direction.INOUT)
        public boolean variable_importances;
        @API(help="Enable fast mode (minor approximation in back-propagation)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean fast_mode;
        @API(help="Force extra load balancing to increase training speed for small datasets (to keep all cores busy)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean force_load_balance;
        @API(help="Replicate the entire training dataset onto every node for faster training on small datasets", level=API.Level.secondary, direction=API.Direction.INOUT)
        public boolean replicate_training_data;
        @API(help="Run on a single node for fine-tuning of model parameters", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean single_node_mode;
        @API(help="Enable shuffling of training data (recommended if training data is replicated and train_samples_per_iteration is close to #nodes x #rows, of if using balance_classes)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean shuffle_training_data;
        @API(help="Handling of missing values. Either Skip or MeanImputation.", values={"Skip", "MeanImputation"}, level=API.Level.expert, direction=API.Direction.INOUT)
        public DeepLearningParameters.MissingValuesHandling missing_values_handling;
        @API(help="Sparse data handling (Experimental).", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean sparse;
        @API(help="Use a column major weight matrix for input layer. Can speed up forward propagation, but might slow down backpropagation (Experimental).", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean col_major;
        @API(help="Average activation for sparse auto-encoder (Experimental)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double average_activation;
        @API(help="Sparsity regularization (Experimental)", level=API.Level.expert, direction=API.Direction.INOUT)
        public double sparsity_beta;
        @API(help="Max. number of categorical features, enforced via hashing (Experimental)", level=API.Level.expert, direction=API.Direction.INOUT)
        public int max_categorical_features;
        @API(help="Force reproducibility on small data (will be slow - only uses 1 thread)", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean reproducible;
        @API(help="Whether to export Neural Network weights and biases to H2O Frames", level=API.Level.expert, direction=API.Direction.INOUT)
        public boolean export_weights_and_biases;
    }
}

