/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.glm.GLMModel;
import hex.schemas.GLMV3;
import java.util.Arrays;
import java.util.Comparator;
import water.api.API;
import water.api.ModelOutputSchema;
import water.api.ModelSchema;
import water.api.TwoDimTableBase;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class GLMModelV3
extends ModelSchema<GLMModel, GLMModelV3, GLMModel.GLMParameters, GLMV3.GLMParametersV3, GLMModel.GLMOutput, GLMModelOutputV3> {
    public GLMV3.GLMParametersV3 createParametersSchema() {
        return new GLMV3.GLMParametersV3();
    }

    public GLMModelOutputV3 createOutputSchema() {
        return new GLMModelOutputV3();
    }

    public GLMModel createImpl() {
        GLMModel.GLMParameters parms = (GLMModel.GLMParameters)((GLMV3.GLMParametersV3)this.parameters).createImpl();
        return new GLMModel(this.model_id.key(), parms, null, 0.0, 0.0, 0.0, 0L, false, false);
    }

    public static final class GLMModelOutputV3
    extends ModelOutputSchema<GLMModel.GLMOutput, GLMModelOutputV3> {
        @API(help="Table of Coefficients")
        TwoDimTableBase coefficients_table;
        @API(help="Standardized Coefficient Magnitudes")
        TwoDimTableBase standardized_coefficients_magnitude;

        public GLMModelOutputV3 fillFromImpl(GLMModel.GLMOutput impl) {
            super.fillFromImpl((Model.Output)impl);
            String[] names = (String[])impl.coefficientNames().clone();
            String[] ns = ArrayUtils.append((String[])new String[]{"Intercept"}, (String[])Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableBase();
            double[] beta = impl.beta();
            if (impl.isStandardized()) {
                int i;
                int i2;
                double[] norm_beta = impl.getNormBeta();
                String[] colTypes = new String[]{"double", "double"};
                String[] colFormats = new String[]{"%5f", "%5f"};
                TwoDimTable tdt = new TwoDimTable("Coefficients", "glm coefficients", ns, new String[]{"Coefficients", "Standardized Coefficients"}, colTypes, colFormats, "names");
                tdt.set(0, 0, (Object)beta[beta.length - 1]);
                tdt.set(0, 1, (Object)norm_beta[norm_beta.length - 1]);
                for (i2 = 0; i2 < beta.length - 1; ++i2) {
                    tdt.set(i2 + 1, 0, (Object)beta[i2]);
                    tdt.set(i2 + 1, 1, (Object)norm_beta[i2]);
                }
                this.coefficients_table.fillFromImpl(tdt);
                final double[] magnitudes = (double[])norm_beta.clone();
                for (i2 = 0; i2 < magnitudes.length; ++i2) {
                    if (!(magnitudes[i2] < 0.0)) continue;
                    int n = i2;
                    magnitudes[n] = magnitudes[n] * -1.0;
                }
                Integer[] indices = new Integer[magnitudes.length - 1];
                for (int i3 = 0; i3 < indices.length; ++i3) {
                    indices[i3] = i3;
                }
                Arrays.sort(indices, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        if (magnitudes[o1] < magnitudes[o2]) {
                            return 1;
                        }
                        if (magnitudes[o1] > magnitudes[o2]) {
                            return -1;
                        }
                        return 0;
                    }
                });
                String[] names2 = new String[names.length];
                for (i = 0; i < names2.length - 1; ++i) {
                    names2[i] = names[indices[i]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i = 0; i < beta.length - 1; ++i) {
                    tdt.set(i, 0, (Object)magnitudes[indices[i]]);
                    tdt.set(i, 1, (Object)(beta[indices[i]] < 0.0 ? "NEG" : "POS"));
                }
                this.standardized_coefficients_magnitude = new TwoDimTableBase();
                this.standardized_coefficients_magnitude.fillFromImpl(tdt);
            } else {
                int i;
                String[] colTypes = new String[]{"double"};
                String[] colFormats = new String[]{"%5f"};
                TwoDimTable tdt = new TwoDimTable("Coefficients", "glm coefficients", ns, new String[]{"Coefficients"}, colTypes, colFormats, "names");
                tdt.set(0, 0, (Object)beta[beta.length - 1]);
                for (i = 0; i < beta.length - 1; ++i) {
                    tdt.set(i + 1, 0, (Object)beta[i]);
                }
                this.coefficients_table.fillFromImpl(tdt);
                double[] magnitudes = (double[])beta.clone();
                for (i = 0; i < magnitudes.length - 1; ++i) {
                    if (!(magnitudes[i] < 0.0)) continue;
                    int n = i;
                    magnitudes[n] = magnitudes[n] * -1.0;
                }
            }
            return this;
        }
    }
}

