/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.parser.ValueString;

public class WordCountTask
extends MRTask<WordCountTask> {
    private static NonBlockingHashMap<ValueStringCount, ValueStringCount> VOCABHM;
    private NonBlockingHashMap<ValueStringCount, ValueStringCount> _vocabHM;
    private transient ValueStringCount[] _vocabArray;
    private final int _minFreq;
    Key _wordCountKey = null;

    public WordCountTask() {
        this._minFreq = 0;
    }

    public WordCountTask(int minFreq) {
        this._minFreq = minFreq;
    }

    protected void setupLocal() {
        VOCABHM = new NonBlockingHashMap();
    }

    public void map(Chunk[] cs) {
        this._vocabHM = VOCABHM;
        for (Chunk chk : cs) {
            if (!(chk instanceof CStrChunk)) continue;
            ValueStringCount tmp = new ValueStringCount();
            for (int row = 0; row < chk._len; ++row) {
                chk.atStr((ValueString)tmp, row);
                ValueStringCount tmp2 = (ValueStringCount)((Object)VOCABHM.get((Object)tmp));
                if (tmp2 == null) {
                    VOCABHM.put((Object)tmp, (Object)tmp);
                    tmp = new ValueStringCount();
                    continue;
                }
                tmp2.inc();
            }
        }
    }

    public void reduce(WordCountTask that) {
        if (this._vocabHM != that._vocabHM) {
            throw H2O.unimpl();
        }
    }

    public AutoBuffer write_impl(AutoBuffer ab) {
        if (this._vocabHM == null) {
            return ab.put1(1);
        }
        int strLen = 0;
        for (ValueStringCount val : VOCABHM.values()) {
            strLen += val.length();
        }
        ab.put1(0);
        ab.put4(strLen);
        for (ValueStringCount val : VOCABHM.values()) {
            ab.put2((char)val.length()).putA1(val.getBuffer(), val.getOffset(), val.getOffset() + val.length()).put8(val._cnt);
        }
        return ab.put2('\uffff');
    }

    public WordCountTask read_impl(AutoBuffer ab) {
        this._vocabHM = VOCABHM;
        int off = 0;
        if (ab.get1() == 1) {
            return this;
        }
        int len = ab.get4();
        byte[] buf = new byte[len];
        while (true) {
            char c = ab.get2();
            len = c;
            if (c == '\uffff') break;
            ValueStringCount vsc1 = new ValueStringCount();
            System.arraycopy(ab.getA1(len), 0, buf, off, len);
            vsc1.set(buf, off, len, ab.get8());
            off += len;
            ValueStringCount vsc2 = (ValueStringCount)((Object)VOCABHM.putIfAbsent((Object)vsc1, (Object)vsc1));
            if (vsc2 == null) continue;
            vsc2.inc(vsc1._cnt);
        }
        return this;
    }

    protected void copyOver(WordCountTask lv) {
        this._vocabHM = lv._vocabHM;
    }

    public void postGlobal() {
        if (this._minFreq > 1) {
            this.filterMin();
        }
        this._vocabArray = this._vocabHM.values().toArray(new ValueStringCount[this._vocabHM.size()]);
        Arrays.sort((Object[])this._vocabArray);
        this._vocabHM = null;
        VOCABHM = null;
        this.buildFrame();
    }

    private void filterMin() {
        for (ValueStringCount vs : this._vocabHM.values()) {
            if (vs._cnt >= (long)this._minFreq) continue;
            this._vocabHM.remove((Object)vs);
        }
    }

    private void buildFrame() {
        Futures fs = new Futures();
        Vec[] vecs = new Vec[2];
        Key[] keys = Vec.VectorGroup.VG_LEN1.addVecs(2);
        AppendableVec wordAV = new AppendableVec(keys[0]);
        AppendableVec cntAV = new AppendableVec(keys[1]);
        NewChunk wordNC = new NewChunk((Vec)wordAV, 0);
        NewChunk cntNC = new NewChunk((Vec)cntAV, 0);
        for (ValueStringCount vwc : this._vocabArray) {
            wordNC.addStr((ValueString)vwc);
            cntNC.addNum(vwc._cnt, 0);
        }
        wordNC.close(0, fs);
        cntNC.close(0, fs);
        vecs[0] = wordAV.close(fs);
        vecs[1] = cntAV.close(fs);
        fs.blockForPending();
        this._wordCountKey = this._fr != null && this._fr._key != null ? Key.make((String)("wca_" + this._fr._key.toString())) : Key.make((String)"wca");
        String[] names = new String[]{"Word", "Count"};
        DKV.put((Key)this._wordCountKey, (Iced)new Frame(this._wordCountKey, names, vecs));
    }

    protected static class ValueStringCount
    extends ValueString {
        volatile long _cnt = 1L;
        private static final AtomicLongFieldUpdater<ValueStringCount> _cntUpdater = AtomicLongFieldUpdater.newUpdater(ValueStringCount.class, "_cnt");

        protected ValueStringCount() {
        }

        public void inc(long d) {
            long r = this._cnt;
            while (!_cntUpdater.compareAndSet(this, r, r + d)) {
                r = this._cnt;
            }
        }

        public void inc() {
            long r = this._cnt;
            while (!_cntUpdater.compareAndSet(this, r, r + 1L)) {
                r = this._cnt;
            }
        }

        public ValueStringCount set(byte[] buf, int off, int len, long cnt) {
            this.set(buf, off, len);
            long r = this._cnt;
            while (!_cntUpdater.compareAndSet(this, r, cnt)) {
                r = this._cnt;
            }
            return this;
        }

        public int compareTo(ValueString that) {
            int BEFORE = -1;
            boolean EQUAL = false;
            boolean AFTER = true;
            if (this == that) {
                return 0;
            }
            if (that instanceof ValueStringCount) {
                long res = ((ValueStringCount)that)._cnt - this._cnt;
                if (res > 0L) {
                    return 1;
                }
                if (res < 0L) {
                    return -1;
                }
            }
            return super.compareTo(that);
        }
    }
}

