/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class DataInfo
extends Keyed {
    public int[] _activeCols;
    public Frame _adaptedFrame;
    public int _responses;
    public TransformType _predictor_transform;
    public TransformType _response_transform;
    public boolean _useAllFactorLevels;
    public int _nums;
    public int _bins;
    public int _cats;
    public int[] _catOffsets;
    public int[] _catMissing;
    public int[] _permutation;
    public double[] _normMul;
    public double[] _normSub;
    public double[] _normRespMul;
    public double[] _normRespSub;
    public boolean _intercept = true;
    public boolean _offset = false;
    public final boolean _skipMissing;
    public boolean _valid;
    final int[][] _catLvls;

    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    private DataInfo() {
        super(null);
        this._catLvls = null;
        this._skipMissing = true;
        this._valid = false;
    }

    public DataInfo deep_clone() {
        AutoBuffer ab = new AutoBuffer();
        this.write(ab);
        ab.flipForReading();
        return (DataInfo)new DataInfo().read(ab);
    }

    public DataInfo(Key selfKey, Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean missingBucket) {
        super(selfKey);
        int i;
        int i2;
        this._valid = false;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._skipMissing = skipMissing;
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._responses = nResponses;
        this._useAllFactorLevels = useAllFactorLevels;
        this._catLvls = null;
        this._permutation = new int[train.numCols()];
        Vec[] tvecs = train.vecs();
        Vec[] vvecs = valid == null ? null : valid.vecs();
        int n = tvecs.length - this._responses;
        assert (n >= 1);
        int[] nums = MemoryManager.malloc4((int)n);
        int[] cats = MemoryManager.malloc4((int)n);
        int nnums = 0;
        int ncats = 0;
        for (i2 = 0; i2 < n; ++i2) {
            if (tvecs[i2].isEnum()) {
                cats[ncats++] = i2;
                continue;
            }
            nums[nnums++] = i2;
        }
        this._nums = nnums;
        this._cats = ncats;
        for (i2 = 0; i2 < ncats; ++i2) {
            for (int j = i2 + 1; j < ncats; ++j) {
                if (tvecs[cats[i2]].domain().length >= tvecs[cats[j]].domain().length) continue;
                int x = cats[i2];
                cats[i2] = cats[j];
                cats[j] = x;
            }
        }
        String[] names = new String[train.numCols()];
        Vec[] tvecs2 = new Vec[train.numCols()];
        this._catOffsets = MemoryManager.malloc4((int)(ncats + 1));
        this._catMissing = new int[ncats];
        this._catOffsets[0] = 0;
        int len = 0;
        for (i = 0; i < ncats; ++i) {
            this._permutation[i] = cats[i];
            names[i] = train._names[cats[i]];
            Vec v = tvecs2[i] = tvecs[cats[i]];
            this._catMissing[i] = missingBucket ? 1 : 0;
            this._catOffsets[i + 1] = len += v.domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
        }
        for (i = 0; i < this._nums; ++i) {
            names[i + this._cats] = train._names[nums[i]];
            tvecs2[i + this._cats] = train.vec(nums[i]);
            this._permutation[i + this._cats] = nums[i];
        }
        for (i = names.length - nResponses; i < names.length; ++i) {
            names[i] = train._names[i];
            tvecs2[i] = train.vec(i);
        }
        this._adaptedFrame = new Frame(names, tvecs2);
        train.restructure(names, tvecs2);
        if (valid != null) {
            valid.restructure(names, valid.vecs(names));
        }
        this.setPredictorTransform(predictor_transform);
        if (this._responses > 0) {
            this.setResponseTransform(response_transform);
        }
    }

    public DataInfo validDinfo(Frame valid) {
        DataInfo res = new DataInfo(Key.make(), this._adaptedFrame, null, 1, this._useAllFactorLevels, TransformType.NONE, TransformType.NONE, this._skipMissing, false);
        res._adaptedFrame = new Frame(this._adaptedFrame.names(), valid.vecs(this._adaptedFrame.names()));
        res._valid = true;
        return res;
    }

    public double[] denormalizeBeta(double[] beta) {
        assert (beta.length == this.fullN() + 1);
        beta = MemoryManager.arrayCopyOf((double[])beta, (int)beta.length);
        if (this._predictor_transform == TransformType.STANDARDIZE) {
            int numoff;
            double norm = 0.0;
            for (int i = numoff = this.numStart(); i < beta.length - 1; ++i) {
                double b = beta[i] * this._normMul[i - numoff];
                norm += b * this._normSub[i - numoff];
                beta[i] = b;
            }
            int n = beta.length - 1;
            beta[n] = beta[n] - norm;
        }
        return beta;
    }

    private DataInfo(Key selfKey, Frame fr, int[][] catLevels, int responses, TransformType predictor_transform, TransformType response_transform, boolean skipMissing) {
        super(selfKey);
        this._valid = false;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._skipMissing = skipMissing;
        this._adaptedFrame = fr;
        this._catOffsets = MemoryManager.malloc4((int)(catLevels.length + 1));
        this._catMissing = new int[catLevels.length];
        int s = 0;
        for (int i = 0; i < catLevels.length; ++i) {
            this._catOffsets[i] = s;
            s += catLevels[i].length;
        }
        this._catLvls = catLevels;
        this._catOffsets[this._catOffsets.length - 1] = s;
        this._responses = responses;
        this._cats = catLevels.length;
        this._nums = fr.numCols() - this._cats - responses;
        this._useAllFactorLevels = true;
        this.setPredictorTransform(predictor_transform);
        this.setResponseTransform(response_transform);
    }

    public DataInfo filterExpandedColumns(int[] cols) {
        int k;
        assert (this._predictor_transform != null);
        assert (this._response_transform != null);
        if (cols == null) {
            return this;
        }
        int i = 0;
        int j = 0;
        int ignoredCnt = 0;
        int[][] catLvls = new int[this._cats][];
        int[] ignoredCols = MemoryManager.malloc4((int)(this._nums + this._cats));
        if (this._catOffsets != null) {
            while (i < cols.length && cols[i] < this._catOffsets[this._catOffsets.length - 1]) {
                int[] levels = MemoryManager.malloc4((int)(this._catOffsets[j + 1] - this._catOffsets[j]));
                k = 0;
                while (i < cols.length && cols[i] < this._catOffsets[j + 1]) {
                    levels[k++] = cols[i++] - this._catOffsets[j];
                }
                if (k > 0) {
                    catLvls[j] = Arrays.copyOf(levels, k);
                }
                ++j;
            }
        }
        for (int k2 = 0; k2 < catLvls.length; ++k2) {
            if (catLvls[k2] != null) continue;
            ignoredCols[ignoredCnt++] = k2;
        }
        if (ignoredCnt > 0) {
            int[][] c = new int[this._cats - ignoredCnt][];
            int y = 0;
            for (int[] catLvl : catLvls) {
                if (catLvl == null) continue;
                c[y++] = catLvl;
            }
            assert (y == c.length);
            catLvls = c;
        }
        j = 0;
        int prev = 0;
        while (i < cols.length) {
            for (k = prev; k < cols[i] - this.numStart(); ++k) {
                ignoredCols[ignoredCnt++] = k + this._cats;
                ++j;
            }
            prev = ++j;
            ++i;
        }
        for (k = prev; k < this._nums; ++k) {
            ignoredCols[ignoredCnt++] = k + this._cats;
        }
        Frame f = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
        if (ignoredCnt > 0) {
            f.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
        }
        assert (catLvls.length < f.numCols()) : "cats = " + catLvls.length + " numcols = " + f.numCols();
        DataInfo dinfo = new DataInfo(this._key, f, catLvls, this._responses, this._predictor_transform, this._response_transform, this._skipMissing);
        dinfo._activeCols = cols;
        return dinfo;
    }

    private void setTransform(TransformType t, double[] normMul, double[] normSub, int vecStart, int n) {
        for (int i = 0; i < n; ++i) {
            Vec v = this._adaptedFrame.vec(vecStart + i);
            switch (t) {
                case STANDARDIZE: {
                    normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case NORMALIZE: {
                    normMul[i] = v.max() - v.min() > 0.0 ? 1.0 / (v.max() - v.min()) : 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case DEMEAN: {
                    normMul[i] = 1.0;
                    normSub[i] = v.mean();
                    break;
                }
                case DESCALE: {
                    normMul[i] = v.sigma() != 0.0 ? 1.0 / v.sigma() : 1.0;
                    normSub[i] = 0.0;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            assert (!Double.isNaN(normMul[i]));
            assert (!Double.isNaN(normSub[i]));
        }
    }

    public void setPredictorTransform(TransformType t) {
        this._predictor_transform = t;
        if (t == TransformType.NONE) {
            this._normMul = null;
            this._normSub = null;
        } else {
            this._normMul = MemoryManager.malloc8d((int)this._nums);
            this._normSub = MemoryManager.malloc8d((int)this._nums);
            this.setTransform(t, this._normMul, this._normSub, this._cats, this._nums);
        }
    }

    public void setResponseTransform(TransformType t) {
        this._response_transform = t;
        if (t == TransformType.NONE) {
            this._normRespMul = null;
            this._normRespSub = null;
        } else {
            this._normRespMul = MemoryManager.malloc8d((int)this._responses);
            this._normRespSub = MemoryManager.malloc8d((int)this._responses);
            this.setTransform(t, this._normRespMul, this._normRespSub, this._adaptedFrame.numCols() - this._responses, this._responses);
        }
    }

    public final int fullN() {
        return this._nums + this._catOffsets[this._cats];
    }

    public final int largestCat() {
        return this._cats > 0 ? this._catOffsets[1] : 0;
    }

    public final int numStart() {
        return this._catOffsets[this._cats];
    }

    public final String[] coefNames() {
        int k = 0;
        int n = this.fullN();
        String[] res = new String[n];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (int i = 0; i < this._cats; ++i) {
            int j;
            int n2 = j = this._useAllFactorLevels ? 0 : 1;
            while (j < vecs[i].domain().length) {
                res[k++] = this._adaptedFrame._names[i] + "." + vecs[i].domain()[j];
                ++j;
            }
            if (this._catMissing[i] <= 0) continue;
            res[k++] = this._adaptedFrame._names[i] + ".missing(NA)";
        }
        int nums = n - k;
        System.arraycopy(this._adaptedFrame._names, this._cats, res, k, nums);
        return res;
    }

    public int[] mapNames(String[] names) {
        assert (names.length == this._adaptedFrame._names.length) : "Names must be the same length!";
        int[] idx = new int[names.length];
        Arrays.fill(idx, -1);
        block0: for (int i = 0; i < this._adaptedFrame._names.length; ++i) {
            for (int j = 0; j < names.length; ++j) {
                if (!names[j].equals(this._adaptedFrame.name(i))) continue;
                idx[i] = j;
                continue block0;
            }
        }
        return idx;
    }

    public final void unScaleNumericals(float[] in, float[] out) {
        if (this._nums == 0) {
            return;
        }
        assert (in.length == out.length);
        assert (in.length == this.fullN());
        for (int k = this.numStart(); k < this.fullN(); ++k) {
            out[k] = in[k] / (float)this._normMul[k - this.numStart()] + (float)this._normSub[k - this.numStart()];
        }
    }

    public final int getCategoricalId(int cid, int val) {
        int c = this._catLvls != null ? Arrays.binarySearch(this._catLvls[cid], val) : val - (this._useAllFactorLevels ? 0 : 1);
        if (c < 0) {
            return -1;
        }
        int v = c + this._catOffsets[cid];
        if (v >= this._catOffsets[cid + 1]) {
            assert (this._valid) : "categorical value out of bounds, got " + v + ", next cat starts at " + this._catOffsets[cid + 1];
            return -2;
        }
        return v;
    }

    public final Row extractDenseRow(Chunk[] chunks, int rid, Row row) {
        int i;
        row.bad = false;
        row.rid = (long)rid + chunks[0].start();
        if (this._skipMissing) {
            for (Chunk c : chunks) {
                if (!c.isNA(rid)) continue;
                row.bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (int i2 = 0; i2 < this._cats; ++i2) {
            if (chunks[i2].isNA(rid)) {
                row.binIds[nbins++] = this._catOffsets[i2 + 1] - 1;
                continue;
            }
            int c = this.getCategoricalId(i2, (int)chunks[i2].at8(rid));
            if (c < 0) continue;
            row.binIds[nbins++] = c;
        }
        row.nBins = nbins;
        int n = this._nums;
        for (i = 0; i < n; ++i) {
            double d = chunks[this._cats + i].atd(rid);
            if (this._normMul != null && this._normSub != null) {
                d = (d - this._normSub[i]) * this._normMul[i];
            }
            row.numVals[i] = d;
        }
        for (i = 0; i < this._responses; ++i) {
            row.response[i] = chunks[chunks.length - this._responses + i].atd(rid);
            if (this._normRespMul != null) {
                row.response[i] = (row.response[i] - this._normRespSub[i]) * this._normRespMul[i];
            }
            if (!Double.isNaN(row.response[i])) continue;
            row.bad = true;
            return row;
        }
        return row;
    }

    public Row newDenseRow() {
        return new Row(false, this._nums, this._cats, this._responses, 0.0);
    }

    public final Row[] extractSparseRows(Chunk[] chunks, double[] beta) {
        int r;
        Chunk c;
        int cid;
        int i;
        if (!this._skipMissing) {
            throw H2O.unimpl();
        }
        Row[] rows = new Row[chunks[0]._len];
        double etaOffset = 0.0;
        if (this._normMul != null && this._normSub != null && beta != null) {
            for (i = 0; i < this._nums; ++i) {
                etaOffset -= beta[i + this.numStart()] * this._normSub[i] * this._normMul[i];
            }
        }
        for (i = 0; i < rows.length; ++i) {
            rows[i] = new Row(true, Math.min(this._nums - this._bins, 16), Math.min(this._bins, 16) + this._cats, this._responses, etaOffset);
            rows[i].rid = chunks[0].start() + (long)i;
        }
        for (i = 0; i < this._cats; ++i) {
            for (int r2 = 0; r2 < chunks[0]._len; ++r2) {
                Row row = rows[r2];
                if (chunks[i].isNA(r2)) {
                    if (this._skipMissing) {
                        row.bad = true;
                        continue;
                    }
                    row.binIds[row.nBins++] = this._catOffsets[i + 1] - 1;
                    continue;
                }
                int c2 = this.getCategoricalId(i, (int)chunks[i].at8(r2));
                if (c2 < 0) continue;
                row.binIds[row.nBins++] = c2;
            }
        }
        int numStart = this.numStart();
        for (cid = 0; cid < this._bins; ++cid) {
            c = chunks[cid + this._cats];
            r = c.nextNZ(-1);
            while (r < c._len) {
                if (c.isSparse() || c.atd(r) != 0.0) {
                    Row row = rows[r];
                    if (c.isNA(r)) {
                        row.bad = this._skipMissing;
                    }
                    if (!row.bad) {
                        row.addBinId(cid + numStart);
                    }
                }
                r = c.nextNZ(r);
            }
        }
        for (cid = 0; cid < this._nums; ++cid) {
            c = chunks[this._cats + cid];
            int oldRow = -1;
            int r3 = c.nextNZ(-1);
            while (r3 < c._len) {
                if (c.isSparse() || c.atd(r3) != 0.0) {
                    assert (r3 > oldRow);
                    oldRow = r3;
                    Row row = rows[r3];
                    if (c.isNA(r3)) {
                        row.bad = this._skipMissing;
                    }
                    if (!row.bad) {
                        double d = c.atd(r3);
                        if (this._normMul != null) {
                            d *= this._normMul[cid];
                        }
                        row.addNum(cid + numStart + this._bins, d);
                    }
                }
                r3 = c.nextNZ(r3);
            }
        }
        for (int i2 = 1; i2 <= this._responses; ++i2) {
            Chunk rChunk = chunks[chunks.length - i2];
            for (r = 0; r < chunks[0]._len; ++r) {
                Row row = rows[r];
                double d = rChunk.atd(r);
                row.response[row.response.length - i2] = rChunk.atd(r);
                if (this._normRespMul != null) {
                    assert (false);
                    row.response[i2] = (row.response[i2] - this._normRespSub[i2]) * this._normRespMul[i2];
                }
                if (!Double.isNaN(row.response[row.response.length - i2])) continue;
                row.bad = true;
            }
        }
        return rows;
    }

    public final class Row {
        public boolean bad;
        public double[] numVals;
        public double[] response;
        public int[] numIds;
        public int[] binIds;
        public long rid;
        public int nBins;
        public int nNums;
        public final double etaOffset;

        public final boolean isSparse() {
            return this.numIds != null;
        }

        public Row(boolean sparse, int nNums, int nBins, int nresponses, double etaOffset) {
            this.binIds = MemoryManager.malloc4((int)nBins);
            this.numVals = MemoryManager.malloc8d((int)nNums);
            this.response = MemoryManager.malloc8d((int)nresponses);
            if (sparse) {
                this.numIds = MemoryManager.malloc4((int)nNums);
            }
            this.etaOffset = etaOffset;
            this.nNums = sparse ? 0 : nNums;
        }

        public double response(int i) {
            return this.response[i];
        }

        public void addBinId(int id) {
            if (this.binIds.length == this.nBins) {
                this.binIds = Arrays.copyOf(this.binIds, Math.max(4, this.binIds.length + (this.binIds.length >> 1)));
            }
            this.binIds[this.nBins++] = id;
        }

        public void addNum(int id, double val) {
            if (this.numIds.length == this.nNums) {
                int newSz = Math.max(4, this.numIds.length + (this.numIds.length >> 1));
                this.numIds = Arrays.copyOf(this.numIds, newSz);
                this.numVals = Arrays.copyOf(this.numVals, newSz);
            }
            int i = this.nNums++;
            this.numIds[i] = id;
            this.numVals[i] = val;
        }

        public final double innerProduct(double[] vec) {
            int i;
            double res = 0.0;
            int numStart = DataInfo.this.numStart();
            for (i = 0; i < this.nBins; ++i) {
                res += vec[this.binIds[i]];
            }
            if (this.numIds == null) {
                for (i = 0; i < this.numVals.length; ++i) {
                    res += this.numVals[i] * vec[numStart + i];
                }
            } else {
                res += this.etaOffset;
                for (i = 0; i < this.nNums; ++i) {
                    res += this.numVals[i] * vec[this.numIds[i]];
                }
            }
            if (DataInfo.this._intercept) {
                res += vec[vec.length - 1];
            }
            return res;
        }

        public String toString() {
            return this.rid + Arrays.toString(Arrays.copyOf(this.binIds, this.nBins)) + ", " + Arrays.toString(this.numVals);
        }
    }

    public static enum TransformType {
        NONE,
        STANDARDIZE,
        NORMALIZE,
        DEMEAN,
        DESCALE;

    }
}

