/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.glm.GLMModel;
import hex.glm.GLMValidation;
import hex.gram.Gram;
import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.CBSChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.FrameUtils;

public abstract class GLMTask {

    public static class GLMIterationTask
    extends MRTask<GLMIterationTask> {
        final Key _jobKey;
        final DataInfo _dinfo;
        final GLMModel.GLMParameters _glm;
        final double[] _beta;
        protected Gram _gram;
        double[] _xy;
        double _yy;
        GLMValidation _val;
        final double _ymu;
        long _nobs;
        final boolean _validate;
        int[] _ti;
        public double _likelihood;
        final double _lambda;
        boolean _sparse;
        Vec _rowFilter;

        public GLMIterationTask(Key jobKey, DataInfo dinfo, double lambda, GLMModel.GLMParameters glm, boolean validate, double[] beta, double ymu, Vec rowFilter, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._jobKey = jobKey;
            this._dinfo = dinfo;
            this._glm = glm;
            this._beta = beta;
            this._ymu = ymu;
            this._validate = validate;
            this._lambda = lambda;
            this._sparse = FrameUtils.sparseRatio((Frame)dinfo._adaptedFrame) < 0.5;
            this._rowFilter = rowFilter;
        }

        public GLMIterationTask setSparse(boolean b) {
            this._sparse = b;
            return this;
        }

        public void map(Chunk[] chks) {
            if (this._jobKey != null && !Job.isRunning((Key)this._jobKey)) {
                throw new Job.JobCancelledException();
            }
            Chunk rowFilter = this._rowFilter == null ? null : this._rowFilter.chunkForChunkIdx(chks[0].cidx());
            this._gram = new Gram(this._dinfo.fullN(), this._dinfo.largestCat(), this._dinfo._nums, this._dinfo._cats, true);
            if (this._validate) {
                String[] domain;
                int rank = 0;
                if (this._beta != null) {
                    for (double d : this._beta) {
                        if (d == 0.0) continue;
                        ++rank;
                    }
                }
                if ((domain = this._dinfo._adaptedFrame.lastVec().domain()) == null && this._glm._family == GLMModel.GLMParameters.Family.binomial) {
                    domain = new String[]{"0", "1"};
                }
                this._val = new GLMValidation(domain, true, this._ymu, this._glm, rank, 0.5, true);
            }
            this._xy = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            if (this._glm._family == GLMModel.GLMParameters.Family.binomial && this._validate) {
                this._ti = new int[2];
            }
            if (this._sparse) {
                for (DataInfo.Row r : this._dinfo.extractSparseRows(chks, this._beta)) {
                    if (rowFilter != null && rowFilter.at8((int)(r.rid - chks[0].start())) != 0L) continue;
                    this.processRow(r);
                }
            } else {
                DataInfo.Row row = this._dinfo.newDenseRow();
                for (int r = 0; r < chks[0]._len; ++r) {
                    if (rowFilter != null && rowFilter.at8(r) != 0L) continue;
                    this.processRow(this._dinfo.extractDenseRow(chks, r, row));
                }
            }
            if (this._validate && this._glm._family == GLMModel.GLMParameters.Family.binomial) assert (this._val != null);
        }

        protected final void processRow(DataInfo.Row r) {
            int i;
            double eta;
            double var;
            double mu;
            double z;
            double w;
            if (r.bad) {
                return;
            }
            ++this._nobs;
            double y = r.response(0);
            assert (this._glm._family != GLMModel.GLMParameters.Family.gamma || y > 0.0) : "illegal response column, y must be > 0  for family=Gamma.";
            assert (this._glm._family != GLMModel.GLMParameters.Family.binomial || 0.0 <= y && y <= 1.0) : "illegal response column, y must be <0,1>  for family=Binomial. got " + y;
            int numStart = this._dinfo.numStart();
            double d = 1.0;
            if (this._glm._family == GLMModel.GLMParameters.Family.gaussian && this._glm._link == GLMModel.GLMParameters.Link.identity) {
                w = 1.0;
                z = y;
                mu = 0.0;
                var = 1.0;
                eta = mu;
            } else {
                eta = r.innerProduct(this._beta);
                mu = this._glm.linkInv(eta);
                var = Math.max(1.0E-6, this._glm.variance(mu));
                d = this._glm.linkDeriv(mu);
                z = eta + (y - mu) * d;
                w = 1.0 / (var * d * d);
            }
            if (this._validate) {
                this._val.add(y, mu);
            }
            this._likelihood += this._glm.likelihood(y, eta, mu);
            assert (w >= 0.0 || Double.isNaN(w)) : "invalid weight " + w;
            double wz = w * z;
            this._yy += wz * z;
            for (i = 0; i < r.nBins; ++i) {
                int n = r.binIds[i];
                this._xy[n] = this._xy[n] + wz;
            }
            for (i = 0; i < r.nNums; ++i) {
                int id = r.numIds == null ? i + numStart : r.numIds[i];
                double val = r.numVals[i];
                int n = id;
                this._xy[n] = this._xy[n] + wz * val;
            }
            if (this._dinfo._intercept) {
                int n = this._xy.length - 1;
                this._xy[n] = this._xy[n] + wz;
            }
            this._gram.addRow(r, w);
        }

        public void reduce(GLMIterationTask git) {
            if (this._jobKey == null || Job.isRunning((Key)this._jobKey)) {
                ArrayUtils.add((double[])this._xy, (double[])git._xy);
                this._gram.add(git._gram);
                this._yy += git._yy;
                this._nobs += git._nobs;
                if (this._validate) {
                    this._val.reduce(git._val);
                }
                this._likelihood += git._likelihood;
                super.reduce((MRTask)git);
            }
        }

        protected void postGlobal() {
            if (this._sparse && this._dinfo._normSub != null) {
                int i;
                int ns = this._dinfo.numStart();
                int interceptIdx = this._xy.length - 1;
                double[] interceptRow = this._gram._xx[interceptIdx - this._gram._diagN];
                double nobs = interceptRow[interceptRow.length - 1];
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int j;
                    double iMean = this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                    for (j = 0; j < ns; ++j) {
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - interceptRow[j] * iMean;
                    }
                    for (j = ns; j <= i; ++j) {
                        double jMean = this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                        double[] dArray = this._gram._xx[i - this._gram._diagN];
                        int n = j;
                        dArray[n] = dArray[n] - (interceptRow[i] * jMean + interceptRow[j] * iMean - nobs * iMean * jMean);
                    }
                }
                if (this._dinfo._intercept) {
                    for (int j = ns; j < this._dinfo.fullN(); ++j) {
                        int n = j;
                        interceptRow[n] = interceptRow[n] - nobs * this._dinfo._normSub[j - ns] * this._dinfo._normMul[j - ns];
                    }
                }
                for (i = ns; i < this._dinfo.fullN(); ++i) {
                    int n = i;
                    this._xy[n] = this._xy[n] - this._xy[this._xy.length - 1] * this._dinfo._normSub[i - ns] * this._dinfo._normMul[i - ns];
                }
            }
            if (this._val != null) {
                this._val.computeAIC();
            }
        }

        public boolean hasNaNsOrInf() {
            return ArrayUtils.hasNaNsOrInfs((double[])this._xy) || this._gram.hasNaNsOrInfs();
        }
    }

    public static class GLMCoordinateDescentTask
    extends MRTask<GLMCoordinateDescentTask> {
        final double[] _betaUpdate;
        final double[] _beta;
        final double _xOldSub;
        final double _xOldMul;
        final double _xNewSub;
        final double _xNewMul;
        double[] _xy;

        public GLMCoordinateDescentTask(double[] betaUpdate, double[] beta, double xOldSub, double xOldMul, double xNewSub, double xNewMul) {
            this._betaUpdate = betaUpdate;
            this._beta = beta;
            this._xOldSub = xOldSub;
            this._xOldMul = xOldMul;
            this._xNewSub = xNewSub;
            this._xNewMul = xNewMul;
        }

        public void map(Chunk[] chks) {
            Chunk xOld = chks[0];
            Chunk xNew = chks[1];
            this._xy = xNew.vec().isEnum() ? MemoryManager.malloc8d((int)xNew.vec().domain().length) : new double[1];
            Chunk eta = chks[2];
            Chunk weights = chks[3];
            Chunk res = chks[4];
            for (int i = 0; i < eta._len; ++i) {
                int cid;
                double w = weights.atd(i);
                double e = eta.atd(i);
                if (this._betaUpdate != null) {
                    if (xOld.vec().isEnum()) {
                        cid = (int)xOld.at8(i);
                        e = this._betaUpdate[cid];
                    } else {
                        e += this._betaUpdate[0] * (xOld.atd(i) - this._xOldSub) * this._xOldMul;
                    }
                    eta.set(i, e);
                }
                cid = 0;
                double x = w;
                if (xNew.vec().isEnum()) {
                    cid = (int)xNew.at8(i);
                    e -= this._beta[cid];
                } else {
                    x = (xNew.atd(i) - this._xNewSub) * this._xNewMul;
                    e -= this._beta[0] * x;
                    x *= w;
                }
                int n = cid;
                this._xy[n] = this._xy[n] + x * (res.atd(i) - e);
            }
        }

        public void reduce(GLMCoordinateDescentTask t) {
            ArrayUtils.add((double[])this._xy, (double[])t._xy);
        }
    }

    public static class LBFGS_LogisticGradientTask
    extends GLMGradientTask {
        public LBFGS_LogisticGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter) {
            super(dinfo, params, lambda, beta, reg, rowFilter);
        }

        @Override
        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                double y = -1.0 + 2.0 * row.response(0);
                if (row.bad) continue;
                ++this._nobs;
                double eta = row.innerProduct(b);
                double d = 1.0 + Math.exp(-y * eta);
                this._likelihood += Math.log(d);
                double gval = -y * (1.0 - 1.0 / d);
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        @Override
        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] g = this._gradient;
            Chunk offsetChunk = null;
            int nxs = chks.length - 1;
            if (this._dinfo._offset) {
                offsetChunk = chks[--nxs];
            }
            Chunk responseChunk = chks[nxs];
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                if (skp[r2] || responseChunk.isNA(r2)) continue;
                ++this._nobs;
                double off = this._dinfo._offset ? offsetChunk.atd(r2) : 0.0;
                double e = eta[r2] + off;
                switch (this._params._family) {
                    case gaussian: {
                        double diff = e - responseChunk.atd(r2);
                        this._likelihood += diff * diff;
                        eta[r2] = diff;
                        break;
                    }
                    case binomial: {
                        double y = -1.0 + 2.0 * responseChunk.atd(r2);
                        double d = 1.0 + Math.exp(-y * e);
                        this._likelihood += Math.log(d);
                        eta[r2] = -y * (1.0 - 1.0 / d);
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }
    }

    static class GLMWeightsTask
    extends MRTask<GLMWeightsTask> {
        final GLMModel.GLMParameters _params;

        GLMWeightsTask(GLMModel.GLMParameters params) {
            this._params = params;
        }

        public void map(Chunk[] chks) {
            Chunk yChunk = chks[0];
            Chunk zChunk = chks[1];
            Chunk wChunk = chks[2];
            Chunk eChunk = chks[3];
            for (int i = 0; i < yChunk._len; ++i) {
                double y = yChunk.atd(i);
                double eta = eChunk.atd(i);
                double mu = this._params.linkInv(eta);
                double var = Math.max(1.0E-6, this._params.variance(mu));
                double d = this._params.linkDeriv(mu);
                zChunk.set(i, eta + (y - mu) * d);
                wChunk.set(i, 1.0 / (var * d * d));
            }
        }

        public void reduce(GLMWeightsTask gwt) {
        }
    }

    static class GLMGradientTask
    extends MRTask<GLMGradientTask> {
        final GLMModel.GLMParameters _params;
        GLMValidation _val;
        double _currentLambda;
        final double[] _beta;
        protected final DataInfo _dinfo;
        final double _reg;
        public double[] _gradient;
        public double _likelihood;
        protected transient boolean[] _skip;
        boolean _validate;
        double _ymu;
        Vec _rowFilter;
        long _nobs;
        private boolean _forceRows;
        private boolean _forceCols;

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter) {
            this(dinfo, params, lambda, beta, reg, rowFilter, null);
        }

        public GLMGradientTask(DataInfo dinfo, GLMModel.GLMParameters params, double lambda, double[] beta, double reg, Vec rowFilter, H2O.H2OCountedCompleter cc) {
            super(cc);
            this._dinfo = dinfo;
            this._params = params;
            this._beta = beta;
            this._reg = reg;
            this._currentLambda = lambda;
            this._rowFilter = rowFilter;
        }

        public GLMGradientTask setValidate(double ymu, boolean validate) {
            this._ymu = ymu;
            this._validate = validate;
            return this;
        }

        protected void goByRows(Chunk[] chks, boolean[] skp) {
            DataInfo.Row row = this._dinfo.newDenseRow();
            double[] g = this._gradient;
            double[] b = this._beta;
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                if (skp[rid]) continue;
                row = this._dinfo.extractDenseRow(chks, rid, row);
                if (row.bad) continue;
                ++this._nobs;
                double eta = row.innerProduct(b);
                double mu = this._params.linkInv(eta);
                this._val.add(row.response(0), mu);
                this._likelihood += this._params.likelihood(row.response(0), eta, mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                double gval = (mu - row.response(0)) / (var * this._params.linkDeriv(mu));
                for (int i = 0; i < row.nBins; ++i) {
                    int n = row.binIds[i];
                    g[n] = g[n] + gval;
                }
                int off = this._dinfo.numStart();
                for (int j = 0; j < this._dinfo._nums; ++j) {
                    int n = j + off;
                    g[n] = g[n] + row.numVals[j] * gval;
                }
                if (!this._dinfo._intercept) continue;
                int n = g.length - 1;
                g[n] = g[n] + gval;
            }
        }

        public void postGlobal() {
            ArrayUtils.mult((double[])this._gradient, (double)this._reg);
            for (int j = 0; j < this._beta.length - (this._dinfo._intercept ? 1 : 0); ++j) {
                int n = j;
                this._gradient[n] = this._gradient[n] + this._currentLambda * this._beta[j];
            }
        }

        protected final double[] computeEtaByCols(Chunk[] chks, boolean[] skip) {
            int r;
            double[] eta = MemoryManager.malloc8d((int)chks[0]._len);
            if (this._dinfo._intercept) {
                Arrays.fill(eta, this._beta[this._beta.length - 1]);
            }
            double[] b = this._beta;
            for (int i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (int r2 = 0; r2 < c._len; ++r2) {
                    if (skip[r2] || c.isNA(r2)) {
                        skip[r2] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i, (int)c.at8(r2));
                    if (off == -1) continue;
                    int n = r2;
                    eta[n] = eta[n] + b[off];
                }
            }
            int numStart = this._dinfo.numStart();
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                double off = 0.0;
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    off -= b[numStart + i] * this._dinfo._normSub[i] * this._dinfo._normMul[i];
                }
                r = 0;
                while (r < chks[0]._len) {
                    int n = r++;
                    eta[n] = eta[n] + off;
                }
            }
            for (int i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                    } else {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = r;
                        eta[n] = eta[n] + b[numStart + i] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            return eta;
        }

        protected void goByCols(Chunk[] chks, boolean[] skp) {
            int r;
            int i;
            int numStart = this._dinfo.numStart();
            double[] eta = this.computeEtaByCols(chks, skp);
            double[] b = this._beta;
            double[] g = this._gradient;
            Chunk offsetChunk = null;
            int nxs = chks.length - 1;
            if (this._dinfo._offset) {
                offsetChunk = chks[--nxs];
            }
            Chunk responseChunk = chks[nxs];
            double eta_sum = 0.0;
            for (int r2 = 0; r2 < chks[0]._len; ++r2) {
                if (skp[r2] || responseChunk.isNA(r2)) continue;
                ++this._nobs;
                double off = this._dinfo._offset ? offsetChunk.atd(r2) : 0.0;
                double y = responseChunk.atd(r2);
                double offset = off;
                double mu = this._params.linkInv(eta[r2] + offset);
                this._val.add(y, mu);
                this._likelihood += this._params.likelihood(y, eta[r2], mu);
                double var = this._params.variance(mu);
                if (var < 1.0E-6) {
                    var = 1.0E-6;
                }
                eta[r2] = (mu - y) / (var * this._params.linkDeriv(mu));
                eta_sum += eta[r2];
            }
            if (this._dinfo._intercept) {
                g[g.length - 1] = eta_sum;
            }
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (i = 0; i < this._dinfo._nums; ++i) {
                    g[numStart + i] = -this._dinfo._normSub[i] * this._dinfo._normMul[i] * eta_sum;
                }
            }
            for (i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (r = 0; r < c._len; ++r) {
                    int off;
                    if (skp[r] || (off = this._dinfo.getCategoricalId(i, (int)chks[i].at8(r))) == -1) continue;
                    int n = off;
                    g[n] = g[n] + eta[r];
                }
            }
            for (i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                r = c.nextNZ(-1);
                while (r < c._len) {
                    if (!skp[r] && !c.isNA(r)) {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        int n = numStart + i;
                        g[n] = g[n] + eta[r] * d;
                    }
                    r = c.nextNZ(r);
                }
            }
            this._skip = skp;
        }

        private boolean mostlySparse(Chunk[] chks) {
            int cnt = 0;
            for (Chunk chk : chks) {
                if (!chk.isSparse()) continue;
                ++cnt;
            }
            return cnt >= chks.length >> 1;
        }

        public GLMGradientTask forceColAccess() {
            this._forceCols = true;
            this._forceRows = false;
            return this;
        }

        public GLMGradientTask forceRowAccess() {
            this._forceCols = false;
            this._forceRows = true;
            return this;
        }

        public void map(Chunk[] chks) {
            int rank = 0;
            for (int i = 0; i < this._beta.length; ++i) {
                if (this._beta[i] == 0.0) continue;
                ++rank;
            }
            this._gradient = MemoryManager.malloc8d((int)this._beta.length);
            String[] domain = this._dinfo._adaptedFrame.lastVec().domain();
            if (domain == null && this._params._family == GLMModel.GLMParameters.Family.binomial) {
                domain = new String[]{"0", "1"};
            }
            this._val = new GLMValidation(domain, this._params._intercept, this._ymu, this._params, rank, 0.0, this._validate);
            boolean[] skp = MemoryManager.mallocZ((int)chks[0]._len);
            if (this._rowFilter != null) {
                Chunk c = this._rowFilter.chunkForChunkIdx(chks[0].cidx());
                for (int r = 0; r < chks[0]._len; ++r) {
                    skp[r] = c.at8(r) == 1L;
                }
            }
            if (this._forceCols || !this._forceRows && (chks.length >= 100 || this.mostlySparse(chks))) {
                this.goByCols(chks, skp);
            } else {
                this.goByRows(chks, skp);
            }
        }

        public void reduce(GLMGradientTask grt) {
            this._likelihood += grt._likelihood;
            this._nobs += grt._nobs;
            this._val.reduce(grt._val);
            ArrayUtils.add((double[])this._gradient, (double[])grt._gradient);
        }
    }

    static class GLMLineSearchTask
    extends MRTask<GLMLineSearchTask> {
        final DataInfo _dinfo;
        final double[] _beta;
        final double[] _direction;
        final double _step;
        final int _nSteps;
        final GLMModel.GLMParameters _params;
        final double _reg;
        Vec _rowFilter;
        boolean _useFasterMetrics = false;
        long _nobs;
        double[] _likelihoods;

        public GLMLineSearchTask(DataInfo dinfo, GLMModel.GLMParameters params, double reg, double[] beta, double[] direction, double step, int nsteps, Vec rowFilter) {
            this(dinfo, params, reg, beta, direction, step, nsteps, rowFilter, null);
        }

        public GLMLineSearchTask(DataInfo dinfo, GLMModel.GLMParameters params, double reg, double[] beta, double[] direction, double step, int nsteps, Vec rowFilter, CountedCompleter cc) {
            super((H2O.H2OCountedCompleter)cc);
            this._dinfo = dinfo;
            this._reg = reg;
            this._beta = beta;
            this._direction = direction;
            this._step = step;
            this._nSteps = nsteps;
            this._params = params;
            this._rowFilter = rowFilter;
        }

        public GLMLineSearchTask setFasterMetrics(boolean b) {
            this._useFasterMetrics = b;
            return this;
        }

        public void map(Chunk[] chks) {
            Chunk rowFilter = this._rowFilter != null ? this._rowFilter.chunkForChunkIdx(chks[0].cidx()) : null;
            Chunk responseChunk = chks[chks.length - 1];
            boolean[] skip = MemoryManager.mallocZ((int)chks[0]._len);
            if (rowFilter != null) {
                for (int r = 0; r < skip.length; ++r) {
                    skip[r] = rowFilter.at8(r) == 1L;
                }
            }
            double[][] eta = new double[responseChunk._len][this._nSteps];
            double[] beta = this._beta;
            double[] pk = this._direction;
            if (this._dinfo._intercept) {
                for (int r = 0; r < eta.length; ++r) {
                    int off = beta.length - 1;
                    double t = 1.0;
                    int j = 0;
                    while (j < this._nSteps) {
                        double[] dArray = eta[r];
                        int n = j++;
                        dArray[n] = dArray[n] + (beta[off] + pk[off] * t);
                        t *= this._step;
                    }
                }
            }
            for (int i = 0; i < this._dinfo._cats; ++i) {
                Chunk c = chks[i];
                for (int r = 0; r < c._len; ++r) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                        continue;
                    }
                    int off = this._dinfo.getCategoricalId(i, (int)c.at8(r));
                    if (off == -1) continue;
                    double t = 1.0;
                    int j = 0;
                    while (j < this._nSteps) {
                        double[] dArray = eta[r];
                        int n = j++;
                        dArray[n] = dArray[n] + (beta[off] + pk[off] * t);
                        t *= this._step;
                    }
                }
            }
            int numStart = this._dinfo.numStart();
            double[] off = new double[this._nSteps];
            if (this._dinfo._normMul != null && this._dinfo._normSub != null) {
                for (int i = 0; i < this._dinfo._nums; ++i) {
                    double b = beta[numStart + i];
                    double s = pk[numStart + i];
                    double d = this._dinfo._normSub[i] * this._dinfo._normMul[i];
                    int j = 0;
                    while (j < this._nSteps) {
                        int n = j++;
                        off[n] = off[n] - (b + s) * d;
                        s *= this._step;
                    }
                }
            }
            for (int i = 0; i < this._dinfo._nums; ++i) {
                Chunk c = chks[i + this._dinfo._cats];
                int r = c.nextNZ(-1);
                while (r < c._len) {
                    if (skip[r] || c.isNA(r)) {
                        skip[r] = true;
                    } else {
                        double d = c.atd(r);
                        if (this._dinfo._normMul != null) {
                            d *= this._dinfo._normMul[i];
                        }
                        double b = beta[numStart + i];
                        double s = pk[numStart + i];
                        int j = 0;
                        while (j < this._nSteps) {
                            double[] dArray = eta[r];
                            int n = j++;
                            dArray[n] = dArray[n] + (b + s) * d;
                            s *= this._step;
                        }
                    }
                    r = c.nextNZ(r);
                }
            }
            this._likelihoods = MemoryManager.malloc8d((int)this._nSteps);
            for (int r = 0; r < chks[0]._len; ++r) {
                if (skip[r] || responseChunk.isNA(r)) continue;
                ++this._nobs;
                double y = responseChunk.atd(r);
                double yy = -1.0 + 2.0 * y;
                for (int i = 0; i < this._nSteps; ++i) {
                    double e = eta[r][i] + off[i];
                    if (this._params._family == GLMModel.GLMParameters.Family.binomial && this._useFasterMetrics) {
                        int n = i;
                        this._likelihoods[n] = this._likelihoods[n] + Math.log(1.0 + Math.exp(-yy * e));
                        continue;
                    }
                    double mu = this._params.linkInv(e);
                    int n = i;
                    this._likelihoods[n] = this._likelihoods[n] + this._params.likelihood(y, e, mu);
                }
            }
        }

        public void reduce(GLMLineSearchTask glt) {
            ArrayUtils.add((double[])this._likelihoods, (double[])glt._likelihoods);
            this._nobs += glt._nobs;
        }
    }

    static class YMUTask
    extends MRTask<YMUTask> {
        double _ymu;
        double _yMin = Double.POSITIVE_INFINITY;
        double _yMax = Double.NEGATIVE_INFINITY;
        long _nobs;
        final Vec _fVec;

        public YMUTask(DataInfo dinfo, Vec mVec, H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._fVec = mVec;
        }

        public void setupLocal() {
            this._fVec.preWriting();
        }

        public void map(Chunk[] chunks) {
            int r;
            boolean[] skip = MemoryManager.mallocZ((int)chunks[0]._len);
            for (int i = 0; i < chunks.length; ++i) {
                r = chunks[i].nextNZ(-1);
                while (r < chunks[i]._len) {
                    int n = r;
                    skip[n] = skip[n] | chunks[i].isNA(r);
                    r = chunks[i].nextNZ(r);
                }
            }
            Chunk response = chunks[chunks.length - 1];
            for (r = 0; r < response._len; ++r) {
                if (skip[r]) continue;
                double d = response.atd(r);
                assert (!Double.isNaN(d));
                assert (!Double.isNaN(this._ymu + d)) : "got NaN by adding " + this._ymu + " + " + d;
                this._ymu += d;
                if (d < this._yMin) {
                    this._yMin = d;
                }
                if (d > this._yMax) {
                    this._yMax = d;
                }
                ++this._nobs;
            }
            if (this._fVec != null) {
                DKV.put((Key)this._fVec.chunkKey(chunks[0].cidx()), (Iced)new CBSChunk(skip));
            }
        }

        public void postGlobal() {
            this._ymu /= (double)this._nobs;
            Futures fs = new Futures();
            this._fVec.postWrite(fs);
            fs.blockForPending();
        }

        public void reduce(YMUTask ymt) {
            if (this._nobs > 0L && ymt._nobs > 0L) {
                this._ymu += ymt._ymu;
                this._nobs += ymt._nobs;
                if (this._yMin > ymt._yMin) {
                    this._yMin = ymt._yMin;
                }
                if (this._yMax < ymt._yMax) {
                    this._yMax = ymt._yMax;
                }
            } else if (this._nobs == 0L) {
                this._ymu = ymt._ymu;
                this._nobs = ymt._nobs;
                this._yMin = ymt._yMin;
                this._yMax = ymt._yMax;
            }
        }
    }
}

