/*
 * Decompiled with CFR 0.152.
 */
package hex.pca;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.pca.PCAModel;
import hex.schemas.ModelBuilderSchema;
import hex.schemas.PCAV3;
import hex.svd.SVD;
import hex.svd.SVDModel;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Job;
import water.Key;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class PCA
extends ModelBuilder<PCAModel, PCAModel.PCAParameters, PCAModel.PCAOutput> {
    private transient int _ncolExp;

    public ModelBuilderSchema schema() {
        return new PCAV3();
    }

    public Job<PCAModel> trainModel() {
        return this.start(new PCADriver(), 0L);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    protected void checkMemoryFootPrint() {
        long max_mem;
        HeartBeat hb = H2O.SELF._heartbeat;
        double p = this._train.degreesOfFreedom();
        long mem_usage = (long)((double)hb._cpus_allowed * p * p * 8.0 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0));
        if (mem_usage > (max_mem = hb.get_max_mem())) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
            this.cancel(msg);
        }
    }

    public PCA(PCAModel.PCAParameters parms) {
        super("PCA", (Model.Parameters)parms);
        this.init(false);
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((PCAModel.PCAParameters)this._parms)._loading_key == null) {
            ((PCAModel.PCAParameters)this._parms)._loading_key = Key.make((String)("PCALoading_" + Key.rand()));
        }
        if (((PCAModel.PCAParameters)this._parms)._max_iterations < 1 || (double)((PCAModel.PCAParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (this._train == null) {
            return;
        }
        if (this._train.numCols() < 2) {
            this.error("_train", "_train must have more than one column");
        }
        this._ncolExp = this._train.numColsExp(((PCAModel.PCAParameters)this._parms)._useAllFactorLevels, false);
        int k_min = (int)Math.min((long)this._ncolExp, this._train.numRows());
        if (((PCAModel.PCAParameters)this._parms)._k < 1 || ((PCAModel.PCAParameters)this._parms)._k > k_min) {
            this.error("_k", "_k must be between 1 and " + k_min);
        }
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    public static double[][] formGram(double[][] x, boolean transpose) {
        int k;
        int j;
        int i;
        if (x == null) {
            return null;
        }
        int dim_in = transpose ? x[0].length : x.length;
        int dim_out = transpose ? x.length : x[0].length;
        double[][] xgram = new double[dim_out][dim_out];
        if (transpose) {
            for (i = 0; i < dim_in; ++i) {
                for (j = 0; j < dim_out; ++j) {
                    for (k = j; k < dim_out; ++k) {
                        double[] dArray = xgram[j];
                        int n = k;
                        dArray[n] = dArray[n] + x[j][i] * x[k][i];
                    }
                }
            }
        } else {
            for (i = 0; i < dim_in; ++i) {
                for (j = 0; j < dim_out; ++j) {
                    for (k = j; k < dim_out; ++k) {
                        double[] dArray = xgram[j];
                        int n = k;
                        dArray[n] = dArray[n] + x[i][j] * x[i][k];
                    }
                }
            }
        }
        for (i = 0; i < dim_in; ++i) {
            for (j = 0; j < dim_out; ++j) {
                for (k = 0; k < j; ++k) {
                    xgram[j][k] = xgram[k][j];
                }
            }
        }
        return xgram;
    }

    public static double[][] formGram(double[][] x) {
        return PCA.formGram(x, false);
    }

    class PCADriver
    extends H2O.H2OCountedCompleter<PCADriver> {
        PCADriver() {
        }

        protected void computeStatsFillModel(PCAModel pca, SVDModel svd) {
            Object[] colTypes = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Object[] colFormats = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            String[] colHeaders = new String[((PCAModel.PCAParameters)PCA.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            for (int i = 0; i < colHeaders.length; ++i) {
                colHeaders[i] = "PC" + String.valueOf(i + 1);
            }
            ((PCAModel.PCAOutput)pca._output)._eigenvectors_raw = ((SVDModel.SVDOutput)svd._output)._v;
            ((PCAModel.PCAOutput)pca._output)._eigenvectors = new TwoDimTable("Rotation", null, PCA.this._train.names(), colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[PCA.this._train.numCols()][], ((SVDModel.SVDOutput)svd._output)._v);
            double[] sdev = new double[((SVDModel.SVDOutput)svd._output)._d.length];
            double[] vars = new double[((SVDModel.SVDOutput)svd._output)._d.length];
            double totVar = 0.0;
            double dfcorr = 1.0 / Math.sqrt((double)PCA.this._train.numRows() - 1.0);
            for (int i = 0; i < sdev.length; ++i) {
                sdev[i] = dfcorr * ((SVDModel.SVDOutput)svd._output)._d[i];
                vars[i] = sdev[i] * sdev[i];
                totVar += vars[i];
            }
            ((PCAModel.PCAOutput)pca._output)._std_deviation = sdev;
            double[] prop_var = new double[vars.length];
            double[] cum_var = new double[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                prop_var[i] = vars[i] / totVar;
                cum_var[i] = i == 0 ? prop_var[0] : cum_var[i - 1] + prop_var[i];
            }
            ((PCAModel.PCAOutput)pca._output)._pc_importance = new TwoDimTable("Importance of components", null, new String[]{"Standard deviation", "Proportion of Variance", "Cumulative Proportion"}, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[3][], (double[][])new double[][]{sdev, prop_var, cum_var});
            if (((PCAModel.PCAParameters)PCA.this._parms)._keep_loading) {
                ((PCAModel.PCAOutput)pca._output)._loading_key = ((SVDModel.SVDOutput)svd._output)._u_key;
            }
            ((PCAModel.PCAOutput)pca._output)._normSub = ((SVDModel.SVDOutput)svd._output)._normSub;
            ((PCAModel.PCAOutput)pca._output)._normMul = ((SVDModel.SVDOutput)svd._output)._normMul;
            ((PCAModel.PCAOutput)pca._output)._permutation = ((SVDModel.SVDOutput)svd._output)._permutation;
            ((PCAModel.PCAOutput)pca._output)._nnums = ((SVDModel.SVDOutput)svd._output)._nnums;
            ((PCAModel.PCAOutput)pca._output)._ncats = ((SVDModel.SVDOutput)svd._output)._ncats;
            ((PCAModel.PCAOutput)pca._output)._catOffsets = ((SVDModel.SVDOutput)svd._output)._catOffsets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compute2() {
            block17: {
                PCAModel model = null;
                Object dinfo = null;
                Object xinfo = null;
                Object x = null;
                try {
                    ((PCAModel.PCAParameters)PCA.this._parms).read_lock_frames((Job)PCA.this);
                    PCA.this.init(true);
                    if (PCA.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + PCA.this.validationErrors());
                    }
                    model = new PCAModel(PCA.this.dest(), (PCAModel.PCAParameters)PCA.this._parms, new PCAModel.PCAOutput(PCA.this));
                    model.delete_and_lock(PCA.this._key);
                    SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
                    parms._train = ((PCAModel.PCAParameters)PCA.this._parms)._train;
                    parms._ignored_columns = ((PCAModel.PCAParameters)PCA.this._parms)._ignored_columns;
                    parms._ignore_const_cols = ((PCAModel.PCAParameters)PCA.this._parms)._ignore_const_cols;
                    parms._score_each_iteration = ((PCAModel.PCAParameters)PCA.this._parms)._score_each_iteration;
                    parms._useAllFactorLevels = ((PCAModel.PCAParameters)PCA.this._parms)._useAllFactorLevels;
                    parms._transform = ((PCAModel.PCAParameters)PCA.this._parms)._transform;
                    parms._nv = ((PCAModel.PCAParameters)PCA.this._parms)._k;
                    parms._max_iterations = ((PCAModel.PCAParameters)PCA.this._parms)._max_iterations;
                    parms._seed = ((PCAModel.PCAParameters)PCA.this._parms)._seed;
                    parms._only_v = false;
                    parms._u_key = ((PCAModel.PCAParameters)PCA.this._parms)._loading_key;
                    parms._keep_u = ((PCAModel.PCAParameters)PCA.this._parms)._keep_loading;
                    SVDModel svd = null;
                    SVD job = null;
                    try {
                        job = new SVD(parms);
                        svd = (SVDModel)job.trainModel().get();
                    }
                    finally {
                        if (job != null) {
                            job.remove();
                        }
                        if (svd != null) {
                            svd.remove();
                        }
                    }
                    this.computeStatsFillModel(model, svd);
                    model.update(PCA.this._key);
                    PCA.this.update(1L);
                    PCA.this.done();
                }
                catch (Throwable t) {
                    Job thisJob = (Job)DKV.getGet((Key)PCA.this._key);
                    if (thisJob._state == Job.JobState.CANCELLED) {
                        Log.info((Object[])new Object[]{"Job cancelled by user."});
                        break block17;
                    }
                    t.printStackTrace();
                    PCA.this.failed(t);
                    throw t;
                }
                finally {
                    ((PCAModel.PCAParameters)PCA.this._parms).read_unlock_frames((Job)PCA.this);
                    if (model != null) {
                        model.unlock(PCA.this._key);
                    }
                    if (dinfo != null) {
                        dinfo.remove();
                    }
                    if (xinfo != null) {
                        xinfo.remove();
                    }
                    if (x != null && !((PCAModel.PCAParameters)PCA.this._parms)._keep_loading) {
                        x.delete();
                    }
                }
            }
            this.tryComplete();
        }

        Key self() {
            return PCA.this._key;
        }
    }

    public static enum Initialization {
        SVD,
        PlusPlus,
        User;

    }
}

