/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.svd.SVD;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;

public class SVDModel
extends Model<SVDModel, SVDParameters, SVDOutput> {
    public SVDModel(Key selfKey, SVDParameters parms, SVDOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsSVD.SVDModelMetrics(((SVDParameters)this._parms)._nv);
    }

    protected Frame scoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((SVDOutput)SVDModel.this._output)._names.length];
                double[] preds = new double[((SVDParameters)SVDModel.this._parms)._nv];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = SVDModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((SVDOutput)SVDModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((SVDOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig, Double.NaN);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((SVDOutput)this._output)._catOffsets[((SVDOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((SVDOutput)this._output)._permutation.length);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < ((SVDOutput)this._output)._ncats; ++j) {
                int level = (int)data[((SVDOutput)this._output)._permutation[j]];
                int n = i;
                preds[n] = preds[n] + ((SVDOutput)this._output)._v[((SVDOutput)this._output)._catOffsets[j] + level][i];
            }
            int dcol = ((SVDOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j = 0; j < ((SVDOutput)this._output)._nnums; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[((SVDOutput)this._output)._permutation[dcol]] - ((SVDOutput)this._output)._normSub[j]) * ((SVDOutput)this._output)._normMul[j] * ((SVDOutput)this._output)._v[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    public Frame score(Frame fr, String destination_key) {
        Frame adaptFr = new Frame(fr);
        this.adaptTestForTrain(adaptFr, true);
        Frame output = this.scoreImpl(fr, adaptFr, destination_key);
        SVDModel.cleanup_adapt((Frame)adaptFr, (Frame)fr);
        return output;
    }

    public static class ModelMetricsSVD
    extends ModelMetricsUnsupervised {
        public ModelMetricsSVD(Model model, Frame frame) {
            super(model, frame, Double.NaN);
        }

        public static class SVDModelMetrics
        extends ModelMetricsUnsupervised.MetricBuilderUnsupervised {
            public SVDModelMetrics(int dims) {
                this._work = new double[dims];
            }

            public double[] perRow(double[] dataRow, float[] preds, Model m) {
                return dataRow;
            }

            public ModelMetrics makeModelMetrics(Model m, Frame f, double sigma) {
                return m._output.addModelMetrics((ModelMetrics)new ModelMetricsSVD(m, f));
            }
        }
    }

    public static class SVDOutput
    extends Model.Output {
        public double[][] _v;
        public double[] _d;
        public Key<Frame> _u_key;
        public int _ncats;
        public int _nnums;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;

        public SVDOutput(SVD b) {
            super((ModelBuilder)b);
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class SVDParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public int _nv = 1;
        public int _max_iterations = 1000;
        public long _seed = System.nanoTime();
        public boolean _keep_u = true;
        public Key<Frame> _u_key;
        public boolean _only_v = false;
        public boolean _useAllFactorLevels = true;
    }
}

