/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.glm.GLM;
import hex.glm.GLMValidation;
import java.util.Arrays;
import java.util.HashMap;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.SB;
import water.util.TwoDimTable;

public class GLMModel
extends Model<GLMModel, GLMParameters, GLMOutput> {
    public final double _lambda_max;
    public final double _ymu;
    public final double _ySigma;
    public final long _nobs;

    public GLMModel(Key selfKey, GLMParameters parms, GLM job, double ymu, double ySigma, double lambda_max, long nobs, boolean hasWeights, boolean hasOffset) {
        super(selfKey, (Model.Parameters)parms, null);
        this._ymu = ymu;
        this._ySigma = ySigma;
        this._lambda_max = lambda_max;
        this._nobs = nobs;
        this._output = job == null ? new GLMOutput() : new GLMOutput(job);
    }

    protected boolean toJavaCheckTooBig() {
        if (this.beta() != null && this.beta().length > 10000) {
            Log.warn((Object[])new Object[]{"toJavaCheckTooBig must be overridden for this model type to render it in the browser"});
            return true;
        }
        return false;
    }

    public DataInfo dinfo() {
        return ((GLMOutput)this._output)._dinfo;
    }

    private int rank(double[] ds) {
        int res = 0;
        for (double d : ds) {
            if (d == 0.0) continue;
            ++res;
        }
        return res;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (domain == null && ((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            domain = new String[]{"0", "1"};
        }
        return new GLMValidation(domain, ((GLMParameters)this._parms)._intercept, this._ymu, (GLMParameters)this._parms, this.rank(this.beta()), ((GLMOutput)this._output)._threshold, true);
    }

    public double[] beta() {
        return ((GLMOutput)this._output)._global_beta;
    }

    public String[] names() {
        return ((GLMOutput)this._output)._names;
    }

    public HashMap<String, Double> coefficients() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficient_names[i], b[i]);
            }
        }
        return res;
    }

    public synchronized void setSubmodel(Submodel sm) {
        int i;
        if (((GLMOutput)this._output)._submodels == null) {
            ((GLMOutput)this._output)._submodels = new Submodel[]{sm};
            return;
        }
        for (i = 0; i < ((GLMOutput)this._output)._submodels.length && !(((GLMOutput)this._output)._submodels[i].lambda_value <= sm.lambda_value); ++i) {
        }
        if (i == ((GLMOutput)this._output)._submodels.length) {
            ((GLMOutput)this._output)._submodels = Arrays.copyOf(((GLMOutput)this._output)._submodels, ((GLMOutput)this._output)._submodels.length + 1);
            ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._submodels.length - 1] = sm;
        } else if (((GLMOutput)this._output)._submodels[i].lambda_value > sm.lambda_value) {
            ((GLMOutput)this._output)._submodels = Arrays.copyOf(((GLMOutput)this._output)._submodels, ((GLMOutput)this._output)._submodels.length + 1);
            for (int j = ((GLMOutput)this._output)._submodels.length - 1; j > i; --j) {
                ((GLMOutput)this._output)._submodels[j] = ((GLMOutput)this._output)._submodels[j - 1];
            }
            ((GLMOutput)this._output)._submodels[i] = sm;
        } else {
            ((GLMOutput)this._output)._submodels[i] = sm;
        }
    }

    public TwoDimTable generateSummary(Key train, int iter) {
        String[] names = new String[]{"Family", "Link", "Regularization", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
        String[] types = new String[]{"string", "string", "string", "int", "int", "int", "string"};
        String[] formats = new String[]{"%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        if (((GLMParameters)this._parms)._lambda_search) {
            names = new String[]{"Family", "Link", "Regularization", "Lambda Search", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
            types = new String[]{"string", "string", "string", "string", "int", "int", "int", "string"};
            formats = new String[]{"%s", "%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        }
        ((GLMOutput)this._output)._model_summary = new TwoDimTable("GLM Model", "summary", new String[]{""}, names, types, formats, "");
        ((GLMOutput)this._output)._model_summary.set(0, 0, (Object)((GLMParameters)this._parms)._family.toString());
        ((GLMOutput)this._output)._model_summary.set(0, 1, (Object)((GLMParameters)this._parms)._link.toString());
        String regularization = "None";
        if (((GLMParameters)this._parms)._lambda != null && (((GLMParameters)this._parms)._lambda.length != 1 || ((GLMParameters)this._parms)._lambda[0] != 0.0)) {
            regularization = ((GLMParameters)this._parms)._alpha[0] == 0.0 ? "Ridge ( lambda = " : (((GLMParameters)this._parms)._alpha[0] == 1.0 ? "Lasso (lambda = " : "Elastic Net (alpha = " + MathUtils.roundToNDigits((double)((GLMParameters)this._parms)._alpha[0], (int)4) + ", lambda = ");
            regularization = regularization + MathUtils.roundToNDigits((double)((GLMParameters)this._parms)._lambda[((GLMOutput)this._output)._best_lambda_idx], (int)4) + " )";
        }
        ((GLMOutput)this._output)._model_summary.set(0, 2, (Object)regularization);
        int lambdaSearch = 0;
        if (((GLMParameters)this._parms)._lambda_search) {
            lambdaSearch = 1;
            ((GLMOutput)this._output)._model_summary.set(0, 3, (Object)("nlambda = " + ((GLMParameters)this._parms)._nlambdas + ", lambda_max = " + MathUtils.roundToNDigits((double)this._lambda_max, (int)4) + ", best_lambda = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).bestSubmodel().lambda_value, (int)4)));
        }
        int intercept = ((GLMParameters)this._parms)._intercept ? 1 : 0;
        ((GLMOutput)this._output)._model_summary.set(0, 3 + lambdaSearch, (Object)Integer.toString(this.beta().length - intercept));
        ((GLMOutput)this._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)this._output).rank() - intercept));
        ((GLMOutput)this._output)._model_summary.set(0, 5 + lambdaSearch, (Object)iter);
        ((GLMOutput)this._output)._model_summary.set(0, 6 + lambdaSearch, (Object)train.toString());
        return ((GLMOutput)this._output)._model_summary;
    }

    public static GLMModel makeGLMModel(GLMParameters.Family fam, double[] coefficients, String[] predictors, String response) {
        if (coefficients.length != predictors.length + 1) {
            throw new IllegalArgumentException("coefficients length is expected to be predictros.length + 1, as each coefficient must have name + intercept term with no name.");
        }
        GLMParameters parms = new GLMParameters(GLMParameters.Family.binomial);
        parms._alpha = new double[]{0.0};
        parms._lambda = new double[]{0.0};
        parms._standardize = false;
        parms._prior = -1.0;
        parms._train = null;
        GLMModel m = new GLMModel(Key.make(), parms, null, fam == GLMParameters.Family.binomial ? 0.5 : 0.0, Double.NaN, Double.NaN, -1L, false, false);
        predictors = ArrayUtils.append((String[])predictors, (String[])new String[]{response});
        ((GLMOutput)m._output)._names = predictors;
        ((GLMOutput)m._output)._coefficient_names = predictors;
        ((GLMOutput)m._output)._dinfo = DataInfo.makeEmpty(coefficients.length - 1);
        ((GLMOutput)m._output)._domains = new String[predictors.length][];
        m.setSubmodel(new Submodel(0.0, coefficients, -1, Double.NaN, Double.NaN));
        ((GLMOutput)m._output).setSubmodelIdx(0);
        return m;
    }

    public long checksum_impl() {
        if (((GLMParameters)this._parms)._train == null) {
            return 0L;
        }
        return super.checksum_impl();
    }

    public double[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
        double mu;
        double eta = 0.0;
        double[] b = this.beta();
        int[] catOffs = this.dinfo()._catOffsets;
        for (int i = 0; i < catOffs.length - 1; ++i) {
            if (chks[i].isNA(row_in_chunk)) {
                eta = Double.NaN;
                break;
            }
            long lval = chks[i].at8(row_in_chunk);
            int ival = (int)lval;
            if ((long)ival != lval) {
                throw new IllegalArgumentException("categorical value out of range");
            }
            if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                --ival;
            }
            int from = catOffs[i];
            int to = catOffs[i + 1];
            if (ival < 0 || ival + from >= catOffs[i + 1]) continue;
            eta += b[ival + from];
        }
        int noff = this.dinfo().numStart() - this.dinfo()._cats;
        for (int i = this.dinfo()._cats; i < b.length - 1 - noff; ++i) {
            eta += b[noff + i] * chks[i].atd(row_in_chunk);
        }
        preds[0] = mu = ((GLMParameters)this._parms).linkInv(eta += b[b.length - 1]);
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Double.NaN;
                preds[1] = Double.NaN;
                preds[2] = Double.NaN;
            } else {
                preds[0] = mu >= ((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            }
        }
        return preds;
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 1.0, 0.0);
    }

    protected double[] score0(double[] data, double[] preds, double w, double o) {
        double mu;
        double eta = 0.0;
        double[] b = this.beta();
        DataInfo dinfo = ((GLMOutput)this._output)._dinfo;
        for (int i = 0; i < dinfo._cats; ++i) {
            if (Double.isNaN(data[i])) {
                eta = Double.NaN;
                break;
            }
            int ival = (int)data[i];
            if ((double)ival != data[i]) {
                throw new IllegalArgumentException("categorical value out of range");
            }
            ival += dinfo._catOffsets[i];
            if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                --ival;
            }
            if (ival < dinfo._catOffsets[i] || ival >= dinfo._catOffsets[i + 1]) continue;
            eta += b[ival];
        }
        int noff = dinfo.numStart();
        for (int i = 0; i < dinfo._nums; ++i) {
            eta += b[noff + i] * data[dinfo._cats + i];
        }
        preds[0] = mu = ((GLMParameters)this._parms).linkInv((eta += b[b.length - 1]) + o);
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            if (Double.isNaN(mu)) {
                preds[0] = Double.NaN;
                preds[1] = Double.NaN;
                preds[2] = Double.NaN;
            } else {
                preds[0] = mu >= ((GLMOutput)this._output)._threshold ? 1 : 0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            }
        }
        return preds;
    }

    protected void toJavaPredictBody(SB body, SB classCtx, SB file) {
        int nclass = ((GLMOutput)this._output).nclasses();
        String mname = JCodeGen.toJavaId((String)this._key.toString());
        JCodeGen.toStaticVar((SB)classCtx, (String)"BETA", (double[])this.beta(), (String)"The Coefficients");
        JCodeGen.toStaticVar((SB)classCtx, (String)"CATOFFS", (int[])this.dinfo()._catOffsets, (String)"Categorical Offsets");
        body.ip("double eta = 0.0;").nl();
        body.ip("final double [] b = BETA;").nl();
        if (!((GLMParameters)this._parms)._use_all_factor_levels) {
            body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0) {").nl();
            body.ip("  int ival = (int)data[i] - 1;").nl();
            body.ip("  if(ival != data[i] - 1) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
            body.ip("  ival += CATOFFS[i];").nl();
            body.ip("  if(ival < CATOFFS[i + 1])").nl();
            body.ip("    eta += b[ival];").nl();
        } else {
            body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) {").nl();
            body.ip("  int ival = (int)data[i];").nl();
            body.ip("  if(ival != data[i]) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
            body.ip("  ival += CATOFFS[i];").nl();
            body.ip("  if(ival < CATOFFS[i + 1])").nl();
            body.ip("    eta += b[ival];").nl();
        }
        body.ip("}").nl();
        int noff = this.dinfo().numStart() - this.dinfo()._cats;
        body.ip("for(int i = ").p(this.dinfo()._cats).p("; i < b.length-1-").p(noff).p("; ++i)").nl();
        body.ip("  eta += b[").p(noff).p("+i]*data[i];").nl();
        body.ip("eta += b[b.length-1]; // reduce intercept").nl();
        body.ip("double mu = hex.genmodel.GenModel.GLM_").p(((GLMParameters)this._parms)._link.toString()).p("Inv(eta");
        body.p(");").nl();
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
            body.ip("preds[0] = mu > ").p(((GLMOutput)this._output)._threshold).p(" ? 1 : 0); // threshold given by ROC").nl();
            body.ip("preds[1] = 1.0 - mu; // class 0").nl();
            body.ip("preds[2] =       mu; // class 1").nl();
        } else {
            body.ip("preds[0] = mu;").nl();
        }
    }

    protected SB toJavaInit(SB sb, SB fileContext) {
        sb.nl();
        sb.ip("public boolean isSupervised() { return true; }").nl();
        sb.ip("public int nfeatures() { return " + ((GLMOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((GLMOutput)this._output).nclasses() + "; }").nl();
        return sb;
    }

    public static class GLMOutput
    extends Model.Output {
        Submodel[] _submodels;
        DataInfo _dinfo;
        String[] _coefficient_names;
        public int _best_lambda_idx;
        double _threshold;
        double[] _global_beta;
        public boolean _binomial;
        private String[] binomialClassNames = new String[]{"0", "1"};

        public int rank() {
            return this._submodels[this._best_lambda_idx].rank();
        }

        public boolean isStandardized() {
            return this._dinfo._predictor_transform == DataInfo.TransformType.STANDARDIZE;
        }

        public String[] coefficientNames() {
            return this._coefficient_names;
        }

        public GLMOutput(DataInfo dinfo, String[] column_names, String[][] domains, String[] coefficient_names, boolean binomial) {
            super(dinfo._weights, dinfo._offset, dinfo._fold);
            this._dinfo = dinfo;
            this._names = column_names;
            this._domains = domains;
            this._coefficient_names = coefficient_names;
            this._binomial = binomial;
            if (this._binomial && domains[domains.length - 1] != null) {
                assert (domains.length == 2);
                this.binomialClassNames = domains[domains.length - 1];
            }
        }

        public GLMOutput(DataInfo dinfo, String[] column_names, String[][] domains, String[] coefficient_names, boolean binomial, double[] beta) {
            this(dinfo, column_names, domains, coefficient_names, binomial);
            this._global_beta = beta;
        }

        public GLMOutput() {
            this._isSupervised = true;
        }

        public GLMOutput(GLM glm) {
            super((ModelBuilder)glm);
            this._dinfo = glm._dinfo;
            String[] cnames = glm._dinfo.coefNames();
            this._names = glm._dinfo._adaptedFrame.names();
            this._domains = glm._dinfo._adaptedFrame.domains();
            this._coefficient_names = Arrays.copyOf(cnames, cnames.length + 1);
            this._coefficient_names[this._coefficient_names.length - 1] = "Intercept";
            this._binomial = ((GLMParameters)glm._parms)._family == GLMParameters.Family.binomial;
        }

        public int nclasses() {
            return this._binomial ? 2 : 1;
        }

        public String[] classNames() {
            return this._binomial ? this.binomialClassNames : null;
        }

        public void pickBestModel() {
            int i;
            for (i = this._submodels.length - 1; i > 0 && this._submodels[i - 1].devianceTest <= this._submodels[i].devianceTest; --i) {
            }
            this._best_lambda_idx = i;
            this.setSubmodelIdx(this._best_lambda_idx);
        }

        public double[] getNormBeta() {
            double[] res = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
            this.getBeta(this._best_lambda_idx, res);
            return res;
        }

        public void getBeta(int l, double[] beta) {
            assert (beta.length == this._dinfo.fullN() + 1);
            int k = 0;
            for (int i : this._submodels[l].idxs) {
                beta[i] = this._submodels[l].beta[k++];
            }
        }

        public void setSubmodelIdx(int l) {
            this._best_lambda_idx = l;
            if (this._global_beta == null) {
                this._global_beta = MemoryManager.malloc8d((int)this._coefficient_names.length);
            } else {
                Arrays.fill(this._global_beta, 0.0);
            }
            this.getBeta(l, this._global_beta);
            this._global_beta = this._dinfo.denormalizeBeta(this._global_beta);
        }

        public double[] beta() {
            return this._global_beta;
        }

        public Submodel bestSubmodel() {
            return this._submodels[this._best_lambda_idx];
        }
    }

    public static class Submodel
    extends Iced {
        public final double lambda_value;
        public final int iteration;
        public final double devianceTrain;
        public final double devianceTest;
        public final int[] idxs;
        public final double[] beta;

        public int rank() {
            return this.idxs != null ? this.idxs.length + 1 : this.beta.length;
        }

        public Submodel(double lambda, double[] beta, int iteration, double devTrain, double devTest) {
            this.lambda_value = lambda;
            this.iteration = iteration;
            this.devianceTrain = devTrain;
            this.devianceTest = devTest;
            int r = 0;
            if (beta != null) {
                for (double d : beta) {
                    if (d == 0.0) continue;
                    ++r;
                }
                this.idxs = MemoryManager.malloc4((int)r);
                int j = 0;
                for (int i = 0; i < beta.length; ++i) {
                    if (beta[i] == 0.0) continue;
                    this.idxs[j++] = i;
                }
                j = 0;
                this.beta = MemoryManager.malloc8d((int)this.idxs.length);
                for (int i : this.idxs) {
                    this.beta[j++] = beta[i];
                }
            } else {
                this.beta = null;
                this.idxs = null;
            }
        }
    }

    public static class GLMParameters
    extends Model.Parameters {
        public boolean _standardize = true;
        public Family _family;
        public Link _link = Link.family_default;
        public Solver _solver = Solver.IRLSM;
        public double _tweedie_variance_power;
        public double _tweedie_link_power;
        public double[] _alpha = null;
        public double[] _lambda = null;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public int _nlambdas = -1;
        public boolean _non_negative = false;
        public boolean _exactLambdas = false;
        public double _lambda_min_ratio = -1.0;
        public boolean _use_all_factor_levels = false;
        public int _max_iterations = -1;
        public boolean _intercept = true;
        public double _beta_epsilon = 1.0E-4;
        public double _objective_epsilon = 1.0E-5;
        public double _gradient_epsilon = 1.0E-4;
        public Key<Frame> _beta_constraints = null;
        public int _max_active_predictors = -1;

        public void validate(GLM glm) {
            if (this._weights_column != null && this._offset_column != null && this._weights_column.equals(this._offset_column)) {
                glm.error("_offset_column", "Offset must be different from weights");
            }
            if (this._lambda_search) {
                if (this._nlambdas == -1) {
                    this._nlambdas = 100;
                } else {
                    this._exactLambdas = false;
                }
            }
            if (this._family != Family.tweedie) {
                glm.hide("_tweedie_variance_power", "Only applicable with Tweedie family");
                glm.hide("_tweedie_link_power", "Only applicable with Tweedie family");
            }
            if (this._beta_constraints != null) {
                Vec v;
                Frame f = (Frame)this._beta_constraints.get();
                if (f == null) {
                    glm.error("beta_constraints", "Missing frame for beta constraints");
                }
                if ((v = f.vec("names")) == null) {
                    glm.error("beta_constraints", "Beta constraints parameter must have names column with valid coefficient names");
                }
                if ((v = f.vec("upper_bounds")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "upper_bounds must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("lower_bounds");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "lower_bounds must be numeric if present");
                }
                if ((v = f.vec("beta_given")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_given must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("beta_start");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_start must be numeric if present");
                }
            }
            if (this._family == Family.binomial) {
                Vec response;
                Frame frame = (Frame)DKV.getGet((Key)this._train);
                if (frame != null && (response = frame.vec(this._response_column)) != null && (response.min() != 0.0 || response.max() != 1.0)) {
                    glm.error("_response_column", "Illegal response for family binomial, must be binary, got min = " + response.min() + ", max = " + response.max() + ")");
                }
            } else if (glm.nclasses() > 2) {
                glm.error("_response_column", "Illegal response for " + (Object)((Object)this._family) + " family, cannot be categorical with more than 2 levels");
            }
            if (!this._lambda_search) {
                glm.hide("_lambda_min_ratio", "only applies if lambda search is on.");
                glm.hide("_nlambdas", "only applies if lambda search is on.");
            }
            if (this._link != Link.family_default) {
                switch (this._family) {
                    case gaussian: {
                        if (this._link == Link.identity || this._link == Link.log || this._link == Link.inverse) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only identity, log and inverse links are allowed for family=gaussian.");
                    }
                    case binomial: {
                        if (this._link == Link.logit) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only logit is allowed for family=binomial. Got " + (Object)((Object)this._link));
                    }
                    case poisson: {
                        if (this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only log and identity links are allowed for family=poisson.");
                    }
                    case gamma: {
                        if (this._link == Link.inverse || this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only inverse, log and identity links are allowed for family=gamma.");
                    }
                    case tweedie: {
                        if (this._link == Link.tweedie) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only tweedie link allowed for family=tweedie.");
                    }
                    default: {
                        H2O.fail();
                    }
                }
            }
        }

        public GLMParameters() {
            this(Family.gaussian, Link.family_default);
            assert (this._link == Link.family_default);
        }

        public GLMParameters(Family f) {
            this(f, f.defaultLink);
        }

        public GLMParameters(Family f, Link l) {
            this(f, l, null, null, 0.0, 1.0);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk) {
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_variance_power = twVar;
            this._tweedie_link_power = twLnk;
            this._family = f;
            this._link = l;
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case binomial: {
                    return mu * (1.0 - mu);
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._tweedie_variance_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this._family));
        }

        public final boolean canonical() {
            switch (this._family) {
                case gaussian: {
                    return this._link == Link.identity;
                }
                case binomial: {
                    return this._link == Link.logit;
                }
                case poisson: {
                    return this._link == Link.log;
                }
                case gamma: {
                    return this._link == Link.inverse;
                }
            }
            throw H2O.unimpl();
        }

        public final double deviance(double yr, double ym) {
            double y1 = yr == 0.0 ? 0.1 : yr;
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case binomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0 - yr, 1.0 - ym));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double theta = this._tweedie_variance_power == 1.0 ? Math.log(y1 / ym) : (Math.pow(y1, 1.0 - this._tweedie_variance_power) - Math.pow(ym, 1.0 - this._tweedie_variance_power)) / (1.0 - this._tweedie_variance_power);
                    double kappa = this._tweedie_variance_power == 2.0 ? Math.log(y1 / ym) : (Math.pow(yr, 2.0 - this._tweedie_variance_power) - Math.pow(ym, 2.0 - this._tweedie_variance_power)) / (2.0 - this._tweedie_variance_power);
                    return 2.0 * (yr * theta - kappa);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            return this.deviance((double)yr, (double)ym);
        }

        public final double likelihood(double yr, double ym) {
            switch (this._family) {
                case gaussian: {
                    return 0.5 * (yr - ym) * (yr - ym);
                }
                case binomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    return 0.5 * this.deviance(yr, ym);
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    return this.deviance(yr, ym);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double link(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    assert (0.0 <= x && x <= 1.0) : "x out of bounds, expected <0,1> range, got " + x;
                    return Math.log(x / (1.0 - x));
                }
                case log: {
                    return Math.log(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? Math.log(x) : Math.pow(x, this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unknown link function " + (Object)((Object)this));
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? 1.0 / Math.max(2.0E-16, x) : this._tweedie_link_power * Math.pow(x, this._tweedie_link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInvDeriv(double x) {
            switch (this._link) {
                case identity: {
                    return 1.0;
                }
                case logit: {
                    double g = Math.exp(-x);
                    double gg = (g + 1.0) * (g + 1.0);
                    return g / gg;
                }
                case log: {
                    return Math.max(Math.exp(x), Double.MIN_NORMAL);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return -1.0 / (xx * xx);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        static final double y_log_y(double y, double mu) {
            if (y == 0.0) {
                return 0.0;
            }
            if (mu < Double.MIN_NORMAL) {
                mu = Double.MIN_NORMAL;
            }
            return y * Math.log(y / mu);
        }

        public static enum Solver {
            AUTO,
            IRLSM,
            L_BFGS;

        }

        public static enum Link {
            family_default,
            identity,
            logit,
            log,
            inverse,
            tweedie;

        }

        public static enum Family {
            gaussian(Link.identity),
            binomial(Link.logit),
            poisson(Link.log),
            gamma(Link.inverse),
            tweedie(Link.tweedie);

            public final Link defaultLink;

            private Family(Link link) {
                this.defaultLink = link;
            }
        }
    }
}

