/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.glrm.GLRM;
import java.util.Random;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GLRMModel
extends Model<GLRMModel, GLRMParameters, GLRMOutput> {
    public GLRMModel(Key selfKey, GLRMParameters parms, GLRMOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    protected double[] score0(double[] data, double[] preds) {
        throw H2O.unimpl();
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsGLRM.GLRMModelMetrics(((GLRMParameters)this._parms)._k);
    }

    public static class ModelMetricsGLRM
    extends ModelMetricsUnsupervised {
        public ModelMetricsGLRM(Model model, Frame frame) {
            super(model, frame, Double.NaN);
        }

        public static class GLRMModelMetrics
        extends ModelMetricsUnsupervised.MetricBuilderUnsupervised {
            public GLRMModelMetrics(int dims) {
                this._work = new double[dims];
            }

            public double[] perRow(double[] dataRow, float[] preds, Model m) {
                return dataRow;
            }

            public ModelMetrics makeModelMetrics(Model m, Frame f) {
                return m._output.addModelMetrics((ModelMetrics)new ModelMetricsGLRM(m, f));
            }
        }
    }

    public static class GLRMOutput
    extends Model.Output {
        public int _iterations;
        public double _objective;
        public double _avg_change_obj;
        public double[][] _archetypes;
        public double _step_size;
        public double[][] _eigenvectors;
        public double[] _singular_vals;
        public Key<Frame> _loading_key;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public String[] _names_expanded;

        public GLRMOutput(GLRM b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return this._names.length;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class GLRMParameters
    extends Model.Parameters {
        public int _k = 1;
        public Loss _loss = Loss.L2;
        public MultiLoss _multi_loss = MultiLoss.Categorical;
        public Regularizer _regularization_x = Regularizer.L2;
        public Regularizer _regularization_y = Regularizer.L2;
        public double _gamma_x = 0.0;
        public double _gamma_y = 0.0;
        public int _max_iterations = 1000;
        public double _init_step_size = 1.0;
        public double _min_step_size = 1.0E-4;
        public long _seed = System.nanoTime();
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public GLRM.Initialization _init = GLRM.Initialization.PlusPlus;
        public Key<Frame> _user_points;
        public Key<Frame> _loading_key;
        public boolean _recover_svd = false;

        public final boolean hasClosedForm() {
            return !(this._loss != Loss.L2 || this._gamma_x != 0.0 && this._regularization_x != Regularizer.L2 || this._gamma_y != 0.0 && this._regularization_y != Regularizer.L2);
        }

        public final double loss(double u, double a) {
            switch (this._loss) {
                case L2: {
                    return (u - a) * (u - a);
                }
                case L1: {
                    return Math.abs(u - a);
                }
                case Huber: {
                    return Math.abs(u - a) <= 1.0 ? 0.5 * (u - a) * (u - a) : Math.abs(u - a) - 0.5;
                }
                case Poisson: {
                    return Math.exp(u) - a * u + a * Math.log(a) - a;
                }
                case Hinge: {
                    return Math.max(1.0 - a * u, 0.0);
                }
                case Logistic: {
                    return Math.log(1.0 + Math.exp(-a * u));
                }
            }
            throw new RuntimeException("Unknown loss function " + (Object)((Object)this._loss));
        }

        public final double lgrad(double u, double a) {
            switch (this._loss) {
                case L2: {
                    return 2.0 * (u - a);
                }
                case L1: {
                    return Math.signum(u - a);
                }
                case Huber: {
                    return Math.abs(u - a) <= 1.0 ? u - a : Math.signum(u - a);
                }
                case Poisson: {
                    return Math.exp(u) - a;
                }
                case Hinge: {
                    return a * u <= 1.0 ? -a : 0.0;
                }
                case Logistic: {
                    return -a / (1.0 + Math.exp(a * u));
                }
            }
            throw new RuntimeException("Unknown loss function " + (Object)((Object)this._loss));
        }

        public final double mloss(double[] u, int a) {
            if (a < 0 || a > u.length - 1) {
                throw new IllegalArgumentException("Index must be between 0 and " + String.valueOf(u.length - 1));
            }
            double sum = 0.0;
            switch (this._multi_loss) {
                case Categorical: {
                    for (int i = 0; i < u.length; ++i) {
                        sum += Math.max(1.0 + u[i], 0.0);
                    }
                    return sum += Math.max(1.0 - u[a], 0.0) - Math.max(1.0 + u[a], 0.0);
                }
                case Ordinal: {
                    for (int i = 0; i < u.length - 1; ++i) {
                        sum += Math.max(a > i ? 1.0 - u[i] : 1.0, 0.0);
                    }
                    return sum;
                }
            }
            throw new RuntimeException("Unknown multidimensional loss function " + (Object)((Object)this._multi_loss));
        }

        public final double[] mlgrad(double[] u, int a) {
            if (a < 0 || a > u.length - 1) {
                throw new IllegalArgumentException("Index must be between 0 and " + String.valueOf(u.length - 1));
            }
            double[] grad = new double[u.length];
            switch (this._multi_loss) {
                case Categorical: {
                    for (int i = 0; i < u.length; ++i) {
                        grad[i] = 1.0 + u[i] > 0.0 ? 1.0 : 0.0;
                    }
                    grad[a] = 1.0 - u[a] > 0.0 ? -1.0 : 0.0;
                    return grad;
                }
                case Ordinal: {
                    for (int i = 0; i < u.length - 1; ++i) {
                        grad[i] = a > i && 1.0 - u[i] > 0.0 ? -1.0 : 0.0;
                    }
                    return grad;
                }
            }
            throw new RuntimeException("Unknown multidimensional loss function " + (Object)((Object)this._multi_loss));
        }

        public final double regularize_x(double[] u) {
            return this.regularize(u, this._regularization_x);
        }

        public final double regularize_y(double[] u) {
            return this.regularize(u, this._regularization_y);
        }

        public final double regularize(double[] u, Regularizer regularization) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            switch (regularization) {
                case L2: {
                    for (int i = 0; i < u.length; ++i) {
                        ureg += u[i] * u[i];
                    }
                    return ureg;
                }
                case L1: {
                    for (int i = 0; i < u.length; ++i) {
                        ureg += Math.abs(u[i]);
                    }
                    return ureg;
                }
                case NonNegative: {
                    for (int i = 0; i < u.length; ++i) {
                        if (!(u[i] < 0.0)) continue;
                        return Double.POSITIVE_INFINITY;
                    }
                    return 0.0;
                }
                case OneSparse: {
                    int card = 0;
                    for (int i = 0; i < u.length; ++i) {
                        if (u[i] < 0.0) {
                            return Double.POSITIVE_INFINITY;
                        }
                        if (!(u[i] > 0.0)) continue;
                        ++card;
                    }
                    return card == 1 ? 0.0 : Double.POSITIVE_INFINITY;
                }
                case UnitOneSparse: {
                    int ones = 0;
                    int zeros = 0;
                    for (int i = 0; i < u.length; ++i) {
                        if (u[i] == 1.0) {
                            ++ones;
                            continue;
                        }
                        if (u[i] == 0.0) {
                            ++zeros;
                            continue;
                        }
                        return Double.POSITIVE_INFINITY;
                    }
                    return ones == 1 && zeros == u.length - 1 ? 0.0 : Double.POSITIVE_INFINITY;
                }
            }
            throw new RuntimeException("Unknown regularization function " + (Object)((Object)regularization));
        }

        public final double regularize_x(double[][] u) {
            return this.regularize(u, this._regularization_x);
        }

        public final double regularize_y(double[][] u) {
            return this.regularize(u, this._regularization_y);
        }

        public final double regularize(double[][] u, Regularizer regularization) {
            if (u == null) {
                return 0.0;
            }
            double ureg = 0.0;
            for (int i = 0; i < u.length; ++i) {
                if (!Double.isInfinite(ureg += this.regularize(u[i], regularization))) continue;
                return ureg;
            }
            return ureg;
        }

        public final double[] rproxgrad_x(double[] u, double alpha, Random rand) {
            return this.rproxgrad(u, alpha, this._gamma_x, this._regularization_x, rand);
        }

        public final double[] rproxgrad_y(double[] u, double alpha, Random rand) {
            return this.rproxgrad(u, alpha, this._gamma_y, this._regularization_y, rand);
        }

        public final double[] rproxgrad(double[] u, double alpha, double gamma, Regularizer regularization, Random rand) {
            if (u == null || alpha == 0.0 || gamma == 0.0) {
                return u;
            }
            double[] v = new double[u.length];
            switch (regularization) {
                case L2: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = u[i] / (1.0 + 2.0 * alpha * gamma);
                    }
                    return v;
                }
                case L1: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = Math.max(u[i] - alpha * gamma, 0.0) + Math.min(u[i] + alpha * gamma, 0.0);
                    }
                    return v;
                }
                case NonNegative: {
                    for (int i = 0; i < u.length; ++i) {
                        v[i] = Math.max(u[i], 0.0);
                    }
                    return v;
                }
                case OneSparse: {
                    int idx = ArrayUtils.maxIndex((double[])u, (Random)rand);
                    v[idx] = u[idx] > 0.0 ? u[idx] : 1.0E-6;
                    return v;
                }
                case UnitOneSparse: {
                    int idx = ArrayUtils.maxIndex((double[])u, (Random)rand);
                    v[idx] = 1.0;
                    return v;
                }
            }
            throw new RuntimeException("Unknown regularization function " + (Object)((Object)regularization));
        }

        public static enum Regularizer {
            L2,
            L1,
            NonNegative,
            OneSparse,
            UnitOneSparse;

        }

        public static enum MultiLoss {
            Categorical,
            Ordinal;

        }

        public static enum Loss {
            L2,
            L1,
            Huber,
            Poisson,
            Hinge,
            Logistic;

        }
    }
}

