/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.svd.SVD;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.SB;

public class SVDModel
extends Model<SVDModel, SVDParameters, SVDOutput> {
    public SVDModel(Key selfKey, SVDParameters parms, SVDOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsSVD.SVDModelMetrics(((SVDParameters)this._parms)._nv);
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key) {
        Frame adaptFrm = new Frame(adaptedFr);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            adaptFrm.add("PC" + String.valueOf(i + 1), adaptFrm.anyVec().makeZero());
        }
        new MRTask(){

            public void map(Chunk[] chks) {
                double[] tmp = new double[((SVDOutput)SVDModel.this._output)._names.length];
                double[] preds = new double[((SVDParameters)SVDModel.this._parms)._nv];
                for (int row = 0; row < chks[0]._len; ++row) {
                    double[] p = SVDModel.this.score0(chks, row, tmp, preds);
                    for (int c = 0; c < preds.length; ++c) {
                        chks[((SVDOutput)SVDModel.this._output)._names.length + c].set(row, p[c]);
                    }
                }
            }
        }.doAll(adaptFrm);
        int x = ((SVDOutput)this._output)._names.length;
        int y = adaptFrm.numCols();
        Frame f = adaptFrm.extractFrame(x, y);
        f = new Frame(null == destination_key ? Key.make() : Key.make((String)destination_key), f.names(), f.vecs());
        DKV.put((Keyed)f);
        this.makeMetricBuilder(null).makeModelMetrics((Model)this, orig);
        return f;
    }

    protected double[] score0(double[] data, double[] preds) {
        int numStart = ((SVDOutput)this._output)._catOffsets[((SVDOutput)this._output)._catOffsets.length - 1];
        assert (data.length == ((SVDOutput)this._output)._permutation.length);
        for (int i = 0; i < ((SVDParameters)this._parms)._nv; ++i) {
            preds[i] = 0.0;
            for (int j = 0; j < ((SVDOutput)this._output)._ncats; ++j) {
                int level;
                double tmp = data[((SVDOutput)this._output)._permutation[j]];
                int last_cat = ((SVDOutput)this._output)._catOffsets[j + 1] - ((SVDOutput)this._output)._catOffsets[j] - 1;
                int n = Double.isNaN(tmp) ? last_cat : (level = (int)tmp - (((SVDParameters)this._parms)._use_all_factor_levels ? 0 : 1));
                if (level < 0 || level > last_cat) continue;
                int n2 = i;
                preds[n2] = preds[n2] + ((SVDOutput)this._output)._v[((SVDOutput)this._output)._catOffsets[j] + level][i];
            }
            int dcol = ((SVDOutput)this._output)._ncats;
            int vcol = numStart;
            for (int j = 0; j < ((SVDOutput)this._output)._nnums; ++j) {
                int n = i;
                preds[n] = preds[n] + (data[((SVDOutput)this._output)._permutation[dcol]] - ((SVDOutput)this._output)._normSub[j]) * ((SVDOutput)this._output)._normMul[j] * ((SVDOutput)this._output)._v[vcol][i];
                ++dcol;
                ++vcol;
            }
        }
        return preds;
    }

    protected SB toJavaInit(SB sb, SB fileContextSB) {
        sb = super.toJavaInit(sb, fileContextSB);
        sb.ip("public boolean isSupervised() { return " + this.isSupervised() + "; }").nl();
        sb.ip("public int nfeatures() { return " + ((SVDOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((SVDParameters)this._parms)._nv + "; }").nl();
        if (((SVDOutput)this._output)._nnums > 0) {
            JCodeGen.toStaticVar((SB)sb, (String)"NORMMUL", (double[])((SVDOutput)this._output)._normMul, (String)"Standardization/Normalization scaling factor for numerical variables.");
            JCodeGen.toStaticVar((SB)sb, (String)"NORMSUB", (double[])((SVDOutput)this._output)._normSub, (String)"Standardization/Normalization offset for numerical variables.");
        }
        JCodeGen.toStaticVar((SB)sb, (String)"CATOFFS", (int[])((SVDOutput)this._output)._catOffsets, (String)"Categorical column offsets.");
        JCodeGen.toStaticVar((SB)sb, (String)"PERMUTE", (int[])((SVDOutput)this._output)._permutation, (String)"Permutation index vector.");
        JCodeGen.toStaticVar((SB)sb, (String)"EIGVECS", (double[][])((SVDOutput)this._output)._v, (String)"Eigenvector matrix.");
        return sb;
    }

    protected void toJavaPredictBody(SB bodySb, SB classCtxSb, SB fileCtxSb) {
        SB model = new SB();
        bodySb.i().p("java.util.Arrays.fill(preds,0);").nl();
        int cats = ((SVDOutput)this._output)._ncats;
        int nums = ((SVDOutput)this._output)._nnums;
        bodySb.i().p("final int nstart = CATOFFS[CATOFFS.length-1];").nl();
        bodySb.i().p("for(int i = 0; i < ").p(((SVDParameters)this._parms)._nv).p("; i++) {").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(cats).p("; j++) {").nl();
        bodySb.i(2).p("double d = data[PERMUTE[j]];").nl();
        bodySb.i(2).p("int last = CATOFFS[j+1]-CATOFFS[j]-1;").nl();
        bodySb.i(2).p("int c = Double.isNaN(d) ? last : (int)d").p(((SVDParameters)this._parms)._use_all_factor_levels ? ";" : "-1;").nl();
        bodySb.i(2).p("if(c < 0 || c > last) continue;").nl();
        bodySb.i(2).p("preds[i] += EIGVECS[CATOFFS[j]+c][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i(1).p("for(int j = 0; j < ").p(nums).p("; j++) {").nl();
        bodySb.i(2).p("preds[i] += (data[PERMUTE[j" + (cats > 0 ? "+" + cats : "") + "]]-NORMSUB[j])*NORMMUL[j]*EIGVECS[j" + (cats > 0 ? "+ nstart" : "") + "][i];").nl();
        bodySb.i(1).p("}").nl();
        bodySb.i().p("}").nl();
        fileCtxSb.p(model);
    }

    public static class ModelMetricsSVD
    extends ModelMetricsUnsupervised {
        public ModelMetricsSVD(Model model, Frame frame) {
            super(model, frame, Double.NaN);
        }

        public static class SVDModelMetrics
        extends ModelMetricsUnsupervised.MetricBuilderUnsupervised {
            public SVDModelMetrics(int dims) {
                this._work = new double[dims];
            }

            public double[] perRow(double[] dataRow, float[] preds, Model m) {
                return dataRow;
            }

            public ModelMetrics makeModelMetrics(Model m, Frame f) {
                return m._output.addModelMetrics((ModelMetrics)new ModelMetricsSVD(m, f));
            }
        }
    }

    public static class SVDOutput
    extends Model.Output {
        public double[][] _v;
        public double[] _d;
        public Key<Frame> _u_key;
        public int _ncats;
        public int _nnums;
        public long _nobs;
        public double _total_variance;
        public int[] _catOffsets;
        public double[] _normSub;
        public double[] _normMul;
        public int[] _permutation;
        public String[] _names_expanded;

        public SVDOutput(SVD b) {
            super((ModelBuilder)b);
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.DimReduction;
        }
    }

    public static class SVDParameters
    extends Model.Parameters {
        public DataInfo.TransformType _transform = DataInfo.TransformType.NONE;
        public int _nv = 1;
        public int _max_iterations = 1000;
        public long _seed = System.nanoTime();
        public boolean _keep_u = true;
        public String _u_name;
        public boolean _only_v = false;
        public boolean _use_all_factor_levels = true;
    }
}

