/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DRealHistogram;
import hex.tree.DTree;
import sun.misc.Unsafe;
import water.H2O;
import water.Iced;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;
import water.util.MathUtils;

public abstract class DHistogram<TDH extends DHistogram>
extends Iced {
    public final transient String _name;
    public final byte _isInt;
    public final char _nbin;
    public final float _step;
    public final float _min;
    public final float _maxEx;
    public double[] _bins;
    protected float _min2;
    protected float _maxIn;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _min2Offset;
    private static final long _max2Offset;

    public void setMin(float min) {
        int imin = Float.floatToRawIntBits(min);
        float old = this._min2;
        while (min < old && !_unsafe.compareAndSwapInt((Object)this, _min2Offset, Float.floatToRawIntBits(old), imin)) {
            old = this._min2;
        }
    }

    public void setMax(float max) {
        int imax = Float.floatToRawIntBits(max);
        float old = this._maxIn;
        while (max > old && !_unsafe.compareAndSwapInt((Object)this, _max2Offset, Float.floatToRawIntBits(old), imax)) {
            old = this._maxIn;
        }
    }

    public DHistogram(String name, int nbins, int nbins_cats, byte isInt, float min, float maxEx) {
        int xbins;
        assert (nbins > 1);
        assert (nbins_cats > 1);
        assert (maxEx > min) : "Caller ensures " + maxEx + ">" + min + ", since if max==min== the column " + name + " is all constants";
        this._isInt = isInt;
        this._name = name;
        this._min = min;
        this._maxEx = maxEx;
        this._min2 = Float.MAX_VALUE;
        this._maxIn = -3.4028235E38f;
        int n = xbins = isInt == 2 ? nbins_cats : nbins;
        if (isInt > 0 && maxEx - min <= (float)xbins) {
            assert ((float)((long)min) == min);
            xbins = (char)((long)maxEx - (long)min);
            this._step = 1.0f;
        } else {
            this._step = (float)xbins / (maxEx - min);
            assert (this._step > 0.0f && !Float.isInfinite(this._step));
        }
        this._nbin = (char)xbins;
    }

    int bin(float col_data) {
        if (Float.isNaN(col_data)) {
            return 0;
        }
        if (Float.isInfinite(col_data)) {
            if (col_data < 0.0f) {
                return 0;
            }
            return this._bins.length - 1;
        }
        assert (this._min <= col_data && col_data < this._maxEx) : "Coldata " + col_data + " out of range " + (Object)((Object)this);
        int idx1 = (int)((col_data - this._min) * this._step);
        assert (0 <= idx1 && idx1 <= this._bins.length) : idx1 + " " + this._bins.length;
        if (idx1 == this._bins.length) {
            --idx1;
        }
        return idx1;
    }

    float binAt(int b) {
        return this._min + (float)b / this._step;
    }

    public int nbins() {
        return this._nbin;
    }

    public double bins(int b) {
        return this._bins[b];
    }

    public abstract double mean(int var1);

    public abstract double var(int var1);

    abstract void init0();

    final void init() {
        assert (this._bins == null);
        this._bins = MemoryManager.malloc8d((int)this._nbin);
        this.init0();
    }

    abstract void incr0(int var1, double var2, double var4);

    final void incr(float col_data, double y, double w) {
        assert (Float.isNaN(col_data) || Float.isInfinite(col_data) || this._min <= col_data && col_data < this._maxEx) : "col_data " + col_data + " out of range " + (Object)((Object)this);
        int b = this.bin(col_data);
        AtomicUtils.DoubleArray.add((double[])this._bins, (int)b, (double)w);
        if (!Float.isInfinite(col_data)) {
            this.setMin(col_data);
            this.setMax(col_data);
        }
        if (y != 0.0 && w != 0.0) {
            this.incr0(b, y, w);
        }
    }

    abstract void add0(TDH var1);

    void add(TDH dsh) {
        assert (this._isInt == ((DHistogram)((Object)dsh))._isInt && this._nbin == ((DHistogram)((Object)dsh))._nbin && this._step == ((DHistogram)((Object)dsh))._step && this._min == ((DHistogram)((Object)dsh))._min && this._maxEx == ((DHistogram)((Object)dsh))._maxEx);
        assert (this._bins == null && ((DHistogram)((Object)dsh))._bins == null || this._bins != null && ((DHistogram)((Object)dsh))._bins != null);
        if (this._bins == null) {
            return;
        }
        ArrayUtils.add((double[])this._bins, (double[])((DHistogram)((Object)dsh))._bins);
        if (this._min2 > ((DHistogram)((Object)dsh))._min2) {
            this._min2 = ((DHistogram)((Object)dsh))._min2;
        }
        if (this._maxIn < ((DHistogram)((Object)dsh))._maxIn) {
            this._maxIn = ((DHistogram)((Object)dsh))._maxIn;
        }
        this.add0(dsh);
    }

    public float find_min() {
        return this._min2;
    }

    public float find_maxIn() {
        return this._maxIn;
    }

    public float find_maxEx() {
        return DHistogram.find_maxEx(this._maxIn, this._isInt);
    }

    public static float find_maxEx(float maxIn, int isInt) {
        float res;
        float ulp = Math.ulp(maxIn);
        if (isInt > 0 && 1.0f > ulp) {
            ulp = 1.0f;
        }
        return Float.isInfinite(res = maxIn + ulp) ? maxIn : res;
    }

    public abstract DTree.Split scoreMSE(int var1, double var2);

    public static DHistogram[] initialHist(Frame fr, int ncols, int nbins, int nbins_cats, DHistogram[] hs) {
        Vec[] vecs = fr.vecs();
        for (int c = 0; c < ncols; ++c) {
            Vec v = vecs[c];
            float minIn = (float)Math.max(v.min(), -3.4028234663852886E38);
            float maxIn = (float)Math.min(v.max(), 3.4028234663852886E38);
            float maxEx = DHistogram.find_maxEx(maxIn, v.isInt() ? 1 : 0);
            long vlen = v.length();
            DHistogram dHistogram = v.naCnt() == vlen || v.min() == v.max() ? null : (hs[c] = DHistogram.make(fr._names[c], nbins, nbins_cats, (byte)(v.isEnum() ? 2 : (v.isInt() ? 1 : 0)), minIn, maxEx));
            assert (hs[c] == null || vlen > 0L);
        }
        return hs;
    }

    public static DHistogram make(String name, int nbins, int nbins_cats, byte isInt, float min, float maxEx) {
        return new DRealHistogram(name, nbins, nbins_cats, isInt, min, maxEx);
    }

    public boolean isConstantResponse() {
        double m = Double.NaN;
        for (int b = 0; b < this._bins.length; ++b) {
            if (this._bins[b] == 0.0) continue;
            if (this.var(b) > 1.0E-6) {
                Log.warn((Object[])new Object[]{"Response should be constant, but variance of bin " + b + " (out of " + this._bins.length + ") is " + this.var(b)});
                return false;
            }
            double mean = this.mean(b);
            if (mean == m) continue;
            if (Double.isNaN(m)) {
                m = mean;
                continue;
            }
            if (MathUtils.compare((double)m, (double)mean, (double)1.0E-6, (double)1.0E-6)) continue;
            Log.warn((Object[])new Object[]{"Response should be constant, but mean of first non-empty bin is " + m + ", but another bin (" + b + ") has mean(b) = " + mean});
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(":").append(this._min).append("-").append(this._maxEx).append(" step=" + 1.0f / this._step + " nbins=" + this.nbins() + " isInt=" + this._isInt);
        if (this._bins != null) {
            for (int b = 0; b < this._bins.length; ++b) {
                sb.append(String.format("\ncnt=%d, [%f - %f], mean/var=", this._bins[b], Float.valueOf(this._min + (float)b / this._step), Float.valueOf(this._min + (float)(b + 1) / this._step)));
                sb.append(String.format("%6.2f/%6.2f,", this.mean(b), this.var(b)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public abstract long byteSize0();

    public long byteSize() {
        long sum = 16L;
        sum += 3L;
        sum += 20L;
        sum += 8L;
        if (this._bins == null) {
            return sum;
        }
        sum += (long)(24 + this._bins.length << 3);
        return sum += this.byteSize0();
    }

    static {
        try {
            _min2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_min2"));
            _max2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_maxIn"));
        }
        catch (Exception e) {
            throw H2O.fail();
        }
    }
}

