/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.gbm;

import hex.Distribution;
import hex.Grid;
import hex.Model;
import hex.tree.SharedTreeGrid;
import hex.tree.gbm.GBM;
import hex.tree.gbm.GBMModel;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GBMGrid
extends SharedTreeGrid<GBMModel.GBMParameters, GBMGrid> {
    public static final String MODEL_NAME = "GBM";
    private static final String[] HYPER_NAMES = ArrayUtils.append((String[])SharedTreeGrid.HYPER_NAMES, (String[])new String[]{"_distribution", "_learn_rate"});
    private static final double[] HYPER_DEFAULTS = ArrayUtils.append((double[])SharedTreeGrid.HYPER_DEFAULTS, (double[])new double[]{Distribution.Family.AUTO.ordinal(), 0.1f});

    @Override
    protected String modelName() {
        return MODEL_NAME;
    }

    protected String[] hyperNames() {
        return HYPER_NAMES;
    }

    protected double[] hyperDefaults() {
        return HYPER_DEFAULTS;
    }

    protected double suggestedNextHyperValue(int h, Model m, double[] hyperLimits) {
        throw H2O.unimpl();
    }

    protected GBM createBuilder(GBMModel.GBMParameters params) {
        return new GBM(params);
    }

    @Override
    protected GBMModel.GBMParameters applyHypers(GBMModel.GBMParameters parms, double[] hypers) {
        GBMModel.GBMParameters p = super.applyHypers(parms, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        p._distribution = Distribution.Family.values()[(int)hypers[slen + 0]];
        p._learn_rate = (float)hypers[slen + 1];
        return p;
    }

    public double[] getHypers(GBMModel.GBMParameters params) {
        double[] hypers = new double[HYPER_NAMES.length];
        super.getHypers(params, hypers);
        int slen = SharedTreeGrid.HYPER_NAMES.length;
        hypers[slen + 0] = params._distribution.ordinal();
        hypers[slen + 1] = params._learn_rate;
        return hypers;
    }

    private GBMGrid(Key key, Frame fr) {
        super(key, fr);
    }

    public static GBMGrid get(Frame fr) {
        Key k = Grid.keyName((String)MODEL_NAME, (Frame)fr);
        GBMGrid kmg = (GBMGrid)DKV.getGet((Key)k);
        if (kmg != null) {
            return kmg;
        }
        kmg = new GBMGrid(k, fr);
        DKV.put((Keyed)kmg);
        return kmg;
    }

    public GBMGrid() {
        super(null, null);
    }
}

