/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.deeplearning.Storage;
import java.util.Arrays;
import java.util.Random;
import water.util.RandomUtils;

public class Dropout {
    private transient Random _rand;
    private transient byte[] _bits;
    private transient double _rate;

    public byte[] bits() {
        return this._bits;
    }

    public String toString() {
        String s = "Dropout: " + super.toString();
        s = s + "\nRandom: " + this._rand.toString();
        s = s + "\nDropout rate: " + this._rate;
        s = s + "\nbits: ";
        for (int i = 0; i < this._bits.length * 8; ++i) {
            s = s + (this.unit_active(i) ? "1" : "0");
        }
        s = s + "\n";
        return s;
    }

    Dropout(int units) {
        this._bits = new byte[(units + 7) / 8];
        this._rand = RandomUtils.getRNG((long[])new long[]{0L});
        this._rate = 0.5;
    }

    Dropout(int units, double rate) {
        this(units);
        this._rate = rate;
    }

    public void randomlySparsifyActivation(Storage.Vector a, long seed) {
        if (!(a instanceof Storage.DenseVector)) {
            throw new UnsupportedOperationException("randomlySparsifyActivation not implemented for this type: " + a.getClass().getSimpleName());
        }
        this.randomlySparsifyActivation((Storage.DenseVector)a, seed);
    }

    private void randomlySparsifyActivation(Storage.DenseVector a, long seed) {
        if (this._rate == 0.0) {
            return;
        }
        this.setSeed(seed);
        for (int i = 0; i < a.size(); ++i) {
            if (!((double)this._rand.nextFloat() < this._rate)) continue;
            a.set(i, 0.0);
        }
    }

    public void fillBytes(long seed) {
        this.setSeed(seed);
        if (this._rate == 0.5) {
            this._rand.nextBytes(this._bits);
        } else {
            Arrays.fill(this._bits, (byte)0);
            for (int i = 0; i < this._bits.length * 8; ++i) {
                if (!((double)this._rand.nextFloat() > this._rate)) continue;
                int n = i / 8;
                this._bits[n] = (byte)(this._bits[n] | 1 << i % 8);
            }
        }
    }

    public boolean unit_active(int o) {
        return (this._bits[o / 8] & 1 << o % 8) != 0;
    }

    private void setSeed(long seed) {
        if (seed >>> 32 < 65535L) {
            seed |= 0x5B93000000000000L;
        }
        if (seed << 32 >>> 32 < 65535L) {
            seed |= 0xDB910000L;
        }
        this._rand.setSeed(seed);
    }
}

