/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.deepwater.DeepWater;
import hex.deepwater.DeepWaterParameters;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.schemas3.ModelParametersSchemaV3;

public class DeepWaterV3
extends ModelBuilderSchema<DeepWater, DeepWaterV3, DeepWaterParametersV3> {

    public static final class DeepWaterParametersV3
    extends ModelParametersSchemaV3<DeepWaterParameters, DeepWaterParametersV3> {
        public static String[] fields = new String[]{"model_id", "checkpoint", "autoencoder", "training_frame", "validation_frame", "nfolds", "balance_classes", "max_after_balance_size", "class_sampling_factors", "keep_cross_validation_predictions", "keep_cross_validation_fold_assignment", "fold_assignment", "fold_column", "response_column", "offset_column", "weights_column", "ignored_columns", "score_each_iteration", "categorical_encoding", "overwrite_with_best_model", "epochs", "train_samples_per_iteration", "target_ratio_comm_to_comp", "seed", "standardize", "learning_rate", "learning_rate_annealing", "momentum_start", "momentum_ramp", "momentum_stable", "distribution", "score_interval", "score_training_samples", "score_validation_samples", "score_duty_cycle", "stopping_rounds", "stopping_metric", "stopping_tolerance", "max_runtime_secs", "ignore_const_cols", "shuffle_training_data", "mini_batch_size", "clip_gradient", "network", "backend", "image_shape", "channels", "sparse", "gpu", "device_id", "network_definition_file", "network_parameters_file", "mean_image_file", "export_native_parameters_prefix", "activation", "hidden", "input_dropout_ratio", "hidden_dropout_ratios", "problem_type"};
        @API(level=API.Level.critical, direction=API.Direction.INOUT, values={"auto", "image", "text", "dataset"}, help="Problem type, auto-detected by default. If set to image, the H2OFrame must contain a string column containing the path (URI or URL) to the images in the first column. If set to text, the H2OFrame must contain a string column containing the text in the first column. If set to dataset, Deep Water behaves just like any other H2O Model and builds a model on the provided H2OFrame (non-String columns).")
        public DeepWaterParameters.ProblemType problem_type;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, values={"Rectifier", "Tanh"}, help="Activation function. Only used if no user-defined network architecture file is provided, and only for problem_type=dataset.")
        public DeepWaterParameters.Activation activation;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="Hidden layer sizes (e.g. [200, 200]). Only used if no user-defined network architecture file is provided, and only for problem_type=dataset.")
        public int[] hidden;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Input layer dropout ratio (can improve generalization, try 0.1 or 0.2).")
        public double input_dropout_ratio;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5.")
        public double[] hidden_dropout_ratios;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=false, help="Maximum size (# classes) for confusion matrices to be printed in the Logs.")
        public int max_confusion_matrix_size;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Sparse data handling (more efficient for data with lots of 0 values).")
        public boolean sparse;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=false, help="Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable).")
        public int max_hit_ratio_k;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="How many times the dataset should be iterated (streamed), can be fractional.")
        public double epochs;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic.")
        public long train_samples_per_iteration;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration = -2 (auto-tuning).")
        public double target_ratio_comm_to_comp;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded.")
        public long seed;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Learning rate (higher => less stable, lower => slower convergence).")
        public double learning_rate;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Learning rate annealing: rate / (1 + rate_annealing * samples).")
        public double learning_rate_annealing;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Initial momentum at the beginning of training (try 0.5).")
        public double momentum_start;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Number of training samples for which momentum increases.")
        public double momentum_ramp;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Final momentum after the ramp is over (try 0.99).")
        public double momentum_stable;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Shortest time interval (in seconds) between model scoring.")
        public double score_interval;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of training set samples for scoring (0 for all).")
        public long score_training_samples;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of validation set samples for scoring (0 for all).")
        public long score_validation_samples;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).")
        public double score_duty_cycle;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Enable quiet mode for less output to standard output.")
        public boolean quiet_mode;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="If enabled, override the final model with the best model found during training.")
        public boolean overwrite_with_best_model;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Auto-Encoder.")
        public boolean autoencoder;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Enable diagnostics for hidden layers.")
        public boolean diagnostics;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, help="Compute variable importances for input features (Gedeon method) - can be slow for large networks.")
        public boolean variable_importances;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Replicate the entire training dataset onto every node for faster training on small datasets.")
        public boolean replicate_training_data;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Run on a single node for fine-tuning of model parameters.")
        public boolean single_node_mode;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Enable global shuffling of training data.")
        public boolean shuffle_training_data;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Mini-batch size (smaller leads to better fit, larger can speed up and generalize better).")
        public int mini_batch_size;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Clip gradients once their absolute value is larger than this value.")
        public double clip_gradient;
        @API(level=API.Level.critical, direction=API.Direction.INOUT, gridable=true, values={"auto", "user", "lenet", "alexnet", "vgg", "googlenet", "inception_bn", "resnet"}, help="Network architecture.")
        public DeepWaterParameters.Network network;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, values={"auto", "mxnet", "caffe", "tensorflow"}, help="Deep Learning Backend.")
        public DeepWaterParameters.Backend backend;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Width and height of image.")
        public int[] image_shape;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Number of (color) channels.")
        public int channels;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Whether to use a GPU (if available).")
        public boolean gpu;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, help="Device IDs (which GPUs to use).")
        public int[] device_id;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Path of file containing network definition (graph, architecture).")
        public String network_definition_file;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Path of file containing network (initial) parameters (weights, biases).")
        public String network_parameters_file;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Path of file containing the mean image data for data normalization.")
        public String mean_image_file;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, help="Path (prefix) where to export the native model parameters after every iteration.")
        public String export_native_parameters_prefix;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="If enabled, automatically standardize the data. If disabled, the user must provide properly scaled input data.")
        public boolean standardize;
        @API(level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true, help="Balance training data class counts via over/under-sampling (for imbalanced data).")
        public boolean balance_classes;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=true, help="Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes.")
        public float[] class_sampling_factors;
        @API(level=API.Level.expert, direction=API.Direction.INOUT, gridable=false, help="Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes.")
        public float max_after_balance_size;
    }
}

