/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.FrameTask;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.gram.Gram;
import hex.svd.SVDModel;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class SVD
extends ModelBuilder<SVDModel, SVDModel.SVDParameters, SVDModel.SVDOutput> {
    private final double TOLERANCE = 1.0E-6;
    private final int MAX_COLS_EXPANDED = 5000;
    private transient int _ncolExp;

    protected SVDDriver trainModelImpl() {
        return new SVDDriver();
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.DimReduction};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public SVD(SVDModel.SVDParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public SVD(SVDModel.SVDParameters parms, Job job) {
        super((Model.Parameters)parms, job);
        this.init(false);
    }

    public SVD(boolean startup_once) {
        super((Model.Parameters)new SVDModel.SVDParameters(), startup_once);
    }

    protected void checkMemoryFootPrint() {
        long max_mem;
        HeartBeat hb = H2O.SELF._heartbeat;
        double p = LinearAlgebraUtils.numColsExp(this._train, true);
        long mem_usage = ((SVDModel.SVDParameters)this._parms)._svd_method == SVDModel.SVDParameters.Method.GramSVD ? (long)((double)hb._cpus_allowed * p * p * 8.0 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)) : 1L;
        if (mem_usage > (max_mem = hb.get_free_mem())) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
        }
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((SVDModel.SVDParameters)this._parms)._max_iterations < 1) {
            this.error("_max_iterations", "max_iterations must be at least 1");
        }
        if (this._train == null) {
            return;
        }
        this._ncolExp = LinearAlgebraUtils.numColsExp(this._train, ((SVDModel.SVDParameters)this._parms)._use_all_factor_levels);
        if (this._ncolExp > 5000) {
            this.warn("_train", "_train has " + this._ncolExp + " columns when categoricals are expanded. Algorithm may be slow.");
        }
        if (((SVDModel.SVDParameters)this._parms)._nv < 1 || ((SVDModel.SVDParameters)this._parms)._nv > this._ncolExp) {
            this.error("_nv", "Number of right singular values must be between 1 and " + this._ncolExp);
        }
        if (((SVDModel.SVDParameters)this._parms)._svd_method != SVDModel.SVDParameters.Method.Randomized && expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    public static double[][] updateIVVSum(double[][] ivv_sum, double[] vec) {
        for (int i = 0; i < vec.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double diff;
                double d = diff = ivv_sum[i][j] - vec[i] * vec[j];
                ivv_sum[j][i] = d;
                ivv_sum[i][j] = d;
            }
            double[] dArray = ivv_sum[i];
            int n = i;
            dArray[n] = dArray[n] - vec[i] * vec[i];
        }
        return ivv_sum;
    }

    private TwoDimTable createModelSummaryTable(SVDModel.SVDOutput output) {
        if (null == output._d) {
            return null;
        }
        Object[] colTypes = new String[((SVDModel.SVDParameters)this._parms)._nv];
        Object[] colFormats = new String[((SVDModel.SVDParameters)this._parms)._nv];
        String[] colHeaders = new String[((SVDModel.SVDParameters)this._parms)._nv];
        Arrays.fill(colTypes, "double");
        Arrays.fill(colFormats, "%5f");
        for (int i = 0; i < colHeaders.length; ++i) {
            colHeaders[i] = "sval" + String.valueOf(i + 1);
        }
        return new TwoDimTable("Singular values", null, new String[1], colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[1][], (double[][])new double[][]{output._d});
    }

    private static class RandSubInit
    extends FrameTask<RandSubInit> {
        final double[][] _gaus;

        public RandSubInit(Key<Job> jobKey, DataInfo dinfo, double[][] gaus) {
            super(jobKey, dinfo);
            this._gaus = gaus;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row row, NewChunk[] outputs) {
            for (int k = 0; k < this._gaus.length; ++k) {
                double y = row.innerProduct(this._gaus[k]);
                outputs[k].addNum(y);
            }
        }
    }

    private static class DivideU
    extends MRTask<DivideU> {
        final double[] _sigma;

        public DivideU(double[] sigma) {
            this._sigma = sigma;
        }

        public void map(Chunk[] cs) {
            assert (this._sigma.length == cs.length);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[0].len(); ++row) {
                    double x = cs[col].atd(row);
                    cs[col].set(row, x / this._sigma[col]);
                }
            }
        }
    }

    private static class GramUpdate
    extends FrameTask<GramUpdate> {
        final double[][] _ivv;
        public Gram _gram;
        public long _nobs;
        private transient DataInfo.Row _numRow;

        public GramUpdate(Key<Job> jobKey, DataInfo dinfo, double[][] ivv) {
            super(jobKey, dinfo);
            assert (null != ivv && ivv.length == ivv[0].length);
            this._ivv = ivv;
        }

        @Override
        protected boolean chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), 0, this._ivv.length, 0, false);
            this._numRow = this._dinfo.newDenseRow(MemoryManager.malloc8d((int)this._ivv.length), 0L);
            return true;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row r) {
            double w = 1.0;
            double[] nums = this._numRow.numVals;
            for (int row = 0; row < this._ivv.length; ++row) {
                nums[row] = r.innerProduct(this._ivv[row]);
            }
            this._gram.addRow(this._numRow, w);
            ++this._nobs;
        }

        @Override
        protected void chunkDone(long n) {
            double r = 1.0 / (double)this._nobs;
            this._gram.mul(r);
        }

        public void reduce(GramUpdate gt) {
            double r1 = (double)this._nobs / (double)(this._nobs + gt._nobs);
            this._gram.mul(r1);
            double r2 = (double)gt._nobs / (double)(this._nobs + gt._nobs);
            gt._gram.mul(r2);
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    private static class CalcSigmaU
    extends FrameTask<CalcSigmaU> {
        final double[] _svec;
        public double _sval;
        public long _nobs;

        public CalcSigmaU(Key<Job> jobKey, DataInfo dinfo, double[] svec) {
            super(jobKey, dinfo);
            this._svec = svec;
            this._sval = 0.0;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row r, NewChunk[] outputs) {
            double num = r.innerProduct(this._svec);
            outputs[0].addNum(num);
            this._sval += num * num;
            ++this._nobs;
        }

        public void reduce(CalcSigmaU other) {
            this._nobs += other._nobs;
            this._sval += other._sval;
        }

        protected void postGlobal() {
            this._sval = Math.sqrt(this._sval);
        }
    }

    class SVDDriver
    extends ModelBuilder.Driver {
        SVDModel _model;

        SVDDriver() {
            super((ModelBuilder)SVD.this);
        }

        private double[] powerLoop(Gram gram, long seed) {
            return this.powerLoop(gram, ArrayUtils.gaussianVector((int)gram.fullN(), (long)seed));
        }

        private double[] powerLoop(Gram gram, double[] vinit) {
            assert (vinit.length == gram.fullN());
            double err = 2.0E-6;
            double[] v = (double[])vinit.clone();
            double[] vnew = new double[v.length];
            for (int iters = 0; iters < ((SVDModel.SVDParameters)SVD.this._parms)._max_iterations && err > 1.0E-6; ++iters) {
                gram.mul(v, vnew);
                double norm = ArrayUtils.l2norm((double[])vnew);
                err = 0.0;
                for (int i = 0; i < v.length; ++i) {
                    int n = i;
                    vnew[n] = vnew[n] / norm;
                    double diff = v[i] - vnew[i];
                    err += diff * diff;
                    v[i] = vnew[i];
                }
                err = Math.sqrt(err);
            }
            return v;
        }

        private double computeSigmaU(DataInfo dinfo, SVDModel model, int k, double[][] ivv_sum, Vec[] uvecs) {
            double[] ivv_vk = ArrayUtils.multArrVec((double[][])ivv_sum, (double[])((SVDModel.SVDOutput)model._output)._v[k]);
            CalcSigmaU ctsk = (CalcSigmaU)new CalcSigmaU((Key<Job>)SVD.this._job._key, dinfo, ivv_vk).doAll((byte)3, dinfo._adaptedFrame);
            ((SVDModel.SVDOutput)model._output)._d[k] = ctsk._sval;
            assert (ctsk._nobs == ((SVDModel.SVDOutput)model._output)._nobs) : "Processed " + ctsk._nobs + " rows but expected " + ((SVDModel.SVDOutput)model._output)._nobs;
            Frame tmp = ctsk.outputFrame();
            uvecs[k] = tmp.vec(0);
            tmp.unlock(SVD.this._job);
            return ((SVDModel.SVDOutput)model._output)._d[k];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame randSubIterInPlace(DataInfo dinfo, SVDModel model) {
            DataInfo yinfo = null;
            Frame yqfrm = null;
            try {
                SVD.this._job.update(1L, "Initializing random subspace of training data Y");
                double[][] gt = ArrayUtils.gaussianArray((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)SVD.this._ncolExp, (long)((SVDModel.SVDParameters)SVD.this._parms)._seed);
                RandSubInit rtsk = new RandSubInit((Key<Job>)SVD.this._job._key, dinfo, gt);
                rtsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                yqfrm = rtsk.outputFrame(Key.make(), null, null);
                Frame aqfrm = new Frame(dinfo._adaptedFrame);
                aqfrm.add(yqfrm);
                SVD.this._job.update(1L, "Computing QR factorization of Y");
                yinfo = new DataInfo(yqfrm, null, true, DataInfo.TransformType.NONE, true, false, false);
                DKV.put((Key)yinfo._key, (Iced)yinfo);
                LinearAlgebraUtils.computeQInPlace((Key<Job>)SVD.this._job._key, yinfo);
                ((SVDModel.SVDOutput)model._output)._iterations = 0;
                while (((SVDModel.SVDOutput)model._output)._iterations < ((SVDModel.SVDParameters)SVD.this._parms)._max_iterations) {
                    if (SVD.this.stop_requested()) {
                        break;
                    }
                    SVD.this._job.update(1L, "Iteration " + String.valueOf(((SVDModel.SVDOutput)model._output)._iterations + 1) + " of randomized subspace iteration");
                    LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                    stsk.doAll(aqfrm);
                    Matrix ysmall = new Matrix(stsk._atq);
                    QRDecomposition ysmall_qr = new QRDecomposition(ysmall);
                    double[][] qtilde = ysmall_qr.getQ().getArray();
                    LinearAlgebraUtils.BMulInPlaceTask tsk = new LinearAlgebraUtils.BMulInPlaceTask(dinfo, ArrayUtils.transpose((double[][])qtilde));
                    tsk.doAll(aqfrm);
                    LinearAlgebraUtils.computeQInPlace((Key<Job>)SVD.this._job._key, yinfo);
                    ++((SVDModel.SVDOutput)model._output)._iterations;
                    model.update(SVD.this._job);
                }
            }
            finally {
                if (yinfo != null) {
                    yinfo.remove();
                }
            }
            return yqfrm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame randSubIter(DataInfo dinfo, SVDModel model) {
            DataInfo yinfo = null;
            Frame ybig = null;
            Frame qfrm = null;
            int ncolA = dinfo._adaptedFrame.numCols();
            try {
                SVD.this._job.update(1L, "Initializing random subspace of training data Y");
                double[][] gt = ArrayUtils.gaussianArray((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)SVD.this._ncolExp, (long)((SVDModel.SVDParameters)SVD.this._parms)._seed);
                RandSubInit rtsk = new RandSubInit((Key<Job>)SVD.this._job._key, dinfo, gt);
                rtsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                ybig = rtsk.outputFrame(Key.make(), null, null);
                Frame ayqfrm = new Frame(dinfo._adaptedFrame);
                ayqfrm.add(ybig);
                for (int i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                    ayqfrm.add("qcol_" + i, ayqfrm.anyVec().makeZero());
                }
                Frame ayfrm = ayqfrm.subframe(0, ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                Frame yqfrm = ayqfrm.subframe(ncolA, ayqfrm.numCols());
                Frame aqfrm = ayqfrm.subframe(0, ncolA);
                aqfrm.add(ayqfrm.subframe(ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv, ayqfrm.numCols()));
                SVD.this._job.update(1L, "Computing QR factorization of Y");
                yinfo = new DataInfo(ybig, null, true, DataInfo.TransformType.NONE, true, false, false);
                DKV.put((Key)yinfo._key, (Iced)yinfo);
                LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, yinfo, yqfrm);
                ((SVDModel.SVDOutput)model._output)._iterations = 0;
                long qobs = dinfo._adaptedFrame.numRows() * (long)((SVDModel.SVDParameters)SVD.this._parms)._nv;
                double qerr = 2.0E-6 * (double)qobs;
                while ((((SVDModel.SVDOutput)model._output)._iterations < 10 || qerr / (double)qobs > 1.0E-6) && ((SVDModel.SVDOutput)model._output)._iterations < ((SVDModel.SVDParameters)SVD.this._parms)._max_iterations && !SVD.this.stop_requested()) {
                    SVD.this._job.update(1L, "Iteration " + String.valueOf(((SVDModel.SVDOutput)model._output)._iterations + 1) + " of randomized subspace iteration");
                    LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                    stsk.doAll(aqfrm);
                    Matrix ysmall = new Matrix(stsk._atq);
                    QRDecomposition ysmall_qr = new QRDecomposition(ysmall);
                    double[][] ysmall_q = ysmall_qr.getQ().getArray();
                    LinearAlgebraUtils.BMulInPlaceTask tsk = new LinearAlgebraUtils.BMulInPlaceTask(dinfo, ArrayUtils.transpose((double[][])ysmall_q));
                    tsk.doAll(ayfrm);
                    qerr = LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, yinfo, yqfrm);
                    ++((SVDModel.SVDOutput)model._output)._iterations;
                    model.update(SVD.this._job);
                }
                qfrm = ayqfrm.extractFrame(ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv, ayqfrm.numCols());
                qfrm = new Frame(Key.make(), qfrm.names(), qfrm.vecs());
                DKV.put((Keyed)qfrm);
            }
            finally {
                if (yinfo != null) {
                    yinfo.remove();
                }
                if (ybig != null) {
                    ybig.delete();
                }
            }
            return qfrm;
        }

        private Frame directSVD(DataInfo dinfo, Frame qfrm, SVDModel model) {
            String u_name = ((SVDModel.SVDParameters)SVD.this._parms)._u_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._u_name.length() == 0 ? "SVDUMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._u_name;
            return this.directSVD(dinfo, qfrm, model, u_name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame directSVD(DataInfo dinfo, Frame qfrm, SVDModel model, String u_name) {
            DataInfo qinfo = null;
            Frame u = null;
            int ncolA = dinfo._adaptedFrame.numCols();
            try {
                int i;
                Vec[] vecs = new Vec[ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv];
                for (i = 0; i < ncolA; ++i) {
                    vecs[i] = dinfo._adaptedFrame.vec(i);
                }
                for (i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                    vecs[ncolA + i] = qfrm.vec(i);
                }
                Frame aqfrm = new Frame(vecs);
                SVD.this._job.update(1L, "Forming small matrix B = Q'A for direct SVD");
                LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                stsk.doAll(aqfrm);
                SVD.this._job.update(1L, "Calculating SVD of small matrix locally");
                Matrix atqJ = new Matrix(stsk._atq);
                SingularValueDecomposition svdJ = atqJ.svd();
                SVD.this._job.update(1L, "Forming distributed orthonormal matrix U");
                if (((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                    ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
                    double[][] svdJ_u = svdJ.getV().getMatrix(0, atqJ.getColumnDimension() - 1, 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1).getArray();
                    qinfo = new DataInfo(qfrm, null, true, DataInfo.TransformType.NONE, false, false, false);
                    DKV.put((Key)qinfo._key, (Iced)qinfo);
                    LinearAlgebraUtils.BMulTask btsk = new LinearAlgebraUtils.BMulTask((Key<Job>)SVD.this._job._key, qinfo, ArrayUtils.transpose((double[][])svdJ_u));
                    btsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, qinfo._adaptedFrame);
                    u = btsk.outputFrame(((SVDModel.SVDOutput)model._output)._u_key, null, null);
                }
                ((SVDModel.SVDOutput)model._output)._d = Arrays.copyOfRange(svdJ.getSingularValues(), 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                ((SVDModel.SVDOutput)model._output)._v = svdJ.getU().getMatrix(0, atqJ.getRowDimension() - 1, 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1).getArray();
            }
            finally {
                if (qinfo != null) {
                    qinfo.remove();
                }
            }
            return u;
        }

        public void computeImpl() {
            Frame qfrm;
            Frame u;
            DataInfo dinfo;
            SVDModel model;
            block48: {
                model = null;
                dinfo = null;
                u = null;
                qfrm = null;
                Vec[] uvecs = null;
                try {
                    Gram gram;
                    Gram.GramTask gtsk;
                    String v_name;
                    SVD.this.init(true);
                    if (SVD.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + SVD.this.validationErrors());
                    }
                    model = new SVDModel((Key<SVDModel>)SVD.this.dest(), (SVDModel.SVDParameters)SVD.this._parms, new SVDModel.SVDOutput(SVD.this));
                    model.delete_and_lock(SVD.this._job);
                    dinfo = new DataInfo(SVD.this._train, SVD.this._valid, 0, ((SVDModel.SVDParameters)SVD.this._parms)._use_all_factor_levels, ((SVDModel.SVDParameters)SVD.this._parms)._transform, DataInfo.TransformType.NONE, !((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, ((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, false, false, false, false, false);
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    double[] dArray = ((SVDModel.SVDOutput)model._output)._normSub = dinfo._normSub == null ? new double[dinfo._nums] : dinfo._normSub;
                    if (dinfo._normMul == null) {
                        ((SVDModel.SVDOutput)model._output)._normMul = new double[dinfo._nums];
                        Arrays.fill(((SVDModel.SVDOutput)model._output)._normMul, 1.0);
                    } else {
                        ((SVDModel.SVDOutput)model._output)._normMul = dinfo._normMul;
                    }
                    ((SVDModel.SVDOutput)model._output)._permutation = dinfo._permutation;
                    ((SVDModel.SVDOutput)model._output)._nnums = dinfo._nums;
                    ((SVDModel.SVDOutput)model._output)._ncats = dinfo._cats;
                    ((SVDModel.SVDOutput)model._output)._catOffsets = dinfo._catOffsets;
                    ((SVDModel.SVDOutput)model._output)._names_expanded = dinfo.coefNames();
                    String u_name = ((SVDModel.SVDParameters)SVD.this._parms)._u_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._u_name.length() == 0 ? "SVDUMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._u_name;
                    String string = v_name = ((SVDModel.SVDParameters)SVD.this._parms)._v_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._v_name.length() == 0 ? "SVDVMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._v_name;
                    if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.GramSVD) {
                        SVD.this._job.update(1L, "Begin distributed calculation of Gram matrix");
                        gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)SVD.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                        gram = gtsk._gram;
                        assert (gram.fullN() == SVD.this._ncolExp);
                        ((SVDModel.SVDOutput)model._output)._nobs = gtsk._nobs;
                        ((SVDModel.SVDOutput)model._output)._total_variance = gram.diagSum() * (double)gtsk._nobs / (double)(gtsk._nobs - 1L);
                        model.update(SVD.this._job);
                        if (gtsk._nobs == 0L) {
                            SVD.this.error("_train", "Every row in _train contains at least one missing value. Consider setting impute_missing = TRUE.");
                        }
                        if (SVD.this.error_count() > 0) {
                            throw new IllegalArgumentException("Found validation errors: " + SVD.this.validationErrors());
                        }
                        SVD.this._job.update(1L, "Calculating SVD of Gram matrix locally");
                        Matrix gramJ = new Matrix(gtsk._gram.getXX());
                        SingularValueDecomposition svdJ = gramJ.svd();
                        SVD.this._job.update(1L, "Computing stats from SVD");
                        double[] sval = svdJ.getSingularValues();
                        ((SVDModel.SVDOutput)model._output)._d = new double[((SVDModel.SVDParameters)SVD.this._parms)._nv];
                        for (int k = 0; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++k) {
                            ((SVDModel.SVDOutput)model._output)._d[k] = Math.sqrt(sval[k] * (double)((SVDModel.SVDOutput)model._output)._nobs);
                        }
                        double[][] v = svdJ.getV().getArray();
                        assert (v.length == SVD.this._ncolExp && LinearAlgebraUtils.numColsExp(dinfo._adaptedFrame, ((SVDModel.SVDParameters)SVD.this._parms)._use_all_factor_levels) == SVD.this._ncolExp);
                        ((SVDModel.SVDOutput)model._output)._v = new double[SVD.this._ncolExp][((SVDModel.SVDParameters)SVD.this._parms)._nv];
                        for (int i = 0; i < v.length; ++i) {
                            System.arraycopy(v[i], 0, ((SVDModel.SVDOutput)model._output)._v[i], 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        }
                        if (((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                            ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
                            double[][] vt = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v);
                            for (int k = 0; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++k) {
                                ArrayUtils.div((double[])vt[k], (double)((SVDModel.SVDOutput)model._output)._d[k]);
                            }
                            LinearAlgebraUtils.BMulTask tsk = (LinearAlgebraUtils.BMulTask)new LinearAlgebraUtils.BMulTask((Key<Job>)SVD.this._job._key, dinfo, vt).doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                            u = tsk.outputFrame(((SVDModel.SVDOutput)model._output)._u_key, null, null);
                        }
                    } else if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.Power) {
                        SVD.this._job.update(1L, "Begin distributed calculation of Gram matrix");
                        gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)SVD.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                        gram = gtsk._gram;
                        assert (gram.fullN() == SVD.this._ncolExp);
                        ((SVDModel.SVDOutput)model._output)._nobs = gtsk._nobs;
                        ((SVDModel.SVDOutput)model._output)._total_variance = gram.diagSum() * (double)gtsk._nobs / (double)(gtsk._nobs - 1L);
                        model.update(SVD.this._job);
                        SVD.this._job.update(1L, "Iteration 1 of power method");
                        ((SVDModel.SVDOutput)model._output)._v = new double[((SVDModel.SVDParameters)SVD.this._parms)._nv][SVD.this._ncolExp];
                        ((SVDModel.SVDOutput)model._output)._v[0] = this.powerLoop(gram, ((SVDModel.SVDParameters)SVD.this._parms)._seed);
                        double[][] ivv_sum = new double[SVD.this._ncolExp][SVD.this._ncolExp];
                        for (int i = 0; i < SVD.this._ncolExp; ++i) {
                            ivv_sum[i][i] = 1.0;
                        }
                        if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v) {
                            ((SVDModel.SVDOutput)model._output)._d = new double[((SVDModel.SVDParameters)SVD.this._parms)._nv];
                            ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
                            uvecs = new Vec[((SVDModel.SVDParameters)SVD.this._parms)._nv];
                            this.computeSigmaU(dinfo, model, 0, ivv_sum, uvecs);
                        }
                        ((SVDModel.SVDOutput)model._output)._iterations = 1;
                        model.update(SVD.this._job);
                        SVD.updateIVVSum(ivv_sum, ((SVDModel.SVDOutput)model._output)._v[0]);
                        GramUpdate guptsk = (GramUpdate)new GramUpdate((Key<Job>)SVD.this._job._key, dinfo, ivv_sum).doAll(dinfo._adaptedFrame);
                        Gram gram_update = guptsk._gram;
                        for (int k = 1; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv && !SVD.this.stop_requested(); ++k) {
                            SVD.this._job.update(1L, "Iteration " + String.valueOf(k + 1) + " of power method");
                            ((SVDModel.SVDOutput)model._output)._v[k] = this.powerLoop(gram_update, ((SVDModel.SVDParameters)SVD.this._parms)._seed);
                            if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v) {
                                this.computeSigmaU(dinfo, model, k, ivv_sum, uvecs);
                            }
                            SVD.updateIVVSum(ivv_sum, ((SVDModel.SVDOutput)model._output)._v[k]);
                            guptsk = (GramUpdate)new GramUpdate((Key<Job>)SVD.this._job._key, dinfo, ivv_sum).doAll(dinfo._adaptedFrame);
                            gram_update = guptsk._gram;
                            ++((SVDModel.SVDOutput)model._output)._iterations;
                            model.update(SVD.this._job);
                        }
                        ((SVDModel.SVDOutput)model._output)._v = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v);
                        if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                            for (Vec uvec : uvecs) {
                                uvec.remove();
                            }
                            ((SVDModel.SVDOutput)model._output)._u_key = null;
                        } else if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && ((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                            u = new Frame(((SVDModel.SVDOutput)model._output)._u_key, null, uvecs);
                            DKV.put((Key)u._key, (Iced)u);
                            DivideU utsk = new DivideU(((SVDModel.SVDOutput)model._output)._d);
                            utsk.doAll(u);
                        }
                    } else if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.Randomized) {
                        qfrm = this.randSubIter(dinfo, model);
                        u = this.directSVD(dinfo, qfrm, model, u_name);
                    } else {
                        SVD.this.error("_svd_method", "Unrecognized SVD method " + (Object)((Object)((SVDModel.SVDParameters)SVD.this._parms)._svd_method));
                    }
                    if (((SVDModel.SVDParameters)SVD.this._parms)._save_v_frame) {
                        ((SVDModel.SVDOutput)model._output)._v_key = Key.make((String)v_name);
                        ArrayUtils.frame(((SVDModel.SVDOutput)model._output)._v_key, null, (double[][])((SVDModel.SVDOutput)model._output)._v);
                    }
                    ((SVDModel.SVDOutput)model._output)._model_summary = SVD.this.createModelSummaryTable((SVDModel.SVDOutput)model._output);
                    model.update(SVD.this._job);
                    if (model == null) break block48;
                }
                catch (Throwable t) {
                    try {
                        t.printStackTrace();
                        throw t;
                    }
                    catch (Throwable throwable) {
                        if (model != null) {
                            model.unlock(SVD.this._job);
                        }
                        if (dinfo != null) {
                            dinfo.remove();
                        }
                        if (u != null & !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                            u.delete();
                        }
                        if (qfrm != null) {
                            qfrm.delete();
                        }
                        ArrayList<Key> keep = new ArrayList<Key>();
                        if (model._output != null) {
                            Frame vFrm;
                            Frame uFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._u_key);
                            if (uFrm != null) {
                                for (Vec vec : uFrm.vecs()) {
                                    keep.add(vec._key);
                                }
                            }
                            if ((vFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._v_key)) != null) {
                                for (Vec vec : vFrm.vecs()) {
                                    keep.add(vec._key);
                                }
                            }
                        }
                        Scope.untrack(keep);
                        throw throwable;
                    }
                }
                model.unlock(SVD.this._job);
            }
            if (dinfo != null) {
                dinfo.remove();
            }
            if (u != null & !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                u.delete();
            }
            if (qfrm != null) {
                qfrm.delete();
            }
            ArrayList<Key> keep = new ArrayList<Key>();
            if (model._output != null) {
                Frame vFrm;
                Frame uFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._u_key);
                if (uFrm != null) {
                    for (Vec vec : uFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
                if ((vFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._v_key)) != null) {
                    for (Vec vec : vFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
            }
            Scope.untrack(keep);
        }
    }
}

