/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import com.google.common.util.concurrent.AtomicDouble;
import hex.tree.DTree;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTreeModel;
import java.util.Arrays;
import java.util.Random;
import sun.misc.Unsafe;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.IcedBitSet;
import water.util.MathUtils;
import water.util.RandomUtils;

public final class DHistogram
extends Iced {
    public final transient String _name;
    public final double _minSplitImprovement;
    public final byte _isInt;
    public char _nbin;
    public double _step;
    public final double _min;
    public final double _maxEx;
    public double[] _w;
    private double[] _wY;
    private double[] _wYY;
    private AtomicDouble _wNA;
    private AtomicDouble _wYNA;
    private AtomicDouble _wYYNA;
    protected double _min2;
    protected double _maxIn;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _min2Offset;
    private static final long _max2Offset;
    public SharedTreeModel.SharedTreeParameters.HistogramType _histoType;
    public transient double[] _splitPts;
    public final long _seed;
    public transient boolean _hasQuantiles;
    public Key _globalQuantilesKey;

    public static int[] activeColumns(DHistogram[] hist) {
        int[] cols = new int[hist.length];
        int len = 0;
        for (int i = 0; i < hist.length; ++i) {
            if (hist[i] == null) continue;
            assert (hist[i]._min < hist[i]._maxEx && hist[i].nbins() > 1) : "broken histo range " + (Object)((Object)hist[i]);
            cols[len++] = i;
        }
        return cols;
    }

    public void setMin(double min) {
        long imin = Double.doubleToRawLongBits(min);
        double old = this._min2;
        while (min < old && !_unsafe.compareAndSwapLong((Object)this, _min2Offset, Double.doubleToRawLongBits(old), imin)) {
            old = this._min2;
        }
    }

    public void setMaxIn(double max) {
        long imax = Double.doubleToRawLongBits(max);
        double old = this._maxIn;
        while (max > old && !_unsafe.compareAndSwapLong((Object)this, _max2Offset, Double.doubleToRawLongBits(old), imax)) {
            old = this._maxIn;
        }
    }

    public DHistogram(String name, int nbins, int nbins_cats, byte isInt, double min, double maxEx, double minSplitImprovement, SharedTreeModel.SharedTreeParameters.HistogramType histogramType, long seed, Key globalQuantilesKey) {
        int xbins;
        assert (nbins > 1);
        assert (nbins_cats > 1);
        assert (maxEx > min) : "Caller ensures " + maxEx + ">" + min + ", since if max==min== the column " + name + " is all constants";
        this._isInt = isInt;
        this._name = name;
        this._min = min;
        this._maxEx = maxEx;
        this._min2 = Double.MAX_VALUE;
        this._maxIn = -1.7976931348623157E308;
        this._minSplitImprovement = minSplitImprovement;
        this._histoType = histogramType;
        this._seed = seed;
        while (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin) {
            SharedTreeModel.SharedTreeParameters.HistogramType[] h = SharedTreeModel.SharedTreeParameters.HistogramType.values();
            this._histoType = h[(int)Math.abs(seed++ % (long)h.length)];
        }
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.AUTO) {
            this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
        }
        assert (this._histoType != SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin);
        this._globalQuantilesKey = globalQuantilesKey;
        int n = xbins = isInt == 2 ? nbins_cats : nbins;
        if (isInt > 0 && maxEx - min <= (double)xbins) {
            assert ((double)((long)min) == min) : "Overflow for integer/categorical histogram: minimum value cannot be cast to long without loss: (long)" + min + " != " + min + "!";
            xbins = (char)((long)maxEx - (long)min);
            this._step = 1.0;
        } else {
            this._step = (double)xbins / (maxEx - min);
            assert (this._step > 0.0 && !Double.isInfinite(this._step)) : "Histogram step size for column '" + name + "' is invalid: " + this._step + ".";
        }
        this._nbin = (char)xbins;
        assert (this._nbin > '\u0000');
        assert (this._w == null);
        assert (this._wY == null);
        assert (this._wYY == null);
    }

    public int bin(double col_data) {
        int idx1;
        double pos;
        assert (!Double.isNaN(col_data));
        if (Double.isInfinite(col_data)) {
            if (col_data < 0.0) {
                return 0;
            }
            return this._w.length - 1;
        }
        assert (this._min <= col_data && col_data < this._maxEx) : "Coldata " + col_data + " out of range " + (Object)((Object)this);
        double d = pos = this._hasQuantiles ? col_data : (col_data - this._min) * this._step;
        if (this._splitPts != null) {
            idx1 = Arrays.binarySearch(this._splitPts, pos);
            if (idx1 < 0) {
                idx1 = -idx1 - 2;
            }
        } else {
            idx1 = (int)pos;
        }
        if (idx1 == this._w.length) {
            --idx1;
        }
        assert (0 <= idx1 && idx1 < this._w.length) : idx1 + " " + this._w.length;
        return idx1;
    }

    public double binAt(int b) {
        if (this._hasQuantiles) {
            return this._splitPts[b];
        }
        return this._min + (this._splitPts == null ? (double)b : this._splitPts[b]) / this._step;
    }

    public int nbins() {
        return this._nbin;
    }

    public double bins(int b) {
        return this._w[b];
    }

    public void init() {
        assert (this._w == null);
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.Random) {
            Random rng = RandomUtils.getRNG((long[])new long[]{Double.doubleToRawLongBits((this._step + 0.324) * this._min + 8.3425 + 89.342 * this._maxEx) + (long)(912559 * this._nbin) + (long)(12648430 * this._isInt) + this._seed});
            assert (this._nbin > '\u0001');
            this._splitPts = new double[this._nbin];
            this._splitPts[0] = 0.0;
            this._splitPts[this._nbin - '\u0001'] = this._nbin - '\u0001';
            for (int i = 1; i < this._nbin - '\u0001'; ++i) {
                this._splitPts[i] = rng.nextFloat() * (float)(this._nbin - '\u0001');
            }
            Arrays.sort(this._splitPts);
        } else if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal) {
            HistoQuantiles hq;
            assert (this._splitPts == null);
            if (this._globalQuantilesKey != null && (hq = (HistoQuantiles)DKV.getGet((Key)this._globalQuantilesKey)) != null) {
                this._splitPts = ((HistoQuantiles)DKV.getGet((Key)this._globalQuantilesKey)).splitPts;
                if (this._splitPts != null) {
                    this._splitPts = ArrayUtils.limitToRange((double[])this._splitPts, (double)this._min, (double)this._maxEx);
                    if (this._splitPts.length > 1 && this._splitPts.length < this._nbin) {
                        this._splitPts = ArrayUtils.padUniformly((double[])this._splitPts, (int)this._nbin);
                    }
                    if (this._splitPts.length <= 1) {
                        this._splitPts = null;
                        this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
                    } else {
                        this._hasQuantiles = true;
                        this._nbin = (char)this._splitPts.length;
                    }
                }
            }
        } else assert (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive);
        assert (this._nbin > '\u0000');
        this._w = MemoryManager.malloc8d((int)this._nbin);
        this._wY = MemoryManager.malloc8d((int)this._nbin);
        this._wYY = MemoryManager.malloc8d((int)this._nbin);
        this._wNA = new AtomicDouble();
        this._wYNA = new AtomicDouble();
        this._wYYNA = new AtomicDouble();
    }

    void incr(double col_data, double y, double w) {
        if (Double.isNaN(col_data)) {
            this._wNA.addAndGet(w);
            this._wYNA.addAndGet(w * y);
            this._wYYNA.addAndGet(w * y * y);
            return;
        }
        assert (Double.isInfinite(col_data) || this._min <= col_data && col_data < this._maxEx) : "col_data " + col_data + " out of range " + (Object)((Object)this);
        int b = this.bin(col_data);
        AtomicUtils.DoubleArray.add((double[])this._w, (int)b, (double)w);
        if (!Double.isInfinite(col_data)) {
            this.setMin(col_data);
            this.setMaxIn(col_data);
        }
        if (y != 0.0 && w != 0.0) {
            this.incr0(b, y, w);
        }
    }

    public void add(DHistogram dsh) {
        assert (this._isInt == dsh._isInt && this._nbin == dsh._nbin && this._step == dsh._step && this._min == dsh._min && this._maxEx == dsh._maxEx);
        assert (this._w == null && dsh._w == null || this._w != null && dsh._w != null);
        if (this._w == null) {
            return;
        }
        ArrayUtils.add((double[])this._w, (double[])dsh._w);
        if (this._min2 > dsh._min2) {
            this._min2 = dsh._min2;
        }
        if (this._maxIn < dsh._maxIn) {
            this._maxIn = dsh._maxIn;
        }
        this.add0(dsh);
        this._wNA.addAndGet(dsh._wNA.get());
        this._wYNA.addAndGet(dsh._wYNA.get());
        this._wYYNA.addAndGet(dsh._wYYNA.get());
    }

    public double find_min() {
        return this._min2;
    }

    public double find_maxIn() {
        return this._maxIn;
    }

    public double find_maxEx() {
        return DHistogram.find_maxEx(this._maxIn, this._isInt);
    }

    public static double find_maxEx(double maxIn, int isInt) {
        double res;
        double ulp = Math.ulp(maxIn);
        if (isInt > 0 && 1.0 > ulp) {
            ulp = 1.0;
        }
        return Double.isInfinite(res = maxIn + ulp) ? maxIn : res;
    }

    public static DHistogram[] initialHist(Frame fr, int ncols, int nbins, DHistogram[] hs, long seed, SharedTreeModel.SharedTreeParameters parms, Key[] globalQuantilesKey) {
        Vec[] vecs = fr.vecs();
        for (int c = 0; c < ncols; ++c) {
            Vec v = vecs[c];
            double minIn = Math.max(v.min(), -1.7976931348623157E308);
            double maxIn = Math.min(v.max(), Double.MAX_VALUE);
            double maxEx = DHistogram.find_maxEx(maxIn, v.isInt() ? 1 : 0);
            long vlen = v.length();
            DHistogram dHistogram = v.naCnt() == vlen || v.min() == v.max() ? null : (hs[c] = DHistogram.make(fr._names[c], nbins, (byte)(v.isCategorical() ? 2 : (v.isInt() ? 1 : 0)), minIn, maxEx, seed, parms, globalQuantilesKey[c]));
            assert (hs[c] == null || vlen > 0L);
        }
        return hs;
    }

    public static DHistogram make(String name, int nbins, byte isInt, double min, double maxEx, long seed, SharedTreeModel.SharedTreeParameters parms, Key globalQuantilesKey) {
        return new DHistogram(name, nbins, parms._nbins_cats, isInt, min, maxEx, parms._min_split_improvement, parms._histogram_type, seed, globalQuantilesKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(":").append(this._min).append("-").append(this._maxEx).append(" step=" + 1.0 / this._step + " nbins=" + this.nbins() + " isInt=" + this._isInt);
        if (this._w != null) {
            for (int b = 0; b < this._w.length; ++b) {
                sb.append(String.format("\ncnt=%f, [%f - %f], mean/var=", this._w[b], this._min + (double)b / this._step, this._min + (double)(b + 1) / this._step));
                sb.append(String.format("%6.2f/%6.2f,", this.mean(b), this.var(b)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    double mean(int b) {
        double n = this._w[b];
        return n > 0.0 ? this._wY[b] / n : 0.0;
    }

    public double var(int b) {
        double n = this._w[b];
        if (n <= 1.0) {
            return 0.0;
        }
        return Math.max(0.0, (this._wYY[b] - this._wY[b] * this._wY[b] / n) / (n - 1.0));
    }

    public void incr0(int b, double y, double w) {
        AtomicUtils.DoubleArray.add((double[])this._wY, (int)b, (double)((float)(w * y)));
        AtomicUtils.DoubleArray.add((double[])this._wYY, (int)b, (double)((float)(w * y * y)));
    }

    public void incr1(int b, double y, double yy) {
        AtomicUtils.DoubleArray.add((double[])this._wY, (int)b, (double)((float)y));
        AtomicUtils.DoubleArray.add((double[])this._wYY, (int)b, (double)((float)yy));
    }

    public void add0(DHistogram dsh) {
        ArrayUtils.add((double[])this._wY, (double[])dsh._wY);
        ArrayUtils.add((double[])this._wYY, (double[])dsh._wYY);
    }

    public DTree.Split findBestSplitPoint(int col, double min_rows) {
        int nbins = this.nbins();
        assert (nbins > 1);
        double[] w = this._w;
        double[] wY = this._wY;
        double[] wYY = this._wYY;
        int[] idxs = null;
        if (this._isInt == 2 && this._step == 1.0) {
            int i;
            idxs = MemoryManager.malloc4((int)(nbins + 1));
            for (int i2 = 0; i2 < nbins + 1; ++i2) {
                idxs[i2] = i2;
            }
            double[] avgs = MemoryManager.malloc8d((int)(nbins + 1));
            for (i = 0; i < nbins; ++i) {
                avgs[i] = this._w[i] == 0.0 ? 0.0 : this._wY[i] / this._w[i];
            }
            avgs[nbins] = Double.MAX_VALUE;
            ArrayUtils.sort((int[])idxs, (double[])avgs);
            w = MemoryManager.malloc8d((int)nbins);
            wY = MemoryManager.malloc8d((int)nbins);
            wYY = MemoryManager.malloc8d((int)nbins);
            for (i = 0; i < nbins; ++i) {
                w[i] = this._w[idxs[i]];
                wY[i] = this._wY[idxs[i]];
                wYY[i] = this._wYY[idxs[i]];
            }
        }
        double[] wlo = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYlo = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYYlo = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b = 1; b <= nbins; ++b) {
            double n0 = wlo[b - 1];
            double n1 = w[b - 1];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYlo[b - 1];
            double m1 = wY[b - 1];
            double s0 = wYYlo[b - 1];
            double s1 = wYY[b - 1];
            wlo[b] = n0 + n1;
            wYlo[b] = m0 + m1;
            wYYlo[b] = s0 + s1;
        }
        double wNA = this._wNA.doubleValue();
        double tot = wlo[nbins] + wNA;
        if (tot < 2.0 * min_rows) {
            return null;
        }
        double wYNA = this._wYNA.doubleValue();
        double wYYNA = this._wYYNA.doubleValue();
        double var = (wYYlo[nbins] + wYYNA) * tot - (wYlo[nbins] + wYNA) * (wYlo[nbins] + wYNA);
        if ((float)var == 0.0f) {
            return null;
        }
        double[] whi = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYhi = MemoryManager.malloc8d((int)(nbins + 1));
        double[] wYYhi = MemoryManager.malloc8d((int)(nbins + 1));
        for (int b = nbins - 1; b >= 0; --b) {
            double n0 = whi[b + 1];
            double n1 = w[b];
            if (n0 == 0.0 && n1 == 0.0) continue;
            double m0 = wYhi[b + 1];
            double m1 = wY[b];
            double s0 = wYYhi[b + 1];
            double s1 = wYY[b];
            whi[b] = n0 + n1;
            wYhi[b] = m0 + m1;
            wYYhi[b] = s0 + s1;
            assert (MathUtils.compare((double)(wlo[b] + whi[b] + wNA), (double)tot, (double)1.0E-5, (double)1.0E-5));
        }
        double best_seL = Double.MAX_VALUE;
        double best_seR = Double.MAX_VALUE;
        NASplitDir nasplit = NASplitDir.None;
        double seNonNA = wYYhi[0] - wYhi[0] * wYhi[0] / whi[0];
        if (seNonNA < 0.0) {
            seNonNA = 0.0;
        }
        double seBefore = seNonNA;
        if (wNA >= min_rows) {
            double seAll = wYYhi[0] + wYYNA - (wYhi[0] + wYNA) * (wYhi[0] + wYNA) / (whi[0] + wNA);
            double seNA = wYYNA - wYNA * wYNA / wNA;
            if (seNA < 0.0) {
                seNA = 0.0;
            }
            best_seL = seNonNA;
            best_seR = seNA;
            nasplit = NASplitDir.NAvsREST;
            seBefore = seAll;
        }
        int best = 0;
        byte equal = 0;
        for (int b = 1; b <= nbins - 1; ++b) {
            double sehi;
            double selo;
            if (w[b] == 0.0 || wlo[b] + wNA < min_rows) continue;
            if (whi[b] + wNA < min_rows) break;
            if (wNA == 0.0) {
                selo = wYYlo[b] - wYlo[b] * wYlo[b] / wlo[b];
                sehi = wYYhi[b] - wYhi[b] * wYhi[b] / whi[b];
                if (selo < 0.0) {
                    selo = 0.0;
                }
                if (sehi < 0.0) {
                    sehi = 0.0;
                }
                if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1)))) continue;
                best_seL = selo;
                best_seR = sehi;
                best = b;
                continue;
            }
            selo = wYYlo[b] + wYYNA - (wYlo[b] + wYNA) * (wYlo[b] + wYNA) / (wlo[b] + wNA);
            sehi = wYYhi[b] - wYhi[b] * wYhi[b] / whi[b];
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if ((selo + sehi < best_seL + best_seR || selo + sehi == best_seL + best_seR && Math.abs(b - (nbins >> 1)) < Math.abs(best - (nbins >> 1))) && wlo[b] + wNA >= min_rows && whi[b] >= min_rows) {
                best_seL = selo;
                best_seR = sehi;
                best = b;
                nasplit = NASplitDir.NALeft;
            }
            selo = wYYlo[b] - wYlo[b] * wYlo[b] / wlo[b];
            sehi = wYYhi[b] + wYYNA - (wYhi[b] + wYNA) * (wYhi[b] + wYNA) / (whi[b] + wNA);
            if (selo < 0.0) {
                selo = 0.0;
            }
            if (sehi < 0.0) {
                sehi = 0.0;
            }
            if (!(selo + sehi < best_seL + best_seR) && (selo + sehi != best_seL + best_seR || Math.abs(b - (nbins >> 1)) >= Math.abs(best - (nbins >> 1))) || !(wlo[b] >= min_rows) || !(whi[b] + wNA >= min_rows)) continue;
            best_seL = selo;
            best_seR = sehi;
            best = b;
            nasplit = NASplitDir.NARight;
        }
        IcedBitSet bs = null;
        if (idxs != null) {
            int i;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (i = best; i < nbins; ++i) {
                min = Math.min(min, idxs[i]);
                max = Math.max(max, idxs[i]);
            }
            bs = new IcedBitSet(max - min + 1, min);
            for (i = best; i < nbins; ++i) {
                bs.set(idxs[i]);
            }
            equal = (byte)(bs.max() <= 32 ? 2 : 3);
        }
        if (best == 0 && nasplit == NASplitDir.None) {
            return null;
        }
        if (!(best_seL + best_seR < seBefore * (1.0 - this._minSplitImprovement))) {
            return null;
        }
        double nLeft = wlo[best];
        double nRight = whi[best];
        double predLeft = wYlo[best];
        double predRight = wYhi[best];
        if (nasplit == NASplitDir.NAvsREST) {
            assert (best == 0);
            nLeft = whi[0];
            predLeft = wYhi[0];
            nRight = wNA;
            predRight = wYNA;
        } else if (nasplit == NASplitDir.NALeft) {
            nLeft += wNA;
            predLeft += wYNA;
        } else if (nasplit == NASplitDir.NARight) {
            nRight += wNA;
            predRight += wYNA;
        }
        if (MathUtils.equalsWithinOneSmallUlp((float)((float)(predLeft / nLeft)), (float)((float)(predRight / nRight)))) {
            return null;
        }
        if (nLeft < min_rows || nRight < min_rows) {
            return null;
        }
        if (nasplit == NASplitDir.None) {
            nasplit = nLeft > nRight ? NASplitDir.Left : NASplitDir.Right;
        }
        return new DTree.Split(col, best, nasplit, bs, equal, seBefore, best_seL, best_seR, nLeft, nRight, predLeft / nLeft, predRight / nRight);
    }

    public void updateSharedHistosAndReset(ScoreBuildHistogram.LocalHisto lh, double[] ws, double[] cs, double[] ys, int[] rows, int hi, int lo) {
        double[] minmax = new double[]{this._min2, this._maxIn};
        for (int r = lo; r < hi; ++r) {
            int k = rows[r];
            double weight = ws[k];
            if (weight == 0.0) continue;
            double col_data = cs[k];
            if (col_data < minmax[0]) {
                minmax[0] = col_data;
            }
            if (col_data > minmax[1]) {
                minmax[1] = col_data;
            }
            double y = ys[k];
            assert (!Double.isNaN(y));
            double wy = weight * y;
            double wyy = wy * y;
            if (Double.isNaN(col_data)) {
                this._wNA.addAndGet(weight);
                this._wYNA.addAndGet(wy);
                this._wYYNA.addAndGet(wyy);
                continue;
            }
            int b = this.bin(col_data);
            lh.wAdd(b, weight);
            lh.wYAdd(b, wy);
            lh.wYYAdd(b, wyy);
        }
        this.setMin(minmax[0]);
        this.setMaxIn(minmax[1]);
        int len = this._w.length;
        for (int b = 0; b < len; ++b) {
            if (lh.w(b) != 0.0) {
                AtomicUtils.DoubleArray.add((double[])this._w, (int)b, (double)lh.w(b));
                lh.wClear(b);
            }
            if (lh.wY(b) != 0.0) {
                AtomicUtils.DoubleArray.add((double[])this._wY, (int)b, (double)((float)lh.wY(b)));
                lh.wYClear(b);
            }
            if (lh.wYY(b) == 0.0) continue;
            AtomicUtils.DoubleArray.add((double[])this._wYY, (int)b, (double)((float)lh.wYY(b)));
            lh.wYYClear(b);
        }
    }

    static {
        try {
            _min2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_min2"));
            _max2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_maxIn"));
        }
        catch (Exception e) {
            throw H2O.fail();
        }
    }

    static class HistoQuantiles
    extends Keyed<HistoQuantiles> {
        double[] splitPts;

        public HistoQuantiles(Key<HistoQuantiles> key, double[] splitPts) {
            super(key);
            this.splitPts = splitPts;
        }
    }

    public static enum NASplitDir {
        None(0),
        NAvsREST(1),
        NALeft(2),
        NARight(3),
        Left(4),
        Right(5);

        private int value;

        private NASplitDir(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

