/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.ModelMojoWriter;
import hex.tree.CompressedTree;
import hex.tree.SharedTreeModel;
import java.io.IOException;
import water.DKV;
import water.Key;
import water.Value;
import water.exceptions.H2OKeyNotFoundArgumentException;

public class SharedTreeMojoWriter<M extends SharedTreeModel<M, P, O>, P extends SharedTreeModel.SharedTreeParameters, O extends SharedTreeModel.SharedTreeOutput>
extends ModelMojoWriter<M, P, O> {
    public SharedTreeMojoWriter(M model) {
        super(model);
    }

    protected void writeModelData() throws IOException {
        assert (((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys.length == ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        int nclasses = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output).nclasses();
        int ntreesPerClass = ((SharedTreeModel)this.model).binomialOpt() && nclasses == 2 ? 1 : nclasses;
        this.writekv("n_trees", ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees);
        this.writekv("n_trees_per_class", ntreesPerClass);
        for (int i = 0; i < ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._ntrees; ++i) {
            for (int j = 0; j < ntreesPerClass; ++j) {
                Value ctVal;
                Key<CompressedTree> key = ((SharedTreeModel.SharedTreeOutput)((SharedTreeModel)this.model)._output)._treeKeys[i][j];
                Value value = ctVal = key != null ? DKV.get(key) : null;
                if (ctVal == null) {
                    throw new H2OKeyNotFoundArgumentException("CompressedTree " + key + " not found");
                }
                CompressedTree ct = (CompressedTree)ctVal.get();
                assert (ct._nclass == nclasses);
                this.writeblob(String.format("trees/t%02d_%03d.bin", j, i), ct._bits);
            }
        }
    }
}

