/*
 * Decompiled with CFR 0.152.
 */
package hex.aggregator;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ToEigenVec;
import hex.aggregator.Aggregator;
import hex.pca.PCAModel;
import hex.util.LinearAlgebraUtils;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class AggregatorModel
extends Model<AggregatorModel, AggregatorParameters, AggregatorOutput>
implements Model.ExemplarMembers {
    public Aggregator.Exemplar[] _exemplars;
    public long[] _counts;
    public Key<Vec> _exemplar_assignment_vec_key;

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    public AggregatorModel(Key selfKey, AggregatorParameters parms, AggregatorOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    protected Frame predictScoreImpl(Frame orig, Frame adaptedFr, String destination_key, Job j) {
        return null;
    }

    protected Futures remove_impl(Futures fs) {
        this._exemplar_assignment_vec_key.remove();
        return super.remove_impl(fs);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return null;
    }

    protected double[] score0(double[] data, double[] preds) {
        return preds;
    }

    public Frame createFrameOfExemplars(Frame orig, Key destination_key) {
        final long[] keep = new long[this._exemplars.length];
        for (int i = 0; i < keep.length; ++i) {
            keep[i] = this._exemplars[i].gid;
        }
        Vec exAssignment = (Vec)this._exemplar_assignment_vec_key.get();
        Vec booleanCol = new MRTask(){

            public void map(Chunk c, Chunk c2) {
                for (int i = 0; i < keep.length; ++i) {
                    if (keep[i] < c.start() || keep[i] >= c.start() + (long)c._len) continue;
                    c2.set((int)(keep[i] - c.start()), 1L);
                }
            }
        }.doAll((Frame)new Frame((Vec[])new Vec[]{exAssignment, exAssignment.makeZero()}))._fr.vec(1);
        Vec[] vecs = Arrays.copyOf(orig.vecs(), orig.vecs().length + 1);
        vecs[vecs.length - 1] = booleanCol;
        Frame ff = new Frame(orig.names(), orig.vecs());
        ff.add("predicate", booleanCol);
        Frame res = ((Frame.DeepSelect)new Frame.DeepSelect().doAll(orig.types(), ff)).outputFrame(destination_key, orig.names(), orig.domains());
        booleanCol.remove();
        assert (res.numRows() == (long)this._exemplars.length);
        Vec cnts = res.anyVec().makeZero();
        Vec.Writer vw = cnts.open();
        for (int i = 0; i < this._counts.length; ++i) {
            vw.set((long)i, this._counts[i]);
        }
        vw.close();
        res.add("counts", cnts);
        DKV.put((Key)destination_key, (Iced)res);
        return res;
    }

    public Frame scoreExemplarMembers(Key destination_key, final int exemplarIdx) {
        Vec booleanCol = new MRTask(){

            public void map(Chunk c, NewChunk nc) {
                for (int i = 0; i < c._len; ++i) {
                    nc.addNum(c.at8(i) == AggregatorModel.this._exemplars[exemplarIdx].gid ? 1L : 0L, 0);
                }
            }
        }.doAll((byte)3, new Frame(new Vec[]{(Vec)this._exemplar_assignment_vec_key.get()})).outputFrame().anyVec();
        Frame orig = ((AggregatorParameters)this._parms).train();
        Vec[] vecs = Arrays.copyOf(orig.vecs(), orig.vecs().length + 1);
        vecs[vecs.length - 1] = booleanCol;
        Frame ff = new Frame(orig.names(), orig.vecs());
        ff.add("predicate", booleanCol);
        Frame res = ((Frame.DeepSelect)new Frame.DeepSelect().doAll(orig.types(), ff)).outputFrame(destination_key, orig.names(), orig.domains());
        assert (res.numRows() == this._counts[exemplarIdx]);
        booleanCol.remove();
        return res;
    }

    public void checkConsistency() {
        long sum = 0L;
        for (long l : this._counts) {
            sum += l;
        }
        assert (sum == ((AggregatorParameters)this._parms).train().numRows());
        long[] exemplarGIDs = new long[this._counts.length];
        for (int i = 0; i < this._exemplars.length; ++i) {
            exemplarGIDs[i] = this._exemplars[i].gid;
        }
        long[] counts = new long[this._exemplars.length];
        int i = 0;
        while ((long)i < ((AggregatorParameters)this._parms).train().numRows()) {
            long ass = ((Vec)this._exemplar_assignment_vec_key.get()).at8((long)i);
            for (int j = 0; j < exemplarGIDs.length; ++j) {
                if (exemplarGIDs[j] != ass) continue;
                int n = j;
                counts[n] = counts[n] + 1L;
                break;
            }
            ++i;
        }
        sum = 0L;
        for (long l : counts) {
            sum += l;
        }
        assert (sum == ((AggregatorParameters)this._parms).train().numRows());
        for (i = 0; i < counts.length; ++i) {
            assert (counts[i] == this._counts[i]);
        }
    }

    public static class AggregatorOutput
    extends Model.Output {
        public Key<Frame> _output_frame;

        public AggregatorOutput(Aggregator b) {
            super((ModelBuilder)b);
        }

        public int nfeatures() {
            return ((Frame)this._output_frame.get()).numCols() - 1;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.Clustering;
        }
    }

    public static class AggregatorParameters
    extends Model.Parameters {
        public double _radius_scale = 1.0;
        public DataInfo.TransformType _transform = DataInfo.TransformType.NORMALIZE;
        public PCAModel.PCAParameters.Method _pca_method = PCAModel.PCAParameters.Method.Power;
        public int _k = 1;
        public int _max_iterations = 1000;
        public boolean _use_all_factor_levels = false;

        public String algoName() {
            return "Aggregator";
        }

        public String fullName() {
            return "Aggregator";
        }

        public String javaName() {
            return AggregatorModel.class.getName();
        }

        public long progressUnits() {
            return 5 + 2 * this.train().anyVec().nChunks() - 1;
        }
    }
}

