/*
 * Decompiled with CFR 0.152.
 */
package hex.glrm;

import Jama.CholeskyDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.kmeans.KMeans;
import hex.kmeans.KMeansModel;
import hex.svd.SVD;
import hex.svd.SVDModel;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.api.ModelCacheManager;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class GLRM
extends ModelBuilder<GLRMModel, GLRMModel.GLRMParameters, GLRMModel.GLRMOutput> {
    private final double TOLERANCE = 1.0E-6;
    private final int MAX_COLS_EXPANDED = 5000;
    private transient int _ncolA;
    private transient int _ncolY;
    private transient int _ncolX;
    private transient GLRMModel.GLRMParameters.Loss[] _lossFunc;

    protected GLRMDriver trainModelImpl() {
        return new GLRMDriver();
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Clustering};
    }

    public GLRM(GLRMModel.GLRMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GLRM(GLRMModel.GLRMParameters parms, Job job) {
        super((Model.Parameters)parms, job);
        this.init(false);
    }

    public GLRM(boolean startup_once) {
        super((Model.Parameters)new GLRMModel.GLRMParameters(), startup_once);
    }

    public void init(boolean expensive) {
        int i;
        super.init(expensive);
        if (!((GLRMModel.GLRMParameters)this._parms)._loss.isForNumeric()) {
            this.error("_loss", (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss) + " is not a univariate loss function");
        }
        if (!((GLRMModel.GLRMParameters)this._parms)._multi_loss.isForCategorical()) {
            this.error("_multi_loss", (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._multi_loss) + " is not a multivariate loss function");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._period <= 0) {
            this.error("_period", "_period must be a positive integer");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._gamma_x < 0.0) {
            this.error("_gamma_x", "gamma must be a non-negative number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._gamma_y < 0.0) {
            this.error("_gamma_y", "gamma_y must be a non-negative number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._max_iterations < 1 || (double)((GLRMModel.GLRMParameters)this._parms)._max_iterations > 1000000.0) {
            this.error("_max_iterations", "max_iterations must be between 1 and 1e6 inclusive");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._init_step_size <= 0.0) {
            this.error("_init_step_size", "init_step_size must be a positive number");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._min_step_size < 0.0 || ((GLRMModel.GLRMParameters)this._parms)._min_step_size > ((GLRMModel.GLRMParameters)this._parms)._init_step_size) {
            this.error("_min_step_size", "min_step_size must be between 0 and " + ((GLRMModel.GLRMParameters)this._parms)._init_step_size);
        }
        if (((GLRMModel.GLRMParameters)this._parms)._recover_svd && ((GLRMModel.GLRMParameters)this._parms)._impute_original && ((GLRMModel.GLRMParameters)this._parms)._transform != DataInfo.TransformType.NONE) {
            this.error("_recover_svd", "_recover_svd and _impute_original cannot both be true if _train is transformed");
        }
        if (this._train == null) {
            return;
        }
        if (this._train.numCols() < 2) {
            this.error("_train", "_train must have more than one column");
        }
        if (this._valid != null && this._valid.numRows() != this._train.numRows()) {
            this.error("_valid", "_valid must have same number of rows as _train");
        }
        this._ncolY = LinearAlgebraUtils.numColsExp(this._train, true);
        if (this._ncolY > 5000) {
            this.warn("_train", "_train has " + this._ncolY + " columns when categoricals are expanded. Algorithm may be slow.");
        }
        if (((GLRMModel.GLRMParameters)this._parms)._k < 1 || ((GLRMModel.GLRMParameters)this._parms)._k > this._ncolY) {
            this.error("_k", "_k must be between 1 and " + this._ncolY + " inclusive");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._user_y) {
            int user_y_cols;
            if (((GLRMModel.GLRMParameters)this._parms)._init != Initialization.User) {
                this.error("_init", "init must be 'User' if providing user-specified points");
            }
            Frame user_y = (Frame)((GLRMModel.GLRMParameters)this._parms)._user_y.get();
            assert (null != user_y);
            int n = user_y_cols = ((GLRMModel.GLRMParameters)this._parms)._expand_user_y ? this._train.numCols() : this._ncolY;
            if (user_y.numCols() != user_y_cols) {
                this.error("_user_y", "The user-specified Y must have the same number of columns (" + user_y_cols + ") as the training observations");
            } else if (user_y.numRows() != (long)((GLRMModel.GLRMParameters)this._parms)._k) {
                this.error("_user_y", "The user-specified Y must have k = " + ((GLRMModel.GLRMParameters)this._parms)._k + " rows");
            } else {
                int zero_vec = 0;
                Vec[] centersVecs = user_y.vecs();
                for (int c = 0; c < this._train.numCols(); ++c) {
                    if (centersVecs[c].naCnt() > 0L) {
                        this.error("_user_y", "The user-specified Y cannot contain any missing values");
                        break;
                    }
                    if (!centersVecs[c].isConst() || centersVecs[c].max() != 0.0) continue;
                    ++zero_vec;
                }
                if (zero_vec == this._train.numCols()) {
                    this.error("_user_y", "The user-specified Y cannot all be zero");
                }
            }
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._user_x) {
            if (((GLRMModel.GLRMParameters)this._parms)._init != Initialization.User) {
                this.error("_init", "init must be 'User' if providing user-specified points");
            }
            Frame user_x = (Frame)((GLRMModel.GLRMParameters)this._parms)._user_x.get();
            assert (null != user_x);
            if (user_x.numCols() != ((GLRMModel.GLRMParameters)this._parms)._k) {
                this.error("_user_x", "The user-specified X must have k = " + ((GLRMModel.GLRMParameters)this._parms)._k + " columns");
            } else if (user_x.numRows() != this._train.numRows()) {
                this.error("_user_x", "The user-specified X must have the same number of rows (" + this._train.numRows() + ") as the training observations");
            } else {
                int zero_vec = 0;
                Vec[] centersVecs = user_x.vecs();
                for (int c = 0; c < ((GLRMModel.GLRMParameters)this._parms)._k; ++c) {
                    if (centersVecs[c].naCnt() > 0L) {
                        this.error("_user_x", "The user-specified X cannot contain any missing values");
                        break;
                    }
                    if (!centersVecs[c].isConst() || centersVecs[c].max() != 0.0) continue;
                    ++zero_vec;
                }
                if (zero_vec == ((GLRMModel.GLRMParameters)this._parms)._k) {
                    this.error("_user_x", "The user-specified X cannot all be zero");
                }
            }
        }
        for (i = 0; i < this._train.numCols(); ++i) {
            if (!this._train.vec(i).isString() && !this._train.vec(i).isUUID()) continue;
            throw H2O.unimpl((String)"GLRM cannot handle String or UUID data");
        }
        if (null != ((GLRMModel.GLRMParameters)this._parms)._loss_by_col) {
            if (((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length > this._train.numCols()) {
                this.error("_loss_by_col", "Number of loss functions specified must be <= " + this._train.numCols());
            } else if (null == ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx && ((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length == this._train.numCols()) {
                for (i = 0; i < ((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length; ++i) {
                    if (this._train.vec(i).isNumeric() && !((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForNumeric()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to numeric column " + i);
                        continue;
                    }
                    if (this._train.vec(i).isCategorical() && !((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForCategorical()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to categorical column " + i);
                        continue;
                    }
                    if (this._train.vec(i).isBinary() || !((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForBinary()) continue;
                    this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to non-binary column " + i);
                }
                this._lossFunc = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col;
            } else if (null != ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx && ((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length == ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx.length) {
                this._lossFunc = new GLRMModel.GLRMParameters.Loss[this._train.numCols()];
                for (i = 0; i < this._lossFunc.length; ++i) {
                    this._lossFunc[i] = this._train.vec(i).isCategorical() ? ((GLRMModel.GLRMParameters)this._parms)._multi_loss : ((GLRMModel.GLRMParameters)this._parms)._loss;
                }
                for (i = 0; i < ((GLRMModel.GLRMParameters)this._parms)._loss_by_col.length; ++i) {
                    int cidx = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx[i];
                    if (cidx < 0 || cidx >= this._train.numCols()) {
                        this.error("_loss_by_col_idx", "Column index " + cidx + " must be in [0," + this._train.numCols() + ")");
                        continue;
                    }
                    if (this._train.vec(cidx).isNumeric() && !((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForNumeric()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to numeric column " + cidx);
                        continue;
                    }
                    if (this._train.vec(cidx).isCategorical() && !((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForCategorical()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to categorical column " + cidx);
                        continue;
                    }
                    if (!this._train.vec(cidx).isBinary() && ((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i].isForBinary()) {
                        this.error("_loss_by_col", "Loss function " + (Object)((Object)((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i]) + " cannot apply to non-binary column " + cidx);
                        continue;
                    }
                    this._lossFunc[((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx[i]] = ((GLRMModel.GLRMParameters)this._parms)._loss_by_col[i];
                }
            } else {
                this.error("_loss_by_col_idx", "Must specify same number of column indices as loss functions");
            }
        } else if (null != ((GLRMModel.GLRMParameters)this._parms)._loss_by_col_idx) {
            this.error("_loss_by_col", "Must specify loss function for each column");
        } else {
            this._lossFunc = new GLRMModel.GLRMParameters.Loss[this._train.numCols()];
            for (i = 0; i < this._lossFunc.length; ++i) {
                this._lossFunc[i] = this._train.vec(i).isCategorical() ? ((GLRMModel.GLRMParameters)this._parms)._multi_loss : ((GLRMModel.GLRMParameters)this._parms)._loss;
            }
        }
        this._ncolX = ((GLRMModel.GLRMParameters)this._parms)._k;
        this._ncolA = this._train.numCols();
    }

    public static double frobenius2(double[][] x) {
        if (x == null) {
            return 0.0;
        }
        double frob = 0.0;
        double[][] arr$ = x;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] xs;
            for (double j : xs = arr$[i$]) {
                frob += j * j;
            }
        }
        return frob;
    }

    public static double[][] transform(double[][] centers, double[] normSub, double[] normMul, int ncats, int nnums) {
        double[] mults;
        int K = centers.length;
        int N = centers[0].length;
        assert (ncats + nnums == N);
        double[][] value = new double[K][N];
        double[] means = normSub == null ? MemoryManager.malloc8d((int)nnums) : normSub;
        double[] dArray = mults = normMul == null ? MemoryManager.malloc8d((int)nnums) : normMul;
        if (normMul == null) {
            Arrays.fill(mults, 1.0);
        }
        for (int clu = 0; clu < K; ++clu) {
            System.arraycopy(centers[clu], 0, value[clu], 0, ncats);
            for (int col = 0; col < nnums; ++col) {
                value[clu][ncats + col] = (centers[clu][ncats + col] - means[col]) * mults[col];
            }
        }
        return value;
    }

    public static double[][] expandCats(double[][] sdata, DataInfo dinfo) {
        if (sdata == null || dinfo._cats == 0) {
            return sdata;
        }
        assert (sdata[0].length == dinfo._adaptedFrame.numCols());
        int catsexp = dinfo._catOffsets[dinfo._catOffsets.length - 1];
        double[][] cexp = new double[sdata.length][catsexp + dinfo._nums];
        for (int i = 0; i < sdata.length; ++i) {
            LinearAlgebraUtils.expandRow(sdata[i], dinfo, cexp[i], false);
        }
        return cexp;
    }

    protected static int idx_xold(int c, int ncolA) {
        return ncolA + c;
    }

    protected static int idx_xnew(int c, int ncolA, int ncolX) {
        return ncolA + ncolX + c;
    }

    protected static Chunk chk_xold(Chunk[] chks, int c, int ncolA) {
        return chks[ncolA + c];
    }

    protected static Chunk chk_xnew(Chunk[] chks, int c, int ncolA, int ncolX) {
        return chks[ncolA + ncolX + c];
    }

    private static class CholMulTask
    extends MRTask<CholMulTask> {
        GLRMModel.GLRMParameters _parms;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        CholeskyDecomposition _chol;

        CholMulTask(GLRMModel.GLRMParameters parms, CholeskyDecomposition chol, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul) {
            assert (yt != null && yt.rank() == ncolX);
            assert (ncats <= ncolA);
            this._parms = parms;
            this._yt = yt;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ncats = ncats;
            this._chol = chol;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            double[] xrow = new double[this._ncolX];
            for (int row = 0; row < cs[0]._len; ++row) {
                for (int k = 0; k < this._ncolX; ++k) {
                    int d;
                    double x = 0.0;
                    for (d = 0; d < this._ncats; ++d) {
                        double a = cs[d].atd(row);
                        if (Double.isNaN(a)) continue;
                        x += this._yt.getCat(d, (int)a, k);
                    }
                    for (d = this._ncats; d < this._ncolA; ++d) {
                        int ds = d - this._ncats;
                        double a = cs[d].atd(row);
                        if (Double.isNaN(a)) continue;
                        x += (a - this._normSub[ds]) * this._normMul[ds] * this._yt.getNum(ds, k);
                    }
                    xrow[k] = x;
                }
                Matrix tmp = this._chol.solve(new Matrix((double[][])new double[][]{xrow}).transpose());
                xrow = tmp.getColumnPackedCopy();
                int i = 0;
                for (int d = this._ncolA; d < this._ncolA + this._ncolX; ++d) {
                    cs[d].set(row, xrow[i]);
                    cs[d + this._ncolX].set(row, xrow[i++]);
                }
                assert (i == xrow.length);
            }
        }
    }

    private static class ObjCalc
    extends MRTask<ObjCalc> {
        GLRMModel.GLRMParameters _parms;
        GLRMModel.GLRMParameters.Loss[] _lossFunc;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        final boolean _regX;
        double _loss;
        double _xold_reg;

        ObjCalc(GLRMModel.GLRMParameters parms, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GLRMModel.GLRMParameters.Loss[] lossFunc, int weightId) {
            this(parms, yt, ncolA, ncolX, ncats, normSub, normMul, lossFunc, weightId, false);
        }

        ObjCalc(GLRMModel.GLRMParameters parms, Archetypes yt, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GLRMModel.GLRMParameters.Loss[] lossFunc, int weightId, boolean regX) {
            assert (yt != null && yt.rank() == ncolX);
            assert (ncats <= ncolA);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ncats = ncats;
            this._regX = regX;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            C0DChunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            this._xold_reg = 0.0;
            this._loss = 0.0;
            for (int row = 0; row < cs[0]._len; ++row) {
                double a;
                int j;
                double cweight = chkweight.atd(row);
                assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                for (j = 0; j < this._ncats; ++j) {
                    a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double[] xy = new double[this._yt._numLevels[j]];
                    for (int level = 0; level < xy.length; ++level) {
                        for (int k = 0; k < this._ncolX; ++k) {
                            int n = level;
                            xy[n] = xy[n] + GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._yt.getCat(j, level, k);
                        }
                    }
                    this._loss += GLRMModel.GLRMParameters.mloss(xy, (int)a, this._lossFunc[j]);
                }
                for (j = this._ncats; j < this._ncolA; ++j) {
                    a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double xy = 0.0;
                    int js = j - this._ncats;
                    for (int k = 0; k < this._ncolX; ++k) {
                        xy += GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._yt.getNum(js, k);
                    }
                    this._loss += this._parms.loss(xy, (a - this._normSub[js]) * this._normMul[js], this._lossFunc[j]);
                }
                this._loss *= cweight;
                if (!this._regX) continue;
                int idx = 0;
                double[] xrow = new double[this._ncolX];
                for (int j2 = this._ncolA; j2 < this._ncolA + this._ncolX; ++j2) {
                    xrow[idx] = cs[j2].atd(row);
                    ++idx;
                }
                assert (idx == this._ncolX);
                this._xold_reg += this._parms.regularize_x(xrow);
            }
        }

        public void reduce(ObjCalc other) {
            this._loss += other._loss;
            this._xold_reg += other._xold_reg;
        }
    }

    private static class UpdateY
    extends MRTask<UpdateY> {
        GLRMModel.GLRMParameters _parms;
        GLRMModel.GLRMParameters.Loss[] _lossFunc;
        final double _alpha;
        final Archetypes _ytold;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        double[][] _ytnew;
        double _yreg;

        UpdateY(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GLRMModel.GLRMParameters.Loss[] lossFunc, int weightId) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            this._ytold = yt;
            this._yreg = 0.0;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        public void map(Chunk[] cs) {
            int j;
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            this._ytnew = new double[this._ytold.nfeatures()][this._ncolX];
            C0DChunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            for (j = 0; j < this._ncats; ++j) {
                for (int row = 0; row < cs[0]._len; ++row) {
                    double a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double cweight = chkweight.atd(row);
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    double[] xy = new double[this._ytold._numLevels[j]];
                    for (int level = 0; level < xy.length; ++level) {
                        for (int k = 0; k < this._ncolX; ++k) {
                            int n = level;
                            xy[n] = xy[n] + GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._ytold.getCat(j, level, k);
                        }
                    }
                    double[] weight = GLRMModel.GLRMParameters.mlgrad(xy, (int)a, this._lossFunc[j]);
                    for (int level = 0; level < xy.length; ++level) {
                        for (int k = 0; k < this._ncolX; ++k) {
                            double[] dArray = this._ytnew[this._ytold.getCatCidx(j, level)];
                            int n = k;
                            dArray[n] = dArray[n] + cweight * weight[level] * GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row);
                        }
                    }
                }
            }
            for (j = this._ncats; j < this._ncolA; ++j) {
                int js = j - this._ncats;
                int yidx = this._ytold.getNumCidx(js);
                for (int row = 0; row < cs[0]._len; ++row) {
                    double a = cs[j].atd(row);
                    if (Double.isNaN(a)) continue;
                    double cweight = chkweight.atd(row);
                    assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                    double xy = 0.0;
                    for (int k = 0; k < this._ncolX; ++k) {
                        xy += GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row) * this._ytold.getNum(js, k);
                    }
                    double weight = cweight * this._parms.lgrad(xy, (a - this._normSub[js]) * this._normMul[js], this._lossFunc[j]);
                    for (int k = 0; k < this._ncolX; ++k) {
                        double[] dArray = this._ytnew[yidx];
                        int n = k;
                        dArray[n] = dArray[n] + weight * GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row);
                    }
                }
            }
        }

        public void reduce(UpdateY other) {
            ArrayUtils.add((double[][])this._ytnew, (double[][])other._ytnew);
        }

        protected void postGlobal() {
            assert (this._ytnew.length == this._ytold.nfeatures() && this._ytnew[0].length == this._ytold.rank());
            Random rand = RandomUtils.getRNG((long[])new long[]{this._parms._seed});
            for (int j = 0; j < this._ytnew.length; ++j) {
                double[] u = new double[this._ytnew[0].length];
                for (int k = 0; k < this._ytnew[0].length; ++k) {
                    u[k] = this._ytold._archetypes[j][k] - this._alpha * this._ytnew[j][k];
                }
                this._ytnew[j] = this._parms.rproxgrad_y(u, this._alpha, rand);
                this._yreg += this._parms.regularize_y(this._ytnew[j]);
            }
        }
    }

    private static class UpdateX
    extends MRTask<UpdateX> {
        GLRMModel.GLRMParameters _parms;
        GLRMModel.GLRMParameters.Loss[] _lossFunc;
        final double _alpha;
        final boolean _update;
        final Archetypes _yt;
        final int _ncolA;
        final int _ncolX;
        final int _ncats;
        final double[] _normSub;
        final double[] _normMul;
        final int _weightId;
        double _loss;
        double _xreg;

        UpdateX(GLRMModel.GLRMParameters parms, Archetypes yt, double alpha, boolean update, int ncolA, int ncolX, int ncats, double[] normSub, double[] normMul, GLRMModel.GLRMParameters.Loss[] lossFunc, int weightId) {
            assert (yt != null && yt.rank() == ncolX);
            this._parms = parms;
            this._yt = yt;
            this._lossFunc = lossFunc;
            this._alpha = alpha;
            this._update = update;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
            assert (ncats <= ncolA);
            this._ncats = ncats;
            this._weightId = weightId;
            this._normSub = normSub;
            this._normMul = normMul;
        }

        public void map(Chunk[] cs) {
            assert (this._ncolA + 2 * this._ncolX == cs.length);
            double[] a = new double[this._ncolA];
            C0DChunk chkweight = this._weightId >= 0 ? cs[this._weightId] : new C0DChunk(1.0, cs[0]._len);
            Random rand = RandomUtils.getRNG((long[])new long[]{0L});
            this._xreg = 0.0;
            this._loss = 0.0;
            for (int row = 0; row < cs[0]._len; ++row) {
                int j;
                int j2;
                rand.setSeed(this._parms._seed + cs[0].start() + (long)row);
                double[] grad = new double[this._ncolX];
                double cweight = chkweight.atd(row);
                assert (!Double.isNaN(cweight)) : "User-specified weight cannot be NaN";
                if (this._update) {
                    for (int k = 0; k < this._ncolX; ++k) {
                        GLRM.chk_xold(cs, k, this._ncolA).set(row, GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).atd(row));
                    }
                }
                for (j2 = 0; j2 < this._ncats; ++j2) {
                    a[j2] = cs[j2].atd(row);
                    if (Double.isNaN(a[j2])) continue;
                    double[] xy = new double[this._yt._numLevels[j2]];
                    for (int level = 0; level < xy.length; ++level) {
                        for (int k = 0; k < this._ncolX; ++k) {
                            int n = level;
                            xy[n] = xy[n] + GLRM.chk_xold(cs, k, this._ncolA).atd(row) * this._yt.getCat(j2, level, k);
                        }
                    }
                    double[] weight = GLRMModel.GLRMParameters.mlgrad(xy, (int)a[j2], this._lossFunc[j2]);
                    double[][] ysub = this._yt.getCatBlock(j2);
                    for (int k = 0; k < this._ncolX; ++k) {
                        for (int c = 0; c < weight.length; ++c) {
                            int n = k;
                            grad[n] = grad[n] + cweight * weight[c] * ysub[k][c];
                        }
                    }
                }
                for (j2 = this._ncats; j2 < this._ncolA; ++j2) {
                    int js = j2 - this._ncats;
                    a[j2] = cs[j2].atd(row);
                    if (Double.isNaN(a[j2])) continue;
                    double xy = 0.0;
                    for (int k = 0; k < this._ncolX; ++k) {
                        xy += GLRM.chk_xold(cs, k, this._ncolA).atd(row) * this._yt.getNum(js, k);
                    }
                    double weight = cweight * this._parms.lgrad(xy, (a[j2] - this._normSub[js]) * this._normMul[js], this._lossFunc[j2]);
                    for (int k = 0; k < this._ncolX; ++k) {
                        int n = k;
                        grad[n] = grad[n] + weight * this._yt.getNum(js, k);
                    }
                }
                double[] u = new double[this._ncolX];
                for (int k = 0; k < this._ncolX; ++k) {
                    double xold = GLRM.chk_xold(cs, k, this._ncolA).atd(row);
                    u[k] = xold - this._alpha * grad[k];
                }
                double[] xnew = this._parms.rproxgrad_x(u, this._alpha, rand);
                this._xreg += this._parms.regularize_x(xnew);
                for (int k = 0; k < this._ncolX; ++k) {
                    GLRM.chk_xnew(cs, k, this._ncolA, this._ncolX).set(row, xnew[k]);
                }
                for (j = 0; j < this._ncats; ++j) {
                    if (Double.isNaN(a[j])) continue;
                    double[] xy = ArrayUtils.multVecArr((double[])xnew, (double[][])this._yt.getCatBlock(j));
                    this._loss += GLRMModel.GLRMParameters.mloss(xy, (int)a[j], this._lossFunc[j]);
                }
                for (j = this._ncats; j < this._ncolA; ++j) {
                    int js = j - this._ncats;
                    if (Double.isNaN(a[j])) continue;
                    double xy = this._yt.lmulNumCol(xnew, js);
                    this._loss += this._parms.loss(xy, (a[j] - this._normSub[js]) * this._normMul[js], this._lossFunc[j]);
                }
                this._loss *= cweight;
            }
        }

        public void reduce(UpdateX other) {
            this._loss += other._loss;
            this._xreg += other._xreg;
        }
    }

    private static class InitialXKMeans
    extends MRTask<InitialXKMeans> {
        GLRMModel.GLRMParameters _parms;
        KMeansModel _model;
        final int _ncolA;
        final int _ncolX;

        InitialXKMeans(GLRMModel.GLRMParameters parms, KMeansModel model, int ncolA, int ncolX) {
            this._parms = parms;
            this._model = model;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
        }

        public void map(Chunk[] chks) {
            double[] tmp = new double[this._ncolA];
            Random rand = RandomUtils.getRNG((long[])new long[]{0L});
            for (int row = 0; row < chks[0]._len; ++row) {
                double[] p = this._model.score_ratio(chks, row, tmp);
                rand.setSeed(this._parms._seed + chks[0].start() + (long)row);
                p = this._parms.project_x(p, rand);
                for (int c = 0; c < p.length; ++c) {
                    chks[this._ncolA + c].set(row, p[c]);
                    chks[this._ncolA + this._ncolX + c].set(row, p[c]);
                }
            }
        }
    }

    private static class InitialXSVD
    extends MRTask<InitialXSVD> {
        final double[] _diag;
        final int _ncolU;
        final int _offX;
        final int _offW;

        InitialXSVD(double[] diag, int ncolU, int ncolA, int ncolX) {
            assert (diag != null && diag.length == ncolU);
            this._diag = diag;
            this._ncolU = ncolU;
            this._offX = ncolU + ncolA;
            this._offW = this._offX + ncolX;
        }

        public void map(Chunk[] chks) {
            for (int row = 0; row < chks[0]._len; ++row) {
                for (int c = 0; c < this._ncolU; ++c) {
                    double ud = chks[c].atd(row) * this._diag[c];
                    chks[this._offX + c].set(row, ud);
                    chks[this._offW + c].set(row, ud);
                }
            }
        }
    }

    private static class InitialXProj
    extends MRTask<InitialXProj> {
        GLRMModel.GLRMParameters _parms;
        final int _ncolA;
        final int _ncolX;

        InitialXProj(GLRMModel.GLRMParameters parms, int ncolA, int ncolX) {
            this._parms = parms;
            this._ncolA = ncolA;
            this._ncolX = ncolX;
        }

        public void map(Chunk[] chks) {
            Random rand = RandomUtils.getRNG((long[])new long[]{0L});
            for (int row = 0; row < chks[0]._len; ++row) {
                rand.setSeed(this._parms._seed + chks[0].start() + (long)row);
                double[] xrow = ArrayUtils.gaussianVector((int)this._ncolX, (Random)rand);
                xrow = this._parms.project_x(xrow, rand);
                for (int c = 0; c < xrow.length; ++c) {
                    chks[this._ncolA + c].set(row, xrow[c]);
                    chks[this._ncolA + this._ncolX + c].set(row, xrow[c]);
                }
            }
        }
    }

    protected static final class Archetypes
    extends Iced<Archetypes> {
        double[][] _archetypes;
        boolean _transposed;
        final int[] _catOffsets;
        final int[] _numLevels;

        Archetypes(double[][] y, boolean transposed, int[] catOffsets, int[] numLevels) {
            this._archetypes = y;
            this._transposed = transposed;
            this._catOffsets = catOffsets;
            this._numLevels = numLevels;
        }

        public int rank() {
            return this._transposed ? this._archetypes[0].length : this._archetypes.length;
        }

        public int nfeatures() {
            return this._transposed ? this._archetypes.length : this._archetypes[0].length;
        }

        public double[][] getY(boolean transpose) {
            return transpose ^ this._transposed ? ArrayUtils.transpose((double[][])this._archetypes) : this._archetypes;
        }

        public TwoDimTable buildTable(String[] features, boolean transpose) {
            int rank = this.rank();
            int nfeat = this.nfeatures();
            assert (features != null && features.length == this.nfeatures());
            double[][] yraw = this.getY(transpose);
            if (transpose) {
                String[] rowNames = features;
                Object[] colTypes = new String[rank];
                Object[] colFormats = new String[rank];
                String[] colHeaders = new String[rank];
                Arrays.fill(colTypes, "double");
                Arrays.fill(colFormats, "%5f");
                for (int i = 0; i < colHeaders.length; ++i) {
                    colHeaders[i] = "Arch" + String.valueOf(i + 1);
                }
                return new TwoDimTable("Archetypes", null, rowNames, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[yraw.length][], yraw);
            }
            String[] rowNames = new String[rank];
            Object[] colTypes = new String[nfeat];
            Object[] colFormats = new String[nfeat];
            String[] colHeaders = features;
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            for (int i = 0; i < rowNames.length; ++i) {
                rowNames[i] = "Arch" + String.valueOf(i + 1);
            }
            return new TwoDimTable("Archetypes", null, rowNames, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[yraw.length][], yraw);
        }

        public int getNumCidx(int j) {
            return this._catOffsets[this._catOffsets.length - 1] + j;
        }

        public int getCatCidx(int j, int level) {
            assert (this._numLevels[j] != 0) : "Number of levels in categorical column cannot be zero";
            assert (!Double.isNaN(level) && level >= 0 && level < this._numLevels[j]) : "Got level = " + level + " when expected integer in [0," + this._numLevels[j] + ")";
            return this._catOffsets[j] + level;
        }

        protected final double getNum(int j, int k) {
            int cidx = this.getNumCidx(j);
            return this._transposed ? this._archetypes[cidx][k] : this._archetypes[k][cidx];
        }

        protected final double lmulNumCol(double[] x, int j) {
            assert (x != null && x.length == this.rank()) : "x must be of length " + this.rank();
            int cidx = this.getNumCidx(j);
            double prod = 0.0;
            if (this._transposed) {
                for (int k = 0; k < this.rank(); ++k) {
                    prod += x[k] * this._archetypes[cidx][k];
                }
            } else {
                for (int k = 0; k < this.rank(); ++k) {
                    prod += x[k] * this._archetypes[k][cidx];
                }
            }
            return prod;
        }

        protected final double getCat(int j, int level, int k) {
            int cidx = this.getCatCidx(j, level);
            return this._transposed ? this._archetypes[cidx][k] : this._archetypes[k][cidx];
        }

        protected final double[][] getCatBlock(int j) {
            assert (this._numLevels[j] != 0) : "Number of levels in categorical column cannot be zero";
            double[][] block = new double[this.rank()][this._numLevels[j]];
            if (this._transposed) {
                for (int level = 0; level < this._numLevels[j]; ++level) {
                    int cidx = this.getCatCidx(j, level);
                    for (int k = 0; k < this.rank(); ++k) {
                        block[k][level] = this._archetypes[cidx][k];
                    }
                }
            } else {
                for (int level = 0; level < this._numLevels[j]; ++level) {
                    int cidx = this.getCatCidx(j, level);
                    for (int k = 0; k < this.rank(); ++k) {
                        block[k][level] = this._archetypes[k][cidx];
                    }
                }
            }
            return block;
        }

        protected final double[] lmulCatBlock(double[] x, int j) {
            assert (this._numLevels[j] != 0) : "Number of levels in categorical column cannot be zero";
            assert (x != null && x.length == this.rank()) : "x must be of length " + this.rank();
            double[] prod = new double[this._numLevels[j]];
            if (this._transposed) {
                for (int level = 0; level < this._numLevels[j]; ++level) {
                    int cidx = this.getCatCidx(j, level);
                    for (int k = 0; k < this.rank(); ++k) {
                        int n = level;
                        prod[n] = prod[n] + x[k] * this._archetypes[cidx][k];
                    }
                }
            } else {
                for (int level = 0; level < this._numLevels[j]; ++level) {
                    int cidx = this.getCatCidx(j, level);
                    for (int k = 0; k < this.rank(); ++k) {
                        int n = level;
                        prod[n] = prod[n] + x[k] * this._archetypes[k][cidx];
                    }
                }
            }
            return prod;
        }
    }

    class GLRMDriver
    extends ModelBuilder.Driver {
        GLRMDriver() {
            super((ModelBuilder)GLRM.this);
        }

        private double[][] initialXY(DataInfo tinfo, Frame dfrm, GLRMModel model, long na_cnt) {
            MRTask xtsk;
            Object parms;
            double[][] centers_exp = null;
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == Initialization.User) {
                if (null != ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_y) {
                    Vec[] yVecs = ((Frame)((GLRMModel.GLRMParameters)GLRM.this._parms)._user_y.get()).vecs();
                    if (((GLRMModel.GLRMParameters)GLRM.this._parms)._expand_user_y) {
                        double[][] centers = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][GLRM.this._ncolA];
                        for (int c = 0; c < GLRM.this._ncolA; ++c) {
                            for (int r = 0; r < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++r) {
                                centers[r][c] = yVecs[c].at((long)r);
                            }
                        }
                        centers = ArrayUtils.permuteCols((double[][])centers, (int[])tinfo._permutation);
                        centers_exp = GLRM.expandCats(centers, tinfo);
                    } else {
                        centers_exp = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k][GLRM.this._ncolY];
                        for (int c = 0; c < GLRM.this._ncolY; ++c) {
                            for (int r = 0; r < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++r) {
                                centers_exp[r][c] = yVecs[c].at((long)r);
                            }
                        }
                    }
                } else {
                    centers_exp = ArrayUtils.gaussianArray((int)((GLRMModel.GLRMParameters)GLRM.this._parms)._k, (int)GLRM.this._ncolY);
                }
                if (null != ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x) {
                    Frame tmp = new Frame(dfrm);
                    tmp.add((Frame)((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x.get());
                    new MRTask(){

                        public void map(Chunk[] cs) {
                            for (int row = 0; row < cs[0]._len; ++row) {
                                for (int i = GLRM.this._ncolA; i < GLRM.this._ncolA + GLRM.this._ncolX; ++i) {
                                    double x = cs[2 * GLRM.this._ncolX + i].atd(row);
                                    cs[i].set(row, x);
                                    cs[GLRM.this._ncolX + i].set(row, x);
                                }
                            }
                        }
                    }.doAll(tmp);
                } else {
                    InitialXProj xtsk2 = new InitialXProj((GLRMModel.GLRMParameters)GLRM.this._parms, GLRM.this._ncolA, GLRM.this._ncolX);
                    xtsk2.doAll(dfrm);
                }
                return centers_exp;
            }
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == Initialization.Random) {
                centers_exp = ArrayUtils.gaussianArray((int)((GLRMModel.GLRMParameters)GLRM.this._parms)._k, (int)GLRM.this._ncolY);
                InitialXProj xtsk3 = new InitialXProj((GLRMModel.GLRMParameters)GLRM.this._parms, GLRM.this._ncolA, GLRM.this._ncolX);
                xtsk3.doAll(dfrm);
            } else if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == Initialization.SVD) {
                parms = new SVDModel.SVDParameters();
                parms._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                parms._ignored_columns = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignored_columns;
                parms._ignore_const_cols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignore_const_cols;
                parms._score_each_iteration = ((GLRMModel.GLRMParameters)GLRM.this._parms)._score_each_iteration;
                parms._use_all_factor_levels = true;
                parms._nv = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                parms._transform = ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform;
                parms._svd_method = ((GLRMModel.GLRMParameters)GLRM.this._parms)._svd_method;
                parms._max_iterations = parms._svd_method == SVDModel.SVDParameters.Method.Randomized ? ((GLRMModel.GLRMParameters)GLRM.this._parms)._k : ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                parms._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                parms._keep_u = true;
                parms._impute_missing = true;
                parms._save_v_frame = false;
                SVDModel svd = (SVDModel)ModelCacheManager.get((Model.Parameters)parms);
                if (svd == null) {
                    svd = (SVDModel)new SVD((SVDModel.SVDParameters)((Object)parms), GLRM.this._job).trainModelNested();
                }
                ((GLRMModel.GLRMOutput)model._output)._init_key = svd._key;
                assert (((SVDModel.SVDOutput)svd._output)._permutation.length == tinfo._permutation.length);
                for (int i = 0; i < tinfo._permutation.length; ++i) {
                    assert (((SVDModel.SVDOutput)svd._output)._permutation[i] == tinfo._permutation[i]);
                }
                centers_exp = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)svd._output)._v);
                double[] dsqrt = new double[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
                for (int i = 0; i < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++i) {
                    dsqrt[i] = Math.sqrt(((SVDModel.SVDOutput)svd._output)._d[i]);
                    ArrayUtils.mult((double[])centers_exp[i], (double)dsqrt[i]);
                }
                Frame uFrm = (Frame)DKV.get(((SVDModel.SVDOutput)svd._output)._u_key).get();
                assert (uFrm.numCols() == ((GLRMModel.GLRMParameters)GLRM.this._parms)._k);
                Frame fullFrm = new Frame(uFrm).add(dfrm);
                xtsk = new InitialXSVD(dsqrt, ((GLRMModel.GLRMParameters)GLRM.this._parms)._k, GLRM.this._ncolA, GLRM.this._ncolX);
                xtsk.doAll(fullFrm);
            } else if (((GLRMModel.GLRMParameters)GLRM.this._parms)._init == Initialization.PlusPlus) {
                parms = new KMeansModel.KMeansParameters();
                ((KMeansModel.KMeansParameters)((Object)parms))._train = ((GLRMModel.GLRMParameters)GLRM.this._parms)._train;
                ((KMeansModel.KMeansParameters)((Object)parms))._ignored_columns = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignored_columns;
                ((KMeansModel.KMeansParameters)((Object)parms))._ignore_const_cols = ((GLRMModel.GLRMParameters)GLRM.this._parms)._ignore_const_cols;
                ((KMeansModel.KMeansParameters)((Object)parms))._score_each_iteration = ((GLRMModel.GLRMParameters)GLRM.this._parms)._score_each_iteration;
                ((KMeansModel.KMeansParameters)((Object)parms))._init = KMeans.Initialization.PlusPlus;
                ((KMeansModel.KMeansParameters)((Object)parms))._k = ((GLRMModel.GLRMParameters)GLRM.this._parms)._k;
                ((KMeansModel.KMeansParameters)((Object)parms))._max_iterations = ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations;
                ((KMeansModel.KMeansParameters)((Object)parms))._standardize = true;
                ((KMeansModel.KMeansParameters)((Object)parms))._seed = ((GLRMModel.GLRMParameters)GLRM.this._parms)._seed;
                ((KMeansModel.KMeansParameters)((Object)parms))._pred_indicator = true;
                ModelCacheManager MCM = H2O.getMCM();
                KMeansModel km = (KMeansModel)ModelCacheManager.get((Model.Parameters)parms);
                if (km == null) {
                    km = (KMeansModel)new KMeans((KMeansModel.KMeansParameters)((Object)parms), GLRM.this._job).trainModelNested();
                }
                ((GLRMModel.GLRMOutput)model._output)._init_key = km._key;
                double frob = GLRM.frobenius2(((KMeansModel.KMeansOutput)km._output)._centers_raw);
                if (frob != 0.0 && !Double.isNaN(frob) && !((GLRMModel.GLRMParameters)GLRM.this._parms).hasClosedForm(na_cnt)) {
                    Log.info((Object[])new Object[]{"Initializing X to matrix of weights inversely correlated with cluster distances"});
                    xtsk = new InitialXKMeans((GLRMModel.GLRMParameters)GLRM.this._parms, km, GLRM.this._ncolA, GLRM.this._ncolX);
                    xtsk.doAll(dfrm);
                }
                double[][] centers = ArrayUtils.permuteCols((double[][])((KMeansModel.KMeansOutput)km._output)._centers_raw, (int[])tinfo.mapNames(((KMeansModel.KMeansOutput)km._output)._names));
                centers = GLRM.transform(centers, tinfo._normSub, tinfo._normMul, tinfo._cats, tinfo._nums);
                centers_exp = GLRM.expandCats(centers, tinfo);
            } else {
                GLRM.this.error("_init", "Initialization method " + (Object)((Object)((GLRMModel.GLRMParameters)GLRM.this._parms)._init) + " is undefined");
            }
            assert (centers_exp != null && centers_exp.length == ((GLRMModel.GLRMParameters)GLRM.this._parms)._k && centers_exp[0].length == GLRM.this._ncolY) : "Y must have " + ((GLRMModel.GLRMParameters)GLRM.this._parms)._k + " rows and " + GLRM.access$100(GLRM.this) + " columns";
            double frob = GLRM.frobenius2(centers_exp);
            if (frob == 0.0 || Double.isNaN(frob)) {
                GLRM.this.warn("_init", "Initialization failed. Setting initial Y to standard normal random matrix instead");
                centers_exp = ArrayUtils.gaussianArray((int)((GLRMModel.GLRMParameters)GLRM.this._parms)._k, (int)GLRM.this._ncolY);
            }
            Random rand = RandomUtils.getRNG((long[])new long[]{((GLRMModel.GLRMParameters)GLRM.this._parms)._seed});
            for (int i = 0; i < ((GLRMModel.GLRMParameters)GLRM.this._parms)._k; ++i) {
                centers_exp[i] = ((GLRMModel.GLRMParameters)GLRM.this._parms).project_y(centers_exp[i], rand);
            }
            return centers_exp;
        }

        private void initialXClosedForm(DataInfo dinfo, Archetypes yt_arch, double[] normSub, double[] normMul) {
            CholeskyDecomposition yychol;
            Log.info((Object[])new Object[]{"Initializing X = AY'(YY' + gamma I)^(-1) where A = training data"});
            double[][] ygram = ArrayUtils.formGram((double[][])yt_arch._archetypes);
            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y > 0.0) {
                int i = 0;
                while (i < ygram.length) {
                    double[] dArray = ygram[i];
                    int n = i++;
                    dArray[n] = dArray[n] + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y;
                }
            }
            if (!(yychol = this.regularizedCholesky(ygram, 10, false)).isSPD()) {
                Log.warn((Object[])new Object[]{"Initialization failed: (YY' + gamma I) is non-SPD. Setting initial X to standard normal random matrix. Results will be numerically unstable"});
            } else {
                CholMulTask cmtsk = new CholMulTask((GLRMModel.GLRMParameters)GLRM.this._parms, yychol, yt_arch, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, normSub, normMul);
                cmtsk.doAll(dinfo._adaptedFrame);
            }
        }

        private boolean isDone(GLRMModel model, int steps_in_row, double step) {
            if (GLRM.this.stop_requested()) {
                return true;
            }
            if (((GLRMModel.GLRMOutput)model._output)._iterations >= ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_iterations) {
                return true;
            }
            if (((GLRMModel.GLRMOutput)model._output)._updates >= ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_updates) {
                return true;
            }
            if (step <= ((GLRMModel.GLRMParameters)GLRM.this._parms)._min_step_size) {
                return true;
            }
            return ((GLRMModel.GLRMOutput)model._output)._iterations > 10 && steps_in_row > 3 && Math.abs(((GLRMModel.GLRMOutput)model._output)._avg_change_obj) < 1.0E-6;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram, int max_attempts) {
            double addedL2 = 0.0;
            Gram.Cholesky chol = gram.cholesky(null);
            for (int attempts = 0; !chol.isSPD() && attempts < max_attempts; ++attempts) {
                addedL2 = addedL2 == 0.0 ? 1.0E-5 : (addedL2 *= 10.0);
                gram.addDiag(addedL2);
                Log.info((Object[])new Object[]{"Added L2 regularization = " + addedL2 + " to diagonal of Gram matrix"});
                gram.cholesky(chol);
            }
            if (!chol.isSPD()) {
                throw new Gram.NonSPDMatrixException();
            }
            return chol;
        }

        public Gram.Cholesky regularizedCholesky(Gram gram) {
            return this.regularizedCholesky(gram, 10);
        }

        public CholeskyDecomposition regularizedCholesky(double[][] gram, int max_attempts, boolean throw_exception) {
            int attempts = 0;
            double addedL2 = 0.0;
            Matrix gmat = new Matrix(gram);
            CholeskyDecomposition chol = new CholeskyDecomposition(gmat);
            while (!chol.isSPD() && attempts < max_attempts) {
                addedL2 = addedL2 == 0.0 ? 1.0E-5 : (addedL2 *= 10.0);
                ++attempts;
                for (int i = 0; i < gram.length; ++i) {
                    gmat.set(i, i, addedL2);
                }
                Log.info((Object[])new Object[]{"Added L2 regularization = " + addedL2 + " to diagonal of Gram matrix"});
                chol = new CholeskyDecomposition(gmat);
            }
            if (!chol.isSPD() && throw_exception) {
                throw new Gram.NonSPDMatrixException();
            }
            return chol;
        }

        public void recoverSVD(GLRMModel model, DataInfo xinfo) {
            Gram.GramTask xgram = (Gram.GramTask)new Gram.GramTask((Key<Job>)GLRM.this._job._key, xinfo).doAll(xinfo._adaptedFrame);
            Gram.Cholesky xxchol = this.regularizedCholesky(xgram._gram);
            Matrix x_r = new Matrix(xxchol.getL()).transpose();
            x_r = x_r.times(Math.sqrt(GLRM.this._train.numRows()));
            Matrix yt = new Matrix(((GLRMModel.GLRMOutput)model._output)._archetypes_raw.getY(true));
            QRDecomposition yt_qr = new QRDecomposition(yt);
            Matrix yt_r = yt_qr.getR();
            Matrix rrmul = x_r.times(yt_r.transpose());
            SingularValueDecomposition rrsvd = new SingularValueDecomposition(rrmul);
            Matrix eigvec = yt_qr.getQ().times(rrsvd.getV());
            ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw = eigvec.getArray();
            ((GLRMModel.GLRMOutput)model._output)._singular_vals = rrsvd.getSingularValues();
            Object[] colTypes = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Object[] colFormats = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            String[] colHeaders = new String[((GLRMModel.GLRMParameters)GLRM.this._parms)._k];
            Arrays.fill(colTypes, "double");
            Arrays.fill(colFormats, "%5f");
            assert (((GLRMModel.GLRMOutput)model._output)._names_expanded.length == ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw.length);
            for (int i = 0; i < colHeaders.length; ++i) {
                colHeaders[i] = "Vec" + String.valueOf(i + 1);
            }
            ((GLRMModel.GLRMOutput)model._output)._eigenvectors = new TwoDimTable("Eigenvectors", null, ((GLRMModel.GLRMOutput)model._output)._names_expanded, colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw.length][], ((GLRMModel.GLRMOutput)model._output)._eigenvectors_raw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            ArrayList<Key> keep;
            boolean overwriteX;
            Frame fr;
            DataInfo tinfo;
            DataInfo xinfo;
            DataInfo dinfo;
            block43: {
                GLRMModel model = null;
                dinfo = null;
                xinfo = null;
                tinfo = null;
                fr = null;
                overwriteX = false;
                try {
                    int i;
                    Archetypes yt;
                    int i2;
                    GLRM.this.init(true);
                    if (GLRM.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + GLRM.this.validationErrors());
                    }
                    model = new GLRMModel(GLRM.this.dest(), (GLRMModel.GLRMParameters)GLRM.this._parms, new GLRMModel.GLRMOutput(GLRM.this));
                    model.delete_and_lock(GLRM.this._job);
                    tinfo = new DataInfo(GLRM.this._train, GLRM.this._valid, 0, true, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put((Key)tinfo._key, (Iced)tinfo);
                    double[] dArray = ((GLRMModel.GLRMOutput)model._output)._normSub = tinfo._normSub == null ? new double[tinfo._nums] : tinfo._normSub;
                    if (tinfo._normMul == null) {
                        ((GLRMModel.GLRMOutput)model._output)._normMul = new double[tinfo._nums];
                        Arrays.fill(((GLRMModel.GLRMOutput)model._output)._normMul, 1.0);
                    } else {
                        ((GLRMModel.GLRMOutput)model._output)._normMul = tinfo._normMul;
                    }
                    ((GLRMModel.GLRMOutput)model._output)._permutation = tinfo._permutation;
                    ((GLRMModel.GLRMOutput)model._output)._nnums = tinfo._nums;
                    ((GLRMModel.GLRMOutput)model._output)._ncats = tinfo._cats;
                    ((GLRMModel.GLRMOutput)model._output)._catOffsets = tinfo._catOffsets;
                    ((GLRMModel.GLRMOutput)model._output)._names_expanded = tinfo.coefNames();
                    assert (GLRM.this._lossFunc != null && GLRM.this._lossFunc.length == GLRM.this._train.numCols());
                    ((GLRMModel.GLRMOutput)model._output)._lossFunc = new GLRMModel.GLRMParameters.Loss[GLRM.this._lossFunc.length];
                    for (int i3 = 0; i3 < GLRM.this._lossFunc.length; ++i3) {
                        ((GLRMModel.GLRMOutput)model._output)._lossFunc[i3] = GLRM.this._lossFunc[tinfo._permutation[i3]];
                    }
                    long nobs = GLRM.this._train.numRows() * (long)GLRM.this._train.numCols();
                    long na_cnt = 0L;
                    for (i2 = 0; i2 < GLRM.this._train.numCols(); ++i2) {
                        na_cnt += GLRM.this._train.vec(i2).naCnt();
                    }
                    ((GLRMModel.GLRMOutput)model._output)._nobs = nobs - na_cnt;
                    fr = new Frame(GLRM.this._train);
                    for (i2 = 0; i2 < GLRM.this._ncolX; ++i2) {
                        fr.add("xcol_" + i2, fr.anyVec().makeZero());
                    }
                    for (i2 = 0; i2 < GLRM.this._ncolX; ++i2) {
                        fr.add("wcol_" + i2, fr.anyVec().makeZero());
                    }
                    dinfo = new DataInfo(fr, null, 0, true, ((GLRMModel.GLRMParameters)GLRM.this._parms)._transform, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    int weightId = dinfo._weights ? dinfo.weightChunkId() : -1;
                    int[] numLevels = tinfo._adaptedFrame.cardinality();
                    GLRM.this._job.update(1L, "Initializing X and Y matrices");
                    double[][] yinit = this.initialXY(tinfo, dinfo._adaptedFrame, model, na_cnt);
                    Archetypes ytnew = yt = new Archetypes(ArrayUtils.transpose((double[][])yinit), true, tinfo._catOffsets, numLevels);
                    double yreg = ((GLRMModel.GLRMParameters)GLRM.this._parms).regularize_y(yt._archetypes);
                    if ((((GLRMModel.GLRMParameters)GLRM.this._parms)._init != Initialization.User || null == ((GLRMModel.GLRMParameters)GLRM.this._parms)._user_x) && ((GLRMModel.GLRMParameters)GLRM.this._parms).hasClosedForm(na_cnt)) {
                        this.initialXClosedForm(dinfo, yt, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul);
                    }
                    GLRM.this._job.update(1L, "Computing initial objective function");
                    boolean regX = ((GLRMModel.GLRMParameters)GLRM.this._parms)._regularization_x != GLRMModel.GLRMParameters.Regularizer.None && ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x != 0.0;
                    ObjCalc objtsk = new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, yt, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId, regX);
                    objtsk.doAll(dinfo._adaptedFrame);
                    ((GLRMModel.GLRMOutput)model._output)._objective = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * objtsk._xold_reg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                    ((GLRMModel.GLRMOutput)model._output)._archetypes_raw = yt;
                    ((GLRMModel.GLRMOutput)model._output)._iterations = 0;
                    ((GLRMModel.GLRMOutput)model._output)._updates = 0;
                    ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = 2.0E-6;
                    model.update(GLRM.this._job);
                    double step = ((GLRMModel.GLRMParameters)GLRM.this._parms)._init_step_size;
                    int steps_in_row = 0;
                    while (!this.isDone(model, steps_in_row, step)) {
                        GLRM.this._job.update(1L, "Iteration " + String.valueOf(((GLRMModel.GLRMOutput)model._output)._iterations + 1) + " of alternating minimization");
                        UpdateX xtsk = new UpdateX((GLRMModel.GLRMParameters)GLRM.this._parms, yt, step / (double)GLRM.this._ncolA, overwriteX, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                        xtsk.doAll(dinfo._adaptedFrame);
                        ++((GLRMModel.GLRMOutput)model._output)._updates;
                        if (((GLRMModel.GLRMOutput)model._output)._updates < ((GLRMModel.GLRMParameters)GLRM.this._parms)._max_updates) {
                            UpdateY ytsk = new UpdateY((GLRMModel.GLRMParameters)GLRM.this._parms, yt, step / (double)GLRM.this._ncolA, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                            double[][] yttmp = ((UpdateY)ytsk.doAll((Frame)dinfo._adaptedFrame))._ytnew;
                            ytnew = new Archetypes(yttmp, true, dinfo._catOffsets, numLevels);
                            yreg = ytsk._yreg;
                            ++((GLRMModel.GLRMOutput)model._output)._updates;
                        }
                        objtsk = new ObjCalc((GLRMModel.GLRMParameters)GLRM.this._parms, ytnew, GLRM.this._ncolA, GLRM.this._ncolX, dinfo._cats, ((GLRMModel.GLRMOutput)model._output)._normSub, ((GLRMModel.GLRMOutput)model._output)._normMul, ((GLRMModel.GLRMOutput)model._output)._lossFunc, weightId);
                        objtsk.doAll(dinfo._adaptedFrame);
                        double obj_new = objtsk._loss + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_x * xtsk._xreg + ((GLRMModel.GLRMParameters)GLRM.this._parms)._gamma_y * yreg;
                        ((GLRMModel.GLRMOutput)model._output)._avg_change_obj = (((GLRMModel.GLRMOutput)model._output)._objective - obj_new) / (double)nobs;
                        ++((GLRMModel.GLRMOutput)model._output)._iterations;
                        if (((GLRMModel.GLRMOutput)model._output)._avg_change_obj > 0.0) {
                            yt = ytnew;
                            ((GLRMModel.GLRMOutput)model._output)._archetypes_raw = ytnew;
                            ((GLRMModel.GLRMOutput)model._output)._objective = obj_new;
                            step *= 1.05;
                            steps_in_row = Math.max(1, steps_in_row + 1);
                            overwriteX = true;
                        } else {
                            step /= Math.max(1.5, (double)(-steps_in_row));
                            steps_in_row = Math.min(0, steps_in_row - 1);
                            overwriteX = false;
                            if (((GLRMModel.GLRMParameters)GLRM.this._parms)._verbose) {
                                Log.info((Object[])new Object[]{"Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective increased to " + obj_new + "; reducing step size to " + step});
                                GLRM.this._job.update(0L, "Iteration " + ((GLRMModel.GLRMOutput)model._output)._iterations + ": Objective increased to " + obj_new + "; reducing step size to " + step);
                            }
                        }
                        ((GLRMModel.GLRMOutput)model._output)._training_time_ms = ArrayUtils.copyAndFillOf((long[])((GLRMModel.GLRMOutput)model._output)._training_time_ms, (int)(((GLRMModel.GLRMOutput)model._output)._training_time_ms.length + 1), (long)System.currentTimeMillis());
                        ((GLRMModel.GLRMOutput)model._output)._history_step_size = ArrayUtils.copyAndFillOf((double[])((GLRMModel.GLRMOutput)model._output)._history_step_size, (int)(((GLRMModel.GLRMOutput)model._output)._history_step_size.length + 1), (double)step);
                        ((GLRMModel.GLRMOutput)model._output)._history_objective = ArrayUtils.copyAndFillOf((double[])((GLRMModel.GLRMOutput)model._output)._history_objective, (int)(((GLRMModel.GLRMOutput)model._output)._history_objective.length + 1), (double)((GLRMModel.GLRMOutput)model._output)._objective);
                        ((GLRMModel.GLRMOutput)model._output)._scoring_history = this.createScoringHistoryTable((GLRMModel.GLRMOutput)model._output);
                        model.update(GLRM.this._job);
                    }
                    Vec[] xvecs = new Vec[GLRM.this._ncolX];
                    String[] xnames = new String[GLRM.this._ncolX];
                    if (overwriteX) {
                        for (i = 0; i < GLRM.this._ncolX; ++i) {
                            xvecs[i] = fr.vec(GLRM.idx_xnew(i, GLRM.this._ncolA, GLRM.this._ncolX));
                            xnames[i] = "Arch" + String.valueOf(i + 1);
                        }
                    } else {
                        for (i = 0; i < GLRM.this._ncolX; ++i) {
                            xvecs[i] = fr.vec(GLRM.idx_xold(i, GLRM.this._ncolA));
                            xnames[i] = "Arch" + String.valueOf(i + 1);
                        }
                    }
                    ((GLRMModel.GLRMOutput)model._output)._representation_name = ((GLRMModel.GLRMParameters)GLRM.this._parms)._representation_name == null || ((GLRMModel.GLRMParameters)GLRM.this._parms)._representation_name.length() == 0 ? "GLRMLoading_" + Key.rand() : ((GLRMModel.GLRMParameters)GLRM.this._parms)._representation_name;
                    ((GLRMModel.GLRMOutput)model._output)._representation_key = Key.make((String)((GLRMModel.GLRMOutput)model._output)._representation_name);
                    Frame x = new Frame(((GLRMModel.GLRMOutput)model._output)._representation_key, xnames, xvecs);
                    xinfo = new DataInfo(x, null, 0, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, false, false, false, false, false, false);
                    DKV.put((Keyed)x);
                    DKV.put((Keyed)xinfo);
                    ((GLRMModel.GLRMOutput)model._output)._history_step_size = ArrayUtils.copyAndFillOf((double[])((GLRMModel.GLRMOutput)model._output)._history_step_size, (int)(((GLRMModel.GLRMOutput)model._output)._history_step_size.length + 1), (double)step);
                    ((GLRMModel.GLRMOutput)model._output)._archetypes = yt.buildTable(((GLRMModel.GLRMOutput)model._output)._names_expanded, false);
                    if (((GLRMModel.GLRMParameters)GLRM.this._parms)._recover_svd) {
                        this.recoverSVD(model, xinfo);
                    }
                    ((GLRMModel.GLRMOutput)model._output)._training_metrics = model.scoreMetricsOnly(((GLRMModel.GLRMParameters)GLRM.this._parms).train());
                    if (GLRM.this._valid != null) {
                        ((GLRMModel.GLRMOutput)model._output)._validation_metrics = model.scoreMetricsOnly(((GLRMModel.GLRMParameters)GLRM.this._parms).valid());
                    }
                    ((GLRMModel.GLRMOutput)model._output)._model_summary = this.createModelSummaryTable((GLRMModel.GLRMOutput)model._output);
                    model.update(GLRM.this._job);
                    keep = new ArrayList<Key>();
                    if (model == null) break block43;
                }
                catch (Throwable throwable) {
                    ArrayList<Key> keep2 = new ArrayList<Key>();
                    if (model != null) {
                        Frame loadingFrm = (Frame)DKV.getGet(((GLRMModel.GLRMOutput)model._output)._representation_key);
                        if (loadingFrm != null) {
                            for (Vec vec : loadingFrm.vecs()) {
                                keep2.add(vec._key);
                            }
                        }
                        model.unlock(GLRM.this._job);
                    }
                    if (tinfo != null) {
                        tinfo.remove();
                    }
                    if (dinfo != null) {
                        dinfo.remove();
                    }
                    if (xinfo != null) {
                        xinfo.remove();
                    }
                    if (fr != null) {
                        if (overwriteX) {
                            for (int i = 0; i < GLRM.this._ncolX; ++i) {
                                fr.vec(GLRM.idx_xold(i, GLRM.this._ncolA)).remove();
                            }
                        } else {
                            for (int i = 0; i < GLRM.this._ncolX; ++i) {
                                fr.vec(GLRM.idx_xnew(i, GLRM.this._ncolA, GLRM.this._ncolX)).remove();
                            }
                        }
                    }
                    Scope.untrack((Key[])keep2.toArray(new Key[0]));
                    throw throwable;
                }
                Frame loadingFrm = (Frame)DKV.getGet(((GLRMModel.GLRMOutput)model._output)._representation_key);
                if (loadingFrm != null) {
                    for (Vec vec : loadingFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
                model.unlock(GLRM.this._job);
            }
            if (tinfo != null) {
                tinfo.remove();
            }
            if (dinfo != null) {
                dinfo.remove();
            }
            if (xinfo != null) {
                xinfo.remove();
            }
            if (fr != null) {
                if (overwriteX) {
                    for (int i = 0; i < GLRM.this._ncolX; ++i) {
                        fr.vec(GLRM.idx_xold(i, GLRM.this._ncolA)).remove();
                    }
                } else {
                    for (int i = 0; i < GLRM.this._ncolX; ++i) {
                        fr.vec(GLRM.idx_xnew(i, GLRM.this._ncolA, GLRM.this._ncolX)).remove();
                    }
                }
            }
            Scope.untrack((Key[])keep.toArray(new Key[0]));
        }

        private TwoDimTable createModelSummaryTable(GLRMModel.GLRMOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Number of Iterations");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Final Step Size");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Final Objective Value");
            colTypes.add("double");
            colFormat.add("%.5f");
            boolean rows = true;
            TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            int row = 0;
            int col = 0;
            table.set(row, col++, (Object)output._iterations);
            table.set(row, col++, (Object)output._history_step_size[output._history_step_size.length - 1]);
            table.set(row, col++, (Object)output._objective);
            return table;
        }

        private TwoDimTable createScoringHistoryTable(GLRMModel.GLRMOutput output) {
            ArrayList<String> colHeaders = new ArrayList<String>();
            ArrayList<String> colTypes = new ArrayList<String>();
            ArrayList<String> colFormat = new ArrayList<String>();
            colHeaders.add("Timestamp");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Duration");
            colTypes.add("string");
            colFormat.add("%s");
            colHeaders.add("Iteration");
            colTypes.add("long");
            colFormat.add("%d");
            colHeaders.add("Step Size");
            colTypes.add("double");
            colFormat.add("%.5f");
            colHeaders.add("Objective");
            colTypes.add("double");
            colFormat.add("%.5f");
            int rows = output._training_time_ms.length;
            TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
            for (int row = 0; row < rows; ++row) {
                int col = 0;
                assert (row < table.getRowDim());
                assert (col < table.getColDim());
                DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                table.set(row, col++, (Object)fmt.print(output._training_time_ms[row]));
                table.set(row, col++, (Object)PrettyPrint.msecs((long)(output._training_time_ms[row] - GLRM.this._job.start_time()), (boolean)true));
                table.set(row, col++, (Object)row);
                table.set(row, col++, (Object)output._history_step_size[row]);
                table.set(row, col, (Object)output._history_objective[row]);
            }
            return table;
        }
    }

    public static enum Initialization {
        Random,
        SVD,
        PlusPlus,
        User;

    }
}

