/*
 * Decompiled with CFR 0.152.
 */
package hex.example;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.example.ExampleModel;
import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.Log;

public class Example
extends ModelBuilder<ExampleModel, ExampleModel.ExampleParameters, ExampleModel.ExampleOutput> {
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Unknown};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public Example(ExampleModel.ExampleParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    protected ExampleDriver trainModelImpl() {
        return new ExampleDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((ExampleModel.ExampleParameters)this._parms)._max_iterations < 1 || ((ExampleModel.ExampleParameters)this._parms)._max_iterations > 9999999) {
            this.error("max_iterations", "must be between 1 and 10 million");
        }
    }

    private static class Max
    extends MRTask<Max> {
        double[] _maxs;

        private Max() {
        }

        public void map(Chunk[] cs) {
            this._maxs = new double[cs.length];
            Arrays.fill(this._maxs, -1.7976931348623157E308);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[col]._len; ++row) {
                    this._maxs[col] = Math.max(this._maxs[col], cs[col].atd(row));
                }
            }
        }

        public void reduce(Max that) {
            for (int col = 0; col < this._maxs.length; ++col) {
                this._maxs[col] = Math.max(this._maxs[col], that._maxs[col]);
            }
        }
    }

    private class ExampleDriver
    extends ModelBuilder.Driver {
        private ExampleDriver() {
            super((ModelBuilder)Example.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            ExampleModel model = null;
            try {
                Example.this.init(true);
                model = new ExampleModel(Example.this._job._result, (ExampleModel.ExampleParameters)Example.this._parms, new ExampleModel.ExampleOutput(Example.this));
                model.delete_and_lock(Example.this._job);
                while (((ExampleModel.ExampleOutput)model._output)._iterations < ((ExampleModel.ExampleParameters)Example.this._parms)._max_iterations) {
                    if (Example.this.stop_requested()) {
                        break;
                    }
                    double[] maxs = ((Max)new Max().doAll((Frame)((ExampleModel.ExampleParameters)Example.this._parms).train()))._maxs;
                    ((ExampleModel.ExampleOutput)model._output)._maxs = maxs;
                    model.update(Example.this._job);
                    Example.this._job.update(1L);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Example: iter: ").append(((ExampleModel.ExampleOutput)model._output)._iterations);
                    Log.info((Object[])new Object[]{sb});
                    ++((ExampleModel.ExampleOutput)model._output)._iterations;
                }
            }
            finally {
                if (model != null) {
                    model.unlock(Example.this._job);
                }
            }
        }
    }
}

